/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import org.junit.Assert;
import org.junit.Test;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;

public class MethodRepresentationTests {
    @Test(timeout=300000L)
    public void testParser() {
        String s = "<soot.jimple.infoflow.test.TestNoMain: java.lang.String function1()>";
        SootMethodRepresentationParser parser = SootMethodRepresentationParser.v();
        SootMethodAndClass result = parser.parseSootMethodString(s);
        Assert.assertEquals((Object)"soot.jimple.infoflow.test.TestNoMain", (Object)result.getClassName());
        Assert.assertEquals((Object)"function1", (Object)result.getMethodName());
        Assert.assertEquals((Object)"java.lang.String", (Object)result.getReturnType());
    }

    @Test(timeout=300000L)
    public void testParser2() {
        String s = "<soot.jimple.infoflow.test.TestNoMain: java.lang.String function1(java.lang.String,int)>";
        SootMethodRepresentationParser parser = SootMethodRepresentationParser.v();
        SootMethodAndClass result = parser.parseSootMethodString(s);
        Assert.assertEquals((Object)"soot.jimple.infoflow.test.TestNoMain", (Object)result.getClassName());
        Assert.assertEquals((Object)"function1", (Object)result.getMethodName());
        Assert.assertEquals((Object)"java.lang.String", (Object)result.getReturnType());
        Assert.assertEquals((long)2L, (long)result.getParameters().size());
        Assert.assertEquals((Object)"java.lang.String", result.getParameters().get(0));
        Assert.assertEquals((Object)"int", result.getParameters().get(1));
    }
}

