/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.test.junit.JUnitTests;

public abstract class MultiTest
extends JUnitTests {
    private static final String SOURCE_STRING_PWD = "<soot.jimple.infoflow.test.android.AccountManager: java.lang.String getPassword()>";

    @Test(timeout=300000L)
    public void multiTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void multiSourceCode()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", SOURCE_STRING_PWD));
    }

    @Test(timeout=300000L)
    public void multiTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void multiSourceCode2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", SOURCE_STRING_PWD));
    }

    @Test(timeout=300000L)
    public void ifPathTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void ifPathTestCode1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", SOURCE_STRING_PWD));
        Assert.assertEquals((long)2L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void ifPathTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void ifPathTestCode2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", SOURCE_STRING_PWD));
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void ifPathTest3() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void ifPathTestCode3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", SOURCE_STRING_PWD));
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void ifPathTest4() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void ifPathTestCode4()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", SOURCE_STRING_PWD));
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void loopPathTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void loopPathTestCode1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", SOURCE_STRING_PWD));
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void hashTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void hashTestCode1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(int)>", SOURCE_STRING_PWD));
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void shiftTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void shiftTestCode1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(int)>", SOURCE_STRING_PWD));
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void intMultiTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void intMultiTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(int)>", "<soot.jimple.infoflow.test.android.TelephonyManager: int getIMEI()>"));
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(int)>", "<soot.jimple.infoflow.test.android.TelephonyManager: int getIMSI()>"));
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void intMultiTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void intMultiTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(int)>", "<soot.jimple.infoflow.test.android.TelephonyManager: int getIMEI()>"));
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(int)>", "<soot.jimple.infoflow.test.android.TelephonyManager: int getIMSI()>"));
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test
    public void sameSourceMultiTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void sameSourceMultiTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
        Assert.assertEquals((long)2L, (long)infoflow.getResults().numConnections());
    }

    @Ignore(value="Race condition by design")
    @Test(timeout=300000L)
    public void stopAfterFirstKFlowsTest0() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setStopAfterFirstFlow(true);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void multiSourceCode()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void stopAfterFirstKFlowsTest1() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setStopAfterFirstFlow(false);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void multiSourceCode()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
    }

    @Ignore(value="Race condition by design")
    @Test(timeout=300000L)
    public void stopAfterFirstKFlowsTest2() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.getConfig().setStopAfterFirstKFlows(1);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void multiSourceCode()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test
    public void multiSinkTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void multiSinkTest1()>");
        String streamSource = "<java.io.ByteArrayOutputStream: byte[] toByteArray()>";
        String publishSink = "<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>";
        ArrayList<String> testSources = new ArrayList<String>(sources);
        testSources.add("<java.io.ByteArrayOutputStream: byte[] toByteArray()>");
        infoflow.getConfig().setPathAgnosticResults(false);
        infoflow.computeInfoflow(appPath, libPath, epoints, testSources, (Collection)sinks);
        InfoflowResults results = infoflow.getResults();
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((boolean)results.isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<java.io.ByteArrayOutputStream: byte[] toByteArray()>"));
        Assert.assertEquals((long)2L, (long)results.numConnections());
    }

    @Test(timeout=300000L)
    public void multiSinkTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.MultiTestCode: void multiSinkTest2()>");
        String streamSource = "<java.io.ByteArrayOutputStream: byte[] toByteArray()>";
        String publishSink = "<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>";
        ArrayList<String> testSources = new ArrayList<String>(sources);
        testSources.add("<java.io.ByteArrayOutputStream: byte[] toByteArray()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, testSources, (Collection)sinks);
        InfoflowResults results = infoflow.getResults();
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((boolean)results.isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<java.io.ByteArrayOutputStream: byte[] toByteArray()>"));
        Assert.assertEquals((long)2L, (long)results.numConnections());
    }
}

