/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.test.junit.JUnitTests;
import soot.options.Options;

public abstract class OtherTests
extends JUnitTests {
    @Test(timeout=300000L)
    public void fieldTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void testWithField()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
    }

    @Test(timeout=300000L)
    public void defaultlifecycleTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.utilclasses.D1static: boolean start()>");
        epoints.add("<soot.jimple.infoflow.test.utilclasses.D1static: boolean taintIt()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void ConstructorFinalClassTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void genericsfinalconstructorProblem()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void ptsTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void testPointsToSet()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void negativeTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void easyNegativeTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void mailTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void methodTainted()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void mailNegativeTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void methodNotTainted()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void mail2Test() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void method2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void mail2TestNegative() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void method2NotTainted()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void mail3Test() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void method3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void mail3NegativeTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void method3NotTainted()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void mail4() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void method4()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void mail5() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void method5()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void mail6() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void method6()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void innerClassTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void innerClassTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=300000L)
    public void multiCallTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void multiCallTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
    }

    @Test(timeout=300000L)
    public void passOverTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void passOverTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void overwriteTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void overwriteTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void loopTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void loopTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void dataObjectTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void dataObjectTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void paramTransferTest() {
        IInfoflow infoflow = this.initInfoflow(true);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void paramTransferTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void objectSensitiveTest1() {
        IInfoflow infoflow = this.initInfoflow(true);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void objectSensitiveTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void accessPathTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void accessPathTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void pathSkipTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void pathSkipTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().getResults().values().size());
    }

    @Test(timeout=300000L)
    public void pathSkipTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void pathSkipTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.AccountManager: java.lang.String getPassword()>"));
        Assert.assertFalse((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void pathSkipTest3() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void pathSkipTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.AccountManager: java.lang.String getPassword()>"));
        Assert.assertFalse((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void pathSkipTest4() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void pathSkipTest4()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertFalse((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.AccountManager: java.lang.String getPassword()>"));
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void pathSkipTest5() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void pathSkipTest5()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertFalse((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.AccountManager: java.lang.String getPassword()>"));
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void pathSkipTest6() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void pathSkipTest6()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.AccountManager: java.lang.String getPassword()>"));
        Assert.assertFalse((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void recursionTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void recursionTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void noPathsTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void noPathsTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void doPrivilegedTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void doPrivilegedTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void doPrivilegedTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void doPrivilegedTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void doPrivilegedTest3() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void doPrivilegedTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void doPrivilegedTest3_NoJDK() {
        IInfoflow infoflow = this.initInfoflow();
        infoflow.setSootConfig(new IInfoflowConfig(){

            public void setSootOptions(Options options, InfoflowConfiguration config) {
                ArrayList<String> excludeList = new ArrayList<String>();
                excludeList.add("java.");
                excludeList.add("javax.");
                options.set_exclude(excludeList);
                options.set_prepend_classpath(false);
                Options.v().set_ignore_classpath_errors(true);
            }
        });
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void doPrivilegedTest3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void multiSinkTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void multiSinkTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 2);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void multiSinkTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void multiSinkTest2()>");
        infoflow.getConfig().setPathAgnosticResults(false);
        infoflow.getConfig().getPathConfiguration().setPathReconstructionMode(InfoflowConfiguration.PathReconstructionMode.Fast);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
        Assert.assertEquals((long)2L, (long)infoflow.getResults().numConnections());
    }

    @Test(timeout=300000L)
    public void multiSinkTest3() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void multiSinkTest3()>");
        infoflow.getConfig().setPathAgnosticResults(false);
        infoflow.getConfig().getPathConfiguration().setPathReconstructionMode(InfoflowConfiguration.PathReconstructionMode.Fast);
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(int)>", "<soot.jimple.infoflow.test.android.TelephonyManager: int getIMEI()>"));
        Assert.assertEquals((long)2L, (long)infoflow.getResults().numConnections());
    }

    @Test(timeout=300000L)
    public void skipOverObjectTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void skipOverObjectTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void skipOverObjectTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void skipOverObjectTest2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=300000L)
    public void testNeighbors1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.OtherTestCode: void testNeighbors1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertEquals((long)3L, (long)infoflow.getResults().getResultSet().size());
    }
}

