/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import soot.SootMethod;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.IfStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.LeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.entryPointCreators.DefaultEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.IReversibleSourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;
import soot.jimple.infoflow.taintWrappers.EasyTaintWrapper;
import soot.jimple.infoflow.test.junit.JUnitTests;

public abstract class SourceSinkTests
extends JUnitTests {
    private static final String sourceGetSecret = "<soot.jimple.infoflow.test.SourceSinkTestCode: soot.jimple.infoflow.test.SourceSinkTestCode$A getSecret()>";
    private static final String sourceGetSecret2 = "<soot.jimple.infoflow.test.SourceSinkTestCode: soot.jimple.infoflow.test.SourceSinkTestCode$B getSecret2()>";
    private static final String sinkAP = "<soot.jimple.infoflow.test.SourceSinkTestCode: void doLeakSecret2(soot.jimple.infoflow.test.SourceSinkTestCode$A)>";
    private static final String sinkAP2 = "<soot.jimple.infoflow.test.SourceSinkTestCode: void doLeakSecret(java.lang.String)>";
    private final ISourceSinkManager getSecretSSM = new BaseSourceSinkManager(){

        public SourceInfo getSourceInfo(Stmt sCallSite, InfoflowManager manager) {
            if (sCallSite.containsInvokeExpr() && sCallSite instanceof DefinitionStmt && sCallSite.getInvokeExpr().getMethod().getName().equals("getSecret")) {
                AccessPath ap = manager.getAccessPathFactory().createAccessPath(((DefinitionStmt)sCallSite).getLeftOp(), true);
                return new SourceInfo(ap);
            }
            return null;
        }

        public SinkInfo getInverseSourceInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
            if (sCallSite.containsInvokeExpr() && sCallSite instanceof DefinitionStmt && sCallSite.getInvokeExpr().getMethod().getName().equals("getSecret") && (ap == null || ((DefinitionStmt)sCallSite).getLeftOp() == ap.getPlainValue())) {
                SootMethod target = sCallSite.getInvokeExpr().getMethod();
                return new SinkInfo((ISourceSinkDefinition)new MethodSourceSinkDefinition(new SootMethodAndClass(target)));
            }
            return null;
        }
    };
    private final ISourceSinkManager getSecretOrSecret2SSM = new BaseSourceSinkManager(){

        public SourceInfo getSourceInfo(Stmt sCallSite, InfoflowManager manager) {
            if (sCallSite.containsInvokeExpr() && sCallSite instanceof DefinitionStmt && (sCallSite.getInvokeExpr().getMethod().getName().equals("getSecret") || sCallSite.getInvokeExpr().getMethod().getName().equals("getSecret2"))) {
                AccessPath ap = manager.getAccessPathFactory().createAccessPath(((DefinitionStmt)sCallSite).getLeftOp(), true);
                return new SourceInfo(ap);
            }
            return null;
        }

        public SinkInfo getInverseSourceInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
            if (sCallSite.containsInvokeExpr() && sCallSite instanceof DefinitionStmt && (sCallSite.getInvokeExpr().getMethod().getName().equals("getSecret") || sCallSite.getInvokeExpr().getMethod().getName().equals("getSecret2")) && (ap == null || ((DefinitionStmt)sCallSite).getLeftOp() == ap.getPlainValue())) {
                SootMethod target = sCallSite.getInvokeExpr().getMethod();
                return new SinkInfo((ISourceSinkDefinition)new MethodSourceSinkDefinition(new SootMethodAndClass(target)));
            }
            return null;
        }
    };
    private final ISourceSinkManager noTaintSubFieldsSSM = new BaseSourceSinkManager(){

        public SourceInfo getSourceInfo(Stmt sCallSite, InfoflowManager manager) {
            if (sCallSite.containsInvokeExpr() && sCallSite instanceof DefinitionStmt && sCallSite.getInvokeExpr().getMethod().getName().equals("getSecret")) {
                AccessPath ap = manager.getAccessPathFactory().createAccessPath(((DefinitionStmt)sCallSite).getLeftOp(), false);
                return new SourceInfo(ap);
            }
            return null;
        }

        public SinkInfo getInverseSourceInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
            if (ap == null) {
                return null;
            }
            if (sCallSite.containsInvokeExpr() && sCallSite instanceof DefinitionStmt && sCallSite.getInvokeExpr().getMethod().getName().equals("getSecret") && ((DefinitionStmt)sCallSite).getLeftOp() == ap.getPlainValue()) {
                SootMethod target = sCallSite.getInvokeExpr().getMethod();
                return new SinkInfo((ISourceSinkDefinition)new MethodSourceSinkDefinition(new SootMethodAndClass(target)));
            }
            return null;
        }

        @Override
        public SourceInfo getInverseSinkInfo(Stmt sCallSite, InfoflowManager manager) {
            if (!sCallSite.containsInvokeExpr()) {
                return null;
            }
            SootMethod target = sCallSite.getInvokeExpr().getMethod();
            if ((target.getSignature().equals(SourceSinkTests.sinkAP) || target.getSignature().equals(SourceSinkTests.sinkAP2) || target.getSignature().equals("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>")) && sCallSite.getInvokeExpr().getArgCount() > 0) {
                AccessPath ap = manager.getAccessPathFactory().createAccessPath(sCallSite.getInvokeExpr().getArg(0), false);
                return new SourceInfo((ISourceSinkDefinition)new MethodSourceSinkDefinition(new SootMethodAndClass(target)), ap);
            }
            return null;
        }
    };

    @Test(timeout=300000L)
    public void fieldTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.SourceSinkTestCode: void testDataObject()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), this.getSecretSSM);
        Assert.assertTrue((boolean)infoflow.isResultAvailable());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", sourceGetSecret));
    }

    @Test(timeout=300000L)
    public void negativeFieldTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.SourceSinkTestCode: void testDataObject()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), this.noTaintSubFieldsSSM);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void accessPathTypesTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.SourceSinkTestCode: void testAccessPathTypes()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), this.getSecretOrSecret2SSM);
        Assert.assertTrue((boolean)infoflow.isResultAvailable());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", sourceGetSecret));
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", sourceGetSecret2));
    }

    @Test(timeout=300000L)
    public void sourceAccessPathTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.SourceSinkTestCode: void testSourceAccessPaths()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), this.noTaintSubFieldsSSM);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void sinkAccessPathTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.SourceSinkTestCode: void testSinkAccessPaths()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), this.noTaintSubFieldsSSM);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void sinkAccessPathTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.SourceSinkTestCode: void testSinkAccessPaths2()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), this.noTaintSubFieldsSSM);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=300000L)
    public void ifAsSinkTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.SourceSinkTestCode: void ifAsSinkTest()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), (ISourceSinkManager)new ifAsSinkSSM());
        Assert.assertTrue((boolean)infoflow.isResultAvailable());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
    }

    @Test(timeout=300000L)
    public void sourceToSourceTest() {
        IInfoflow infoflow = this.initInfoflow(true);
        ((EasyTaintWrapper)infoflow.getTaintWrapper()).addIncludePrefix("soot.jimple.infoflow.test.SourceSinkTestCode");
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.SourceSinkTestCode: void sourceToSourceTest()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), (ISourceSinkManager)new sourceToSourceSSM());
        Assert.assertTrue((boolean)infoflow.isResultAvailable());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().numConnections());
    }

    @Test(timeout=300000L)
    public void parameterSourceTest1() {
        IInfoflow infoflow = this.initInfoflow(true);
        ((EasyTaintWrapper)infoflow.getTaintWrapper()).addIncludePrefix("soot.jimple.infoflow.test.SourceSinkTestCode");
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.SourceSinkTestCode: void parameterSourceTest1()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), (ISourceSinkManager)new parameterSourceSSM());
        Assert.assertTrue((boolean)infoflow.isResultAvailable());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().numConnections());
    }

    @Test(timeout=300000L)
    public void parameterSourceTest2() {
        IInfoflow infoflow = this.initInfoflow(true);
        ((EasyTaintWrapper)infoflow.getTaintWrapper()).addIncludePrefix("soot.jimple.infoflow.test.SourceSinkTestCode");
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.SourceSinkTestCode: void parameterSourceTest2()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), (ISourceSinkManager)new parameterSourceSSM());
        Assert.assertTrue((boolean)infoflow.isResultAvailable());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().numConnections());
    }

    @Test(timeout=300000L)
    public void parameterSourceTest3() {
        IInfoflow infoflow = this.initInfoflow(true);
        ((EasyTaintWrapper)infoflow.getTaintWrapper()).addIncludePrefix("soot.jimple.infoflow.test.SourceSinkTestCode");
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.SourceSinkTestCode: void parameterSourceTest3()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), (ISourceSinkManager)new parameterSourceSSM());
        Assert.assertTrue((boolean)infoflow.isResultAvailable());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().numConnections());
    }

    @Test(timeout=300000L)
    public void parameterSourceTest4() {
        IInfoflow infoflow = this.initInfoflow(true);
        ((EasyTaintWrapper)infoflow.getTaintWrapper()).addIncludePrefix("soot.jimple.infoflow.test.SourceSinkTestCode");
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.SourceSinkTestCode: void parameterSourceTest4()>");
        infoflow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(epoints), (ISourceSinkManager)new parameterSourceSSM());
        Assert.assertTrue((boolean)infoflow.isResultAvailable());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().size());
        Assert.assertEquals((long)1L, (long)infoflow.getResults().numConnections());
    }

    private final class ifAsSinkSSM
    implements IReversibleSourceSinkManager {
        private ifAsSinkSSM() {
        }

        public SourceInfo getSourceInfo(Stmt sCallSite, InfoflowManager manager) {
            if (sCallSite instanceof DefinitionStmt && sCallSite.containsInvokeExpr() && sCallSite.getInvokeExpr().getMethod().getName().equals("currentTimeMillis")) {
                Value val = ((DefinitionStmt)sCallSite).getLeftOp();
                return new SourceInfo(manager.getAccessPathFactory().createAccessPath(val, true));
            }
            return null;
        }

        public SinkInfo getSinkInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
            return sCallSite instanceof IfStmt ? new SinkInfo() : null;
        }

        public SinkInfo getInverseSourceInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
            if (sCallSite instanceof DefinitionStmt && sCallSite.containsInvokeExpr() && sCallSite.getInvokeExpr().getMethod().getName().equals("currentTimeMillis") && (ap == null || ((DefinitionStmt)sCallSite).getLeftOp() == ap.getPlainValue())) {
                return new SinkInfo();
            }
            return null;
        }

        public SourceInfo getInverseSinkInfo(Stmt sCallSite, InfoflowManager manager) {
            if (!(sCallSite instanceof IfStmt)) {
                return null;
            }
            Value cond = ((IfStmt)sCallSite).getCondition();
            if (!(cond instanceof LeExpr)) {
                return null;
            }
            LeExpr le = (LeExpr)cond;
            AccessPath ap = manager.getAccessPathFactory().createAccessPath(le.getOp1(), true);
            return ap != null ? new SourceInfo(ap) : null;
        }

        public void initialize() {
        }
    }

    private final class sourceToSourceSSM
    extends BaseSourceSinkManager {
        private sourceToSourceSSM() {
        }

        public SourceInfo getSourceInfo(Stmt sCallSite, InfoflowManager manager) {
            if (sCallSite instanceof DefinitionStmt && sCallSite.containsInvokeExpr() && sCallSite.getInvokeExpr().getMethod().getName().equals("getSecret")) {
                Value val = ((DefinitionStmt)sCallSite).getLeftOp();
                return new SourceInfo(manager.getAccessPathFactory().createAccessPath(val, true));
            }
            return null;
        }

        public SinkInfo getInverseSourceInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
            if (sCallSite.containsInvokeExpr() && sCallSite instanceof DefinitionStmt && sCallSite.getInvokeExpr().getMethod().getName().equals("getSecret") && (ap == null || ((DefinitionStmt)sCallSite).getLeftOp() == ap.getPlainValue())) {
                SootMethod target = sCallSite.getInvokeExpr().getMethod();
                return new SinkInfo((ISourceSinkDefinition)new MethodSourceSinkDefinition(new SootMethodAndClass(target)));
            }
            return null;
        }
    }

    private final class parameterSourceSSM
    extends BaseSourceSinkManager {
        private parameterSourceSSM() {
        }

        public SourceInfo getSourceInfo(Stmt sCallSite, InfoflowManager manager) {
            if (sCallSite.containsInvokeExpr()) {
                InvokeExpr iexpr = sCallSite.getInvokeExpr();
                String name = iexpr.getMethod().getName();
                boolean includeExistingImmutableAliases = name.equals("annotatedSource");
                if ((name.equals("source") || includeExistingImmutableAliases) && iexpr.getArgCount() > 0) {
                    AccessPath ap = manager.getAccessPathFactory().createAccessPath(iexpr.getArg(0), null, null, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength, true);
                    return new SourceInfo(ap);
                }
            }
            return null;
        }

        public SinkInfo getInverseSourceInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
            if (sCallSite.containsInvokeExpr()) {
                InvokeExpr iexpr = sCallSite.getInvokeExpr();
                String name = iexpr.getMethod().getName();
                boolean includeExistingImmutableAliases = name.equals("annotatedSource");
                if ((name.equals("source") || includeExistingImmutableAliases) && iexpr.getArgCount() > 0) {
                    if (ap == null) {
                        return new SinkInfo();
                    }
                    if (iexpr.getArg(0) == ap.getPlainValue()) {
                        SootMethod target = sCallSite.getInvokeExpr().getMethod();
                        return new SinkInfo((ISourceSinkDefinition)new MethodSourceSinkDefinition(new SootMethodAndClass(target)));
                    }
                }
            }
            return null;
        }

        @Override
        public SourceInfo getInverseSinkInfo(Stmt sCallSite, InfoflowManager manager) {
            if (!sCallSite.containsInvokeExpr()) {
                return null;
            }
            SootMethod target = sCallSite.getInvokeExpr().getMethod();
            if ((target.getSignature().equals(SourceSinkTests.sinkAP) || target.getSignature().equals(SourceSinkTests.sinkAP2) || target.getSignature().equals("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>")) && sCallSite.getInvokeExpr().getArgCount() > 0) {
                AccessPath ap = manager.getAccessPathFactory().createAccessPath(sCallSite.getInvokeExpr().getArg(0), null, null, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength, true);
                return new SourceInfo((ISourceSinkDefinition)new MethodSourceSinkDefinition(new SootMethodAndClass(target)), ap);
            }
            return null;
        }
    }

    private abstract class BaseSourceSinkManager
    implements IReversibleSourceSinkManager {
        private BaseSourceSinkManager() {
        }

        public void initialize() {
        }

        public SinkInfo getSinkInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
            if (!sCallSite.containsInvokeExpr()) {
                return null;
            }
            SootMethod target = sCallSite.getInvokeExpr().getMethod();
            SinkInfo targetInfo = new SinkInfo((ISourceSinkDefinition)new MethodSourceSinkDefinition(new SootMethodAndClass(target)));
            if ((target.getSignature().equals(SourceSinkTests.sinkAP) || target.getSignature().equals(SourceSinkTests.sinkAP2) || target.getSignature().equals("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>")) && sCallSite.getInvokeExpr().getArgCount() > 0) {
                if (ap == null) {
                    return targetInfo;
                }
                if (ap.getPlainValue() == sCallSite.getInvokeExpr().getArg(0) && (ap.isLocal() || ap.getTaintSubFields())) {
                    return targetInfo;
                }
            }
            return null;
        }

        public SourceInfo getInverseSinkInfo(Stmt sCallSite, InfoflowManager manager) {
            if (!sCallSite.containsInvokeExpr()) {
                return null;
            }
            SootMethod target = sCallSite.getInvokeExpr().getMethod();
            if ((target.getSignature().equals(SourceSinkTests.sinkAP) || target.getSignature().equals(SourceSinkTests.sinkAP2) || target.getSignature().equals("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>")) && sCallSite.getInvokeExpr().getArgCount() > 0) {
                AccessPath ap = manager.getAccessPathFactory().createAccessPath(sCallSite.getInvokeExpr().getArg(0), true);
                return new SourceInfo((ISourceSinkDefinition)new MethodSourceSinkDefinition(new SootMethodAndClass(target)), ap);
            }
            return null;
        }
    }
}

