/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.test.junit.JUnitTests;
import soot.options.Options;

public abstract class StringTests
extends JUnitTests {
    @Test(timeout=600000L)
    public void multipleSourcesTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void multipleSources()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void substringTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodSubstring()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void lowerCaseTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringLowerCase()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void upperCaseTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringUpperCase()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void concatTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringConcat1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void concatTest1b() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringConcat1b()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void concatTest1c() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringConcat1c(java.lang.String)>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void concatTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringConcat2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void stringConcatTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void stringConcatTest()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void stringConcatTestSmall1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void stringConcatTestSmall1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void stringConcatTestSmall2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void stringConcatTestSmall2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void concatTestNegative() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringConcatNegative()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.negativeCheckInfoflow(infoflow);
    }

    @Test(timeout=600000L)
    public void concatPlusTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringConcatPlus1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void concatPlusTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringConcatPlus2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void valueOfTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodValueOf()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void toStringTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodtoString()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void stringBufferTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringBuffer1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void stringBufferTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringBuffer2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void stringBuilderTest1() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringBuilder1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void stringBuilderTest2() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringBuilder2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void stringBuilderTest2_NoJDK() {
        IInfoflow infoflow = this.initInfoflow(true);
        infoflow.setSootConfig(new IInfoflowConfig(){

            public void setSootOptions(Options options, InfoflowConfiguration config) {
                ArrayList<String> excludeList = new ArrayList<String>();
                excludeList.add("java.");
                excludeList.add("javax.");
                options.set_exclude(excludeList);
                options.set_prepend_classpath(false);
                Options.v().set_ignore_classpath_errors(true);
            }
        });
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringBuilder2()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void stringBuilderTest3() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringBuilder3()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void stringBuilderTest4() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringBuilder4(java.lang.String)>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void stringBuilderTest5() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringBuilder5()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void stringBuilderTest6() {
        IInfoflow infoflow = this.initInfoflow(true);
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringBuilder6()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void testcharArray() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void getChars()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test(timeout=600000L)
    public void testStringConcat() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringConcat()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods("<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>", "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>"));
    }

    @Test(timeout=600000L)
    public void testStringConstructor() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodStringConstructor()>");
        LinkedList<String> sources = new LinkedList<String>();
        sources.add("<java.lang.String: void <init>(java.lang.String)>");
        LinkedList<String> sinks = new LinkedList<String>();
        sinks.add("<java.lang.Runtime: java.lang.Process exec(java.lang.String)>");
        infoflow.computeInfoflow(appPath, libPath, epoints, sources, sinks);
        Assert.assertNotNull((Object)infoflow.getResults());
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods((String)sinks.get(0), (String)sources.get(0)));
    }

    @Test
    public void methodToCharArrayTest() {
        IInfoflow infoflow = this.initInfoflow();
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void methodToCharArray()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, (Collection)sources, (Collection)sinks);
        this.checkInfoflow(infoflow, 1);
    }

    @Test
    public void stringFileStreamTest1() {
        IInfoflow infoflow = this.initInfoflow();
        LinkedList<String> sources = new LinkedList<String>();
        sources.add("<soot.jimple.infoflow.test.StringTestCode: byte[] read(byte[],java.io.FileInputStream)>");
        LinkedList<String> sinks = new LinkedList<String>();
        sinks.add("<java.io.FileOutputStream: void write(byte[])>");
        ArrayList<String> epoints = new ArrayList<String>();
        epoints.add("<soot.jimple.infoflow.test.StringTestCode: void stringFileStreamTest1()>");
        infoflow.computeInfoflow(appPath, libPath, epoints, sources, sinks);
        Assert.assertNotNull((Object)infoflow.getResults());
        Assert.assertTrue((boolean)infoflow.getResults().isPathBetweenMethods((String)sinks.get(0), (String)sources.get(0)));
    }
}

