/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.methodSummary.junit;

import java.util.LinkedList;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.generator.SummaryGenerator;
import soot.jimple.infoflow.test.methodSummary.junit.ApiTestHelper;

public class ApiTests
extends ApiTestHelper {
    static final String className = "soot.jimple.infoflow.test.methodSummary.ApiClass";

    @Test(timeout=100000L)
    public void standardFlow1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int standardFlow(int)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, null));
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void standardFlow11() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int standardFlow(int)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void standardFlow2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int standardFlow2(int,int)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, null));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Return, null));
    }

    @Test(timeout=100000L)
    public void standardFlow2Com() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int standardFlow2Com(int,int)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, null));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, null));
    }

    @Test(timeout=100000L)
    public void standardFlow22() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int standardFlow2(int,int)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, null));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, null));
        Assert.assertEquals((long)2L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void standardFlow3() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int standardFlow3(soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Return, null));
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void standardFlow31() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int standardFlow3(soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void standardFlow4() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data standardFlow4(int,java.lang.Object)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Return, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertEquals((long)2L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void standardFlow6() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data standardFlow6(java.lang.Object)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
    }

    @Test(timeout=100000L)
    public void standardFlow8() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data standardFlow8(soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}, SourceSinkType.Return, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void staticStandardFlow1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int staticStandardFlow1(int,int)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, null));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Return, null));
        Assert.assertEquals((long)2L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void staticStandardFlow11() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int staticStandardFlow1(int,int)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, null));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Return, null));
        Assert.assertEquals((long)2L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void staticStandardFlow2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data staticStandardFlow2(int,java.lang.Object)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Return, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
    }

    @Test(timeout=100000L)
    public void staticStandardFlow21() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data staticStandardFlow2(int,java.lang.Object)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Return, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertEquals((long)2L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void noFlow() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int noFlow(int)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((res == null || res.size() == 0 ? 1 : 0) != 0);
    }

    @Test(timeout=100000L)
    public void noFlow2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int noFlow2(int,int)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((res == null || res.size() == 0 ? 1 : 0) != 0);
    }

    @Test(timeout=100000L)
    public void noFlow3() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data noFlow3(soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((res == null || res.size() == 0 ? 1 : 0) != 0);
    }

    @Test(timeout=100000L)
    public void noFlow4() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data noFlow4(int,java.lang.Object)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((res == null || res.size() == 0 ? 1 : 0) != 0);
    }

    @Test(timeout=100000L)
    public void paraToVar() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int paraToVar(int,int)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: int primitiveVariable"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: int primitiveVariable"}));
    }

    @Test(timeout=100000L)
    public void paraToVar12() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int paraToVar(int,int)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: int primitiveVariable"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: int primitiveVariable"}));
        Assert.assertEquals((long)2L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void paraToVar2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data paraToVar2(int,java.lang.Object)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertEquals((long)4L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void paraToVar21() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data paraToVar2(int,java.lang.Object)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Return, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertEquals((long)4L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void paraToparaFlow1WrongSinkSigAccepted() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void paraToparaFlow1(int,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, SourceSinkType.Parameter, 1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void paraToparaFlow2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void paraToparaFlow2(int,java.lang.Object,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertEquals((long)2L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void paraToparaFlow3WrongSinkSigAccepted() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void paraToparaFlow3(int,java.lang.Object,soot.jimple.infoflow.test.methodSummary.Data,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, SourceSinkType.Parameter, 3, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
    }

    @Test(timeout=100000L)
    public void staticParaToParaFlow1WrongSinkSigAccepted() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void staticParaToparaFlow1(int,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, SourceSinkType.Parameter, 1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void staticParaToParaFlow2WrongSinkSigAccepted() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void staticParaToparaFlow2(int,java.lang.Object,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertEquals((long)2L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void staticParaToParaFlow3WrongSinkSigAccepted() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void staticParaToparaFlow3(int,java.lang.Object,soot.jimple.infoflow.test.methodSummary.Data,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
    }

    @Test(timeout=100000L)
    public void mixedFlow1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data mixedFlow1(int,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Return, null));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, SourceSinkType.Parameter, 1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: int primitiveVariable"}));
        Assert.assertEquals((long)4L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void mixedFlow1small() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data mixedFlow1small(int,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 1, null, SourceSinkType.Return, null));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, SourceSinkType.Parameter, 1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertEquals((long)3L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void paraToparaFlow1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void paraToparaFlow1(int,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Parameter, 1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void paraToparaFlow3() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void paraToparaFlow3(int,java.lang.Object,soot.jimple.infoflow.test.methodSummary.Data,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, SourceSinkType.Parameter, 3, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertEquals((long)3L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void staticParaToParaFlow1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void staticParaToparaFlow1(int,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Parameter, 1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void staticParaToParaFlow2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void staticParaToparaFlow2(int,java.lang.Object,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertEquals((long)2L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void staticParaToParaFlow3() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void staticParaToparaFlow3(int,java.lang.Object,soot.jimple.infoflow.test.methodSummary.Data,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, SourceSinkType.Parameter, 2, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, SourceSinkType.Parameter, 3, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertEquals((long)3L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void primitivVarToReturn1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int intParaToReturn()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: int primitiveVariable"}, SourceSinkType.Return, null));
    }

    @Test(timeout=100000L)
    public void nonPrimitivVarToReturn1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int intInDataToReturn()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Return, null));
    }

    @Test(timeout=100000L)
    public void nonPrimitivVarToReturn11() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int intInDataToReturn()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Return, null));
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void nonPrimitivVarToReturn2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int intInDataToReturn2()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Return, null));
    }

    @Test(timeout=100000L)
    public void nonPrimitivVarToReturn3() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: int intInDataToReturn3()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Return, null));
    }

    @Test(timeout=100000L)
    public void nonPrimitivVarToReturn4() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataFieldToReturn()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>"}, SourceSinkType.Return, null));
    }

    @Test(timeout=200000L)
    public void nonPrimitivVarToReturn5() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataFieldToReturn2()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>"}, SourceSinkType.Return, null));
    }

    @Test(timeout=100000L)
    public void swap() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void swap()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>"}, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField2"}));
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test(timeout=100000L)
    public void swap2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void swap2()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField2", "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField2", "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
    }

    @Test(timeout=100000L)
    public void data1ToDate2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void data1ToDate2()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>"}, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField2"}));
    }

    @Test(timeout=150000L)
    public void fieldToPara1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void fieldToPara(soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
    }

    @Test(timeout=150000L)
    public void ListGetTest() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: java.lang.Object get()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.ApiClass$Node first>", "<soot.jimple.infoflow.test.methodSummary.ApiClass$Node: java.lang.Object item>"}, SourceSinkType.Return, new String[0]));
    }

    @Test(timeout=100000L)
    public void fieldToField1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void fieldToField1()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>"}, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField2"}));
    }

    @Test(timeout=100000L)
    public void fieldToField2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void fieldToField2()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: java.lang.Object objectField>"}));
    }

    @Test(timeout=100000L)
    public void fieldToField3() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void fieldToField3()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField2", "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: int primitiveVariable"}));
    }

    @Test(timeout=100000L)
    public void fieldToField4() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void fieldToField4()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: java.lang.Object objectField>"}, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField2", "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
    }

    @Test(timeout=100000L)
    public void fieldToField5() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void fieldToField5()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}, SourceSinkType.Field, new String[]{"soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField2", "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
    }

    @Test(timeout=100000L)
    public void shiftTest() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: java.lang.String shiftTest(soot.jimple.infoflow.test.methodSummary.Data,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.String stringField>"}, SourceSinkType.Parameter, 1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.String stringField>"}));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.String stringField>"}, SourceSinkType.Return, 1, null));
    }

    @Test(timeout=100000L)
    public void storeAliasInGapClass() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: java.lang.String storeAliasInGapClass(soot.jimple.infoflow.test.methodSummary.IGapClass,java.lang.String)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Return, -1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.String stringField>"}, "<soot.jimple.infoflow.test.methodSummary.IGapClass: soot.jimple.infoflow.test.methodSummary.Data retrieveData()>", SourceSinkType.Return, -1, null, ""));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, "", SourceSinkType.Return, -1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.String stringField>"}, "<soot.jimple.infoflow.test.methodSummary.IGapClass: soot.jimple.infoflow.test.methodSummary.Data retrieveData()>"));
    }

    @Test(timeout=100000L)
    public void setNonPrimitiveData1APL3() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void setNonPrimitiveData1APL3(java.lang.Object)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, SourceSinkType.Field, -1, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
    }

    @Test(timeout=100000L)
    public void getNonPrimitiveData1APL3() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: java.lang.Object getNonPrimitiveData1APL3()>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Field, -1, new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>", "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}, SourceSinkType.Return, -1, null));
    }

    @Test(timeout=100000L)
    public void transferNoStringThroughDataClass() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: java.lang.String transferNoStringThroughDataClass(soot.jimple.infoflow.test.methodSummary.IGapClass,java.lang.String)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        String gapSig = this.makeGapClassSignature("soot.jimple.infoflow.test.methodSummary.Data dataThroughGap(soot.jimple.infoflow.test.methodSummary.Data)");
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, null, SourceSinkType.GapBaseObject, -1, null, gapSig));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, null, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.String stringField>"}, gapSig));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Return, -1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.String stringField2>"}, gapSig, SourceSinkType.Return, -1, null, null));
    }

    @Test(timeout=100000L)
    public void makeStringUserCodeClass() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: java.lang.String makeStringUserCodeClass(soot.jimple.infoflow.test.methodSummary.IUserCodeClass,java.lang.String)>";
        Set res = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 1, null, "", SourceSinkType.Parameter, 0, null, "<soot.jimple.infoflow.test.methodSummary.IUserCodeClass: java.lang.String callTheGap(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Parameter, 0, null, "", SourceSinkType.GapBaseObject, -1, null, "<soot.jimple.infoflow.test.methodSummary.IUserCodeClass: java.lang.String callTheGap(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(res, SourceSinkType.Return, -1, null, "<soot.jimple.infoflow.test.methodSummary.IUserCodeClass: java.lang.String callTheGap(java.lang.String)>", SourceSinkType.Return, -1, null, ""));
    }

    @Override
    protected SummaryGenerator getSummary() {
        SummaryGenerator sg = new SummaryGenerator();
        LinkedList<String> sub = new LinkedList<String>();
        sub.add("java.util.ArrayList");
        sg.setSubstitutedWith(sub);
        sg.getConfig().getAccessPathConfiguration().setAccessPathLength(5);
        sg.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(true);
        return sg;
    }
}

