/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.methodSummary.junit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.stream.XMLStreamException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import soot.G;
import soot.jimple.infoflow.AbstractInfoflow;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.entryPointCreators.DefaultEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.methodSummary.taintWrappers.TaintWrapperFactory;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.options.Options;

public abstract class BaseSummaryTaintWrapperTests {
    private static String appPath;
    private static String libPath;
    private String[] source = new String[]{"<soot.jimple.infoflow.test.methodSummary.ApiClassClient: java.lang.Object source()>", "<soot.jimple.infoflow.test.methodSummary.ApiClassClient: int intSource()>", "<soot.jimple.infoflow.test.methodSummary.ApiClassClient: java.lang.String stringSource()>", "<soot.jimple.infoflow.test.methodSummary.ApiClassClient: java.lang.String stringSource2()>"};
    private String sink = "<soot.jimple.infoflow.test.methodSummary.ApiClassClient: void sink(java.lang.Object)>";
    private ITaintPropagationWrapper summaryWrapper;

    @Before
    public void resetSootAndStream() throws IOException {
        G.reset();
        System.gc();
    }

    protected void testFlowForMethod(String m) {
        this.testFlowForMethod(m, 1);
    }

    protected void testFlowForMethod(String m, int count2) {
        IInfoflow iFlow = null;
        try {
            iFlow = this.initInfoflow();
            iFlow.getConfig().getAccessPathConfiguration().setAccessPathLength(3);
            iFlow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(Collections.singletonList(m)), Arrays.asList(this.source), Collections.singletonList(this.sink));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.checkInfoflow(iFlow, count2);
    }

    protected void testNoFlowForMethod(String m) {
        IInfoflow iFlow = null;
        try {
            iFlow = this.initInfoflow();
            iFlow.computeInfoflow(appPath, libPath, (IEntryPointCreator)new DefaultEntryPointCreator(Collections.singletonList(m)), Arrays.asList(this.source), Collections.singletonList(this.sink));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.checkNoInfoflow(iFlow);
    }

    private void checkNoInfoflow(IInfoflow infoflow) {
        Assert.assertTrue((!infoflow.isResultAvailable() || infoflow.getResults().size() == 0 ? 1 : 0) != 0);
    }

    private void checkInfoflow(IInfoflow infoflow, int resultCount) {
        if (infoflow.isResultAvailable()) {
            InfoflowResults map = infoflow.getResults();
            Assert.assertTrue((boolean)map.containsSinkMethod(this.sink));
            Assert.assertTrue((map.isPathBetweenMethods(this.sink, this.source[0]) || map.isPathBetweenMethods(this.sink, this.source[1]) || map.isPathBetweenMethods(this.sink, this.source[2]) || map.isPathBetweenMethods(this.sink, this.source[3]) ? 1 : 0) != 0);
            Assert.assertEquals((long)resultCount, (long)infoflow.getResults().numConnections());
        } else {
            Assert.fail((String)"result is not available");
        }
    }

    protected abstract AbstractInfoflow createInfoflowInstance();

    protected IInfoflow initInfoflow() throws IOException, XMLStreamException {
        AbstractInfoflow result = this.createInfoflowInstance();
        result.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(false);
        IInfoflowConfig testConfig = new IInfoflowConfig(){

            public void setSootOptions(Options options, InfoflowConfiguration config) {
                ArrayList<String> excludeList = new ArrayList<String>();
                excludeList.add("soot.jimple.infoflow.test.methodSummary.ApiClass");
                excludeList.add("soot.jimple.infoflow.test.methodSummary.GapClass");
                Options.v().set_exclude(excludeList);
                ArrayList<String> includeList = new ArrayList<String>();
                includeList.add("soot.jimple.infoflow.test.methodSummary.UserCodeClass");
                Options.v().set_include(includeList);
                Options.v().set_no_bodies_for_excluded(true);
                Options.v().set_allow_phantom_refs(true);
                Options.v().set_ignore_classpath_errors(true);
            }
        };
        result.setSootConfig(testConfig);
        File testRoot = BaseSummaryTaintWrapperTests.getTestRoot();
        HashSet<File> summaryFiles = new HashSet<File>();
        summaryFiles.add(new File(testRoot, "./testSummaries/soot.jimple.infoflow.test.methodSummary.ApiClass.xml"));
        summaryFiles.add(new File(testRoot, "./testSummaries/soot.jimple.infoflow.test.methodSummary.GapClass.xml"));
        summaryFiles.add(new File(testRoot, "./testSummaries/soot.jimple.infoflow.test.methodSummary.Data.xml"));
        summaryFiles.add(new File(testRoot, "./testSummaries/soot.jimple.infoflow.test.methodSummary.TestCollection.xml"));
        summaryFiles.add(new File(testRoot, "./summariesManual"));
        this.summaryWrapper = TaintWrapperFactory.createTaintWrapperFromFiles(summaryFiles);
        result.setTaintWrapper(this.summaryWrapper);
        return result;
    }

    @BeforeClass
    public static void setUp() throws IOException {
        StringBuilder appPathBuilder = new StringBuilder();
        File f = BaseSummaryTaintWrapperTests.getTestRoot();
        BaseSummaryTaintWrapperTests.addTestPathes(f, appPathBuilder);
        File fi = new File(f, "../soot-infoflow");
        if (!fi.getCanonicalFile().equals(f.getCanonicalFile())) {
            BaseSummaryTaintWrapperTests.addTestPathes(fi, appPathBuilder);
        }
        if (!(fi = new File(f, "../soot-infoflow-summaries")).getCanonicalFile().equals(f.getCanonicalFile())) {
            BaseSummaryTaintWrapperTests.addTestPathes(fi, appPathBuilder);
        }
        appPath = appPathBuilder.toString();
        StringBuilder libPathBuilder = new StringBuilder();
        BaseSummaryTaintWrapperTests.appendWithSeparator(libPathBuilder, new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
        BaseSummaryTaintWrapperTests.appendWithSeparator(libPathBuilder, new File("/usr/lib/jvm/java-8-openjdk-amd64/jre/lib/rt.jar"));
        libPath = libPathBuilder.toString();
    }

    private static void addTestPathes(File f, StringBuilder appPathBuilder) throws IOException {
        File testSrc1 = new File(f, "bin");
        File testSrc2 = new File(f, "testBin");
        File testSrc3 = new File(f, "build" + File.separator + "classes");
        File testSrc4 = new File(f, "build" + File.separator + "testclasses");
        if (!(testSrc1.exists() || testSrc2.exists() || testSrc3.exists() || testSrc4.exists())) {
            Assert.fail((String)"Test aborted - none of the test sources are available");
        }
        BaseSummaryTaintWrapperTests.appendWithSeparator(appPathBuilder, testSrc1);
        BaseSummaryTaintWrapperTests.appendWithSeparator(appPathBuilder, testSrc2);
        BaseSummaryTaintWrapperTests.appendWithSeparator(appPathBuilder, testSrc3);
        BaseSummaryTaintWrapperTests.appendWithSeparator(appPathBuilder, testSrc4);
    }

    private static void appendWithSeparator(StringBuilder sb, File f) throws IOException {
        if (f.exists()) {
            if (sb.length() > 0) {
                sb.append(System.getProperty("path.separator"));
            }
            sb.append(f.getCanonicalPath());
        }
    }

    public static File getTestRoot() throws IOException {
        File testRoot = new File(".").getCanonicalFile();
        if (!new File(testRoot, "testSummaries").exists()) {
            File subFolder = new File(testRoot, "soot-infoflow-summaries");
            testRoot = subFolder.exists() ? subFolder : new File(testRoot.getParentFile(), "soot-infoflow-summaries");
        }
        if (!new File(testRoot, "testSummaries").exists()) {
            throw new RuntimeException(String.format("Test root not found in %s", testRoot.getAbsolutePath()));
        }
        return testRoot;
    }
}

