/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.methodSummary.junit;

import java.util.Collections;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.methodSummary.DefaultSummaryConfig;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.generator.SummaryGenerator;
import soot.jimple.infoflow.test.methodSummary.junit.TestHelper;
import soot.options.Options;

public class CallbackTests
extends TestHelper {
    static final String className = "soot.jimple.infoflow.test.methodSummary.Callbacks";
    private static final String FIELD_CALLBACK = "<soot.jimple.infoflow.test.methodSummary.Callbacks: soot.jimple.infoflow.test.methodSummary.Callbacks$MyCallbacks cbs>";

    @Test(timeout=100000L)
    public void paraToCallbackToReturn() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.Callbacks: java.lang.String paraToCallbackToReturn(java.lang.String,soot.jimple.infoflow.test.methodSummary.Callbacks$MyCallbacks)>";
        MethodSummaries flow = this.createSummaries(mSig);
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 1, null, "", SourceSinkType.GapBaseObject, 0, null, "<soot.jimple.infoflow.test.methodSummary.Callbacks$MyCallbacks: java.lang.String transform(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 0, null, "", SourceSinkType.Parameter, 0, null, "<soot.jimple.infoflow.test.methodSummary.Callbacks$MyCallbacks: java.lang.String transform(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Return, -1, null, "<soot.jimple.infoflow.test.methodSummary.Callbacks$MyCallbacks: java.lang.String transform(java.lang.String)>", SourceSinkType.Return, -1, null, ""));
        Assert.assertEquals((long)3L, (long)flow.getFlowCount());
    }

    @Test(timeout=100000L)
    public void fieldCallbackToReturn() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.Callbacks: java.lang.String fieldCallbackToReturn(java.lang.String)>";
        MethodSummaries flow = this.createSummaries(mSig);
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Field, -1, new String[]{FIELD_CALLBACK}, "", SourceSinkType.GapBaseObject, 0, null, "<soot.jimple.infoflow.test.methodSummary.Callbacks$MyCallbacks: java.lang.String transform(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 0, null, "", SourceSinkType.Parameter, 0, null, "<soot.jimple.infoflow.test.methodSummary.Callbacks$MyCallbacks: java.lang.String transform(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Return, -1, null, "<soot.jimple.infoflow.test.methodSummary.Callbacks$MyCallbacks: java.lang.String transform(java.lang.String)>", SourceSinkType.Return, -1, null, ""));
        Assert.assertEquals((long)3L, (long)flow.getFlowCount());
    }

    @Test(timeout=100000L)
    public void fieldCallbackToField() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.Callbacks: soot.jimple.infoflow.test.methodSummary.Data fieldCallbackToField(soot.jimple.infoflow.test.methodSummary.Data)>";
        MethodSummaries flow = this.createSummaries(mSig);
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Field, -1, new String[]{FIELD_CALLBACK}, "", SourceSinkType.GapBaseObject, 0, null, "<soot.jimple.infoflow.test.methodSummary.Callbacks$MyCallbacks: void transformObject(soot.jimple.infoflow.test.methodSummary.Data)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 0, null, "", SourceSinkType.Parameter, 0, null, "<soot.jimple.infoflow.test.methodSummary.Callbacks$MyCallbacks: void transformObject(soot.jimple.infoflow.test.methodSummary.Data)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 0, null, "<soot.jimple.infoflow.test.methodSummary.Callbacks$MyCallbacks: void transformObject(soot.jimple.infoflow.test.methodSummary.Data)>", SourceSinkType.Return, -1, null, ""));
        Assert.assertEquals((long)3L, (long)flow.getFlowCount());
    }

    @Test(timeout=100000L)
    public void apiClassMakeString() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: java.lang.String makeString(soot.jimple.infoflow.test.methodSummary.IGapClass,java.lang.String)>";
        MethodSummaries flow = this.createSummaries(mSig);
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 0, null, "", SourceSinkType.GapBaseObject, 0, null, "<soot.jimple.infoflow.test.methodSummary.IGapClass: java.lang.String callTheGap(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 1, null, "", SourceSinkType.Parameter, 0, null, "<soot.jimple.infoflow.test.methodSummary.IGapClass: java.lang.String callTheGap(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Return, -1, null, "<soot.jimple.infoflow.test.methodSummary.IGapClass: java.lang.String callTheGap(java.lang.String)>", SourceSinkType.Return, -1, null, ""));
        Assert.assertEquals((long)3L, (long)flow.getFlowCount());
    }

    @Test(timeout=100000L)
    public void apifillDataObject() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: void fillDataObject(soot.jimple.infoflow.test.methodSummary.IGapClass,java.lang.String,soot.jimple.infoflow.test.methodSummary.Data)>";
        MethodSummaries flow = this.createSummaries(mSig);
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 0, null, "", SourceSinkType.GapBaseObject, 0, null, "<soot.jimple.infoflow.test.methodSummary.IGapClass: void fillDataString(java.lang.String,soot.jimple.infoflow.test.methodSummary.Data)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 1, null, "", SourceSinkType.Parameter, 0, null, "<soot.jimple.infoflow.test.methodSummary.IGapClass: void fillDataString(java.lang.String,soot.jimple.infoflow.test.methodSummary.Data)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 2, null, "", SourceSinkType.Parameter, 1, null, "<soot.jimple.infoflow.test.methodSummary.IGapClass: void fillDataString(java.lang.String,soot.jimple.infoflow.test.methodSummary.Data)>"));
        Assert.assertEquals((long)3L, (long)flow.getFlowCount());
    }

    @Test(timeout=100000L)
    public void gapToGap() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: java.lang.String gapToGap(soot.jimple.infoflow.test.methodSummary.IUserCodeClass,java.lang.String)>";
        MethodSummaries flow = this.createSummaries(mSig);
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 0, null, "", SourceSinkType.GapBaseObject, 0, null, "<soot.jimple.infoflow.test.methodSummary.IUserCodeClass: java.lang.String callTheGap(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 1, null, "", SourceSinkType.Parameter, 0, null, "<soot.jimple.infoflow.test.methodSummary.IUserCodeClass: java.lang.String callTheGap(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Field, -1, null, "<soot.jimple.infoflow.test.methodSummary.IUserCodeClass: java.lang.String callTheGap(java.lang.String)>", SourceSinkType.Parameter, 0, null, ""));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Return, -1, null, "<soot.jimple.infoflow.test.methodSummary.IUserCodeClass: java.lang.String callTheGap(java.lang.String)>", SourceSinkType.Parameter, 0, null, "<soot.jimple.infoflow.test.methodSummary.IUserCodeClass: java.lang.String callTheGap(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Return, -1, null, "<soot.jimple.infoflow.test.methodSummary.IUserCodeClass: java.lang.String callTheGap(java.lang.String)>", SourceSinkType.Return, -1, null, null));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Field, -1, null, "<soot.jimple.infoflow.test.methodSummary.IUserCodeClass: java.lang.String callTheGap(java.lang.String)>", SourceSinkType.GapBaseObject, -1, null, "<soot.jimple.infoflow.test.methodSummary.IUserCodeClass: java.lang.String callTheGap(java.lang.String)>"));
        Assert.assertEquals((long)6L, (long)flow.getFlowCount());
    }

    @Test(timeout=100000L)
    public void callToCall() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ApiClass: java.lang.String callToCall(soot.jimple.infoflow.test.methodSummary.IGapClass,java.lang.String)>";
        MethodSummaries flow = this.createSummaries(mSig);
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 0, null, "", SourceSinkType.GapBaseObject, 0, null, "<soot.jimple.infoflow.test.methodSummary.IGapClass: java.lang.String retrieveString()>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Field, 0, null, "<soot.jimple.infoflow.test.methodSummary.IGapClass: java.lang.String retrieveString()>", SourceSinkType.GapBaseObject, 0, null, "<soot.jimple.infoflow.test.methodSummary.IGapClass: java.lang.String callTheGap(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Parameter, 1, null, "", SourceSinkType.Parameter, 0, null, "<soot.jimple.infoflow.test.methodSummary.IGapClass: java.lang.String callTheGap(java.lang.String)>"));
        Assert.assertTrue((boolean)this.containsFlow(flow.getAllFlows(), SourceSinkType.Return, -1, null, "<soot.jimple.infoflow.test.methodSummary.IGapClass: java.lang.String callTheGap(java.lang.String)>", SourceSinkType.Return, -1, null, null));
        Assert.assertEquals((long)5L, (long)flow.getFlowCount());
    }

    @Override
    protected SummaryGenerator getSummary() {
        SummaryGenerator sg = new SummaryGenerator();
        LinkedList<String> sub = new LinkedList<String>();
        sub.add("java.util.ArrayList");
        sg.setSubstitutedWith(sub);
        sg.getConfig().getAccessPathConfiguration().setAccessPathLength(5);
        sg.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(true);
        sg.setSootConfig((IInfoflowConfig)new DefaultSummaryConfig(){

            public void setSootOptions(Options options, InfoflowConfiguration config) {
                super.setSootOptions(options, config);
                Options.v().set_exclude(Collections.singletonList("soot.jimple.infoflow.test.methodSummary.GapClass"));
            }
        });
        return sg;
    }
}

