/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.methodSummary.junit;

import java.util.LinkedList;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.generator.SummaryGenerator;
import soot.jimple.infoflow.test.methodSummary.junit.TestHelper;

public class ContextSensitivityTests
extends TestHelper {
    static final String className = "soot.jimple.infoflow.test.methodSummary.ContextSensitivity";
    static final String FIELD_X = "<soot.jimple.infoflow.test.methodSummary.ContextSensitivity: java.lang.String x>";
    static final String FIELD_Y = "<soot.jimple.infoflow.test.methodSummary.ContextSensitivity: java.lang.String y>";
    static final String FIELD_Z = "<soot.jimple.infoflow.test.methodSummary.ContextSensitivity: java.lang.String z>";

    @Override
    protected SummaryGenerator getSummary() {
        SummaryGenerator sg = new SummaryGenerator();
        LinkedList<String> sub = new LinkedList<String>();
        sub.add("java.util.ArrayList");
        sg.setSubstitutedWith(sub);
        sg.getConfig().getAccessPathConfiguration().setAccessPathLength(5);
        sg.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(true);
        return sg;
    }

    @Test(timeout=100000L)
    public void contextSensitivity1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ContextSensitivity: void contextSensitivity1(soot.jimple.infoflow.test.methodSummary.Data,java.lang.String,java.lang.String)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 1, null, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.String stringField>"}));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 2, null, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.String stringField2>"}));
        Assert.assertEquals((long)2L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void recursionTest1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ContextSensitivity: java.lang.String recursionTest1(java.lang.String)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Field, -1, new String[]{FIELD_Y}, SourceSinkType.Field, -1, new String[]{FIELD_Z}));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Field, -1, new String[]{FIELD_Y}, SourceSinkType.Field, -1, new String[]{FIELD_X}));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Field, -1, new String[]{FIELD_X}, SourceSinkType.Field, -1, new String[]{FIELD_Z}));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Field, -1, new String[]{FIELD_Y}, SourceSinkType.Field, -1, new String[]{FIELD_X}));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 0, null, SourceSinkType.Field, -1, new String[]{FIELD_X}));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 0, null, SourceSinkType.Field, -1, new String[]{FIELD_Y}));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 0, null, SourceSinkType.Field, -1, new String[]{FIELD_Z}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, null, SourceSinkType.Return, null));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Field, -1, new String[]{FIELD_X}, SourceSinkType.Return, -1, null));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Field, -1, new String[]{FIELD_Y}, SourceSinkType.Return, -1, null));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Field, -1, new String[]{FIELD_Z}, SourceSinkType.Return, -1, null));
        Assert.assertEquals((long)11L, (long)flow.size());
    }
}

