/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.methodSummary.junit;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import soot.jimple.infoflow.methodSummary.data.provider.EagerSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.provider.IMethodSummaryProvider;
import soot.jimple.infoflow.test.methodSummary.junit.BaseSummaryTaintWrapperTests;

public class HierarchyTests {
    protected final IMethodSummaryProvider testProvider;
    protected final IMethodSummaryProvider manualProvider;

    public HierarchyTests() throws IOException {
        File testRoot = BaseSummaryTaintWrapperTests.getTestRoot();
        this.testProvider = new EagerSummaryProvider(new File(testRoot, "testSummaries"));
        this.manualProvider = new EagerSummaryProvider(new File(testRoot, "summariesManual"));
    }

    @Test
    public void superClassesTest() {
        List superclasses = this.manualProvider.getSuperclassesOf("java.util.ArrayList$ListItr");
        Assert.assertEquals((long)2L, (long)superclasses.size());
        Assert.assertEquals((Object)"java.util.ArrayList$Itr", superclasses.get(0));
        Assert.assertEquals((Object)"java.lang.Object", superclasses.get(1));
    }

    @Test
    public void superInterfacesTest() {
        Collection superInterfaces = this.manualProvider.getSuperinterfacesOf("java.io.InputStream");
        Assert.assertEquals((long)2L, (long)superInterfaces.size());
        Assert.assertTrue((boolean)superInterfaces.contains("java.io.Closeable"));
        Assert.assertTrue((boolean)superInterfaces.contains("java.lang.AutoCloseable"));
    }

    @Test
    public void subclassesTest() {
        List subclasses = this.manualProvider.getSubclassesOf("org.apache.http.message.AbstractHttpMessage");
        Assert.assertEquals((long)13L, (long)subclasses.size());
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.client.methods.AbstractExecutionAwareRequest"));
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.message.BasicHttpRequest"));
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.client.methods.HttpRequestBase"));
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.message.BasicHttpEntityEnclosingRequest"));
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.client.methods.HttpDelete"));
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.client.methods.HttpTrace"));
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.client.methods.HttpEntityEnclosingRequestBase"));
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.client.methods.HttpHead"));
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.client.methods.HttpGet"));
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.client.methods.HttpOptions"));
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.client.methods.HttpPatch"));
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.client.methods.HttpPost"));
        Assert.assertTrue((boolean)subclasses.contains("org.apache.http.client.methods.HttpPut"));
    }

    @Test
    public void implementersOfInterfaceTest() {
        List implementers = this.manualProvider.getImplementersOfInterface("java.util.Iterator");
        Assert.assertEquals((long)1L, (long)implementers.size());
        Assert.assertTrue((boolean)implementers.contains("java.util.Scanner"));
    }

    @Test
    public void subInterfacesOfTest() {
        Set subinterfaces = this.manualProvider.getSubInterfacesOf("java.util.Collection");
        Assert.assertEquals((long)4L, (long)subinterfaces.size());
        Assert.assertTrue((boolean)subinterfaces.contains("java.util.Set"));
        Assert.assertTrue((boolean)subinterfaces.contains("java.util.List"));
        Assert.assertTrue((boolean)subinterfaces.contains("java.util.Queue"));
        Assert.assertTrue((boolean)subinterfaces.contains("java.util.Deque"));
    }
}

