/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.methodSummary.junit;

import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;
import soot.jimple.infoflow.methodSummary.generator.SummaryGenerator;
import soot.jimple.infoflow.test.methodSummary.junit.TestHelper;

public class JDKTests
extends TestHelper {
    static final String className = "java.util.ArrayList";

    @Test(timeout=100000L)
    public void arrayListRemoveAll() {
        String mSig = "<java.util.ArrayList: boolean removeAll(java.util.Collection)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=100000L)
    public void arrayListIterator() {
        String mSig = "<java.util.ArrayList: java.util.Iterator iterator()>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=100000L)
    public void abstractListEquals() {
        String mSig = "<java.util.AbstractList: boolean equals(java.lang.Object)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=100000L)
    public void arrayListAdd() {
        String mSig = "<java.util.ArrayList: void add(int,java.lang.Object)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=150000L)
    public void arrayListTest() {
        ClassSummaries summaries = this.getSummary().createMethodSummaries(libPath, Collections.singleton(className));
        Set flow = summaries.getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=100000L)
    public void weakHashMapPut() {
        String mSig = "<java.util.WeakHashMap: java.lang.Object put(java.lang.Object,java.lang.Object)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=100000L)
    public void gapTest1() {
        String mSig = "<java.util.Collections$UnmodifiableMap$UnmodifiableEntrySet: boolean containsAll(java.util.Collection)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=100000L)
    public void gapTest2() {
        ClassSummaries summaries = this.getSummary().createMethodSummaries(libPath, Collections.singleton("java.util.Collections$UnmodifiableMap$UnmodifiableEntrySet"));
        Set flow = summaries.getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=300000L)
    public void gapTest3() {
        ClassSummaries summaries = this.getSummary().createMethodSummaries(libPath, Collections.singleton("java.util.HashMap$EntrySet"));
        Set flow = summaries.getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=300000L)
    public void gapTest4() {
        ClassSummaries summaries = this.getSummary().createMethodSummaries(libPath, Collections.singleton("java.util.concurrent.ConcurrentHashMap$Values"));
        Set flow = summaries.getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=300000L)
    public void gapTest5() {
        ClassSummaries summaries = this.getSummary().createMethodSummaries(libPath, Collections.singleton("java.lang.ProcessEnvironment$StringKeySet"));
        Set flow = summaries.getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=600000L)
    public void gapTest6() {
        ClassSummaries summaries = this.getSummary().createMethodSummaries(libPath, Collections.singleton("java.util.PriorityQueue"));
        Set flow = summaries.getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=600000L)
    public void gapTest7() {
        String mSig = "<java.util.concurrent.ConcurrentSkipListMap: java.lang.Object remove(java.lang.Object)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=100000L)
    public void gapTest8() {
        String mSig = "<java.util.concurrent.ConcurrentSkipListMap: java.util.concurrent.ConcurrentNavigableMap descendingMap()>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=100000L)
    public void treeMapPerformanceTest() {
        String mSig = "<java.util.TreeMap: void <init>(java.util.Map)>";
        SummaryGenerator gen = this.getSummary();
        gen.getConfig().setFlowSensitiveAliasing(false);
        Set flow = gen.createMethodSummary(this.getClasspath(), mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Test(timeout=100000L)
    public void gapTest9() {
        String mSig = "<java.util.TreeMap: void putAll(java.util.Map)>";
        SummaryGenerator gen = this.getSummary();
        gen.getConfig().setFlowSensitiveAliasing(false);
        Set flow = gen.createMethodSummary(this.getClasspath(), mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Ignore(value="State explosion")
    @Test(timeout=100000L)
    public void treeMapPerformanceTest2() {
        String mSig = "<java.util.TreeMap: java.lang.Object clone()>";
        SummaryGenerator gen = this.getSummary();
        gen.getConfig().setFlowSensitiveAliasing(false);
        Set flow = gen.createMethodSummary(this.getClasspath(), mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Ignore(value="State explosion")
    @Test(timeout=100000L)
    public void gapTest10() {
        String mSig = "<java.lang.String: byte[] getBytes(java.lang.String)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Ignore(value="State explosion")
    @Test(timeout=100000L)
    public void arrayBlockingQueueIterator() {
        String mSig = "<java.util.concurrent.ArrayBlockingQueue: java.util.Iterator iterator()>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertNotNull((Object)flow);
    }

    @Override
    protected SummaryGenerator getSummary() {
        SummaryGenerator sg = super.getSummary();
        sg.getConfig().getAccessPathConfiguration().setAccessPathLength(4);
        sg.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(true);
        sg.getConfig().setLoadFullJAR(false);
        sg.getConfig().setSummarizeFullJAR(false);
        sg.getConfig().setEnableExceptionTracking(true);
        return sg;
    }
}

