/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.methodSummary.junit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import soot.G;
import soot.jimple.infoflow.AbstractInfoflow;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.config.ConfigForTest;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.taintWrappers.EasyTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;

public abstract class JUnitTests {
    protected static String appPath;
    protected static String libPath;
    protected static List<String> sinks;
    protected static final String sink = "<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.String)>";
    protected static final String sinkInt = "<soot.jimple.infoflow.test.android.ConnectionManager: void publish(int)>";
    protected static final String sinkBoolean = "<soot.jimple.infoflow.test.android.ConnectionManager: void publish(boolean)>";
    protected static final String sinkDouble = "<soot.jimple.infoflow.test.android.ConnectionManager: void publish(java.lang.Double)>";
    protected static List<String> sources;
    protected static final String sourceDeviceId = "<soot.jimple.infoflow.test.android.TelephonyManager: java.lang.String getDeviceId()>";
    protected static final String sourceIMEI = "<soot.jimple.infoflow.test.android.TelephonyManager: int getIMEI()>";
    protected static final String sourceIMSI = "<soot.jimple.infoflow.test.android.TelephonyManager: int getIMSI()>";
    protected static final String sourcePwd = "<soot.jimple.infoflow.test.android.AccountManager: java.lang.String getPassword()>";
    protected static final String sourceUserData = "<soot.jimple.infoflow.test.android.AccountManager: java.lang.String[] getUserData(java.lang.String)>";
    protected static final String sourceBundleGet = "<soot.jimple.infoflow.test.android.Bundle: java.lang.Object get(java.lang.String)>";
    protected static final String sourceLongitude = "<soot.jimple.infoflow.test.android.LocationManager: double getLongitude()>";

    @BeforeClass
    public static void setUp() throws IOException {
        File parentDir;
        File[] files;
        File f = new File(".");
        File testSrc1 = new File(f, "bin");
        File testSrc4 = new File(f, "testBin");
        File testSrc2 = new File(f, "build" + File.separator + "classes");
        File testSrc3 = new File(f, "build" + File.separator + "testclasses");
        File testSrc5 = new File(f, ".." + File.separator + "soot-infoflow" + File.separator + "build" + File.separator + "testclasses");
        if (!(testSrc1.exists() || testSrc2.exists() || testSrc3.exists() || testSrc5.exists())) {
            Assert.fail((String)"Test aborted - none of the test sources are available");
        }
        StringBuilder appPathBuilder = new StringBuilder();
        JUnitTests.appendWithSeparator(appPathBuilder, testSrc1);
        JUnitTests.appendWithSeparator(appPathBuilder, testSrc2);
        JUnitTests.appendWithSeparator(appPathBuilder, testSrc3);
        JUnitTests.appendWithSeparator(appPathBuilder, testSrc4);
        JUnitTests.appendWithSeparator(appPathBuilder, testSrc5);
        appPath = appPathBuilder.toString();
        StringBuilder libPathBuilder = new StringBuilder();
        String javaHomeStr = System.getProperty("java.home");
        boolean found = false;
        if (!javaHomeStr.isEmpty() && (files = (parentDir = new File(javaHomeStr).getParentFile()).listFiles((dir, name) -> name.contains("java-1.8.0-") || name.contains("java-8-"))) != null) {
            for (File java8Path : files) {
                File rtjar = new File(java8Path, "jre" + File.separator + "lib" + File.separator + "rt.jar");
                if (!rtjar.exists()) continue;
                JUnitTests.appendWithSeparator(libPathBuilder, rtjar);
                found = true;
                break;
            }
        }
        if (!found) {
            JUnitTests.appendWithSeparator(libPathBuilder, new File("/usr/lib/jvm/java-8-openjdk-amd64/jre/lib/rt.jar"));
            JUnitTests.appendWithSeparator(libPathBuilder, new File("/usr/lib/jvm/java-1.8.0/jre/lib/rt.jar"));
        }
        if ((libPath = libPathBuilder.toString()).isEmpty()) {
            throw new RuntimeException("Could not find rt.jar!");
        }
        sources = new ArrayList<String>();
        sources.add(sourcePwd);
        sources.add(sourceUserData);
        sources.add(sourceDeviceId);
        sources.add(sourceIMEI);
        sources.add(sourceIMSI);
        sources.add(sourceBundleGet);
        sources.add(sourceLongitude);
        sinks = new ArrayList<String>();
        sinks.add(sink);
        sinks.add(sinkInt);
        sinks.add(sinkBoolean);
        sinks.add(sinkDouble);
    }

    private static void appendWithSeparator(StringBuilder sb, File f) throws IOException {
        if (f.exists()) {
            if (sb.length() > 0) {
                sb.append(System.getProperty("path.separator"));
            }
            sb.append(f.getCanonicalPath());
        }
    }

    @Before
    public void resetSootAndStream() throws IOException {
        G.reset();
        System.gc();
    }

    protected void checkInfoflow(IInfoflow infoflow, int resultCount) {
        if (infoflow.isResultAvailable()) {
            InfoflowResults map = infoflow.getResults();
            Assert.assertEquals((long)resultCount, (long)map.size());
            Assert.assertTrue((map.containsSinkMethod(sink) || map.containsSinkMethod(sinkInt) || map.containsSinkMethod(sinkBoolean) || map.containsSinkMethod(sinkDouble) ? 1 : 0) != 0);
            Assert.assertTrue((map.isPathBetweenMethods(sink, sourceDeviceId) || map.isPathBetweenMethods(sink, sourceIMEI) || map.isPathBetweenMethods(sink, sourcePwd) || map.isPathBetweenMethods(sink, sourceBundleGet) || map.isPathBetweenMethods(sinkInt, sourceDeviceId) || map.isPathBetweenMethods(sinkInt, sourceIMEI) || map.isPathBetweenMethods(sinkInt, sourceIMSI) || map.isPathBetweenMethods(sinkBoolean, sourceDeviceId) || map.isPathBetweenMethods(sinkDouble, sourceLongitude) ? 1 : 0) != 0);
        } else {
            Assert.fail((String)"result is not available");
        }
    }

    protected void negativeCheckInfoflow(IInfoflow infoflow) {
        if (infoflow.isResultAvailable()) {
            InfoflowResults map = infoflow.getResults();
            Assert.assertEquals((long)0L, (long)map.size());
            Assert.assertFalse((boolean)map.containsSinkMethod(sink));
            Assert.assertFalse((boolean)map.containsSinkMethod(sinkInt));
        }
    }

    protected abstract AbstractInfoflow createInfoflowInstance();

    protected IInfoflow initInfoflow() {
        return this.initInfoflow(false);
    }

    protected IInfoflow initInfoflow(boolean useTaintWrapper) {
        AbstractInfoflow result = this.createInfoflowInstance();
        ConfigForTest testConfig = new ConfigForTest();
        result.setSootConfig((IInfoflowConfig)testConfig);
        if (useTaintWrapper) {
            try {
                EasyTaintWrapper easyWrapper = new EasyTaintWrapper(new File("EasyTaintWrapperSource.txt"));
                result.setTaintWrapper((ITaintPropagationWrapper)easyWrapper);
            }
            catch (IOException e) {
                System.err.println("Could not initialized Taintwrapper:");
                e.printStackTrace();
            }
        }
        return result;
    }
}

