/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.methodSummary.junit;

import java.util.LinkedList;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.generator.SummaryGenerator;
import soot.jimple.infoflow.test.methodSummary.junit.TestHelper;

public class ParaToFieldTests
extends TestHelper {
    static final String className = "soot.jimple.infoflow.test.methodSummary.ParaToField";
    static final String[] LIST_ITEM = new String[]{"<soot.jimple.infoflow.test.methodSummary.ParaToField: java.util.List listField>", "<java.util.LinkedList: java.util.LinkedList$Node first>", "<java.util.LinkedList$Node: java.lang.Object item>"};
    static final String DATA_FIELD = "<soot.jimple.infoflow.test.methodSummary.ParaToField: soot.jimple.infoflow.test.methodSummary.Data dataField>";
    private static final String INT_FIELD = "<soot.jimple.infoflow.test.methodSummary.ParaToField: int intField>";
    private static final String IARRAY_FIELD = "<soot.jimple.infoflow.test.methodSummary.ParaToField: int[] intArray>";
    private static final String OBJECT_FIELD = "<soot.jimple.infoflow.test.methodSummary.ParaToField: java.lang.Object obField>";
    private static final String OBJ_ARRAY_FIELD = "<soot.jimple.infoflow.test.methodSummary.ParaToField: java.lang.Object[] arrayField>";
    private static final String LIST_FIELD = "<soot.jimple.infoflow.test.methodSummary.ParaToField: java.util.List listField>";

    @Test(timeout=100000L)
    public void intParameter() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToField: void intPara(int)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{INT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{DATA_FIELD, "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{IARRAY_FIELD}));
        Assert.assertEquals((long)3L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void intParameterRec() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToField: void intParaRec(int,int)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{INT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{DATA_FIELD, "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{IARRAY_FIELD}));
        Assert.assertEquals((long)3L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void objectParameter() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToField: void objPara(java.lang.Object)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{OBJECT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{OBJ_ARRAY_FIELD}));
    }

    @Test(timeout=100000L)
    public void objectParameter2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToField: void objPara(java.lang.Object)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{DATA_FIELD, "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, LIST_ITEM));
        Assert.assertEquals((long)6L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void intAndObjectParameter() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToField: void intAndObj(int,java.lang.Object)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{INT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{OBJECT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{OBJ_ARRAY_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{IARRAY_FIELD}));
        Assert.assertEquals((long)9L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void intAndObjectParameter2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToField: void intAndObj(int,java.lang.Object)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{DATA_FIELD, "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{INT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{OBJECT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, LIST_ITEM));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{DATA_FIELD, "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{OBJ_ARRAY_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{IARRAY_FIELD}));
        Assert.assertEquals((long)9L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void arrayParas() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToField: void arrayParas(int[],java.lang.Object[])>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{INT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{DATA_FIELD, "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{IARRAY_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{OBJECT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{DATA_FIELD, "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{OBJ_ARRAY_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{LIST_FIELD, "<java.util.LinkedList: java.util.LinkedList$Node first>", "<java.util.LinkedList$Node: java.lang.Object item>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{LIST_FIELD, "<java.util.LinkedList: java.util.LinkedList$Node last>", "<java.util.LinkedList$Node: java.lang.Object item>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Field, 0, new String[]{LIST_FIELD, "<java.util.LinkedList: java.util.LinkedList$Node last>"}, SourceSinkType.Field, new String[]{LIST_FIELD, "<java.util.LinkedList: java.util.LinkedList$Node first>"}));
        Assert.assertEquals((long)9L, (long)flow.size());
    }

    @Test(timeout=300000L)
    public void arrayParas2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToField: void arrayParas(int[],java.lang.Object[])>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{INT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{DATA_FIELD, "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{OBJECT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{DATA_FIELD, "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, LIST_ITEM));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Field, new String[]{OBJ_ARRAY_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Field, new String[]{IARRAY_FIELD}));
        Assert.assertEquals((long)9L, (long)flow.size());
    }

    @Test(timeout=300000L)
    public void dataAndListParameter() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToField: void dataAndList(soot.jimple.infoflow.test.methodSummary.Data,java.util.List)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Field, new String[]{INT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Field, new String[]{DATA_FIELD, "<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Field, new String[]{IARRAY_FIELD}));
        Assert.assertTrue((this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node first>", "<java.util.LinkedList$Node: java.lang.Object item>"}, SourceSinkType.Field, new String[]{OBJECT_FIELD}) || this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node last>", "<java.util.LinkedList$Node: java.lang.Object item>"}, SourceSinkType.Field, new String[]{OBJECT_FIELD}) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}, SourceSinkType.Field, new String[]{DATA_FIELD, "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}, SourceSinkType.Field, new String[]{OBJ_ARRAY_FIELD}));
        Assert.assertTrue((this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node first>", "<java.util.LinkedList$Node: java.lang.Object item>"}, SourceSinkType.Field, new String[]{LIST_FIELD, "<java.util.LinkedList: java.util.LinkedList$Node last>", "<java.util.LinkedList$Node: java.lang.Object item>"}) || this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 1, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node last>", "<java.util.LinkedList$Node: java.lang.Object item>"}, SourceSinkType.Field, new String[]{LIST_FIELD, "<java.util.LinkedList: java.util.LinkedList$Node last>", "<java.util.LinkedList$Node: java.lang.Object item>"}) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Field, 0, new String[]{LIST_FIELD, "<java.util.LinkedList: java.util.LinkedList$Node last>"}, SourceSinkType.Field, new String[]{LIST_FIELD, "<java.util.LinkedList: java.util.LinkedList$Node first>"}));
        Assert.assertTrue((flow.size() >= 9 ? 1 : 0) != 0);
    }

    @Test(timeout=300000L)
    public void contextSensitivity() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToField: void contextSensitivity(soot.jimple.infoflow.test.methodSummary.Data)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}, SourceSinkType.Field, new String[]{INT_FIELD}));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value2>"}, SourceSinkType.Field, new String[]{IARRAY_FIELD}));
        Assert.assertEquals((long)2L, (long)flow.size());
    }

    @Override
    protected SummaryGenerator getSummary() {
        SummaryGenerator sg = super.getSummary();
        LinkedList<String> sub = new LinkedList<String>();
        sub.add("java.util.LinkedList");
        sg.setSubstitutedWith(sub);
        sg.getConfig().getAccessPathConfiguration().setAccessPathLength(3);
        sg.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(true);
        return sg;
    }
}

