/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.methodSummary.junit;

import java.util.LinkedList;
import java.util.Set;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.generator.SummaryGenerator;
import soot.jimple.infoflow.test.methodSummary.junit.TestHelper;

public class ParaToParaTests
extends TestHelper {
    static final String className = "soot.jimple.infoflow.test.methodSummary.ParaToParaFlows";

    @Test(timeout=100000L)
    public void array() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToParaFlows: void array(java.lang.Object,java.lang.Object[])>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Parameter, 1, new String[0]));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void arrayRec() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToParaFlows: void arrayRec(java.lang.Object,java.lang.Object[],int)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Parameter, 1, new String[0]));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void list() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToParaFlows: int list(java.util.List,java.lang.Object)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Parameter, 0, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node first>", "<java.util.LinkedList$Node: java.lang.Object item>"}));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Parameter, 0, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node last>", "<java.util.LinkedList$Node: java.lang.Object item>"}));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 0, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node last>", "<java.util.LinkedList$Node: java.lang.Object item>"}, SourceSinkType.Parameter, 0, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node first>", "<java.util.LinkedList$Node: java.lang.Object item>"}));
        Assert.assertEquals((long)3L, (long)flow.size());
    }

    @Ignore
    public void list2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToParaFlows: int list(java.util.List,java.lang.Object)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Parameter, 1, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node first>", "<java.util.LinkedList$Node: java.lang.Object item>"}));
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 1, new String[0], SourceSinkType.Parameter, 1, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node last>", "<java.util.LinkedList$Node: java.lang.Object item>"}));
        Assert.assertEquals((long)2L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void setter() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToParaFlows: int setter(java.lang.String,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Parameter, 1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.String stringField>"}));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void setter2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToParaFlows: int setter2(int,soot.jimple.infoflow.test.methodSummary.Data)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Parameter, 1, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: int value>"}));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void innerClass() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToParaFlows: void innerClass(java.lang.Object,soot.jimple.infoflow.test.methodSummary.ParaToParaFlows$InnerClass)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow(flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Parameter, 1, new String[]{"<soot.jimple.infoflow.test.methodSummary.ParaToParaFlows$InnerClass: java.lang.Object o>"}));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Override
    protected SummaryGenerator getSummary() {
        SummaryGenerator sg = super.getSummary();
        LinkedList<String> sub = new LinkedList<String>();
        sub.add("java.util.LinkedList");
        sg.setSubstitutedWith(sub);
        sg.getConfig().getAccessPathConfiguration().setAccessPathLength(3);
        sg.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(true);
        return sg;
    }
}

