/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.methodSummary.junit;

import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.generator.SummaryGenerator;
import soot.jimple.infoflow.test.methodSummary.junit.TestHelper;

public class ParaToReturnTests
extends TestHelper {
    protected static Map<String, Set<MethodFlow>> flows;
    static final String className = "soot.jimple.infoflow.test.methodSummary.ParaToReturn";
    static boolean executeSummary;

    @Test(timeout=100000L)
    public void primitiv() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToReturn: int return1(int)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Return, new String[0]));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void primitivRec() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToReturn: int returnRec(int,int)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Return, new String[0]));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void object() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToReturn: java.lang.Object return2(java.lang.Object)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Return, new String[0]));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void list() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToReturn: java.util.List return3(java.util.List)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Return, new String[0]));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void list2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToReturn: java.lang.Object return31(java.util.List)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node first>", "<java.util.LinkedList$Node: java.lang.Object item>"}, SourceSinkType.Return, new String[0]));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node last>", "<java.util.LinkedList$Node: java.lang.Object item>"}, SourceSinkType.Return, new String[0]));
        Assert.assertEquals((long)2L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void list3() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToReturn: java.lang.Object return31(java.util.LinkedList)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node first>", "<java.util.LinkedList$Node: java.lang.Object item>"}, SourceSinkType.Return, new String[0]));
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<java.util.LinkedList: java.util.LinkedList$Node last>", "<java.util.LinkedList$Node: java.lang.Object item>"}, SourceSinkType.Return, new String[0]));
        Assert.assertEquals((long)2L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void array1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToReturn: java.lang.Object return4(java.lang.Object[])>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Return, new String[0]));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void array2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToReturn: java.lang.Object[] return5(java.lang.Object[])>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[0], SourceSinkType.Return, new String[0]));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void data1() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToReturn: java.lang.Object return6(soot.jimple.infoflow.test.methodSummary.Data)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}, SourceSinkType.Return, new String[0]));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Test(timeout=100000L)
    public void data2() {
        String mSig = "<soot.jimple.infoflow.test.methodSummary.ParaToReturn: java.lang.Object return7(soot.jimple.infoflow.test.methodSummary.Data)>";
        Set flow = this.createSummaries(mSig).getAllFlows();
        Assert.assertTrue((boolean)this.containsFlow((Set<MethodFlow>)flow, SourceSinkType.Parameter, 0, new String[]{"<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>"}, SourceSinkType.Return, new String[0]));
        Assert.assertEquals((long)1L, (long)flow.size());
    }

    @Override
    protected SummaryGenerator getSummary() {
        SummaryGenerator sg = super.getSummary();
        LinkedList<String> sub = new LinkedList<String>();
        sub.add("java.util.LinkedList");
        sg.setSubstitutedWith(sub);
        sg.getConfig().getAccessPathConfiguration().setAccessPathLength(-1);
        sg.getConfig().getAccessPathConfiguration().setUseRecursiveAccessPaths(true);
        return sg;
    }

    static {
        executeSummary = true;
    }
}

