/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.methodSummary.junit;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.junit.Assert;
import org.junit.BeforeClass;
import soot.jimple.infoflow.methodSummary.data.sourceSink.AbstractFlowSinkSource;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSink;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSource;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.generator.SummaryGenerator;

public abstract class TestHelper {
    protected static String appPath;
    protected static String libPath;
    protected static final String INT_TYPE = "int";
    protected static final String OBJECT_TYPE = "java.lang.Object";
    protected static final String OBJECT_ARRAY_TYPE = "java.lang.Object[]";
    protected static final String INT_ARRAY_TYPE = "int[]";
    protected static final String LIST_TYPE = "java.util.List";
    protected static final String STRING_TYPE = "java.lang.String";
    protected static final String DATACLASS_SIG = "soot.jimple.infoflow.test.methodSummary.Data";
    protected static final String DATACLASS_INT_FIELD = "<soot.jimple.infoflow.test.methodSummary.Data: int value>";
    protected static final String DATACLASS_INT_FIELD2 = "<soot.jimple.infoflow.test.methodSummary.Data: int value2>";
    protected static final String DATACLASS_OBJECT_FIELD = "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.Object objectField>";
    protected static final String DATACLASS_STRING_FIELD = "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.String stringField>";
    protected static final String DATACLASS_STRING_FIELD2 = "<soot.jimple.infoflow.test.methodSummary.Data: java.lang.String stringField2>";
    protected static final String APICLASS_SIG = "soot.jimple.infoflow.test.methodSummary.ApiClass";
    protected static final String APICLASS_DATA_FIELD = "<soot.jimple.infoflow.test.methodSummary.ApiClass: soot.jimple.infoflow.test.methodSummary.Data dataField>";
    protected static final String LINKEDLIST_FIRST = "<java.util.LinkedList: java.util.LinkedList$Node first>";
    protected static final String LINKEDLIST_LAST = "<java.util.LinkedList: java.util.LinkedList$Node last>";
    protected static final String LINKEDLIST_ITEM = "<java.util.LinkedList$Node: java.lang.Object item>";
    protected static final String GAPCLASS_SIG = "soot.jimple.infoflow.test.methodSummary.IGapClass";

    @BeforeClass
    public static void setUp() throws IOException {
        File f = new File(".");
        File testSrc1 = new File(f, "testBin");
        File testSrc2 = new File(f, "build" + File.separator + "testclasses");
        if (!(testSrc1.exists() || testSrc2.exists() || f.getName().equals("soot-infoflow-summaries"))) {
            f = new File(f, "soot-infoflow-summaries");
            testSrc1 = new File(f, "testBin");
            testSrc2 = new File(f, "build" + File.separator + "testclasses");
        }
        if (!testSrc1.exists() && !testSrc2.exists()) {
            Assert.fail((String)String.format("Test aborted - none of the test sources are available in root %s", f.getCanonicalPath()));
        }
        StringBuilder appPathBuilder = new StringBuilder();
        TestHelper.appendWithSeparator(appPathBuilder, testSrc1);
        TestHelper.appendWithSeparator(appPathBuilder, testSrc2);
        appPath = appPathBuilder.toString();
        StringBuilder libPathBuilder = new StringBuilder();
        TestHelper.appendWithSeparator(libPathBuilder, new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
        TestHelper.appendWithSeparator(libPathBuilder, new File("/usr/lib/jvm/java-8-openjdk-amd64/jre/lib/rt.jar"));
        libPath = libPathBuilder.toString();
    }

    private static void appendWithSeparator(StringBuilder sb, File f) throws IOException {
        if (f.exists()) {
            if (sb.length() > 0) {
                sb.append(System.getProperty("path.separator"));
            }
            sb.append(f.getCanonicalPath());
        }
    }

    protected boolean containsFlow(Set<MethodFlow> flows, SourceSinkType sourceTyp, String[] sourceFields, SourceSinkType sinkTyp, String[] sinkFields) {
        return this.containsFlow(flows, sourceTyp, -1, sourceFields, sinkTyp, -1, sinkFields);
    }

    protected boolean containsFlow(Set<MethodFlow> flows, SourceSinkType sourceTyp, String[] sourceFields, SourceSinkType sinkTyp, int sinkParameterIdx, String[] sinkFields) {
        return this.containsFlow(flows, sourceTyp, -1, sourceFields, sinkTyp, sinkParameterIdx, sinkFields);
    }

    protected boolean containsFlow(Set<MethodFlow> flows, SourceSinkType sourceTyp, int sourceParamterIdx, String[] sourceFields, SourceSinkType sinkTyp, String[] sinkFields) {
        return this.containsFlow(flows, sourceTyp, sourceParamterIdx, sourceFields, sinkTyp, -1, sinkFields);
    }

    protected boolean containsFlow(Set<MethodFlow> flows, SourceSinkType sourceTyp, int sourceParamterIdx, String[] sourceFields, SourceSinkType sinkTyp, int sinkParamterIdx, String[] sinkFields) {
        return this.containsFlow(flows, sourceTyp, sourceParamterIdx, sourceFields, null, sinkTyp, sinkParamterIdx, sinkFields, null);
    }

    protected boolean containsFlow(Set<MethodFlow> flows, SourceSinkType sourceTyp, int sourceParamterIdx, String[] sourceFields, String sourceGapSignature, SourceSinkType sinkTyp, int sinkParamterIdx, String[] sinkFields, String sinkGapSignature) {
        for (MethodFlow mf : flows) {
            MethodFlow reverseFlow;
            if (this.flowMatches(sourceTyp, sourceParamterIdx, sourceFields, sourceGapSignature, sinkTyp, sinkParamterIdx, sinkFields, sinkGapSignature, mf)) {
                return true;
            }
            if (!mf.isAlias() || !this.flowMatches(sourceTyp, sourceParamterIdx, sourceFields, sourceGapSignature, sinkTyp, sinkParamterIdx, sinkFields, sinkGapSignature, reverseFlow = mf.reverse())) continue;
            return true;
        }
        return false;
    }

    protected boolean flowMatches(SourceSinkType sourceTyp, int sourceParamterIdx, String[] sourceFields, String sourceGapSignature, SourceSinkType sinkTyp, int sinkParamterIdx, String[] sinkFields, String sinkGapSignature, MethodFlow mf) {
        FlowSource source = mf.source();
        FlowSink sink = mf.sink();
        return source.getType() == sourceTyp && sink.getType() == sinkTyp && this.checkParamter((AbstractFlowSinkSource)source, sourceTyp, sourceParamterIdx) && this.checkParamter((AbstractFlowSinkSource)sink, sinkTyp, sinkParamterIdx) && this.checkFields((AbstractFlowSinkSource)source, sourceFields) && this.checkFields((AbstractFlowSinkSource)sink, sinkFields) && this.checkGap((AbstractFlowSinkSource)source, sourceGapSignature) && this.checkGap((AbstractFlowSinkSource)sink, sinkGapSignature);
    }

    private boolean checkGap(AbstractFlowSinkSource sourceSink, String gapSignature) {
        if (sourceSink.getGap() == null) {
            return gapSignature == null || gapSignature.isEmpty();
        }
        return sourceSink.getGap().getSignature().equals(gapSignature);
    }

    private boolean checkParamter(AbstractFlowSinkSource s, SourceSinkType sType, int parameterIdx) {
        if (sType.equals((Object)SourceSinkType.Parameter)) {
            if (s.getType() == SourceSinkType.Parameter) {
                return s.getParameterIndex() == parameterIdx;
            }
            return false;
        }
        return true;
    }

    private boolean checkFields(AbstractFlowSinkSource s, String[] fields) {
        if (fields == null || fields.length == 0) {
            return !s.hasAccessPath();
        }
        if (!s.hasAccessPath() && fields != null && fields.length > 0) {
            return false;
        }
        if (s.getAccessPath().length() != fields.length) {
            return false;
        }
        for (int i = 0; i < fields.length; ++i) {
            if (s.getAccessPath().getField(i).replaceAll("[<>]", "").equals(fields[i].replaceAll("[<>]", ""))) continue;
            return false;
        }
        return true;
    }

    protected SummaryGenerator getSummary() {
        SummaryGenerator sg = new SummaryGenerator();
        sg.getConfig().setUseDefaultSummaries(false);
        return sg;
    }

    protected String getClasspath() {
        return appPath + System.getProperty("path.separator") + libPath;
    }

    protected MethodSummaries createSummaries(String methodSignature) {
        return this.getSummary().createMethodSummary(this.getClasspath(), methodSignature);
    }

    protected String makeGapClassSignature(String subsignature) {
        return String.format("<%s: %s>", GAPCLASS_SIG, subsignature);
    }
}

