/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.test.securibench;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import soot.G;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.Infoflow;
import soot.jimple.infoflow.config.ConfigSecuriBench;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.entryPointCreators.DefaultEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.taintWrappers.EasyTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.test.base.AbstractJUnitTests;

public abstract class JUnitTests
extends AbstractJUnitTests {
    protected static String appPath;
    protected static String libPath;
    protected static List<String> sources;
    protected static List<String> sinks;
    protected static final String[] sinkArray;
    protected static final String[] sourceArray;
    protected static boolean taintWrapper;
    protected static boolean substituteCallParams;
    protected IEntryPointCreator entryPointCreator = null;

    @BeforeClass
    public static void setUp() throws IOException {
        File f = new File(".");
        StringBuilder appPathBuilder = new StringBuilder();
        JUnitTests.addTestPathes(f, appPathBuilder);
        appPath = appPathBuilder.toString();
        StringBuilder libPathBuilder = new StringBuilder();
        JUnitTests.addRtJarPath(libPathBuilder);
        libPath = libPathBuilder.toString();
        sources = Arrays.asList(sourceArray);
        sinks = Arrays.asList(sinkArray);
    }

    @Before
    public void resetSootAndStream() throws IOException {
        G.reset();
        System.gc();
    }

    protected void checkInfoflow(IInfoflow infoflow, int resultCount) {
        if (infoflow.isResultAvailable()) {
            InfoflowResults map = infoflow.getResults();
            boolean containsSink = false;
            LinkedList<String> actualSinkStrings = new LinkedList<String>();
            Assert.assertEquals((long)resultCount, (long)map.size());
            for (String sink : sinkArray) {
                if (!map.containsSinkMethod(sink)) continue;
                containsSink = true;
                actualSinkStrings.add(sink);
            }
            Assert.assertTrue((boolean)containsSink);
            boolean onePathFound = false;
            for (String sink : actualSinkStrings) {
                boolean hasPath = false;
                for (String source : sourceArray) {
                    if (!map.isPathBetweenMethods(sink, source)) continue;
                    hasPath = true;
                    break;
                }
                if (!hasPath) continue;
                onePathFound = true;
            }
            Assert.assertTrue((boolean)onePathFound);
        } else {
            Assert.fail((String)"result is not available");
        }
    }

    protected void negativeCheckInfoflow(IInfoflow infoflow) {
        if (infoflow.isResultAvailable()) {
            InfoflowResults map = infoflow.getResults();
            for (String sink : sinkArray) {
                if (!map.containsSinkMethod(sink)) continue;
                Assert.fail((String)("sink is reached: " + sink));
            }
            Assert.assertEquals((long)0L, (long)map.size());
        } else {
            Assert.fail((String)"result is not available");
        }
    }

    protected IInfoflow initInfoflow(List<String> entryPoints) {
        LinkedList<String> substClasses = new LinkedList<String>();
        substClasses.add("soot.jimple.infoflow.test.securibench.supportClasses.DummyHttpRequest");
        substClasses.add("soot.jimple.infoflow.test.securibench.supportClasses.DummyHttpResponse");
        DefaultEntryPointCreator entryPointCreator = new DefaultEntryPointCreator(entryPoints);
        entryPointCreator.setSubstituteCallParams(substituteCallParams);
        entryPointCreator.setSubstituteClasses(substClasses);
        this.entryPointCreator = entryPointCreator;
        Infoflow result = new Infoflow();
        result.setSootConfig((IInfoflowConfig)new ConfigSecuriBench());
        result.getConfig().setInspectSinks(false);
        if (taintWrapper) {
            try {
                EasyTaintWrapper easyWrapper = new EasyTaintWrapper(new File("EasyTaintWrapperSource.txt"));
                result.setTaintWrapper((ITaintPropagationWrapper)easyWrapper);
            }
            catch (IOException e) {
                System.err.println("Could not initialize Taintwrapper:");
                e.printStackTrace();
            }
        }
        return result;
    }

    static {
        sinkArray = new String[]{"<java.io.PrintWriter: void println(java.lang.String)>", "<java.io.PrintWriter: void println(java.lang.Object)>", "<java.sql.Connection: java.sql.PreparedStatement prepareStatement(java.lang.String)>", "<java.sql.Statement: boolean execute(java.lang.String)>", "<java.sql.Statement: int executeUpdate(java.lang.String)>", "<java.sql.Statement: int executeUpdate(java.lang.String,int)>", "<java.sql.Statement: int executeUpdate(java.lang.String,java.lang.String[])>", "<java.sql.Statement: java.sql.ResultSet executeQuery(java.lang.String)>", "<jakarta.servlet.http.HttpServletResponse: void sendRedirect(java.lang.String)>", "<java.io.File: void <init>(java.lang.String)>", "<java.io.FileWriter: void <init>(java.lang.String)>", "<java.io.FileInputStream: void <init>(java.lang.String)>"};
        sourceArray = new String[]{"<jakarta.servlet.ServletRequest: java.lang.String getParameter(java.lang.String)>", "<jakarta.servlet.http.HttpServletRequest: java.lang.String getParameter(java.lang.String)>", "<jakarta.servlet.ServletRequest: java.lang.String[] getParameterValues(java.lang.String)>", "<jakarta.servlet.http.HttpServletRequest: java.lang.String[] getParameterValues(java.lang.String)>", "<jakarta.servlet.ServletRequest: java.util.Map getParameterMap()>", "<jakarta.servlet.http.HttpServletRequest: java.util.Map getParameterMap()>", "<jakarta.servlet.ServletConfig: java.lang.String getInitParameter(java.lang.String)>", "<soot.jimple.infoflow.test.securibench.supportClasses.DummyServletConfig: java.lang.String getInitParameter(java.lang.String)>", "<jakarta.servlet.ServletConfig: java.util.Enumeration getInitParameterNames()>", "<jakarta.servlet.ServletContext: java.lang.String getInitParameter(java.lang.String)>", "<jakarta.servlet.http.HttpServletRequest: java.lang.String getParameter(java.lang.String)>", "<jakarta.servlet.http.HttpServletRequest: java.lang.String[] getParameterValues(java.lang.String)>", "<jakarta.servlet.http.HttpServletRequest: java.util.Map getParameterMap()>", "<jakarta.servlet.http.HttpServletRequest: javax.servlet.http.Cookie[] getCookies()>", "<jakarta.servlet.http.HttpServletRequest: java.lang.String getHeader(java.lang.String)>", "<jakarta.servlet.http.HttpServletRequest: java.util.Enumeration getHeaders(java.lang.String)>", "<jakarta.servlet.http.HttpServletRequest: java.util.Enumeration getHeaderNames()>", "<jakarta.servlet.ServletRequest: java.lang.String getProtocol()>", "<jakarta.servlet.http.HttpServletRequest: java.lang.String getProtocol()>", "<jakarta.servlet.ServletRequest: java.lang.String getScheme()>", "<jakarta.servlet.http.HttpServletRequest: java.lang.String getScheme()>", "<jakarta.servlet.http.HttpServletRequest: java.lang.String getAuthType()>", "<jakarta.servlet.http.HttpServletRequest: java.lang.String getQueryString()>", "<jakarta.servlet.http.HttpServletRequest: java.lang.String getRemoteUser()>", "<jakarta.servlet.http.HttpServletRequest: java.lang.StringBuffer getRequestURL()>", "<jakarta.servlet.http.HttpServletRequest: javax.servlet.ServletInputStream getInputStream()>", "<jakarta.servlet.ServletRequest: javax.servlet.ServletInputStream getInputStream()>", "<org.springframework.web.multipart.MultipartHttpServletRequest: java.lang.String getParameter(java.lang.String)>"};
        taintWrapper = false;
        substituteCallParams = true;
    }
}

