/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.factory;

import soot.ArrayType;
import soot.Type;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.methodSummary.data.sourceSink.ConstraintType;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSink;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSource;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;

public class SourceSinkFactory {
    private final int summaryAPLength;

    public SourceSinkFactory(int summaryAPLength) {
        this.summaryAPLength = summaryAPLength;
    }

    private AccessPathFragment cutAPLength(AccessPathFragment accessPath) {
        if (accessPath == null || accessPath.isEmpty()) {
            return null;
        }
        return accessPath.prefix(this.summaryAPLength);
    }

    public FlowSource createParameterSource(int parameterIdx, String baseType) {
        return new FlowSource(SourceSinkType.Parameter, parameterIdx, baseType, ConstraintType.FALSE);
    }

    public FlowSource createThisSource(String baseType) {
        return new FlowSource(SourceSinkType.Field, baseType, ConstraintType.FALSE);
    }

    public FlowSource createSource(SourceSinkType type, int parameterIdx, AccessPath accessPath, GapDefinition gap) {
        return new FlowSource(type, parameterIdx, accessPath.getBaseType().toString(), this.cutAPLength(new AccessPathFragment(accessPath)), gap, ConstraintType.FALSE);
    }

    public FlowSink createParameterSink(int paraIdx, AccessPath accessPath) {
        return this.createParameterSink(paraIdx, accessPath, null);
    }

    public FlowSink createParameterSink(int paraIdx, AccessPath accessPath, GapDefinition gap) {
        if (accessPath.isLocal()) {
            return new FlowSink(SourceSinkType.Parameter, paraIdx, accessPath.getBaseType().toString(), accessPath.getTaintSubFields(), gap, ConstraintType.FALSE);
        }
        if (accessPath.getFragmentCount() < this.summaryAPLength) {
            return new FlowSink(SourceSinkType.Parameter, paraIdx, accessPath.getBaseType().toString(), new AccessPathFragment(accessPath), accessPath.getTaintSubFields(), gap, false, ConstraintType.FALSE);
        }
        return new FlowSink(SourceSinkType.Parameter, paraIdx, accessPath.getBaseType().toString(), this.cutAPLength(new AccessPathFragment(accessPath)), true, gap, false, ConstraintType.FALSE);
    }

    public FlowSink createGapBaseObjectSink(GapDefinition gap, Type baseType) {
        return new FlowSink(SourceSinkType.GapBaseObject, -1, baseType.toString(), false, gap, ConstraintType.FALSE);
    }

    public FlowSink createReturnSink(AccessPath accessPath) {
        return this.createReturnSink(accessPath, null);
    }

    public FlowSink createReturnSink(AccessPath accessPath, GapDefinition gap) {
        if (accessPath.isLocal()) {
            return new FlowSink(SourceSinkType.Return, -1, accessPath.getBaseType().toString(), accessPath.getTaintSubFields(), gap, ConstraintType.FALSE);
        }
        if (accessPath.getFragmentCount() < this.summaryAPLength) {
            return new FlowSink(SourceSinkType.Return, -1, accessPath.getBaseType().toString(), new AccessPathFragment(accessPath), accessPath.getTaintSubFields(), gap, false, ConstraintType.FALSE);
        }
        return new FlowSink(SourceSinkType.Return, -1, accessPath.getBaseType().toString(), this.cutAPLength(new AccessPathFragment(accessPath)), true, gap, false, ConstraintType.FALSE);
    }

    public FlowSink createFieldSink(AccessPath accessPath) {
        return this.createFieldSink(accessPath, null);
    }

    public FlowSink createFieldSink(AccessPath accessPath, GapDefinition gap) {
        if (accessPath.isLocal()) {
            return new FlowSink(SourceSinkType.Field, -1, accessPath.getBaseType().toString(), accessPath.getTaintSubFields(), gap, ConstraintType.FALSE);
        }
        if (accessPath.getFragmentCount() < this.summaryAPLength) {
            return new FlowSink(SourceSinkType.Field, -1, accessPath.getBaseType().toString(), new AccessPathFragment(accessPath), accessPath.getTaintSubFields(), gap, false, ConstraintType.FALSE);
        }
        return new FlowSink(SourceSinkType.Field, -1, accessPath.getBaseType().toString(), this.cutAPLength(new AccessPathFragment(accessPath)), true, gap, false, ConstraintType.FALSE);
    }

    public FlowSink createParameterSinkAtGap(int paraIdx, AccessPath accessPath, String gapSignature) {
        if (accessPath.isLocal()) {
            if (!(accessPath.getBaseType() instanceof ArrayType)) {
                throw new RuntimeException("Parameter locals cannot directly be sinks");
            }
            return new FlowSink(SourceSinkType.Parameter, paraIdx, accessPath.getBaseType().toString(), accessPath.getTaintSubFields(), ConstraintType.FALSE);
        }
        if (accessPath.getFragmentCount() < this.summaryAPLength) {
            return new FlowSink(SourceSinkType.Parameter, paraIdx, accessPath.getBaseType().toString(), new AccessPathFragment(accessPath), accessPath.getTaintSubFields(), ConstraintType.FALSE);
        }
        return new FlowSink(SourceSinkType.Parameter, paraIdx, accessPath.getBaseType().toString(), this.cutAPLength(new AccessPathFragment(accessPath)), true, ConstraintType.FALSE);
    }

    public FlowSink createCustomSink(int paraIdx, AccessPath accessPath, GapDefinition gap, Object userData) {
        if (accessPath.isLocal()) {
            if (gap == null && !accessPath.getTaintSubFields() && !(accessPath.getBaseType() instanceof ArrayType)) {
                throw new RuntimeException("Parameter locals cannot directly be sinks");
            }
            return new FlowSink(SourceSinkType.Custom, paraIdx, accessPath.getBaseType().toString(), accessPath.getTaintSubFields(), gap, userData, ConstraintType.FALSE);
        }
        if (accessPath.getFragmentCount() < this.summaryAPLength) {
            return new FlowSink(SourceSinkType.Custom, paraIdx, accessPath.getBaseType().toString(), new AccessPathFragment(accessPath), accessPath.getTaintSubFields(), gap, userData, false, ConstraintType.FALSE);
        }
        return new FlowSink(SourceSinkType.Custom, paraIdx, accessPath.getBaseType().toString(), this.cutAPLength(new AccessPathFragment(accessPath)), true, gap, userData, false, ConstraintType.FALSE);
    }
}

