/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.jimple.infoflow.methodSummary.data.provider.IMethodSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public abstract class AbstractMethodSummaryProvider
implements IMethodSummaryProvider {
    protected Map<String, String> classToSuperclass = null;
    protected MultiMap<String, String> classToSubclasses = null;
    protected MultiMap<String, String> classToInterfaces = null;
    protected MultiMap<String, String> interfaceToImplementers = null;
    protected MultiMap<String, String> interfaceToSubInterfaces = null;

    @Override
    public List<String> getSubclassesOf(String className) {
        this.ensureHierarchy();
        ArrayList<String> worklist = new ArrayList<String>();
        ArrayList<String> subclasses = new ArrayList<String>();
        worklist.add(className);
        while (!worklist.isEmpty()) {
            Set scs = this.classToSubclasses.get((Object)((String)worklist.remove(0)));
            if (!subclasses.addAll(scs)) continue;
            worklist.addAll(scs);
        }
        return subclasses;
    }

    @Override
    public List<String> getSuperclassesOf(String className) {
        this.ensureHierarchy();
        ArrayList<String> worklist = new ArrayList<String>();
        ArrayList<String> superclasses = new ArrayList<String>();
        worklist.add(className);
        while (!worklist.isEmpty()) {
            String scs = this.classToSuperclass.get(worklist.remove(0));
            if (scs == null || scs.isEmpty()) continue;
            superclasses.add(scs);
            worklist.add(scs);
        }
        return superclasses;
    }

    @Override
    public Collection<String> getSuperinterfacesOf(String className) {
        this.ensureHierarchy();
        ArrayList<String> worklist = new ArrayList<String>();
        ArrayList<String> superinterfaces = new ArrayList<String>();
        worklist.add(className);
        while (!worklist.isEmpty()) {
            Set intfs = this.classToInterfaces.get((Object)((String)worklist.remove(0)));
            if (intfs == null || intfs.isEmpty()) continue;
            superinterfaces.addAll(intfs);
            worklist.addAll(intfs);
        }
        return superinterfaces;
    }

    @Override
    public List<String> getImplementersOfInterface(String className) {
        this.ensureHierarchy();
        ArrayList<String> worklist = new ArrayList<String>();
        ArrayList<String> implementers = new ArrayList<String>();
        worklist.add(className);
        worklist.addAll(this.getSubInterfacesOf(className));
        while (!worklist.isEmpty()) {
            Set scs = this.interfaceToImplementers.get((Object)((String)worklist.remove(0)));
            implementers.addAll(scs);
        }
        return implementers;
    }

    @Override
    public Set<String> getSubInterfacesOf(String className) {
        this.ensureHierarchy();
        ArrayList<String> worklist = new ArrayList<String>();
        HashSet<String> subInterfaces = new HashSet<String>();
        worklist.add(className);
        while (!worklist.isEmpty()) {
            Set scs = this.interfaceToSubInterfaces.get((Object)((String)worklist.remove(0)));
            if (!subInterfaces.addAll(scs)) continue;
            worklist.addAll(scs);
        }
        return subInterfaces;
    }

    private void ensureHierarchy() {
        if (this.classToSuperclass == null || this.classToSubclasses == null || this.interfaceToImplementers == null) {
            HashMap<String, String> classToSuperclass = new HashMap<String, String>();
            HashMultiMap classToSubclasses = new HashMultiMap();
            HashMultiMap classToInterfaces = new HashMultiMap();
            HashMultiMap interfaceToImplementers = new HashMultiMap();
            HashMultiMap interfaceToSubInterfaces = new HashMultiMap();
            Set<String> classNames = this.getAllClassesWithSummaries();
            for (String curClass : classNames) {
                Set<String> intfs;
                ClassMethodSummaries curSummaries = this.getClassFlows(curClass);
                if (curSummaries == null) continue;
                String superclass = curSummaries.getSuperClass();
                if (superclass != null && !superclass.isEmpty()) {
                    classToSuperclass.put(curClass, superclass);
                    classToSubclasses.put((Object)superclass, (Object)curClass);
                }
                if ((intfs = curSummaries.getInterfaces()) == null || intfs.isEmpty()) continue;
                for (String intf : intfs) {
                    if (curSummaries.isInterface()) {
                        interfaceToSubInterfaces.put((Object)intf, (Object)curClass);
                        continue;
                    }
                    classToInterfaces.put((Object)curClass, (Object)intf);
                    interfaceToImplementers.put((Object)intf, (Object)curClass);
                }
            }
            this.classToSuperclass = classToSuperclass;
            this.classToSubclasses = classToSubclasses;
            this.classToInterfaces = classToInterfaces;
            this.interfaceToImplementers = interfaceToImplementers;
            this.interfaceToSubInterfaces = interfaceToSubInterfaces;
        }
    }
}

