/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.provider;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.methodSummary.data.provider.XMLSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;

public class LazySummaryProvider
extends XMLSummaryProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Set<File> files = new HashSet<File>();
    protected Set<Path> pathes = new HashSet<Path>();
    protected Set<String> loadableClasses = new ConcurrentHashSet();

    public LazySummaryProvider(String folderInJar) throws URISyntaxException, IOException {
        this(folderInJar, LazySummaryProvider.class);
    }

    public LazySummaryProvider(String folderInJar, Class<?> parentClass) throws URISyntaxException, IOException {
        this.logger.warn("Lazy loading summaries from a jar/zip file might throw a ClosedChannelException. Use the EagerSummaryProvider instead.");
        this.loadSummariesFromJAR(folderInJar, parentClass, p -> {
            this.pathes.add((Path)p);
            this.loadableClasses.add(this.fileToClass(this.getFileName((Path)p)));
        });
    }

    public LazySummaryProvider(File source) {
        this(Collections.singletonList(source));
    }

    public LazySummaryProvider(Collection<File> files) {
        this.loadSummariesFromFiles(files, f -> {
            this.files.add((File)f);
            this.loadableClasses.add(this.fileToClass((File)f));
        });
    }

    protected void loadClass(String clazz) {
        if (this.loadedClasses.contains(clazz)) {
            return;
        }
        if (this.files != null && !this.files.isEmpty()) {
            for (File f : this.files) {
                if (!this.fileToClass(f).equals(clazz)) continue;
                this.loadClass(clazz, f);
                break;
            }
        }
        if (this.pathes != null && !this.pathes.isEmpty()) {
            for (Path path : this.pathes) {
                if (!this.fileToClass(this.getFileName(path)).equals(clazz)) continue;
                this.loadClass(clazz, path);
                break;
            }
        }
    }

    @Override
    public boolean supportsClass(String clazz) {
        if (this.loadableClasses != null && this.loadableClasses.contains(clazz)) {
            return true;
        }
        return super.supportsClass(clazz);
    }

    @Override
    public ClassSummaries getMethodFlows(Set<String> classes, String methodSignature) {
        if (this.loadableClasses != null) {
            for (String className : classes) {
                if (!this.loadableClasses.contains(className)) continue;
                this.loadClass(className);
            }
        }
        return super.getMethodFlows(classes, methodSignature);
    }

    @Override
    protected ClassMethodSummaries getClassSummaries(String className) {
        if (this.loadableClasses != null && this.loadableClasses.contains(className)) {
            this.loadClass(className);
        }
        return super.getClassSummaries(className);
    }

    @Override
    protected void addMethodSummaries(ClassMethodSummaries newSummaries) {
        super.addMethodSummaries(newSummaries);
        if (this.loadableClasses != null && !this.loadableClasses.isEmpty()) {
            this.loadableClasses.remove(newSummaries.getClassName());
        }
    }

    public Set<String> getLoadableClasses() {
        return this.loadableClasses;
    }

    @Override
    public ClassMethodSummaries getClassFlows(String className) {
        if (this.loadableClasses != null && className != null && this.loadableClasses.contains(className)) {
            this.loadClass(className);
        }
        return super.getClassFlows(className);
    }

    @Override
    public boolean mayHaveSummaryForMethod(String subsig) {
        if (this.loadableClasses != null && !this.loadableClasses.isEmpty()) {
            return true;
        }
        return super.mayHaveSummaryForMethod(subsig);
    }

    @Override
    public Set<String> getAllClassesWithSummaries() {
        HashSet<String> classes = new HashSet<String>(this.loadedClasses.size() + this.loadableClasses.size());
        classes.addAll(this.loadedClasses);
        classes.addAll(this.loadableClasses);
        return classes;
    }
}

