/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.sourceSink;

import java.util.HashMap;
import java.util.Map;
import soot.Local;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.methodSummary.data.sourceSink.ConstraintType;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;

public abstract class AbstractFlowSinkSource {
    protected final SourceSinkType type;
    protected final int parameterIdx;
    protected final String baseType;
    protected final AccessPathFragment accessPath;
    protected final GapDefinition gap;
    protected final Object userData;
    protected final boolean matchStrict;
    protected ConstraintType isConstrained;

    public AbstractFlowSinkSource(SourceSinkType type, int parameterIdx, String baseType, AccessPathFragment accessPath, boolean matchStrict, ConstraintType isConstrained) {
        this(type, parameterIdx, baseType, accessPath, null, matchStrict, isConstrained);
    }

    public AbstractFlowSinkSource(SourceSinkType type, String baseType, AccessPathFragment accessPath, GapDefinition gap, boolean matchStrict, ConstraintType isConstrained) {
        this(type, -1, baseType, accessPath, gap, matchStrict, isConstrained);
    }

    public AbstractFlowSinkSource(SourceSinkType type, int parameterIdx, String baseType, AccessPathFragment accessPath, GapDefinition gap, boolean matchStrict, ConstraintType isConstrained) {
        this(type, parameterIdx, baseType, accessPath, gap, null, matchStrict, isConstrained);
    }

    public AbstractFlowSinkSource(SourceSinkType type, int parameterIdx, String baseType, AccessPathFragment accessPath, GapDefinition gap, Object userData, boolean matchStrict, ConstraintType isConstrained) {
        this.type = type;
        this.parameterIdx = parameterIdx;
        this.baseType = baseType;
        this.accessPath = accessPath;
        this.gap = gap;
        this.userData = userData;
        this.matchStrict = matchStrict;
        this.isConstrained = isConstrained;
    }

    public boolean isCoarserThan(AbstractFlowSinkSource other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.type != other.type || this.parameterIdx != other.parameterIdx || !this.safeCompare(this.baseType, other.baseType) || !this.safeCompare(this.gap, other.gap)) {
            return false;
        }
        if (this.accessPath != null && other.accessPath != null) {
            if (this.accessPath.length() > other.accessPath.length()) {
                return false;
            }
            for (int i = 0; i < this.accessPath.length(); ++i) {
                if (this.accessPath.getField(i).equals(other.accessPath.getField(i))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isParameter() {
        return this.type == SourceSinkType.Parameter;
    }

    public boolean isThis() {
        return this.type == SourceSinkType.Field && !this.hasAccessPath();
    }

    public boolean isCustom() {
        return this.type == SourceSinkType.Custom;
    }

    public int getParameterIndex() {
        return this.parameterIdx;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public boolean isField() {
        return this.type == SourceSinkType.Field;
    }

    public AccessPathFragment getAccessPath() {
        return this.accessPath;
    }

    public boolean isReturn() {
        return this.type == SourceSinkType.Return;
    }

    public boolean isGapBaseObject() {
        return this.type == SourceSinkType.GapBaseObject;
    }

    public boolean hasAccessPath() {
        return this.accessPath != null && !this.accessPath.isEmpty();
    }

    public int getAccessPathLength() {
        return this.accessPath == null ? 0 : this.accessPath.length();
    }

    public SourceSinkType getType() {
        return this.type;
    }

    public GapDefinition getGap() {
        return this.gap;
    }

    public boolean hasGap() {
        return this.gap != null;
    }

    public String getLastFieldType() {
        if (this.accessPath == null || this.accessPath.isEmpty()) {
            return this.baseType;
        }
        return this.accessPath.getLastFieldType();
    }

    public boolean isMatchStrict() {
        return this.matchStrict;
    }

    public boolean isConstrained() {
        return this.isConstrained == ConstraintType.TRUE || this.isConstrained == ConstraintType.NO_MATCH;
    }

    public boolean shiftRight() {
        return this.isConstrained == ConstraintType.SHIFT_RIGHT;
    }

    public boolean shiftLeft() {
        return this.isConstrained == ConstraintType.SHIFT_LEFT;
    }

    public boolean anyShift() {
        return this.shiftLeft() || this.shiftRight();
    }

    public boolean keepConstraint() {
        return this.isConstrained == ConstraintType.KEEP;
    }

    public boolean keepOnRO() {
        return this.isConstrained == ConstraintType.READONLY;
    }

    public boolean append() {
        return this.isConstrained == ConstraintType.APPEND;
    }

    public ConstraintType getConstraintType() {
        return this.isConstrained;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessPath == null ? 0 : this.accessPath.hashCode());
        result = 31 * result + (this.baseType == null ? 0 : this.baseType.hashCode());
        result = 31 * result + (this.gap == null ? 0 : this.gap.hashCode());
        result = 31 * result + (this.matchStrict ? 1231 : 1237);
        result = 31 * result + this.isConstrained.hashCode();
        result = 31 * result + this.parameterIdx;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.userData == null ? 0 : this.userData.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFlowSinkSource other = (AbstractFlowSinkSource)obj;
        if (this.accessPath == null ? other.accessPath != null : !this.accessPath.equals(other.accessPath)) {
            return false;
        }
        if (this.baseType == null ? other.baseType != null : !this.baseType.equals(other.baseType)) {
            return false;
        }
        if (this.gap == null ? other.gap != null : !this.gap.equals(other.gap)) {
            return false;
        }
        if (this.matchStrict != other.matchStrict) {
            return false;
        }
        if (this.isConstrained != other.isConstrained) {
            return false;
        }
        if (this.parameterIdx != other.parameterIdx) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.userData == null ? other.userData != null : !this.userData.equals(other.userData));
    }

    protected boolean safeCompare(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return o1 == null;
        }
        return o1.equals(o2);
    }

    public Map<String, String> xmlAttributes() {
        HashMap<String, String> res = new HashMap<String, String>();
        if (this.isParameter()) {
            res.put("sourceSinkType", "parameter");
            res.put("ParameterIndex", "" + this.getParameterIndex());
        } else if (this.isField()) {
            res.put("sourceSinkType", "field");
        } else if (this.isReturn()) {
            res.put("sourceSinkType", "return");
        } else {
            throw new RuntimeException("Invalid source type");
        }
        if (this.baseType != null) {
            res.put("BaseType", this.baseType);
        }
        if (this.hasAccessPath()) {
            res.put("AccessPath", this.getAccessPath().toString());
        }
        if (this.gap != null) {
            res.put("gap", "" + this.getGap().getID());
        }
        return res;
    }

    public Object getUserData() {
        return this.userData;
    }

    public abstract AbstractFlowSinkSource replaceGaps(Map<Integer, GapDefinition> var1);

    public Local getBaseLocal(Stmt stmt) {
        if (stmt.containsInvokeExpr()) {
            AssignStmt assignStmt;
            Value lop;
            InvokeExpr iexpr = stmt.getInvokeExpr();
            if (this.isField()) {
                if (iexpr instanceof InstanceInvokeExpr) {
                    InstanceInvokeExpr iiexpr = (InstanceInvokeExpr)iexpr;
                    return (Local)iiexpr.getBase();
                }
            } else if (this.isParameter()) {
                Value val;
                int idx = this.getParameterIndex();
                if (idx < iexpr.getArgCount() && (val = iexpr.getArg(idx)) instanceof Local) {
                    return (Local)val;
                }
            } else if (this.isReturn() && stmt instanceof AssignStmt && (lop = (assignStmt = (AssignStmt)stmt).getLeftOp()) instanceof Local) {
                return (Local)lop;
            }
        }
        return null;
    }
}

