/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.sourceSink;

import java.util.Map;
import soot.jimple.infoflow.methodSummary.data.sourceSink.AbstractFlowSinkSource;
import soot.jimple.infoflow.methodSummary.data.sourceSink.ConstraintType;
import soot.jimple.infoflow.methodSummary.data.sourceSink.InvalidFlowSpecificationException;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;

public class FlowSource
extends AbstractFlowSinkSource
implements Cloneable {
    public static final int ANY_PARAMETER = -2;

    public FlowSource(SourceSinkType type, String baseType, ConstraintType isConstrained) {
        super(type, -1, baseType, null, null, false, isConstrained);
    }

    public FlowSource(SourceSinkType type, String baseType, GapDefinition gap, ConstraintType isConstrained) {
        super(type, -1, baseType, null, gap, null, false, isConstrained);
    }

    public FlowSource(SourceSinkType type, String baseType, GapDefinition gap, boolean matchStrict, ConstraintType isConstrained) {
        super(type, -1, baseType, null, gap, null, matchStrict, isConstrained);
    }

    public FlowSource(SourceSinkType type, String baseType, AccessPathFragment apf, GapDefinition gap, boolean matchStrict, ConstraintType isConstrained) {
        super(type, baseType, apf, gap, matchStrict, isConstrained);
    }

    public FlowSource(SourceSinkType type, int parameterIdx, String baseType, ConstraintType isConstrained) {
        super(type, parameterIdx, baseType, null, null, false, isConstrained);
    }

    public FlowSource(SourceSinkType type, int parameterIdx, String baseType, GapDefinition gap, ConstraintType isConstrained) {
        super(type, parameterIdx, baseType, null, gap, null, false, isConstrained);
    }

    public FlowSource(SourceSinkType type, int parameterIdx, String baseType, AccessPathFragment accessPath, GapDefinition gap, ConstraintType isConstrained) {
        super(type, parameterIdx, baseType, accessPath, gap, false, isConstrained);
    }

    public FlowSource(SourceSinkType type, int parameterIdx, String baseType, AccessPathFragment accessPath, GapDefinition gap, boolean matchStrict, ConstraintType isConstrained) {
        super(type, parameterIdx, baseType, accessPath, gap, matchStrict, isConstrained);
    }

    public FlowSource(SourceSinkType type, int parameterIdx, String baseType, AccessPathFragment accessPath, GapDefinition gap, Object userData, boolean matchStrict, ConstraintType isConstrained) {
        super(type, parameterIdx, baseType, accessPath, gap, userData, matchStrict, isConstrained);
    }

    public String toString() {
        String gapString;
        String string = gapString = this.getGap() == null ? "" : "Gap " + this.getGap().getSignature() + " ";
        if (this.isParameter()) {
            return gapString + "Parameter " + this.getParameterIndex() + (String)(this.accessPath == null ? "" : " " + AccessPathFragment.toString(this.accessPath));
        }
        if (this.isField()) {
            return gapString + "Field" + (String)(this.accessPath == null ? "" : " " + AccessPathFragment.toString(this.accessPath));
        }
        if (this.isThis()) {
            return "THIS";
        }
        if (this.isReturn() && this.gap != null) {
            return "Return value of gap " + this.gap.getSignature() + (String)(this.accessPath == null ? "" : " " + AccessPathFragment.toString(this.accessPath));
        }
        if (this.isReturn()) {
            return "Return value" + (String)(this.accessPath == null ? "" : " " + AccessPathFragment.toString(this.accessPath));
        }
        if (this.isCustom()) {
            return "CUSTOM " + gapString + "Parameter " + this.getParameterIndex() + (String)(this.accessPath == null ? "" : " " + AccessPathFragment.toString(this.accessPath));
        }
        return "<unknown>";
    }

    public void validate(String methodName) {
        if (this.getType() == SourceSinkType.Return && this.getGap() == null) {
            throw new InvalidFlowSpecificationException("Return values cannot be sources. Offending method: " + methodName, this);
        }
    }

    @Override
    public FlowSource replaceGaps(Map<Integer, GapDefinition> replacementMap) {
        if (this.gap == null) {
            return this;
        }
        GapDefinition newGap = replacementMap.get(this.gap.getID());
        if (newGap == null) {
            return this;
        }
        return new FlowSource(this.type, this.parameterIdx, this.baseType, this.accessPath, newGap, this.matchStrict, this.isConstrained);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new FlowSource(this.type, this.parameterIdx, this.baseType, this.accessPath, this.gap, this.userData, this.matchStrict, this.isConstrained);
    }
}

