/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.summary;

import java.util.Arrays;
import java.util.Map;
import soot.jimple.infoflow.methodSummary.data.sourceSink.AbstractFlowSinkSource;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowConstraint;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.IsAliasType;
import soot.jimple.infoflow.methodSummary.taintWrappers.Taint;

public abstract class AbstractMethodSummary {
    protected final String methodSig;
    protected final FlowConstraint[] constraints;
    protected final IsAliasType isAlias;

    AbstractMethodSummary(String methodSig, FlowConstraint[] constraints, IsAliasType isAlias) {
        this.methodSig = methodSig;
        this.constraints = constraints;
        this.isAlias = isAlias;
    }

    public String methodSig() {
        return this.methodSig;
    }

    public FlowConstraint[] getConstraints() {
        return this.constraints;
    }

    public boolean isAlias() {
        return this.isAlias == IsAliasType.TRUE;
    }

    public abstract boolean isAlias(Taint var1);

    protected boolean isAlias(Taint t, AbstractFlowSinkSource flow) {
        if (this.isAlias == IsAliasType.TRUE) {
            return true;
        }
        int fromLen = flow.getAccessPathLength();
        boolean hasContext = fromLen == 0 ? t.getBaseContext() != null : (t.getAccessPathLength() >= fromLen ? t.getAccessPath().getContext(fromLen - 1) != null : false);
        return hasContext && this.isAlias == IsAliasType.WITH_CONTEXT;
    }

    public abstract AbstractMethodSummary replaceGaps(Map<Integer, GapDefinition> var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methodSig == null ? 0 : this.methodSig.hashCode());
        result = 31 * result + (this.constraints == null ? 0 : Arrays.hashCode(this.constraints));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMethodSummary other = (AbstractMethodSummary)obj;
        if (this.methodSig == null ? other.methodSig != null : !this.methodSig.equals(other.methodSig)) {
            return false;
        }
        return Arrays.equals(this.constraints, other.constraints);
    }
}

