/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.summary;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import soot.RefType;
import soot.Scene;
import soot.Type;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowConstraint;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSink;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSource;
import soot.jimple.infoflow.methodSummary.data.summary.AbstractMethodSummary;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.IsAliasType;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.taintWrappers.Taint;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;

public class MethodFlow
extends AbstractMethodSummary {
    private final FlowSource from;
    private final FlowSink to;
    private final Boolean typeChecking;
    private final Boolean ignoreTypes;
    private final Boolean cutSubFields;
    private final boolean isFinal;
    private final boolean excludedOnClear;

    public MethodFlow(String methodSig, FlowSource from, FlowSink to, IsAliasType isAlias, Boolean typeChecking, Boolean ignoreTypes, Boolean cutSubFields, FlowConstraint[] constraints, boolean isFinal, boolean excludedOnClear) {
        super(methodSig, constraints, isAlias);
        this.from = from;
        this.to = to;
        this.typeChecking = typeChecking;
        this.ignoreTypes = ignoreTypes;
        this.cutSubFields = cutSubFields;
        this.isFinal = isFinal;
        this.excludedOnClear = excludedOnClear;
    }

    public FlowSource source() {
        return this.from;
    }

    public FlowSink sink() {
        return this.to;
    }

    public boolean isCoarserThan(MethodFlow flow) {
        if (flow.equals(this)) {
            return true;
        }
        return this.from.isCoarserThan(flow.source()) && this.to.isCoarserThan(flow.sink());
    }

    public MethodFlow reverse() {
        boolean taintSubFields = this.to.taintSubFields();
        SourceSinkType fromType = this.to.getType();
        SourceSinkType toType = this.from.getType();
        if (this.from.getType() == SourceSinkType.Field && !this.from.hasAccessPath() && this.from.hasGap()) {
            toType = SourceSinkType.GapBaseObject;
            taintSubFields = false;
        }
        if (this.to.isGapBaseObject()) {
            fromType = SourceSinkType.Field;
            taintSubFields = true;
        }
        FlowSource reverseSource = new FlowSource(fromType, this.to.getParameterIndex(), this.to.getBaseType(), this.to.getAccessPath(), this.to.getGap(), this.to.isMatchStrict(), this.to.getConstraintType());
        FlowSink reverseSink = new FlowSink(toType, this.from.getParameterIndex(), this.from.getBaseType(), this.from.getAccessPath(), taintSubFields, this.from.getGap(), this.from.isMatchStrict(), this.from.getConstraintType());
        return new MethodFlow(this.methodSig, reverseSource, reverseSink, this.isAlias, this.typeChecking, this.ignoreTypes, this.cutSubFields, this.constraints, this.isFinal, false);
    }

    public Boolean getTypeChecking() {
        return this.typeChecking;
    }

    public Boolean getCutSubFields() {
        return this.cutSubFields;
    }

    public boolean isCustom() {
        return this.from.isCustom() || this.to.isCustom();
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isExcludedOnClear() {
        return this.excludedOnClear;
    }

    @Override
    public boolean isAlias(Taint t) {
        return this.isAlias(t, this.from);
    }

    @Override
    public MethodFlow replaceGaps(Map<Integer, GapDefinition> replacementMap) {
        if (replacementMap == null) {
            return this;
        }
        return new MethodFlow(this.methodSig, (FlowSource)this.from.replaceGaps((Map)replacementMap), (FlowSink)this.to.replaceGaps((Map)replacementMap), this.isAlias, this.typeChecking, this.ignoreTypes, this.cutSubFields, this.constraints, this.isFinal, false);
    }

    public void validate() {
        this.source().validate(this.methodSig);
        this.sink().validate(this.methodSig);
        if (this.sink().getType() == SourceSinkType.GapBaseObject && this.sink().getGap() != null) {
            String sinkType = SootMethodRepresentationParser.v().parseSootMethodString(this.sink().getGap().getSignature()).getClassName();
            RefType t1 = RefType.v((String)this.sink().getBaseType());
            RefType t2 = RefType.v((String)sinkType);
            if (!Scene.v().getFastHierarchy().canStoreType((Type)t1, (Type)t2) && !Scene.v().getFastHierarchy().canStoreType((Type)t2, (Type)t1)) {
                throw new RuntimeException("Target type of gap base flow is invalid");
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodFlow that = (MethodFlow)o;
        return this.isAlias == that.isAlias && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.typeChecking, that.typeChecking) && Objects.equals(this.ignoreTypes, that.ignoreTypes) && Objects.equals(this.cutSubFields, that.cutSubFields) && Arrays.equals(this.constraints, that.constraints) && this.isFinal == that.isFinal;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.from, this.to, this.isAlias, this.typeChecking, this.ignoreTypes, this.cutSubFields, Arrays.hashCode(this.constraints), this.isFinal});
    }

    public String toString() {
        return "{" + this.methodSig + " Source: [" + this.from.toString() + "] Sink: [" + this.to.toString() + "]}";
    }

    public boolean getIgnoreTypes() {
        if (this.ignoreTypes == null) {
            if (this.typeChecking != null && !this.typeChecking.booleanValue()) {
                if ("java.lang.Object[]".equals(this.to.getLastFieldType())) {
                    return true;
                }
                if ("java.lang.Object[]".equals(this.from.getLastFieldType())) {
                    return true;
                }
                if (this.to.isField() && !this.to.hasAccessPath()) {
                    return true;
                }
            }
            return false;
        }
        return this.ignoreTypes;
    }
}

