/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.summary;

import heros.solver.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import soot.Scene;
import soot.SootMethod;
import soot.jimple.infoflow.methodSummary.data.summary.AbstractMethodSummary;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.ImmutableMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.IsAliasType;
import soot.jimple.infoflow.methodSummary.data.summary.MethodClear;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.util.ConcurrentHashMultiMap;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class MethodSummaries
implements Iterable<MethodFlow> {
    public static final MethodSummaries EMPTY_SUMMARIES = new ImmutableMethodSummaries();
    private volatile MultiMap<String, MethodFlow> flows;
    private volatile MultiMap<String, MethodClear> clears;
    private volatile Map<Integer, GapDefinition> gaps;
    private volatile Set<String> excludedMethods;

    public MethodSummaries() {
        this((MultiMap<String, MethodFlow>)new ConcurrentHashMultiMap());
    }

    MethodSummaries(Set<MethodFlow> flows) {
        this(MethodSummaries.flowSetToFlowMap(flows), new ConcurrentHashMap<Integer, GapDefinition>());
    }

    MethodSummaries(MultiMap<String, MethodFlow> flows) {
        this(flows, null);
    }

    MethodSummaries(MultiMap<String, MethodFlow> flows, Map<Integer, GapDefinition> gaps) {
        this(flows, null, gaps);
    }

    MethodSummaries(MultiMap<String, MethodFlow> flows, MultiMap<String, MethodClear> clears, Map<Integer, GapDefinition> gaps) {
        this.flows = flows;
        this.clears = clears;
        this.gaps = gaps;
    }

    private static MultiMap<String, MethodFlow> flowSetToFlowMap(Set<MethodFlow> flows) {
        HashMultiMap flowSet = new HashMultiMap();
        if (flows != null && !flows.isEmpty()) {
            for (MethodFlow flow : flows) {
                flowSet.put((Object)flow.methodSig(), (Object)flow);
            }
        }
        return flowSet;
    }

    public void mergeFlows(Collection<MethodFlow> newFlows) {
        if (newFlows != null && !newFlows.isEmpty()) {
            this.ensureFlows();
            for (MethodFlow flow : newFlows) {
                this.flows.put((Object)flow.methodSig(), (Object)flow);
            }
        }
    }

    public void mergeClears(Collection<MethodClear> newClears) {
        if (newClears != null && !newClears.isEmpty()) {
            this.ensureClears();
            for (MethodClear clear : newClears) {
                this.clears.put((Object)clear.methodSig(), (Object)clear);
            }
        }
    }

    public void mergeSummaries(Collection<MethodSummaries> newSummaries) {
        if (newSummaries != null && !newSummaries.isEmpty()) {
            for (MethodSummaries summaries : newSummaries) {
                this.merge(summaries);
            }
        }
    }

    public void merge(MultiMap<String, MethodFlow> newFlows) {
        if (newFlows != null && !newFlows.isEmpty()) {
            this.flows.putAll(newFlows);
        }
    }

    public boolean merge(MethodSummaries newFlows) {
        AbstractMethodSummary replacedFlow;
        if (newFlows == null || newFlows.isEmpty()) {
            return false;
        }
        HashMap<Integer, GapDefinition> renumberedGaps = null;
        if (newFlows.gaps != null) {
            renumberedGaps = new HashMap<Integer, GapDefinition>();
            int lastFreeGapId = 0;
            for (Integer newGapId : newFlows.gaps.keySet()) {
                Iterator newGap = newFlows.gaps.get(newGapId);
                GapDefinition oldGap = this.gaps == null ? null : this.gaps.get(((GapDefinition)((Object)newGap)).getID());
                if (oldGap == null || oldGap == newGap) continue;
                while (this.gaps.containsKey(lastFreeGapId)) {
                    ++lastFreeGapId;
                }
                GapDefinition renumberedGap = ((GapDefinition)((Object)newGap)).renumber(lastFreeGapId);
                renumberedGaps.put(newGapId, renumberedGap);
                ++lastFreeGapId;
            }
        }
        boolean newData = false;
        if (newFlows.flows != null && !newFlows.flows.isEmpty()) {
            for (String key : newFlows.flows.keySet()) {
                for (MethodFlow flow : newFlows.flows.get((Object)key)) {
                    replacedFlow = flow.replaceGaps(renumberedGaps);
                    this.ensureFlows();
                    if (!this.flows.put((Object)key, (Object)replacedFlow)) continue;
                    newData = true;
                }
            }
        }
        if (newFlows.clears != null && !newFlows.clears.isEmpty()) {
            for (String key : newFlows.clears.keySet()) {
                for (MethodClear clear : newFlows.clears.get((Object)key)) {
                    replacedFlow = clear.replaceGaps(renumberedGaps);
                    this.ensureClears();
                    if (!this.clears.put((Object)key, (Object)replacedFlow)) continue;
                    newData = true;
                }
            }
        }
        if (newFlows.gaps != null) {
            for (Integer newGapId : newFlows.gaps.keySet()) {
                GapDefinition replacedGap = (GapDefinition)renumberedGaps.get(newGapId);
                if (replacedGap == null) {
                    replacedGap = newFlows.gaps.get(newGapId);
                }
                this.ensureGaps();
                this.gaps.put(replacedGap.getID(), replacedGap);
                newData = true;
            }
        }
        return newData;
    }

    public Set<MethodFlow> getFlowsForMethod(String methodSig) {
        return this.flows == null ? null : this.flows.get((Object)methodSig);
    }

    public MethodSummaries filterForMethod(String signature) {
        Set sigClears;
        Set sigFlows;
        MethodSummaries summaries = null;
        if (this.flows != null && !this.flows.isEmpty() && (sigFlows = this.flows.get((Object)signature)) != null && !sigFlows.isEmpty()) {
            if (summaries == null) {
                summaries = new MethodSummaries();
            }
            summaries.mergeFlows(sigFlows);
        }
        if (this.clears != null && !this.clears.isEmpty() && (sigClears = this.clears.get((Object)signature)) != null && !sigClears.isEmpty()) {
            if (summaries == null) {
                summaries = new MethodSummaries();
            }
            summaries.mergeClears(sigClears);
        }
        return summaries;
    }

    public MethodSummaries getApproximateFlows() {
        if (this.flows == null || this.flows.isEmpty()) {
            return null;
        }
        MethodSummaries summaries = new MethodSummaries();
        for (Pair flow : this.flows) {
            if (!((MethodFlow)flow.getO2()).sink().anyShift()) continue;
            summaries.addFlow((MethodFlow)flow.getO2());
        }
        if (summaries.isEmpty()) {
            return null;
        }
        if (this.clears != null && !this.clears.isEmpty()) {
            summaries.mergeClears(this.clears.values());
        }
        return summaries;
    }

    public MethodSummaries filterForAliases() {
        Set<MethodClear> sigClears;
        Set<MethodFlow> sigFlows;
        MethodSummaries summaries = null;
        if (this.flows != null && !this.flows.isEmpty() && !(sigFlows = this.flows.values().stream().filter(f -> f.isAlias != IsAliasType.FALSE).collect(Collectors.toSet())).isEmpty()) {
            if (summaries == null) {
                summaries = new MethodSummaries();
            }
            summaries.mergeFlows(sigFlows);
        }
        if (this.clears != null && !this.clears.isEmpty() && !(sigClears = this.clears.values().stream().filter(f -> f.isAlias != IsAliasType.FALSE).collect(Collectors.toSet())).isEmpty()) {
            if (summaries == null) {
                summaries = new MethodSummaries();
            }
            summaries.mergeClears(sigClears);
        }
        return summaries;
    }

    public boolean addFlow(MethodFlow flow) {
        this.ensureFlows();
        return this.flows.put((Object)flow.methodSig, (Object)flow);
    }

    public boolean addClear(MethodClear clear) {
        this.ensureClears();
        return this.clears.put((Object)clear.methodSig, (Object)clear);
    }

    public Map<Integer, GapDefinition> getGaps() {
        return this.gaps;
    }

    public GapDefinition getGap(int id) {
        return this.gaps == null ? null : this.gaps.get(id);
    }

    public Collection<GapDefinition> getAllGaps() {
        return this.gaps == null ? null : this.gaps.values();
    }

    public MultiMap<String, MethodFlow> getFlows() {
        return this.flows;
    }

    public MultiMap<String, MethodClear> getClears() {
        return this.clears;
    }

    public Set<MethodFlow> getAllFlows() {
        return this.flows == null ? null : this.flows.values();
    }

    public Set<MethodClear> getAllClears() {
        return this.clears == null ? null : this.clears.values();
    }

    @Override
    public Iterator<MethodFlow> iterator() {
        return new Iterator<MethodFlow>(){
            private Pair<String, MethodFlow> curPair = null;
            private Iterator<Pair<String, MethodFlow>> flowIt;
            {
                this.flowIt = MethodSummaries.this.flows.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.flowIt.hasNext();
            }

            @Override
            public MethodFlow next() {
                this.curPair = this.flowIt.next();
                return (MethodFlow)this.curPair.getO2();
            }

            @Override
            public void remove() {
                MethodSummaries.this.flows.remove((Object)((String)this.curPair.getO1()), (Object)((MethodFlow)this.curPair.getO2()));
            }
        };
    }

    public GapDefinition getOrCreateGap(int gapID, String signature) {
        this.ensureGaps();
        GapDefinition gd = this.gaps.get(gapID);
        if (gd == null) {
            gd = new GapDefinition(gapID, signature);
            this.gaps.put(gapID, gd);
        }
        if (gd.getSignature() == null || gd.getSignature().isEmpty()) {
            gd.setSignature(signature);
        } else if (!gd.getSignature().equals(signature)) {
            throw new RuntimeException("Gap signature mismatch detected");
        }
        return gd;
    }

    public GapDefinition createTemporaryGap(int gapID) {
        if (this.gaps != null && this.gaps.containsKey(gapID)) {
            throw new RuntimeException("A gap with the ID " + gapID + " already exists");
        }
        this.ensureGaps();
        GapDefinition gd = new GapDefinition(gapID);
        this.gaps.put(gapID, gd);
        return gd;
    }

    public boolean removeGap(GapDefinition gap) {
        if (this.gaps == null || this.gaps.isEmpty()) {
            return false;
        }
        for (Map.Entry<Integer, GapDefinition> entry : this.gaps.entrySet()) {
            if (entry.getValue() != gap) continue;
            boolean ok = this.gaps.remove(entry.getKey()) == gap;
            return ok;
        }
        return false;
    }

    public void clear() {
        if (this.flows != null) {
            this.flows.clear();
        }
        if (this.clears != null) {
            this.clears.clear();
        }
        if (this.gaps != null) {
            this.gaps.clear();
        }
    }

    public int getFlowCount() {
        return this.flows == null || this.flows.isEmpty() ? 0 : this.flows.values().size();
    }

    public void validate() {
        this.validateGaps();
        this.validateFlows();
    }

    private void validateGaps() {
        if (this.gaps == null || this.gaps.isEmpty()) {
            return;
        }
        for (String methodName : this.getFlows().keySet()) {
            HashSet<GapDefinition> gapsWithFlows = new HashSet<GapDefinition>();
            HashSet<GapDefinition> gapsWithBases = new HashSet<GapDefinition>();
            for (MethodFlow flow : this.getFlows().get((Object)methodName)) {
                if (flow.isCustom()) continue;
                if (flow.source().getGap() != null) {
                    if (flow.source().getType() == SourceSinkType.GapBaseObject) {
                        gapsWithBases.add(flow.source().getGap());
                    } else {
                        gapsWithFlows.add(flow.source().getGap());
                    }
                }
                if (flow.sink().getGap() == null) continue;
                if (flow.sink().getType() == SourceSinkType.GapBaseObject) {
                    gapsWithBases.add(flow.sink().getGap());
                    continue;
                }
                gapsWithFlows.add(flow.sink().getGap());
            }
            for (GapDefinition gd : gapsWithFlows) {
                SootMethod sm = Scene.v().grabMethod(gd.getSignature());
                if (sm != null && sm.isStatic() || gapsWithBases.contains(gd)) continue;
                throw new RuntimeException("Flow to/from a gap without a base detected  for method " + methodName + ". Gap target is " + gd.getSignature());
            }
        }
        for (GapDefinition gap : this.getAllGaps()) {
            if (gap.getSignature() != null && !gap.getSignature().isEmpty()) continue;
            throw new RuntimeException("Gap without signature detected");
        }
        for (Integer gapId : this.gaps.keySet()) {
            GapDefinition gd1 = this.gaps.get(gapId);
            for (GapDefinition gd2 : this.gaps.values()) {
                if (gd1 == gd2 || gd1.getID() != gd2.getID()) continue;
                throw new RuntimeException("Duplicate gap id");
            }
        }
    }

    private void validateFlows() {
        if (this.flows == null || this.flows.isEmpty()) {
            return;
        }
        for (String methodName : this.getFlows().keySet()) {
            for (MethodFlow flow : this.getFlows().get((Object)methodName)) {
                flow.validate();
            }
        }
    }

    public Set<MethodFlow> getInFlowsForGap(GapDefinition gd) {
        HashSet<MethodFlow> res = new HashSet<MethodFlow>();
        for (String methodName : this.getFlows().keySet()) {
            for (MethodFlow flow : this.getFlows().get((Object)methodName)) {
                if (flow.sink().getGap() != gd) continue;
                res.add(flow);
            }
        }
        return res;
    }

    public Set<MethodFlow> getOutFlowsForGap(GapDefinition gd) {
        HashSet<MethodFlow> res = new HashSet<MethodFlow>();
        for (String methodName : this.getFlows().keySet()) {
            for (MethodFlow flow : this.getFlows().get((Object)methodName)) {
                MethodFlow reverseFlow;
                if (flow.source().getGap() == gd) {
                    res.add(flow);
                    continue;
                }
                if (!flow.isAlias() || (reverseFlow = flow.reverse()).source().getGap() != gd) continue;
                res.add(reverseFlow);
            }
        }
        return res;
    }

    public void remove(MethodFlow toRemove) {
        Set flowsForMethod = this.flows.get((Object)toRemove.methodSig());
        if (flowsForMethod != null) {
            flowsForMethod.remove(toRemove);
            if (flowsForMethod.isEmpty()) {
                this.flows.remove((Object)toRemove.methodSig());
            }
        }
    }

    public void removeAll(Collection<MethodFlow> toRemove) {
        Iterator<MethodFlow> flowIt = this.iterator();
        while (flowIt.hasNext()) {
            MethodFlow flow = flowIt.next();
            if (!toRemove.contains(flow)) continue;
            flowIt.remove();
        }
    }

    public boolean isEmpty() {
        return !(this.flows != null && !this.flows.isEmpty() || this.clears != null && !this.clears.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureGaps() {
        if (this.gaps == null) {
            MethodSummaries methodSummaries = this;
            synchronized (methodSummaries) {
                if (this.gaps == null) {
                    this.gaps = new ConcurrentHashMap<Integer, GapDefinition>();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFlows() {
        if (this.flows == null) {
            MethodSummaries methodSummaries = this;
            synchronized (methodSummaries) {
                if (this.flows == null) {
                    this.flows = new ConcurrentHashMultiMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureClears() {
        if (this.clears == null) {
            MethodSummaries methodSummaries = this;
            synchronized (methodSummaries) {
                if (this.clears == null) {
                    this.clears = new ConcurrentHashMultiMap();
                }
            }
        }
    }

    public boolean hasFlows() {
        return this.flows != null && !this.flows.isEmpty();
    }

    public boolean hasGaps() {
        return this.gaps != null && !this.gaps.isEmpty();
    }

    public boolean hasClears() {
        return this.clears != null && !this.clears.isEmpty();
    }

    public MethodSummaries reverse() {
        HashMultiMap reversedFlows = new HashMultiMap(this.flows.size());
        for (String className : this.flows.keySet()) {
            for (MethodFlow flow : this.flows.get((Object)className)) {
                reversedFlows.put((Object)className, (Object)flow.reverse());
            }
        }
        return new MethodSummaries((MultiMap<String, MethodFlow>)reversedFlows, this.clears, this.gaps);
    }

    public void addExcludedMethod(String methodSignature) {
        if (this.excludedMethods == null) {
            this.excludedMethods = new HashSet<String>();
        }
        this.excludedMethods.add(methodSignature);
    }

    public boolean isExcluded(String subsignature) {
        return this.excludedMethods != null && this.excludedMethods.contains(subsignature);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clears == null ? 0 : this.clears.hashCode());
        result = 31 * result + (this.excludedMethods == null ? 0 : this.excludedMethods.hashCode());
        result = 31 * result + (this.flows == null ? 0 : this.flows.hashCode());
        result = 31 * result + (this.gaps == null ? 0 : this.gaps.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSummaries other = (MethodSummaries)obj;
        if (this.clears == null ? other.clears != null : !this.clears.equals(other.clears)) {
            return false;
        }
        if (this.excludedMethods == null ? other.excludedMethods != null : !this.excludedMethods.equals(other.excludedMethods)) {
            return false;
        }
        if (this.flows == null ? other.flows != null : !this.flows.equals(other.flows)) {
            return false;
        }
        return !(this.gaps == null ? other.gaps != null : !this.gaps.equals(other.gaps));
    }

    public static MethodSummaries fromSingleFlow(MethodFlow flow) {
        MethodSummaries summaries = new MethodSummaries();
        summaries.addFlow(flow);
        return summaries;
    }
}

