/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.summary;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;

public class SummaryMetaData {
    private final Set<String> exclusiveClasses = new HashSet<String>();
    private final Set<String> exclusivePackages = new HashSet<String>();
    private final Map<String, ClassInformation> classInformation = new HashMap<String, ClassInformation>();

    public SummaryMetaData() {
    }

    public SummaryMetaData(SummaryMetaData metaData) {
        if (metaData != null) {
            this.exclusiveClasses.addAll(metaData.exclusiveClasses);
            this.exclusivePackages.addAll(metaData.exclusivePackages);
        }
    }

    public Set<String> getExclusiveClasses() {
        return this.exclusiveClasses;
    }

    public Set<String> getExclusivePackages() {
        return this.exclusivePackages;
    }

    public void merge(SummaryMetaData original) {
        if (original != null) {
            this.exclusiveClasses.addAll(original.exclusiveClasses);
            this.exclusivePackages.addAll(original.exclusivePackages);
        }
    }

    public boolean isClassExclusive(String className) {
        int idx;
        if (this.exclusiveClasses.contains(className)) {
            return true;
        }
        String tempName = className;
        while (!tempName.isEmpty() && (idx = tempName.lastIndexOf(".")) >= 0) {
            if (!this.exclusivePackages.contains(tempName = tempName.substring(0, idx))) continue;
            return true;
        }
        return false;
    }

    public void setSuperclass(String name, String superclass) {
        this.classInformation.computeIfAbsent(name, n -> new ClassInformation((String)n)).setSuperclass(superclass);
    }

    public String getSuperclass(String name) {
        ClassInformation info = this.classInformation.get(name);
        return info == null ? null : info.getSuperclass();
    }

    public void mergeHierarchyData(ClassSummaries summaries) {
        for (String className : this.classInformation.keySet()) {
            ClassMethodSummaries clazzSummaries = summaries.getOrCreateClassSummaries(className);
            ClassInformation classInfo = this.classInformation.get(className);
            if (classInfo == null) continue;
            if (!clazzSummaries.hasSuperclass()) {
                clazzSummaries.setSuperClass(classInfo.getSuperclass());
            }
            if (classInfo.getIsInterface() == null) continue;
            clazzSummaries.setInterface(classInfo.getIsInterface());
        }
    }

    public ClassInformation getOrCreateClassInfo(String name) {
        return this.classInformation.computeIfAbsent(name, n -> new ClassInformation(name));
    }

    public Collection<? extends String> getClassesWithHierarchyInfo() {
        return this.classInformation.keySet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exclusiveClasses == null ? 0 : this.exclusiveClasses.hashCode());
        result = 31 * result + (this.exclusivePackages == null ? 0 : this.exclusivePackages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SummaryMetaData other = (SummaryMetaData)obj;
        if (this.exclusiveClasses == null ? other.exclusiveClasses != null : !this.exclusiveClasses.equals(other.exclusiveClasses)) {
            return false;
        }
        return !(this.exclusivePackages == null ? other.exclusivePackages != null : !this.exclusivePackages.equals(other.exclusivePackages));
    }

    public static class ClassInformation {
        protected final String className;
        protected String superclass;
        protected Boolean isInterface;

        public ClassInformation(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return this.className;
        }

        public int hashCode() {
            return Objects.hash(this.className, this.isInterface, this.superclass);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassInformation other = (ClassInformation)obj;
            return Objects.equals(this.className, other.className) && Objects.equals(this.isInterface, other.isInterface) && Objects.equals(this.superclass, other.superclass);
        }

        public String getSuperclass() {
            return this.superclass;
        }

        public void setSuperclass(String superclass) {
            this.superclass = superclass;
        }

        public Boolean getIsInterface() {
            return this.isInterface;
        }

        public void setIsInterface(Boolean isInterface) {
            this.isInterface = isInterface;
        }
    }
}

