/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.jimple.infoflow.InfoflowConfiguration;

public class SummaryGeneratorConfiguration
extends InfoflowConfiguration {
    protected boolean loadFullJAR = false;
    protected boolean summarizeFullJAR = false;
    protected String androidPlatformDir = "";
    protected Set<String> excludes = null;
    protected boolean summarizeHashCodeEquals = false;
    protected Map<String, TaintCondition> defaultTaints = new HashMap<String, TaintCondition>();
    protected boolean validateResults = true;
    protected boolean applySummariesOnTheFly = true;
    protected Set<String> additionalSummaryDirectories;
    protected boolean useDefaultSummaries = true;
    protected long classSummaryTimeout = -1L;
    private int repeatCount = 1;

    public SummaryGeneratorConfiguration() {
        this.setEnableExceptionTracking(false);
        this.setStaticFieldTrackingMode(InfoflowConfiguration.StaticFieldTrackingMode.None);
        this.setCodeEliminationMode(InfoflowConfiguration.CodeEliminationMode.PropagateConstants);
        this.setIgnoreFlowsInSystemPackages(false);
        this.setStopAfterFirstFlow(false);
        this.setEnableArraySizeTainting(false);
        this.setExcludeSootLibraryClasses(false);
        this.setWriteOutputFiles(false);
        this.getPathConfiguration().setPathBuildingAlgorithm(InfoflowConfiguration.PathBuildingAlgorithm.None);
        this.getPathConfiguration().setPathReconstructionMode(InfoflowConfiguration.PathReconstructionMode.Fast);
        this.setStandardDefaultTaints();
    }

    public void merge(InfoflowConfiguration config) {
        super.merge(config);
        if (config instanceof SummaryGeneratorConfiguration) {
            SummaryGeneratorConfiguration summaryConfig = (SummaryGeneratorConfiguration)config;
            this.androidPlatformDir = summaryConfig.androidPlatformDir;
            this.loadFullJAR = summaryConfig.loadFullJAR;
            this.summarizeFullJAR = summaryConfig.summarizeFullJAR;
            this.excludes = summaryConfig.excludes == null || summaryConfig.excludes.isEmpty() ? null : new HashSet<String>(summaryConfig.excludes);
            this.summarizeHashCodeEquals = summaryConfig.summarizeHashCodeEquals;
            this.defaultTaints = summaryConfig.defaultTaints == null || summaryConfig.defaultTaints.isEmpty() ? null : new HashMap<String, TaintCondition>(summaryConfig.defaultTaints);
            this.validateResults = summaryConfig.validateResults;
            this.repeatCount = summaryConfig.repeatCount;
            this.applySummariesOnTheFly = summaryConfig.applySummariesOnTheFly;
            this.useDefaultSummaries = summaryConfig.useDefaultSummaries;
            Set<String> otherAdditionalDirs = summaryConfig.additionalSummaryDirectories;
            this.additionalSummaryDirectories = otherAdditionalDirs == null || otherAdditionalDirs.isEmpty() ? null : new HashSet<String>(otherAdditionalDirs);
            this.classSummaryTimeout = summaryConfig.classSummaryTimeout;
        }
    }

    public void setAndroidPlatformDir(String androidPlatformDir) {
        this.androidPlatformDir = androidPlatformDir;
    }

    public String getAndroidPlatformDir() {
        return this.androidPlatformDir;
    }

    public void setLoadFullJAR(boolean loadFullJAR) {
        this.loadFullJAR = loadFullJAR;
    }

    public boolean getLoadFullJAR() {
        return this.loadFullJAR;
    }

    public void setSummarizeFullJAR(boolean summarizeFullJAR) {
        this.summarizeFullJAR = summarizeFullJAR;
    }

    public boolean getSummarizeFullJAR() {
        return this.summarizeFullJAR;
    }

    public void setExcludes(Set<String> excludes) {
        this.excludes = excludes;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public boolean getSummarizeHashCodeEquals() {
        return this.summarizeHashCodeEquals;
    }

    public void setSummarizeHashCodeEquals(boolean summarizeHashCodeEquals) {
        this.summarizeHashCodeEquals = summarizeHashCodeEquals;
    }

    public Map<String, TaintCondition> getDefaultTaints() {
        return this.defaultTaints;
    }

    public void setDefaultTaints(Map<String, TaintCondition> defaultTaints) {
        this.defaultTaints = defaultTaints;
    }

    public void addDefaultTaint(String method, TaintCondition taintCondition) {
        this.defaultTaints.put(method, taintCondition);
    }

    public void setStandardDefaultTaints() {
        this.defaultTaints.put("int hashCode()", TaintCondition.TaintAlways);
        this.defaultTaints.put("boolean equals(java.lang.Object)", TaintCondition.TaintOnImplicit);
        this.defaultTaints.put("int compare(java.lang.Object,java.lang.Object)", TaintCondition.TaintOnImplicit);
        this.defaultTaints.put("int compareTo(java.lang.Object)", TaintCondition.TaintOnImplicit);
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setValidateResults(boolean validateResults) {
        this.validateResults = validateResults;
    }

    public boolean getValidateResults() {
        return this.validateResults;
    }

    public boolean getApplySummariesOnTheFly() {
        return this.applySummariesOnTheFly;
    }

    public void setApplySummariesOnTheFly(boolean applySummariesOnTheFly) {
        this.applySummariesOnTheFly = applySummariesOnTheFly;
    }

    public Set<String> getAdditionalSummaryDirectories() {
        return this.additionalSummaryDirectories;
    }

    public void setUseDefaultSummaries(boolean useDefaultSummaries) {
        this.useDefaultSummaries = useDefaultSummaries;
    }

    public boolean isUseDefaultSummaries() {
        return this.useDefaultSummaries;
    }

    public void addAdditionalSummaryDirectory(String directory) {
        if (this.additionalSummaryDirectories == null) {
            this.additionalSummaryDirectories = new HashSet<String>();
        }
        this.additionalSummaryDirectories.add(directory);
    }

    public long getClassSummaryTimeout() {
        return this.classSummaryTimeout;
    }

    public void setClassSummaryTimeout(long classSummaryTimeout) {
        this.classSummaryTimeout = classSummaryTimeout;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.additionalSummaryDirectories == null ? 0 : this.additionalSummaryDirectories.hashCode());
        result = 31 * result + (this.androidPlatformDir == null ? 0 : this.androidPlatformDir.hashCode());
        result = 31 * result + (this.applySummariesOnTheFly ? 1231 : 1237);
        result = 31 * result + (int)(this.classSummaryTimeout ^ this.classSummaryTimeout >>> 32);
        result = 31 * result + (this.excludes == null ? 0 : this.excludes.hashCode());
        result = 31 * result + (this.loadFullJAR ? 1231 : 1237);
        result = 31 * result + (this.summarizeFullJAR ? 1231 : 1237);
        result = 31 * result + this.repeatCount;
        result = 31 * result + (this.summarizeHashCodeEquals ? 1231 : 1237);
        result = 31 * result + (this.defaultTaints == null ? 0 : this.defaultTaints.hashCode());
        result = 31 * result + (this.useDefaultSummaries ? 1231 : 1237);
        result = 31 * result + (this.validateResults ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SummaryGeneratorConfiguration other = (SummaryGeneratorConfiguration)((Object)obj);
        if (this.additionalSummaryDirectories == null ? other.additionalSummaryDirectories != null : !this.additionalSummaryDirectories.equals(other.additionalSummaryDirectories)) {
            return false;
        }
        if (this.androidPlatformDir == null ? other.androidPlatformDir != null : !this.androidPlatformDir.equals(other.androidPlatformDir)) {
            return false;
        }
        if (this.applySummariesOnTheFly != other.applySummariesOnTheFly) {
            return false;
        }
        if (this.classSummaryTimeout != other.classSummaryTimeout) {
            return false;
        }
        if (this.excludes == null ? other.excludes != null : !this.excludes.equals(other.excludes)) {
            return false;
        }
        if (this.loadFullJAR != other.loadFullJAR) {
            return false;
        }
        if (this.summarizeFullJAR != other.summarizeFullJAR) {
            return false;
        }
        if (this.repeatCount != other.repeatCount) {
            return false;
        }
        if (this.summarizeHashCodeEquals != other.summarizeHashCodeEquals) {
            return false;
        }
        if (this.defaultTaints == null ? other.defaultTaints != null : !this.defaultTaints.equals(other.defaultTaints)) {
            return false;
        }
        if (this.useDefaultSummaries != other.useDefaultSummaries) {
            return false;
        }
        return this.validateResults == other.validateResults;
    }

    public static enum TaintCondition {
        TaintAlways,
        TaintOnImplicit,
        TaintNever;

    }
}

