/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.postProcessor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;

public class SummaryFlowCompactor {
    private static final Logger logger = LoggerFactory.getLogger(SummaryFlowCompactor.class);
    private final MethodSummaries summaries;

    public SummaryFlowCompactor(MethodSummaries summaries) {
        this.summaries = summaries;
    }

    public void compact() {
        this.compactFlowSet();
        this.removeDuplicateFlows();
        this.compactGaps();
    }

    private void compactFlowSet() {
        int flowsRemoved = 0;
        boolean hasChanged = false;
        block0: do {
            hasChanged = false;
            Iterator<MethodFlow> flowIt = this.summaries.iterator();
            while (flowIt.hasNext()) {
                MethodFlow flow = flowIt.next();
                for (MethodFlow flow2 : this.summaries) {
                    if (flow == flow2) continue;
                    boolean removeFlow = false;
                    MethodFlow reverseFlow = flow.reverse();
                    if (reverseFlow.equals(flow2) && flow.isAlias() && flow2.isAlias()) {
                        if (flow.sink().getType() != SourceSinkType.GapBaseObject) {
                            removeFlow = true;
                        }
                    } else if (flow.isCoarserThan(flow2) || flow.isAlias() && flow2.isAlias() && reverseFlow.isCoarserThan(flow2)) {
                        removeFlow = true;
                    }
                    if (!removeFlow) continue;
                    flowIt.remove();
                    ++flowsRemoved;
                    hasChanged = true;
                    break;
                }
                if (!hasChanged) continue;
                continue block0;
            }
        } while (hasChanged);
        logger.info("Removed {} flows in favour of more precise ones", (Object)flowsRemoved);
    }

    public void compactGaps() {
        if (this.summaries == null || !this.summaries.hasGaps()) {
            return;
        }
        for (GapDefinition gd : this.summaries.getAllGaps()) {
            if (!this.summaries.getOutFlowsForGap(gd).isEmpty()) continue;
            this.summaries.removeAll(this.summaries.getInFlowsForGap(gd));
            this.summaries.removeGap(gd);
        }
        HashSet<GapDefinition> gaps = new HashSet<GapDefinition>(this.summaries.getAllGaps());
        for (GapDefinition gd : gaps) {
            boolean gapIsUsed = false;
            for (MethodFlow flow : this.summaries.getAllFlows()) {
                if (flow.source().getGap() != gd && flow.sink().getGap() != gd) continue;
                gapIsUsed = true;
                break;
            }
            if (gapIsUsed) continue;
            this.summaries.removeGap(gd);
        }
    }

    private void removeDuplicateFlows() {
        Iterator<MethodFlow> flowIt = this.summaries.iterator();
        block0: while (flowIt.hasNext()) {
            MethodFlow curFlow = flowIt.next();
            for (MethodFlow compFlow : this.summaries) {
                if (curFlow == compFlow || !compFlow.isAlias() || !curFlow.isAlias() || !curFlow.reverse().equals(compFlow) || curFlow.source().getGap() == null && curFlow.sink().getGap() != null || curFlow.source().getGap() == null && curFlow.sink().getGap() == null && this.compare(curFlow.source().getAccessPath(), compFlow.source().getAccessPath()) > 0) continue;
                flowIt.remove();
                continue block0;
            }
        }
    }

    private int compare(AccessPathFragment accessPath, AccessPathFragment accessPath2) {
        if (accessPath == null && accessPath2 == null) {
            return 0;
        }
        if (accessPath == null) {
            return -1;
        }
        if (accessPath2 == null) {
            return 1;
        }
        return this.compare(accessPath.getFields(), accessPath2.getFields());
    }

    private int compare(String[] accessPath, String[] accessPath2) {
        if (accessPath == accessPath2) {
            return 0;
        }
        if (accessPath == null) {
            return -1;
        }
        if (accessPath2 == null) {
            return 1;
        }
        if (accessPath.length > accessPath2.length) {
            return -1;
        }
        return Arrays.toString(accessPath).compareTo(Arrays.toString(accessPath2));
    }
}

