/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.postProcessor;

import heros.solver.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.PrimType;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFragment;
import soot.jimple.infoflow.data.SourceContextAndPath;
import soot.jimple.infoflow.methodSummary.postProcessor.InvalidPathBuilderStateException;
import soot.jimple.infoflow.methodSummary.postProcessor.SummaryPathBuilderContext;
import soot.jimple.infoflow.methodSummary.util.AliasUtils;
import soot.jimple.infoflow.taintWrappers.IReversibleTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.infoflow.util.extensiblelist.ExtensibleList;

class SummarySourceContextAndPath
extends SourceContextAndPath {
    private static final Logger logger = LoggerFactory.getLogger(SummarySourceContextAndPath.class);
    private final InfoflowManager manager;
    private boolean isAlias;
    private AccessPath curAP;
    private int depth;
    private final List<SootMethod> callees;
    private final SummaryPathBuilderContext context;

    public SummarySourceContextAndPath(InfoflowManager manager, AccessPath value, Stmt stmt, boolean isAlias, AccessPath curAP, List<SootMethod> callees, SummaryPathBuilderContext context) {
        super(manager.getConfig(), null, value, stmt);
        this.manager = manager;
        this.isAlias = isAlias;
        this.curAP = curAP;
        this.callees = callees;
        this.context = context;
    }

    public SummarySourceContextAndPath(InfoflowManager manager, AccessPath value, Stmt stmt, AccessPath curAP, boolean isAlias, int depth, List<SootMethod> callees, Object userData, SummaryPathBuilderContext context) {
        super(manager.getConfig(), null, value, stmt, userData);
        this.manager = manager;
        this.isAlias = isAlias;
        this.curAP = curAP;
        this.callees = new ArrayList<SootMethod>(callees);
        this.depth = depth;
        this.context = context;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SourceContextAndPath extendPath(Abstraction abs, InfoflowConfiguration pathConfig) {
        if (abs == null) {
            return this;
        }
        if (abs.getCurrentStmt() == null && abs.getCorrespondingCallSite() == null) {
            return this;
        }
        if (abs.getSourceContext() != null) {
            return this;
        }
        SummarySourceContextAndPath scap = this.clone();
        if (abs.getCorrespondingCallSite() != null && abs.getCorrespondingCallSite() != abs.getCurrentStmt()) {
            if (scap.callStack == null) {
                scap.callStack = new ExtensibleList();
            } else if (!scap.callStack.isEmpty() && scap.callStack.getFirstSlow() == abs.getCorrespondingCallSite()) {
                return null;
            }
            scap.callStack = scap.callStack.add((Object)abs.getCorrespondingCallSite());
        }
        Stmt stmt = abs.getCurrentStmt();
        Stmt callSite = abs.getCorrespondingCallSite();
        boolean matched = false;
        if (stmt == null && abs.getSourceContext() != null) {
            scap.curAP = abs.getSourceContext().getAccessPath();
            scap.validate();
            return scap;
        }
        if (stmt.containsInvokeExpr()) {
            IReversibleTaintWrapper reversibleWrapper;
            Object previousAbstractions;
            ITaintPropagationWrapper iTaintPropagationWrapper;
            if (abs.getCorrespondingCallSite() != abs.getCurrentStmt()) {
                Stmt topCallStackItem;
                Pair pair = scap.popTopCallStackItem();
                if (pair != null && (topCallStackItem = (Stmt)pair.getO2()) != abs.getCurrentStmt()) {
                    return null;
                }
            } else if (this.context != null && (iTaintPropagationWrapper = this.context.getTaintWrapper()) != null && iTaintPropagationWrapper instanceof IReversibleTaintWrapper && (previousAbstractions = (reversibleWrapper = (IReversibleTaintWrapper)iTaintPropagationWrapper).getInverseTaintsForMethod(stmt, null, abs)) != null && !previousAbstractions.isEmpty()) {
                Iterator iterator = previousAbstractions.iterator();
                while (iterator.hasNext()) {
                    Abstraction prevAbs = (Abstraction)iterator.next();
                    if (prevAbs == abs) continue;
                    scap.curAP = prevAbs.getAccessPath();
                    matched = true;
                }
            }
            if (!matched && callSite == stmt) {
                Local local = abs.getPredecessor() != null ? abs.getPredecessor().getAccessPath().getPlainValue() : abs.getAccessPath().getPlainValue();
                boolean found = false;
                try {
                    for (ValueBox vb : stmt.getUseAndDefBoxes()) {
                        if (vb.getValue() != scap.curAP.getPlainValue()) continue;
                        found = true;
                        break;
                    }
                }
                catch (ConcurrentModificationException ex) {
                    logger.error(String.format("Found a glitch in Soot for statement %s", stmt), (Throwable)ex);
                    throw ex;
                }
                if (found) {
                    AccessPath newAP = null;
                    newAP = local.getType() instanceof PrimType || this.curAP.getBaseType() instanceof PrimType ? this.manager.getAccessPathFactory().createAccessPath((Value)local, true) : this.manager.getAccessPathFactory().copyWithNewValue(scap.curAP, (Value)local);
                    if (newAP != null) {
                        scap.curAP = newAP;
                        --scap.depth;
                        matched = true;
                    }
                }
            }
        }
        if (matched) {
            scap.validate();
            return scap;
        }
        if (stmt.containsInvokeExpr()) {
            void var7_14;
            Set<SootMethod> set;
            Set<SootMethod> set2 = set = scap.callees.isEmpty() ? null : Collections.singleton(scap.callees.remove(0));
            if (set == null) {
                Collection collection = this.manager.getICFG().getCalleesOfCallAt((Object)stmt);
            }
            for (SootMethod callee : var7_14) {
                AccessPath newAP;
                if (!callee.isConcrete() || (newAP = this.mapAccessPathBackIntoCaller(scap.curAP, stmt, callee)) == null) continue;
                scap.curAP = newAP;
                --scap.depth;
                matched = true;
                break;
            }
            if (!matched) {
                return null;
            }
        } else if (callSite != null && callSite.containsInvokeExpr()) {
            SootMethod sootMethod = (SootMethod)this.manager.getICFG().getMethodOf((Object)stmt);
            scap.callees.add(0, sootMethod);
            AccessPath newAP = this.mapAccessPathIntoCallee(scap.curAP, stmt, callSite, sootMethod, !abs.isAbstractionActive());
            if (newAP == null) return null;
            scap.curAP = newAP;
            ++scap.depth;
            matched = true;
        } else if (stmt instanceof AssignStmt) {
            InstanceFieldRef ifref;
            AccessPath matchedAP;
            AccessPath newAP;
            Local base;
            AssignStmt assignStmt = (AssignStmt)stmt;
            Value leftOp = BaseSelector.selectBase((Value)assignStmt.getLeftOp(), (boolean)false);
            Value rightOp = BaseSelector.selectBase((Value)assignStmt.getRightOp(), (boolean)false);
            if (leftOp instanceof Local && leftOp == scap.curAP.getPlainValue() && !assignStmt.containsInvokeExpr()) {
                Value[] rightOps = BaseSelector.selectBaseList((Value)assignStmt.getRightOp(), (boolean)false);
                Value rop = null;
                if (rightOps.length == 1) {
                    rop = rightOps[0];
                } else if (abs.getPredecessor() != null) {
                    base = abs.getPredecessor().getAccessPath().getPlainValue();
                    for (Value rv : rightOps) {
                        if (base != rv) continue;
                        rop = rv;
                        break;
                    }
                }
                newAP = null;
                newAP = assignStmt.getRightOp() instanceof NewArrayExpr ? this.manager.getAccessPathFactory().createAccessPath(rop, false) : this.manager.getAccessPathFactory().copyWithNewValue(scap.curAP, rop, null, false);
                if (newAP != null) {
                    scap.curAP = newAP;
                    matched = true;
                }
            } else if (assignStmt.getLeftOp() instanceof InstanceFieldRef && (matchedAP = this.matchAccessPath(scap.curAP, (ifref = (InstanceFieldRef)assignStmt.getLeftOp()).getBase(), ifref.getField())) != null && (newAP = this.manager.getAccessPathFactory().copyWithNewValue(matchedAP, assignStmt.getRightOp(), matchedAP.getFirstFieldType(), true)) != null) {
                scap.curAP = newAP;
                matched = true;
            }
            if (matched) {
                scap.validate();
                return scap;
            }
            if (abs.isAbstractionActive()) {
                return null;
            }
            if (rightOp instanceof Local && rightOp == scap.curAP.getPlainValue() && !assignStmt.containsInvokeExpr() && !(assignStmt.getRightOp() instanceof LengthExpr)) {
                Value[] leftOps = BaseSelector.selectBaseList((Value)assignStmt.getLeftOp(), (boolean)false);
                Value lop = null;
                if (leftOps.length == 1) {
                    lop = leftOps[0];
                } else if (abs.getPredecessor() != null) {
                    base = abs.getPredecessor().getAccessPath().getPlainValue();
                    for (Value rv : leftOps) {
                        if (base != rv) continue;
                        lop = rv;
                        break;
                    }
                }
                scap.curAP = this.manager.getAccessPathFactory().copyWithNewValue(scap.curAP, lop, null, false);
                matched = true;
            } else if (assignStmt.getRightOp() instanceof InstanceFieldRef && (matchedAP = this.matchAccessPath(scap.curAP, (ifref = (InstanceFieldRef)assignStmt.getRightOp()).getBase(), ifref.getField())) != null) {
                scap.curAP = this.manager.getAccessPathFactory().copyWithNewValue(matchedAP, assignStmt.getLeftOp(), matchedAP.getFirstFieldType(), true);
                matched = true;
            }
        }
        scap.isAlias &= AliasUtils.canAccessPathHaveAliases(scap.curAP);
        if (!matched) return null;
        scap.validate();
        return scap;
    }

    private void validate() {
        if (this.curAP == null) {
            throw new InvalidPathBuilderStateException("No current access path");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessPath matchAccessPath(AccessPath curAP, Value base, SootField field) {
        if (curAP.getPlainValue() != base) {
            return null;
        }
        if (curAP.isLocal() && (curAP.getTaintSubFields() || field == null)) {
            return this.manager.getAccessPathFactory().createAccessPath(base, new SootField[]{field}, true);
        }
        if (curAP.isInstanceFieldRef()) {
            if (curAP.getFirstField() == field) {
                return curAP;
            }
            Collection bases = this.manager.getAccessPathFactory().getBaseForType(base.getType());
            if (bases != null) {
                Collection collection = bases;
                synchronized (collection) {
                    for (AccessPathFragment[] xbase : bases) {
                        if (xbase[0].getField() != field) continue;
                        AccessPathFragment[] cutFragments = new AccessPathFragment[curAP.getFragmentCount() + xbase.length];
                        System.arraycopy(xbase, 0, cutFragments, 0, xbase.length);
                        System.arraycopy(curAP.getFragments(), 0, cutFragments, xbase.length, curAP.getFragmentCount());
                        return this.manager.getAccessPathFactory().createAccessPath((Value)curAP.getPlainValue(), curAP.getBaseType(), cutFragments, curAP.getTaintSubFields(), false, false, curAP.getArrayTaintType());
                    }
                }
            }
        }
        return null;
    }

    private AccessPath mapAccessPathIntoCallee(AccessPath curAP, Stmt stmt, Stmt callSite, SootMethod callee, boolean isBackwards) {
        InstanceInvokeExpr iiExpr;
        InvokeExpr iexpr = callSite.getInvokeExpr();
        SootMethod targetMethod = iexpr.getMethod();
        if (stmt instanceof ReturnStmt) {
            ReturnStmt retStmt = (ReturnStmt)stmt;
            if (callSite instanceof AssignStmt && ((AssignStmt)callSite).getLeftOp() == curAP.getPlainValue()) {
                return this.manager.getAccessPathFactory().copyWithNewValue(curAP, retStmt.getOp());
            }
        }
        if (!callee.isStatic() && iexpr instanceof InstanceInvokeExpr && (iiExpr = (InstanceInvokeExpr)iexpr).getBase() == curAP.getPlainValue()) {
            Local thisLocal = callee.getActiveBody().getThisLocal();
            return this.manager.getAccessPathFactory().copyWithNewValue(curAP, (Value)thisLocal);
        }
        if (!curAP.isLocal() || isBackwards) {
            if (this.isThreadCall(targetMethod, callee) || this.isDoPrivilegedCall(targetMethod, callee)) {
                if (iexpr.getArgCount() == 1 && iexpr.getArg(0) == curAP.getPlainValue()) {
                    Local thisLocal = callee.getActiveBody().getThisLocal();
                    return this.manager.getAccessPathFactory().copyWithNewValue(curAP, (Value)thisLocal);
                }
            } else {
                for (int i = 0; i < iexpr.getArgCount(); ++i) {
                    if (iexpr.getArg(i) != curAP.getPlainValue()) continue;
                    Local paramLocal = callee.getActiveBody().getParameterLocal(i);
                    return this.manager.getAccessPathFactory().copyWithNewValue(curAP, (Value)paramLocal);
                }
            }
        }
        if (!curAP.isLocal() && !isBackwards) {
            SootMethod curMethod = (SootMethod)this.manager.getICFG().getMethodOf((Object)stmt);
            if (this.isThreadCall(targetMethod, callee) || this.isDoPrivilegedCall(targetMethod, callee)) {
                Local thisLocal = curMethod.getActiveBody().getThisLocal();
                if (iexpr.getArgCount() == 1 && thisLocal == curAP.getPlainValue()) {
                    return this.manager.getAccessPathFactory().copyWithNewValue(curAP, iexpr.getArg(0), curMethod.getParameterType(0), false);
                }
            } else {
                for (int i = 0; i < iexpr.getArgCount(); ++i) {
                    Local paramLocal = curMethod.getActiveBody().getParameterLocal(i);
                    if (paramLocal != curAP.getPlainValue()) continue;
                    return this.manager.getAccessPathFactory().copyWithNewValue(curAP, iexpr.getArg(i), curMethod.getParameterType(i), false);
                }
            }
        }
        return null;
    }

    private AccessPath mapAccessPathBackIntoCaller(AccessPath curAP, Stmt stmt, SootMethod callee) {
        AccessPath newAP;
        boolean matched = false;
        if (callee.isStaticInitializer()) {
            return null;
        }
        Local thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
        SootMethod targetMethod = stmt.getInvokeExpr().getMethod();
        if (this.isThreadCall(targetMethod, callee) || this.isDoPrivilegedCall(targetMethod, callee)) {
            if (curAP.getPlainValue() == thisLocal) {
                return this.manager.getAccessPathFactory().copyWithNewValue(curAP, stmt.getInvokeExpr().getArg(0));
            }
            return null;
        }
        if (!callee.getSubSignature().equals(targetMethod.getSubSignature()) && !this.isThreadCall(targetMethod, callee)) {
            logger.warn(String.format("Invalid callee on stack. Caller was %s, callee was %s", stmt.getInvokeExpr().getMethod().getSubSignature(), callee));
            return null;
        }
        for (int i = 0; i < stmt.getInvokeExpr().getArgCount(); ++i) {
            Local paramLocal = callee.getActiveBody().getParameterLocal(i);
            if (paramLocal != curAP.getPlainValue()) continue;
            if (stmt.getInvokeExpr().getArg(i) instanceof Constant) {
                return null;
            }
            AccessPath newAP2 = this.manager.getAccessPathFactory().copyWithNewValue(curAP, stmt.getInvokeExpr().getArg(i));
            if (newAP2 == null) continue;
            curAP = newAP2;
            matched = true;
        }
        if (!callee.isStatic() && stmt.getInvokeExpr() instanceof InstanceInvokeExpr && thisLocal == curAP.getPlainValue() && (newAP = this.manager.getAccessPathFactory().copyWithNewValue(curAP, ((InstanceInvokeExpr)stmt.getInvokeExpr()).getBase())) != null) {
            curAP = newAP;
            matched = true;
        }
        if (matched) {
            return curAP;
        }
        if (stmt instanceof AssignStmt) {
            AssignStmt assign = (AssignStmt)stmt;
            for (Unit u : callee.getActiveBody().getUnits()) {
                AccessPath newAP3;
                ReturnStmt rStmt;
                if (!(u instanceof ReturnStmt) || (rStmt = (ReturnStmt)u).getOp() != curAP.getPlainValue() || (newAP3 = this.manager.getAccessPathFactory().copyWithNewValue(curAP, assign.getLeftOp())) == null) continue;
                curAP = newAP3;
                matched = true;
            }
        }
        return matched ? curAP : null;
    }

    private boolean isDoPrivilegedCall(SootMethod targetMethod, SootMethod callee) {
        return targetMethod.getName().equals("doPrivileged") && !callee.isStatic();
    }

    private boolean isThreadCall(SootMethod callSite, SootMethod callee) {
        if (callee.getName().equals("run") && !callee.isStatic()) {
            String callSiteName = callSite.getName();
            return callSiteName.equals("start") || callSiteName.equals("post");
        }
        return false;
    }

    public synchronized SummarySourceContextAndPath clone() {
        SummarySourceContextAndPath scap = new SummarySourceContextAndPath(this.manager, this.getAccessPath(), this.getStmt(), this.curAP, this.isAlias, this.depth, new ArrayList<SootMethod>(this.callees), this.getUserData(), this.context);
        if (this.callStack != null) {
            scap.callStack = new ExtensibleList(this.callStack);
        }
        if (this.path != null) {
            scap.path = new ExtensibleList(this.path);
        }
        return scap;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.callees == null ? 0 : this.callees.hashCode());
        result = 31 * result + (this.manager == null ? 0 : this.manager.hashCode());
        result = 31 * result + (this.curAP == null ? 0 : this.curAP.hashCode());
        result = 31 * result + (this.isAlias ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SummarySourceContextAndPath other = (SummarySourceContextAndPath)((Object)obj);
        if (this.callees == null ? other.callees != null : !this.callees.equals(other.callees)) {
            return false;
        }
        if (this.manager == null ? other.manager != null : !this.manager.equals(other.manager)) {
            return false;
        }
        if (this.curAP == null ? other.curAP != null : !this.curAP.equals((Object)other.curAP)) {
            return false;
        }
        return this.isAlias == other.isAlias;
    }

    public AccessPath getCurrentAccessPath() {
        return this.curAP;
    }

    public boolean getIsAlias() {
        return this.isAlias;
    }

    public int getDepth() {
        return this.depth;
    }
}

