/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.taintWrappers;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import soot.SootField;
import soot.Type;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.ContainerContext;

public class AccessPathFragment {
    private final String[] fields;
    private final String[] fieldTypes;
    private final ContainerContext[][] contexts;

    public AccessPathFragment(String[] fields, String[] fieldTypes) {
        this(fields, fieldTypes, (ContainerContext[][])new ContainerContext[fields == null ? 0 : fields.length][]);
    }

    public AccessPathFragment(String[] fields, String[] fieldTypes, ContainerContext[][] contexts) {
        this.fields = fields;
        this.fieldTypes = fieldTypes == null ? AccessPathFragment.fieldsToTypes(fields) : fieldTypes;
        this.contexts = contexts;
        if (fields != null && fieldTypes != null && fields.length != fieldTypes.length) {
            throw new RuntimeException("Access path array and type array must be of equal length");
        }
        if (fields != null && fieldTypes != null && fields.length != contexts.length) {
            throw new RuntimeException("Access path array and context array must be of equal length");
        }
    }

    public AccessPathFragment(SootField[] fields, Type[] fieldTypes, ContainerContext[][] contexts) {
        this(AccessPathFragment.fieldArrayToStringArray(fields), AccessPathFragment.typeArrayToStringArray(fieldTypes), contexts);
    }

    public AccessPathFragment(AccessPath accessPath) {
        this(accessPath.getFragmentCount() > 0 ? Arrays.stream(accessPath.getFragments()).map(f -> f.getField().toString()).collect(Collectors.toList()) : null, accessPath.getFragmentCount() > 0 ? Arrays.stream(accessPath.getFragments()).map(f -> f.getFieldType().toString()).collect(Collectors.toList()) : null, accessPath.getFragmentCount() > 0 ? Arrays.stream(accessPath.getFragments()).map(f -> f.getContext()).collect(Collectors.toList()) : null);
    }

    public AccessPathFragment(List<String> fields, List<String> fieldTypes, List<ContainerContext[]> contexts) {
        this.fields = fields == null ? null : fields.toArray(new String[fields.size()]);
        this.fieldTypes = fieldTypes == null ? null : fieldTypes.toArray(new String[fieldTypes.size()]);
        this.contexts = contexts == null ? null : (ContainerContext[][])contexts.toArray((T[])new ContainerContext[0][0]);
    }

    private static String[] fieldArrayToStringArray(SootField[] fields) {
        if (fields == null) {
            return null;
        }
        String[] stringFields = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            stringFields[i] = fields[i].toString();
        }
        return stringFields;
    }

    private static String[] typeArrayToStringArray(Type[] types) {
        if (types == null) {
            return null;
        }
        String[] stringTypes = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            stringTypes[i] = types[i].toString();
        }
        return stringTypes;
    }

    private static String[] fieldsToTypes(String[] fields) {
        if (fields == null) {
            return null;
        }
        String[] types = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String f = fields[i];
            types[i] = f.substring(f.indexOf(":") + 2, f.lastIndexOf(" "));
        }
        return types;
    }

    public int length() {
        return this.fields == null ? 0 : this.fields.length;
    }

    public String[] getFields() {
        return this.fields;
    }

    public String[] getFieldTypes() {
        return this.fieldTypes;
    }

    public ContainerContext[][] getContexts() {
        return this.contexts;
    }

    public ContainerContext[] getContext(int idx) {
        if (this.contexts == null || idx < 0 || idx >= this.contexts.length) {
            return null;
        }
        return this.contexts[idx];
    }

    public String getLastFieldName() {
        if (this.fields == null || this.fields.length == 0) {
            return null;
        }
        return this.fields[this.fields.length - 1];
    }

    public String getFirstFieldName() {
        if (this.fields == null || this.fields.length == 0) {
            return null;
        }
        return this.fields[0];
    }

    public String getLastFieldType() {
        if (this.fieldTypes == null || this.fieldTypes.length == 0) {
            return null;
        }
        return this.fieldTypes[this.fieldTypes.length - 1];
    }

    public String getFirstFieldType() {
        if (this.fieldTypes == null || this.fieldTypes.length == 0) {
            return null;
        }
        return this.fieldTypes[0];
    }

    public ContainerContext[] getFirstFieldContext() {
        if (this.contexts == null || this.contexts.length == 0) {
            return null;
        }
        return this.contexts[0];
    }

    public boolean isEmpty() {
        return this.fields == null || this.fields.length == 0;
    }

    public AccessPathFragment append(AccessPathFragment toAppend) {
        if (toAppend == null || toAppend.isEmpty()) {
            if (this.isEmpty()) {
                return null;
            }
            return this;
        }
        if (this.isEmpty()) {
            return toAppend;
        }
        String[] toAppendFields = toAppend.getFields();
        String[] toAppendFieldTypes = toAppend.getFieldTypes();
        ContainerContext[][] toAppendContexts = toAppend.getContexts();
        String[] appendedFields = new String[this.fields.length + toAppendFields.length];
        System.arraycopy(this.fields, 0, appendedFields, 0, this.fields.length);
        System.arraycopy(toAppendFields, 0, appendedFields, this.fields.length, toAppendFields.length);
        String[] appendedTypes = new String[this.fieldTypes.length + toAppendFieldTypes.length];
        System.arraycopy(this.fieldTypes, 0, appendedTypes, 0, this.fieldTypes.length);
        System.arraycopy(toAppendFieldTypes, 0, appendedTypes, this.fieldTypes.length, toAppendFieldTypes.length);
        ContainerContext[][] appendedContexts = new ContainerContext[this.contexts.length + toAppendContexts.length][];
        System.arraycopy(this.contexts, 0, appendedContexts, 0, this.contexts.length);
        System.arraycopy(toAppendContexts, 0, appendedContexts, this.contexts.length, toAppendContexts.length);
        return new AccessPathFragment(appendedFields, appendedTypes, (ContainerContext[][])appendedContexts);
    }

    public AccessPathFragment updateFieldType(int idx, String fieldType) {
        String[] newFieldTypes = Arrays.copyOf(this.fieldTypes, this.fieldTypes.length);
        newFieldTypes[idx] = fieldType;
        return new AccessPathFragment(this.fields, newFieldTypes, this.contexts);
    }

    public String getField(int idx) {
        if (idx < 0 || idx >= this.fields.length) {
            return null;
        }
        return this.fields[idx];
    }

    public AccessPathFragment prefix(int length) {
        if (length < 0) {
            return this;
        }
        if (this.length() <= length) {
            return this;
        }
        String[] newFields = new String[length];
        String[] newFieldTypes = new String[length];
        ContainerContext[][] newContexts = new ContainerContext[length][];
        System.arraycopy(this.fields, 0, newFields, 0, length);
        System.arraycopy(this.fieldTypes, 0, newFieldTypes, 0, length);
        System.arraycopy(this.fieldTypes, 0, newFieldTypes, 0, length);
        return new AccessPathFragment(newFields, newFieldTypes, (ContainerContext[][])newContexts);
    }

    public String toString() {
        return this.fields == null ? "<null>" : Arrays.toString(this.fields);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fieldTypes);
        result = 31 * result + Arrays.hashCode(this.fields);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPathFragment other = (AccessPathFragment)obj;
        if (!Arrays.equals(this.fieldTypes, other.fieldTypes)) {
            return false;
        }
        return Arrays.equals(this.fields, other.fields);
    }

    public static String toString(AccessPathFragment accessPath) {
        return accessPath.fields == null ? "" : Arrays.toString(accessPath.fields);
    }

    public static AccessPathFragment append(AccessPathFragment accessPath, AccessPathFragment suffix) {
        if (accessPath == null) {
            return suffix;
        }
        if (suffix == null) {
            return accessPath;
        }
        return accessPath.append(suffix);
    }

    public AccessPathFragment addContext(ContainerContext[] ctxt) {
        ContainerContext[][] contexts = new ContainerContext[this.fields.length][];
        System.arraycopy(this.contexts, 1, contexts, 1, this.contexts.length - 1);
        contexts[0] = ctxt;
        return new AccessPathFragment(this.fields, this.fieldTypes, (ContainerContext[][])contexts);
    }
}

