/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.taintWrappers;

import soot.jimple.Stmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.taintWrappers.Taint;

public class AccessPathPropagator {
    private final Taint taint;
    private final GapDefinition gap;
    private final AccessPathPropagator parent;
    private final boolean inversePropagator;
    private final Stmt stmt;
    private final Abstraction d1;
    private final Abstraction d2;

    public AccessPathPropagator(Taint taint) {
        this(taint, null, null);
    }

    public AccessPathPropagator(Taint taint, Stmt stmt) {
        this(taint, null, null, stmt, null, null);
    }

    public AccessPathPropagator(Taint taint, GapDefinition gap, AccessPathPropagator parent) {
        this(taint, gap, parent, null, null, null);
    }

    public AccessPathPropagator(Taint taint, GapDefinition gap, AccessPathPropagator parent, Stmt stmt, Abstraction d1, Abstraction d2) {
        this(taint, gap, parent, stmt, d1, d2, false);
    }

    public AccessPathPropagator(Taint taint, GapDefinition gap, AccessPathPropagator parent, Stmt stmt, Abstraction d1, Abstraction d2, boolean inversePropagator) {
        this.taint = taint;
        this.gap = gap;
        this.parent = parent;
        this.stmt = stmt;
        this.d1 = d1;
        this.d2 = d2;
        this.inversePropagator = inversePropagator;
    }

    public Taint getTaint() {
        return this.taint;
    }

    public GapDefinition getGap() {
        return this.gap;
    }

    public AccessPathPropagator getParent() {
        return this.parent;
    }

    public Stmt getStmt() {
        return this.stmt;
    }

    public Abstraction getD1() {
        return this.d1;
    }

    public Abstraction getD2() {
        return this.d2;
    }

    public AccessPathPropagator copyWithNewTaint(Taint newTaint) {
        return new AccessPathPropagator(newTaint, this.gap, this.parent, this.stmt, this.d1, this.d2, this.inversePropagator);
    }

    public boolean isInversePropagator() {
        return this.inversePropagator;
    }

    public AccessPathPropagator deriveInversePropagator() {
        return new AccessPathPropagator(this.taint, this.gap, this.parent, this.stmt, this.d1, this.d2, !this.inversePropagator);
    }

    public String toString() {
        return (this.inversePropagator ? "_" : "") + this.taint.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.taint == null ? 0 : this.taint.hashCode());
        result = 31 * result + (this.gap == null ? 0 : this.gap.hashCode());
        result = 31 * result + (this.stmt == null ? 0 : this.stmt.hashCode());
        result = 31 * result + (this.d1 == null ? 0 : this.d1.hashCode());
        result = 31 * result + (this.d2 == null ? 0 : this.d2.hashCode());
        result = 31 * result + (this.inversePropagator ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPathPropagator other = (AccessPathPropagator)obj;
        if (this.taint == null ? other.taint != null : !this.taint.equals(other.taint)) {
            return false;
        }
        if (this.gap == null ? other.gap != null : !this.gap.equals(other.gap)) {
            return false;
        }
        if (this.stmt == null ? other.stmt != null : !this.stmt.equals(other.stmt)) {
            return false;
        }
        if (this.d1 == null ? other.d1 != null : !this.d1.equals((Object)other.d1)) {
            return false;
        }
        if (this.d2 == null ? other.d2 != null : !this.d2.equals((Object)other.d2)) {
            return false;
        }
        return this.inversePropagator == other.inversePropagator;
    }
}

