/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.taintWrappers;

import heros.solver.Pair;
import heros.solver.PathEdge;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import soot.ArrayType;
import soot.FastHierarchy;
import soot.Hierarchy;
import soot.Local;
import soot.MethodSubSignature;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.jimple.DefinitionStmt;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.collections.ICollectionsSupport;
import soot.jimple.infoflow.collections.context.UnknownContext;
import soot.jimple.infoflow.collections.strategies.containers.DefaultConfigContainerStrategyFactory;
import soot.jimple.infoflow.collections.strategies.containers.IContainerStrategy;
import soot.jimple.infoflow.collections.strategies.containers.IContainerStrategyFactory;
import soot.jimple.infoflow.collections.util.NonNullHashSet;
import soot.jimple.infoflow.collections.util.Tristate;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.ContainerContext;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.handlers.PreAnalysisHandler;
import soot.jimple.infoflow.methodSummary.data.provider.IMethodSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.sourceSink.AbstractFlowSinkSource;
import soot.jimple.infoflow.methodSummary.data.sourceSink.ConstraintType;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowConstraint;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSink;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSource;
import soot.jimple.infoflow.methodSummary.data.summary.AbstractMethodSummary;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.MethodClear;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.data.summary.SummaryMetaData;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathPropagator;
import soot.jimple.infoflow.methodSummary.taintWrappers.Taint;
import soot.jimple.infoflow.methodSummary.taintWrappers.resolvers.SummaryQuery;
import soot.jimple.infoflow.methodSummary.taintWrappers.resolvers.SummaryResolver;
import soot.jimple.infoflow.methodSummary.taintWrappers.resolvers.SummaryResponse;
import soot.jimple.infoflow.solver.EndSummary;
import soot.jimple.infoflow.solver.IFollowReturnsPastSeedsHandler;
import soot.jimple.infoflow.taintWrappers.IReversibleTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.infoflow.util.ByReferenceBoolean;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.util.ConcurrentHashMultiMap;
import soot.util.MultiMap;

public class SummaryTaintWrapper
implements IReversibleTaintWrapper,
ICollectionsSupport {
    protected InfoflowManager manager;
    private AtomicInteger wrapperHits = new AtomicInteger();
    private AtomicInteger wrapperMisses = new AtomicInteger();
    private boolean reportMissingSummaries = false;
    protected ITaintPropagationWrapper fallbackWrapper = null;
    protected IMethodSummaryProvider flows;
    private Hierarchy hierarchy;
    private FastHierarchy fastHierarchy;
    private SummaryResolver summaryResolver;
    protected MultiMap<Pair<Abstraction, SootMethod>, AccessPathPropagator> userCodeTaints = new ConcurrentHashMultiMap();
    protected IContainerStrategy containerStrategy;
    protected IContainerStrategyFactory containerStrategyFactory;

    public SummaryTaintWrapper(IMethodSummaryProvider flows) {
        this.flows = flows;
        this.setContainerStrategyFactory((IContainerStrategyFactory)new DefaultConfigContainerStrategyFactory());
    }

    public SummaryTaintWrapper setContainerStrategyFactory(IContainerStrategyFactory factory) {
        this.containerStrategyFactory = factory;
        return this;
    }

    public IContainerStrategy getContainerStrategy() {
        return this.containerStrategy;
    }

    public void initialize(InfoflowManager manager) {
        Set<String> loadableClasses;
        this.manager = manager;
        if (this.containerStrategyFactory != null) {
            this.containerStrategy = this.containerStrategyFactory.create(manager);
        }
        if ((loadableClasses = this.flows.getAllClassesWithSummaries()) != null) {
            for (String className : loadableClasses) {
                this.loadClass(className);
            }
        }
        for (String className : this.flows.getSupportedClasses()) {
            this.loadClass(className);
        }
        this.summaryResolver = new SummaryResolver(this.flows);
        Scene scene = Scene.v();
        this.hierarchy = scene.getActiveHierarchy();
        this.fastHierarchy = scene.getOrMakeFastHierarchy();
        manager.getMainSolver().setFollowReturnsPastSeedsHandler((IFollowReturnsPastSeedsHandler)new SummaryFRPSHandler());
        if (this.fallbackWrapper != null) {
            this.fallbackWrapper.initialize(manager);
        }
    }

    public Collection<PreAnalysisHandler> getPreAnalysisHandlers() {
        return Collections.singleton(new HierarchyInjector());
    }

    protected void loadClass(String className) {
        SootClass sc = Scene.v().getSootClassUnsafe(className);
        if (sc == null) {
            sc = Scene.v().makeSootClass(className);
            sc.setPhantomClass();
            Scene.v().addClass(sc);
        } else if (sc.resolvingLevel() < 1) {
            Scene.v().forceResolve(className, 1);
        }
    }

    protected Set<Taint> createTaintFromAccessPathOnCall(AccessPath ap, Stmt stmt, boolean matchReturnedValues, ByReferenceBoolean killIncomingSource) {
        DefinitionStmt defStmt;
        int paramIdx;
        Value base = this.getMethodBase(stmt);
        HashSet<Taint> newTaints = null;
        if ((ap.isLocal() || ap.isInstanceFieldRef()) && base != null && base == ap.getPlainValue()) {
            if (newTaints == null) {
                newTaints = new HashSet<Taint>();
            }
            newTaints.add(new Taint(SourceSinkType.Field, -1, ap.getBaseType().toString(), ap.getBaseContext(), new AccessPathFragment(ap), ap.getTaintSubFields()));
        }
        if ((paramIdx = this.getParameterIndex(stmt, ap)) >= 0) {
            if (newTaints == null) {
                newTaints = new HashSet();
            }
            newTaints.add(new Taint(SourceSinkType.Parameter, paramIdx, ap.getBaseType().toString(), ap.getBaseContext(), new AccessPathFragment(ap), ap.getTaintSubFields()));
        }
        if (matchReturnedValues && stmt instanceof DefinitionStmt && (defStmt = (DefinitionStmt)stmt).getLeftOp() == ap.getPlainValue()) {
            if (killIncomingSource != null) {
                killIncomingSource.value = true;
            }
            if (newTaints == null) {
                newTaints = new HashSet();
            }
            newTaints.add(new Taint(SourceSinkType.Return, -1, ap.getBaseType().toString(), ap.getBaseContext(), new AccessPathFragment(ap), ap.getTaintSubFields()));
        }
        return newTaints;
    }

    protected Set<Taint> createTaintFromAccessPathOnReturn(AccessPath ap, Stmt stmt, GapDefinition gap) {
        ReturnStmt retStmt;
        int paramIdx;
        SootMethod sm = (SootMethod)this.manager.getICFG().getMethodOf((Object)stmt);
        HashSet<Taint> res = null;
        if (!sm.isStatic() && (ap.isLocal() || ap.isInstanceFieldRef()) && ap.getPlainValue() == sm.getActiveBody().getThisLocal()) {
            if (res == null) {
                res = new HashSet();
            }
            res.add(new Taint(SourceSinkType.Field, -1, ap.getBaseType().toString(), ap.getBaseContext(), new AccessPathFragment(ap), ap.getTaintSubFields(), gap));
        }
        if ((paramIdx = this.getParameterIndex(sm, ap)) >= 0) {
            if (res == null) {
                res = new HashSet<Taint>();
            }
            res.add(new Taint(SourceSinkType.Parameter, paramIdx, ap.getBaseType().toString(), ap.getBaseContext(), new AccessPathFragment(ap), ap.getTaintSubFields(), gap));
        }
        if (stmt instanceof ReturnStmt && (retStmt = (ReturnStmt)stmt).getOp() == ap.getPlainValue()) {
            if (res == null) {
                res = new HashSet();
            }
            res.add(new Taint(SourceSinkType.Return, -1, ap.getBaseType().toString(), ap.getBaseContext(), new AccessPathFragment(ap), ap.getTaintSubFields(), gap));
        }
        return res;
    }

    protected AccessPath createAccessPathFromTaint(Taint t, Stmt stmt, boolean reverseFlows) {
        SootField[] fields = this.safeGetFields(t.getAccessPath());
        Type[] types = this.safeGetTypes(t.getAccessPath(), fields);
        ContainerContext[][] contexts = this.safeGetContexts(t.getAccessPath());
        Type baseType = TypeUtils.getTypeFromString((String)t.getBaseType());
        ContainerContext[] baseContext = t.getBaseContext();
        soot.jimple.infoflow.data.AccessPathFragment[] fragments = soot.jimple.infoflow.data.AccessPathFragment.createFragmentArray((SootField[])fields, (Type[])types, (ContainerContext[][])contexts);
        if (t.isReturn()) {
            if (!(stmt instanceof DefinitionStmt)) {
                return null;
            }
            DefinitionStmt defStmt = (DefinitionStmt)stmt;
            return this.manager.getAccessPathFactory().createAccessPath(defStmt.getLeftOp(), baseType, baseContext, fragments, t.taintSubFields(), false, true, AccessPath.ArrayTaintType.ContentsAndLength, false);
        }
        if (t.isParameter() && stmt.containsInvokeExpr()) {
            InvokeExpr iexpr = stmt.getInvokeExpr();
            int paramIndex = t.getParameterIndex();
            if (paramIndex >= iexpr.getArgCount()) {
                return null;
            }
            Value paramVal = iexpr.getArg(paramIndex);
            if (!AccessPath.canContainValue((Value)paramVal)) {
                return null;
            }
            if (this.manager.getTypeUtils().getMorePreciseType(baseType, paramVal.getType()) == null) {
                baseType = null;
            }
            return this.manager.getAccessPathFactory().createAccessPath(paramVal, baseType, fragments, t.taintSubFields(), false, true, AccessPath.ArrayTaintType.ContentsAndLength);
        }
        if (t.isField() && stmt.containsInvokeExpr()) {
            StaticInvokeExpr siexpr;
            InvokeExpr iexpr = stmt.getInvokeExpr();
            if (iexpr instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iiexpr = (InstanceInvokeExpr)iexpr;
                return this.manager.getAccessPathFactory().createAccessPath(iiexpr.getBase(), baseType, baseContext, fragments, t.taintSubFields(), false, true, AccessPath.ArrayTaintType.ContentsAndLength, false);
            }
            if (iexpr instanceof StaticInvokeExpr && !((siexpr = (StaticInvokeExpr)iexpr).getMethodRef().getReturnType() instanceof VoidType)) {
                if (stmt instanceof DefinitionStmt) {
                    DefinitionStmt defStmt = (DefinitionStmt)stmt;
                    return this.manager.getAccessPathFactory().createAccessPath(defStmt.getLeftOp(), baseType, baseContext, fragments, t.taintSubFields(), false, true, AccessPath.ArrayTaintType.ContentsAndLength, false);
                }
                return null;
            }
        }
        throw new RuntimeException("Could not convert taint to access path: " + t + " at " + stmt);
    }

    protected Set<AccessPath> createAccessPathInMethod(Taint t, SootMethod sm) {
        SootField[] fields = this.safeGetFields(t.getAccessPath());
        Type[] types = this.safeGetTypes(t.getAccessPath(), fields);
        Type baseType = TypeUtils.getTypeFromString((String)t.getBaseType());
        ContainerContext[] baseContext = t.getBaseContext();
        ContainerContext[][] contexts = this.safeGetContexts(t.getAccessPath());
        soot.jimple.infoflow.data.AccessPathFragment[] fragments = soot.jimple.infoflow.data.AccessPathFragment.createFragmentArray((SootField[])fields, (Type[])types, (ContainerContext[][])contexts);
        if (t.isReturn()) {
            if (this.manager.getConfig().getDataFlowDirection() == InfoflowConfiguration.DataFlowDirection.Forwards) {
                throw new RuntimeException("Unsupported taint type");
            }
            HashSet<AccessPath> aps = new HashSet<AccessPath>();
            for (Unit unit : sm.getActiveBody().getUnits()) {
                if (!(unit instanceof ReturnStmt)) continue;
                AccessPath ap = this.manager.getAccessPathFactory().createAccessPath(((ReturnStmt)unit).getOp(), baseType, baseContext, fragments, t.taintSubFields(), false, true, AccessPath.ArrayTaintType.ContentsAndLength, false);
                aps.add(ap);
            }
            return aps;
        }
        if (t.isParameter()) {
            Local l = sm.getActiveBody().getParameterLocal(t.getParameterIndex());
            AccessPath ap = this.manager.getAccessPathFactory().createAccessPath((Value)l, baseType, baseContext, fragments, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength, false);
            return ap == null ? Collections.emptySet() : Collections.singleton(ap);
        }
        if (t.isField() || t.isGapBaseObject()) {
            Local l = sm.getActiveBody().getThisLocal();
            AccessPath ap = this.manager.getAccessPathFactory().createAccessPath((Value)l, baseType, baseContext, fragments, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength, false);
            return ap == null ? Collections.emptySet() : Collections.singleton(ap);
        }
        throw new RuntimeException("Failed to convert taint " + t);
    }

    public Set<Abstraction> getTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedAbs) {
        if (!stmt.containsInvokeExpr()) {
            return Collections.singleton(taintedAbs);
        }
        HashSet<Abstraction> resAbs = null;
        ByReferenceBoolean killIncomingTaint = new ByReferenceBoolean(false);
        ByReferenceBoolean classSupported = new ByReferenceBoolean(false);
        InvokeExpr inv = stmt.getInvokeExpr();
        SootMethod callee = inv.getMethod();
        if (inv instanceof DynamicInvokeExpr) {
            DynamicInvokeExpr dyn = (DynamicInvokeExpr)inv;
            SootMethod m = dyn.getBootstrapMethodRef().tryResolve();
            if (m == null) {
                return null;
            }
            callee = m;
        }
        Set<AccessPath> res = this.computeTaintsForMethod(stmt, d1, taintedAbs, callee, killIncomingTaint, classSupported);
        boolean wasEqualToIncoming = false;
        if (res != null && !res.isEmpty()) {
            if (resAbs == null) {
                resAbs = new HashSet<Abstraction>();
            }
            for (AccessPath ap : res) {
                resAbs.add(taintedAbs.deriveNewAbstraction(ap, stmt));
                if (!ap.equals((Object)taintedAbs.getAccessPath())) continue;
                wasEqualToIncoming = true;
            }
        }
        if (!(killIncomingTaint.value || resAbs != null && !resAbs.isEmpty() || this.flows.isMethodExcluded(callee.getDeclaringClass().getName(), callee.getSubSignature()))) {
            if (classSupported.value) {
                return Collections.singleton(taintedAbs);
            }
            this.reportMissingSummary(callee, stmt, taintedAbs);
            return this.fallbackWrapper == null ? null : this.fallbackWrapper.getTaintsForMethod(stmt, d1, taintedAbs);
        }
        if (!killIncomingTaint.value) {
            if (resAbs == null) {
                return Collections.singleton(taintedAbs);
            }
            if (!wasEqualToIncoming) {
                resAbs.add(taintedAbs);
            }
        }
        return resAbs;
    }

    protected void reportMissingSummary(SootMethod method, Stmt stmt, Abstraction incoming) {
        this.reportMissingMethod(method);
    }

    protected void reportMissingMethod(SootMethod method) {
        if (this.reportMissingSummaries && SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass())) {
            System.out.println("Missing summary for class " + method.getDeclaringClass());
        }
    }

    private Set<AccessPath> computeTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedAbs, SootMethod method, ByReferenceBoolean killIncomingTaint, ByReferenceBoolean classSupported) {
        ClassSummaries flowsInCallees = this.getFlowSummariesForMethod(stmt, method, taintedAbs, classSupported);
        if (flowsInCallees == null || flowsInCallees.isEmpty()) {
            return null;
        }
        Set<Taint> taintsFromAP = this.createTaintFromAccessPathOnCall(taintedAbs.getAccessPath(), stmt, false, null);
        if (taintsFromAP == null || taintsFromAP.isEmpty()) {
            return null;
        }
        HashSet<AccessPath> res = null;
        for (String className : flowsInCallees.getClasses()) {
            MethodSummaries flowsInCallee;
            ClassMethodSummaries classFlows = flowsInCallees.getClassSummaries(className);
            if (classFlows == null || classFlows.isEmpty() || (flowsInCallee = classFlows.getMethodSummaries()) == null || flowsInCallee.isEmpty()) continue;
            ArrayList<AccessPathPropagator> workList = new ArrayList<AccessPathPropagator>();
            boolean preventPropagation = false;
            for (Taint taint : taintsFromAP) {
                boolean killTaint = false;
                if (killIncomingTaint != null && flowsInCallee.hasClears()) {
                    for (MethodClear clear : flowsInCallee.getAllClears()) {
                        if (!this.clearMatchesTaint(clear, taint, stmt)) continue;
                        killTaint = true;
                        preventPropagation |= clear.preventPropagation();
                        break;
                    }
                }
                if (killTaint) {
                    killIncomingTaint.value = true;
                }
                if (preventPropagation) continue;
                workList.add(new AccessPathPropagator(taint, null, null, stmt, d1, taintedAbs));
            }
            Set<AccessPath> resCallee = this.applyFlowsIterative(flowsInCallee, workList, false, stmt, taintedAbs, killIncomingTaint.value);
            if (resCallee == null || resCallee.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<AccessPath>();
            }
            res.addAll(resCallee);
        }
        return res;
    }

    private Set<AccessPath> applyFlowsIterative(MethodSummaries flowsInCallee, List<AccessPathPropagator> workList, boolean reverseFlows, Stmt stmt, Abstraction incoming, boolean killIncomingTaint) {
        HashSet<AccessPath> res = null;
        HashSet<AccessPathPropagator> doneSet = new HashSet<AccessPathPropagator>(workList);
        while (!workList.isEmpty()) {
            MethodSummaries flowsInTarget;
            AccessPathPropagator curPropagator = workList.remove(0);
            GapDefinition curGap = curPropagator.getGap();
            if (curGap != null && curPropagator.getParent() == null) {
                throw new RuntimeException("Gap flow without parent detected");
            }
            if (curGap == null) {
                flowsInTarget = flowsInCallee;
            } else {
                SootMethod gapMethod;
                flowsInTarget = this.getFlowSummariesForGap(curGap);
                if ((flowsInTarget == null || flowsInTarget.isEmpty()) && (gapMethod = Scene.v().grabMethod(curGap.getSignature())) != null) {
                    SootMethod sm = (SootMethod)this.manager.getICFG().getMethodOf((Object)stmt);
                    ClassSummaries targetSummaries = flowsInCallee.getInFlowsForGap(curGap).stream().filter(f -> f.sink().isGapBaseObject()).map(f -> f.source().getBaseLocal(stmt)).flatMap(l -> this.rebaseSootMethod(gapMethod, (Local)l, sm)).filter(m -> m != null).map(m -> this.getFlowSummariesForMethod(stmt, (SootMethod)m, null)).collect(ClassSummaries::new, ClassSummaries::merge, ClassSummaries::merge);
                    flowsInTarget = targetSummaries.getAllSummariesForMethod(curGap.getSignature());
                }
            }
            if ((flowsInTarget == null || flowsInTarget.isEmpty()) && curGap != null) {
                SootMethod callee = Scene.v().grabMethod(curGap.getSignature());
                if (callee == null) {
                    SootMethodAndClass smac = SootMethodRepresentationParser.v().parseSootMethodString(curGap.getSignature());
                    SootClass declClass = Scene.v().getSootClassUnsafe(smac.getClassName());
                    if (declClass != null) {
                        SootMethodRef ref = Scene.v().makeMethodRef(declClass, smac.getSubSignature(), false);
                        callee = ref.tryResolve();
                    }
                }
                if (callee != null) {
                    for (SootMethod implementor : this.getImplementors(stmt, callee)) {
                        Set<AccessPathPropagator> implementorPropagators = this.spawnAnalysisIntoClientCode(implementor, curPropagator, stmt, incoming);
                        if (implementorPropagators == null) continue;
                        workList.addAll(implementorPropagators);
                    }
                }
            }
            if (flowsInTarget == null || flowsInTarget.isEmpty()) continue;
            if (reverseFlows) {
                flowsInTarget = flowsInTarget.reverse();
            }
            for (MethodFlow flow : flowsInTarget) {
                AccessPathPropagator backwardsPropagator;
                AccessPathPropagator newPropagator;
                if (flow.isExcludedOnClear() && killIncomingTaint || (newPropagator = this.applyFlow(flow, curPropagator)) == null && ((flow = this.getReverseFlowForAlias(flow, curPropagator.getTaint())) == null || (newPropagator = this.applyFlow(flow, curPropagator)) == null)) continue;
                if (newPropagator.getParent() == null && newPropagator.getTaint().getGap() == null) {
                    AccessPath ap = this.createAccessPathFromTaint(newPropagator.getTaint(), newPropagator.getStmt(), reverseFlows);
                    if (ap == null) continue;
                    if (res == null) {
                        res = new HashSet<AccessPath>();
                    }
                    res.add(ap);
                }
                if (doneSet.add(newPropagator) && !flow.isFinal()) {
                    workList.add(newPropagator);
                }
                if (!newPropagator.getTaint().hasAccessPath() || flow.isFinal() || !doneSet.add(backwardsPropagator = newPropagator.deriveInversePropagator())) continue;
                workList.add(backwardsPropagator);
            }
        }
        return res;
    }

    public Stream<SootMethod> rebaseSootMethod(SootMethod targetMethod, Local baseLocal, SootMethod context) {
        return Scene.v().getPointsToAnalysis().reachingObjects(baseLocal).possibleTypes().stream().filter(t -> t instanceof RefType).map(t -> ((RefType)t).getSootClass()).map(sc -> Scene.v().getOrMakeFastHierarchy().resolveMethod(sc, targetMethod, false));
    }

    protected MethodFlow getReverseFlowForAlias(MethodFlow flow, Taint taint) {
        if (!flow.isAlias(taint)) {
            return null;
        }
        if (!this.canTypeAlias(flow.source().getLastFieldType())) {
            return null;
        }
        if (!this.canTypeAlias(flow.sink().getLastFieldType())) {
            return null;
        }
        if (flow.source().getGap() != null && flow.source().getType() == SourceSinkType.Return) {
            return null;
        }
        if (flow.sink().getGap() != null && flow.sink().getType() == SourceSinkType.Return) {
            return null;
        }
        if (flow.sink().getConstraintType().isAction()) {
            return null;
        }
        return flow.reverse();
    }

    protected boolean canTypeAlias(String type) {
        Type tp = TypeUtils.getTypeFromString((String)type);
        if (tp instanceof PrimType) {
            return false;
        }
        return !(tp instanceof RefType) || !((RefType)tp).getClassName().equals("java.lang.String");
    }

    protected Set<AccessPathPropagator> spawnAnalysisIntoClientCode(SootMethod implementor, AccessPathPropagator propagator, Stmt stmt, Abstraction incoming) {
        Set<AccessPath> aps;
        if (!implementor.hasActiveBody()) {
            implementor.retrieveActiveBody(body -> this.manager.getICFG().notifyNewBody(body));
        }
        if ((aps = this.createAccessPathInMethod(propagator.getTaint(), implementor)).isEmpty()) {
            return null;
        }
        Set absSet = aps.stream().map(ap -> incoming.deriveNewAbstraction(ap, stmt)).filter(Objects::nonNull).collect(Collectors.toSet());
        AccessPathPropagator parent = this.safePopParent(propagator);
        GapDefinition gap = propagator.getParent() == null ? null : propagator.getParent().getGap();
        HashSet<AccessPathPropagator> outgoingTaints = null;
        for (Abstraction abs : absSet) {
            Set endSummary = this.manager.getMainSolver().endSummary(implementor, abs);
            if (endSummary != null && !endSummary.isEmpty()) {
                for (EndSummary pair : endSummary) {
                    Set<Taint> newTaints;
                    if (outgoingTaints == null) {
                        outgoingTaints = new HashSet<AccessPathPropagator>();
                    }
                    if ((newTaints = this.createTaintFromAccessPathOnReturn(((Abstraction)pair.d4).getAccessPath(), (Stmt)pair.eP, propagator.getGap())) == null) continue;
                    for (Taint newTaint : newTaints) {
                        AccessPathPropagator newPropagator = new AccessPathPropagator(newTaint, gap, parent, propagator.getParent() == null ? null : propagator.getParent().getStmt(), propagator.getParent() == null ? null : propagator.getParent().getD1(), propagator.getParent() == null ? null : propagator.getParent().getD2());
                        outgoingTaints.add(newPropagator);
                    }
                }
                continue;
            }
            this.userCodeTaints.put((Object)new Pair((Object)abs, (Object)implementor), (Object)propagator);
            for (Unit sP : this.manager.getICFG().getStartPointsOf((Object)implementor)) {
                PathEdge edge = new PathEdge((Object)abs, (Object)sP, (Object)abs);
                this.manager.getMainSolver().processEdge(edge);
            }
        }
        return outgoingTaints;
    }

    protected AccessPathPropagator safePopParent(AccessPathPropagator curPropagator) {
        if (curPropagator.getParent() == null) {
            return null;
        }
        return curPropagator.getParent().getParent();
    }

    protected MethodSummaries getFlowSummariesForGap(GapDefinition gap) {
        SootMethod gapMethod;
        ClassSummaries flows;
        if (Scene.v().containsMethod(gap.getSignature()) && (flows = this.getFlowSummariesForMethod(null, gapMethod = Scene.v().getMethod(gap.getSignature()), null)) != null && !flows.isEmpty()) {
            MethodSummaries summaries = new MethodSummaries();
            summaries.mergeSummaries(flows.getAllMethodSummaries());
            return summaries;
        }
        SootMethodAndClass smac = SootMethodRepresentationParser.v().parseSootMethodString(gap.getSignature());
        ClassMethodSummaries cms = this.flows.getMethodFlows(smac.getClassName(), smac.getSubSignature());
        return cms == null ? null : cms.getMethodSummaries();
    }

    private ClassSummaries getFlowSummariesForMethod(Stmt stmt, SootMethod method, ByReferenceBoolean classSupported) {
        return this.getFlowSummariesForMethod(stmt, method, null, classSupported);
    }

    protected ClassSummaries getFlowSummariesForMethod(Stmt stmt, SootMethod method, Abstraction taintedAbs, ByReferenceBoolean classSupported) {
        String subsig = method.getSubSignature();
        ClassSummaries classSummaries = null;
        SootClass morePreciseClass = this.getSummaryDeclaringClass(stmt, taintedAbs == null ? null : taintedAbs.getAccessPath());
        SummaryResponse response = this.summaryResolver.resolve(new SummaryQuery(morePreciseClass, method.getDeclaringClass(), subsig));
        if (response != null) {
            if (classSupported != null) {
                classSupported.value = response.isClassSupported();
            }
            classSummaries = new ClassSummaries();
            classSummaries.merge(response.getClassSummaries());
        }
        if (!(classSummaries != null && !classSummaries.isEmpty() || method.isConstructor() || method.isStaticInitializer() || method.isStatic() || stmt == null)) {
            for (SootMethod callee : this.manager.getICFG().getCalleesOfCallAt((Object)stmt)) {
                ClassMethodSummaries flows = this.flows.getMethodFlows(callee.getDeclaringClass(), subsig);
                if (flows == null || flows.isEmpty()) continue;
                if (classSupported != null) {
                    classSupported.value = true;
                }
                if (classSummaries == null) {
                    classSummaries = new ClassSummaries();
                }
                classSummaries.merge("<dummy>", flows.getMethodSummaries());
            }
        }
        return classSummaries;
    }

    protected SootClass getSummaryDeclaringClass(Stmt stmt, AccessPath taintedAP) {
        Type declaredType = null;
        if (stmt != null) {
            if (stmt.getInvokeExpr() instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
                if (taintedAP != null && iinv.getBase() == taintedAP.getPlainValue()) {
                    declaredType = taintedAP.getBaseType();
                }
                Type baseType = iinv.getBase().getType();
                declaredType = this.manager.getTypeUtils().getMorePreciseType(declaredType, baseType);
            } else if (stmt.getInvokeExpr() instanceof DynamicInvokeExpr) {
                return ((DynamicInvokeExpr)stmt.getInvokeExpr()).getBootstrapMethodRef().getDeclaringClass();
            }
        }
        return declaredType instanceof RefType ? ((RefType)declaredType).getSootClass() : null;
    }

    protected Collection<SootMethod> getImplementors(Stmt stmt, SootMethod method) {
        HashSet<SootMethod> implementors = new HashSet<SootMethod>();
        if (stmt != null) {
            for (SootMethod callee : this.manager.getICFG().getCalleesOfCallAt((Object)stmt)) {
                if (!callee.isConcrete()) continue;
                SootClass gapClass = method.getDeclaringClass();
                SootClass implClass = callee.getDeclaringClass();
                if (!this.fastHierarchy.canStoreClass(implClass, gapClass)) continue;
                implementors.add(callee);
            }
        }
        if (!implementors.isEmpty()) {
            return implementors;
        }
        String subSig = method.getSubSignature();
        ArrayList<SootClass> workList = new ArrayList<SootClass>();
        workList.add(method.getDeclaringClass());
        HashSet<SootClass> doneSet = new HashSet<SootClass>();
        while (!workList.isEmpty()) {
            SootMethod ifm;
            SootClass curClass = (SootClass)workList.remove(0);
            if (!doneSet.add(curClass)) continue;
            if (curClass.isInterface()) {
                workList.addAll(this.hierarchy.getImplementersOf(curClass));
                workList.addAll(this.hierarchy.getSubinterfacesOf(curClass));
            } else {
                workList.addAll(this.hierarchy.getSubclassesOf(curClass));
            }
            if ((ifm = curClass.getMethodUnsafe(subSig)) == null || !ifm.isConcrete()) continue;
            implementors.add(ifm);
        }
        return implementors;
    }

    protected AccessPathPropagator applyFlow(MethodFlow flow, AccessPathPropagator propagator) {
        GapDefinition taintGap;
        Abstraction d2;
        Abstraction d1;
        Stmt stmt;
        GapDefinition gap;
        AccessPathPropagator parent;
        boolean typesCompatible;
        FlowSource flowSource = flow.source();
        FlowSink flowSink = flow.sink();
        Taint taint = propagator.getTaint();
        boolean bl = typesCompatible = flowSource.getBaseType() == null || this.isCastCompatible(TypeUtils.getTypeFromString((String)taint.getBaseType()), TypeUtils.getTypeFromString((String)flowSource.getBaseType()));
        if (!typesCompatible) {
            return null;
        }
        if (taint.getGap() != flow.source().getGap()) {
            return null;
        }
        if (flowSink.getGap() != null) {
            parent = propagator;
            gap = flowSink.getGap();
            stmt = null;
            d1 = null;
            d2 = null;
            taintGap = null;
        } else {
            parent = this.safePopParent(propagator);
            gap = propagator.getParent() == null ? null : propagator.getParent().getGap();
            stmt = propagator.getParent() == null ? propagator.getStmt() : propagator.getParent().getStmt();
            d1 = propagator.getParent() == null ? propagator.getD1() : propagator.getParent().getD1();
            d2 = propagator.getParent() == null ? propagator.getD2() : propagator.getParent().getD2();
            taintGap = propagator.getGap();
        }
        boolean addTaint = this.flowMatchesTaint(flow, taint, propagator.getStmt());
        if (!addTaint) {
            return null;
        }
        Taint newTaint = null;
        newTaint = flow.isCustom() ? this.addCustomSinkTaint(flow, taint, taintGap) : this.addSinkTaint(flow, taint, taintGap, stmt, propagator.isInversePropagator());
        if (newTaint == null) {
            return null;
        }
        if (!(d2 == null || d2.isAbstractionActive() || d2.dependsOnCutAP() || !flowSink.isReturn() || newTaint.hasAccessPath() && newTaint.getAccessPathLength() != 0)) {
            return null;
        }
        AccessPathPropagator newPropagator = new AccessPathPropagator(newTaint, gap, parent, stmt, d1, d2, propagator.isInversePropagator());
        return newPropagator;
    }

    protected boolean isCastCompatible(Type baseType, Type checkType) {
        if (baseType == null || checkType == null) {
            return false;
        }
        if (baseType == Scene.v().getObjectType()) {
            return checkType instanceof RefType;
        }
        if (checkType == Scene.v().getObjectType()) {
            return baseType instanceof RefType;
        }
        return baseType == checkType || this.fastHierarchy.canStoreType(baseType, checkType) || this.fastHierarchy.canStoreType(checkType, baseType);
    }

    protected int getParameterIndex(Stmt stmt, AccessPath curAP) {
        if (!stmt.containsInvokeExpr()) {
            return -1;
        }
        if (curAP.isStaticFieldRef()) {
            return -1;
        }
        InvokeExpr iexpr = stmt.getInvokeExpr();
        for (int i = 0; i < iexpr.getArgCount(); ++i) {
            if (iexpr.getArg(i) != curAP.getPlainValue()) continue;
            return i;
        }
        return -1;
    }

    protected int getParameterIndex(SootMethod sm, AccessPath curAP) {
        if (curAP.isStaticFieldRef()) {
            return -1;
        }
        for (int i = 0; i < sm.getParameterCount(); ++i) {
            if (curAP.getPlainValue() != sm.getActiveBody().getParameterLocal(i)) continue;
            return i;
        }
        return -1;
    }

    protected boolean compareFields(Taint taintedPath, AbstractFlowSinkSource flowSource) {
        if (taintedPath.getAccessPathLength() < flowSource.getAccessPathLength() && (!taintedPath.taintSubFields() || flowSource.isMatchStrict())) {
            return false;
        }
        for (int i = 0; i < taintedPath.getAccessPathLength() && i < flowSource.getAccessPathLength(); ++i) {
            SootField sourceSootField;
            SootField taintSootField;
            String taintField = taintedPath.getAccessPath().getField(i);
            String sourceField = flowSource.getAccessPath().getField(i);
            if (sourceField.equals(taintField) || (taintSootField = this.safeGetField(taintField)).equals(sourceSootField = this.safeGetField(sourceField))) continue;
            Scene sc = Scene.v();
            SootClass sourceClass = sc.getSootClassUnsafe(Scene.signatureToClass((String)sourceField));
            SootClass taintClass = sc.getSootClassUnsafe(Scene.signatureToClass((String)taintField));
            if (sourceClass == null || taintClass == null) {
                return false;
            }
            if (sc.getOrMakeFastHierarchy().canStoreClass(taintClass, sourceClass)) {
                if (Scene.signatureToSubsignature((String)sourceField).equals(Scene.signatureToSubsignature((String)taintField))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected SootField safeGetField(String fieldSig) {
        if (fieldSig == null || fieldSig.isEmpty()) {
            return null;
        }
        SootField sf = Scene.v().grabField(fieldSig);
        if (sf != null) {
            return sf;
        }
        int colonIdx = fieldSig.indexOf(":");
        String className = fieldSig.substring(1, colonIdx);
        SootClass sc = Scene.v().getSootClassUnsafe(className, true);
        if (sc.resolvingLevel() < 2 && !sc.isPhantom()) {
            System.err.println("WARNING: Class not loaded: " + sc);
            return null;
        }
        String typeAndName = fieldSig.substring(colonIdx + 2, fieldSig.length() - 1);
        int spaceIdx = typeAndName.indexOf(" ");
        String type = typeAndName.substring(0, spaceIdx);
        String fieldName = typeAndName.substring(spaceIdx + 1);
        SootFieldRef ref = Scene.v().makeFieldRef(sc, fieldName, TypeUtils.getTypeFromString((String)type), false);
        return ref.resolve();
    }

    protected SootField[] safeGetFields(AccessPathFragment accessPath) {
        if (accessPath == null || accessPath.isEmpty()) {
            return null;
        }
        return this.safeGetFields(accessPath.getFields());
    }

    protected SootField[] safeGetFields(String[] fieldSigs) {
        if (fieldSigs == null || fieldSigs.length == 0) {
            return null;
        }
        SootField[] fields = new SootField[fieldSigs.length];
        for (int i = 0; i < fieldSigs.length; ++i) {
            fields[i] = this.safeGetField(fieldSigs[i]);
            if (fields[i] != null) continue;
            return null;
        }
        return fields;
    }

    protected Type[] safeGetTypes(AccessPathFragment accessPath, SootField[] fields) {
        if (accessPath == null || accessPath.isEmpty()) {
            return null;
        }
        return this.safeGetTypes(accessPath.getFieldTypes(), fields);
    }

    protected Type[] safeGetTypes(String[] fieldTypes, SootField[] fields) {
        if (fieldTypes == null || fieldTypes.length == 0) {
            if (fields != null && fields.length > 0) {
                Type[] types = new Type[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    types[i] = fields[i].getType();
                }
                return types;
            }
            return null;
        }
        Type[] types = new Type[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            types[i] = TypeUtils.getTypeFromString((String)fieldTypes[i]);
        }
        return types;
    }

    protected ContainerContext[][] safeGetContexts(AccessPathFragment accessPath) {
        if (accessPath == null || accessPath.isEmpty()) {
            return null;
        }
        return accessPath.getContexts();
    }

    protected Taint addCustomSinkTaint(MethodFlow flow, Taint taint, GapDefinition gap) {
        return null;
    }

    protected Taint addSinkTaint(MethodFlow flow, Taint taint, GapDefinition gap, Stmt stmt, boolean inversePropagator) {
        Object sBaseType;
        FlowSource flowSource = flow.source();
        FlowSink flowSink = flow.sink();
        boolean taintSubFields = flow.sink().taintSubFields();
        Boolean checkTypes = flow.getTypeChecking();
        AccessPathFragment remainingFields = this.cutSubFields(flow, this.getRemainingFields(flowSource, taint));
        AccessPathFragment appendedFields = AccessPathFragment.append(flowSink.getAccessPath(), remainingFields);
        int lastCommonAPIdx = Math.min(flowSource.getAccessPathLength(), taint.getAccessPathLength());
        Type sinkType = TypeUtils.getTypeFromString((String)this.getAssignmentType(flowSink, flow.methodSig()));
        Type taintType = TypeUtils.getTypeFromString((String)this.getAssignmentType(taint, lastCommonAPIdx - 1));
        if (!(checkTypes != null && !checkTypes.booleanValue() || sinkType == null || taintType == null || sinkType instanceof PrimType || this.isCastCompatible(taintType, sinkType) || flowSink.getType() != SourceSinkType.Field)) {
            boolean found = false;
            while (sinkType instanceof ArrayType) {
                if (!this.isCastCompatible(taintType, sinkType = ((ArrayType)sinkType).getElementType())) continue;
                found = true;
                break;
            }
            while (taintType instanceof ArrayType) {
                if (!this.isCastCompatible(taintType = ((ArrayType)taintType).getElementType(), sinkType)) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        }
        SourceSinkType sourceSinkType = flowSink.getType();
        if (flowSink.getType() == SourceSinkType.GapBaseObject && remainingFields != null && !remainingFields.isEmpty()) {
            sourceSinkType = SourceSinkType.Field;
        }
        Object object = sBaseType = sinkType == null ? null : "" + sinkType;
        if (!flow.getIgnoreTypes()) {
            Type newBaseType = this.manager.getTypeUtils().getMorePreciseType(taintType, sinkType);
            if (newBaseType == null) {
                newBaseType = sinkType;
            }
            sBaseType = String.valueOf(newBaseType);
            if (flowSink.hasAccessPath()) {
                if (appendedFields != null) {
                    appendedFields = appendedFields.updateFieldType(flowSink.getAccessPathLength() - 1, (String)sBaseType);
                }
                sBaseType = flowSink.getBaseType();
            }
        }
        ContainerContext[] baseCtxt = null;
        if (this.containerStrategy != null) {
            ContainerContext[] ctxt;
            if (flow.sink().isConstrained()) {
                ContainerContext[] ctxt2 = this.concretizeFlowConstraints(flow.getConstraints(), stmt, taint.hasAccessPath() ? taint.getAccessPath().getFirstFieldContext() : null);
                if (appendedFields != null && ctxt2 != null && !this.containerStrategy.shouldSmash(ctxt2)) {
                    appendedFields = appendedFields.addContext(ctxt2);
                }
            } else if (flow.sink().append() && !this.appendInfiniteAscendingChain(flow, stmt)) {
                ContainerContext[] taintCtxt;
                ContainerContext[] stmtCtxt = this.concretizeFlowConstraints(flow.getConstraints(), stmt, null);
                ContainerContext[] ctxt3 = this.containerStrategy.append(stmtCtxt, taintCtxt = taint.getAccessPath().getFirstFieldContext());
                if (ctxt3 != null && !this.containerStrategy.shouldSmash(ctxt3) && appendedFields != null) {
                    appendedFields = appendedFields.addContext(ctxt3);
                }
            } else if (flow.sink().shiftLeft() && !inversePropagator) {
                ContainerContext newCtxt;
                Tristate lte;
                ContainerContext[] taintCtxt = taint.getAccessPath().getFirstFieldContext();
                if (taintCtxt != null && !(lte = this.flowShiftLeft(flowSource, flow, taint, stmt)).isFalse() && (newCtxt = this.containerStrategy.shift(taintCtxt[0], -1, lte.isTrue())) != null && appendedFields != null) {
                    ContainerContext[] containerContextArray;
                    if (newCtxt.containsInformation()) {
                        ContainerContext[] containerContextArray2 = new ContainerContext[1];
                        containerContextArray = containerContextArray2;
                        containerContextArray2[0] = newCtxt;
                    } else {
                        containerContextArray = null;
                    }
                    appendedFields = appendedFields.addContext(containerContextArray);
                }
            } else if (flow.sink().shiftRight() && !inversePropagator) {
                ContainerContext newCtxt;
                Tristate lte;
                ContainerContext[] taintCtxt = taint.getAccessPath().getFirstFieldContext();
                if (taintCtxt != null && !(lte = this.flowShiftRight(flowSource, flow, taint, stmt)).isFalse() && (newCtxt = this.containerStrategy.shift(taintCtxt[0], 1, lte.isTrue())) != null && appendedFields != null) {
                    ContainerContext[] containerContextArray;
                    if (newCtxt.containsInformation()) {
                        ContainerContext[] containerContextArray3 = new ContainerContext[1];
                        containerContextArray = containerContextArray3;
                        containerContextArray3[0] = newCtxt;
                    } else {
                        containerContextArray = null;
                    }
                    appendedFields = appendedFields.addContext(containerContextArray);
                }
            } else if ((flow.sink().keepConstraint() || flow.sink().keepOnRO() && this.containerStrategy.isReadOnly((Unit)stmt)) && (ctxt = lastCommonAPIdx == 0 ? taint.getBaseContext() : taint.getAccessPath().getContext(lastCommonAPIdx - 1)) != null) {
                ctxt = this.filterContexts(ctxt, flow.getConstraints());
                if (appendedFields == null || appendedFields.isEmpty()) {
                    baseCtxt = ctxt;
                } else {
                    appendedFields = appendedFields.addContext(ctxt);
                }
            }
        }
        return new Taint(sourceSinkType, flowSink.getParameterIndex(), (String)sBaseType, baseCtxt, appendedFields, taintSubFields || taint.taintSubFields(), gap);
    }

    private boolean appendInfiniteAscendingChain(MethodFlow flow, Stmt stmt) {
        PointsToAnalysis pta = Scene.v().getPointsToAnalysis();
        AccessPath sourceAp = this.createAccessPathFromTaint(new Taint(flow.source().getType(), flow.source().getParameterIndex(), flow.source().getBaseType(), true), stmt, false);
        AccessPath sinkAp = this.createAccessPathFromTaint(new Taint(flow.sink().getType(), flow.sink().getParameterIndex(), flow.sink().getBaseType(), true), stmt, false);
        PointsToSet sourcePts = pta.reachingObjects(sourceAp.getPlainValue());
        PointsToSet sinkPts = pta.reachingObjects(sinkAp.getPlainValue());
        return sourcePts.hasNonEmptyIntersection(sinkPts);
    }

    private ContainerContext[] filterContexts(ContainerContext[] ctxt, FlowConstraint[] constraints) {
        if (constraints.length == 0) {
            return ctxt;
        }
        ContainerContext[] newCtxt = new ContainerContext[ctxt.length];
        int i = 0;
        for (int k = 0; k < constraints.length; ++k) {
            FlowConstraint constraint = constraints[k];
            if (constraint.getType() != SourceSinkType.Any) continue;
            newCtxt[i++] = ctxt[k];
        }
        if (i == 0) {
            return null;
        }
        if (i == ctxt.length) {
            return newCtxt;
        }
        return Arrays.copyOf(newCtxt, i);
    }

    protected AccessPathFragment cutSubFields(MethodFlow flow, AccessPathFragment accessPath) {
        if (this.isCutSubFields(flow)) {
            return null;
        }
        return accessPath;
    }

    protected boolean isCutSubFields(MethodFlow flow) {
        Boolean cut = flow.getCutSubFields();
        return cut != null && cut != false;
    }

    protected String getAssignmentType(Taint taint, int idx) {
        if (idx < 0) {
            return taint.getBaseType();
        }
        AccessPathFragment accessPath = taint.getAccessPath();
        if (accessPath == null) {
            return null;
        }
        String[] fieldTypes = accessPath.getFieldTypes();
        return fieldTypes == null ? null : fieldTypes[idx];
    }

    protected String getAssignmentType(AbstractFlowSinkSource srcSink, String methodSig) {
        if (!srcSink.hasAccessPath()) {
            String baseType = srcSink.getBaseType();
            if (baseType != null) {
                return baseType;
            }
            if (srcSink.hasGap()) {
                String gapSig = srcSink.getGap().getSignature();
                SootMethodAndClass smac = SootMethodRepresentationParser.v().parseSootMethodString(gapSig);
                if (srcSink.isReturn()) {
                    return smac.getReturnType();
                }
                if (srcSink.isParameter()) {
                    return (String)smac.getParameters().get(srcSink.getParameterIndex());
                }
                if (srcSink.isGapBaseObject()) {
                    return smac.getClassName();
                }
            } else {
                MethodSubSignature subsig = new MethodSubSignature(Scene.v().getSubSigNumberer().findOrAdd(methodSig));
                if (srcSink.isReturn()) {
                    return subsig.returnType.toString();
                }
                if (srcSink.isParameter()) {
                    return ((Type)subsig.parameterTypes.get(srcSink.getParameterIndex())).toString();
                }
            }
            return null;
        }
        AccessPathFragment accessPath = srcSink.getAccessPath();
        if (accessPath.getFieldTypes() == null && accessPath.getFields() != null) {
            String[] ap = accessPath.getFields();
            String apElement = ap[srcSink.getAccessPathLength() - 1];
            Pattern pattern = Pattern.compile("^\\s*<(.*?):\\s*(.*?)>\\s*$");
            Matcher matcher = pattern.matcher(apElement);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        return accessPath.getFieldTypes() == null ? null : accessPath.getFieldTypes()[srcSink.getAccessPathLength() - 1];
    }

    protected AccessPathFragment getRemainingFields(AbstractFlowSinkSource flowSource, Taint taintedPath) {
        if (!flowSource.hasAccessPath()) {
            return taintedPath.getAccessPath();
        }
        int fieldCnt = taintedPath.getAccessPathLength() - flowSource.getAccessPathLength();
        if (fieldCnt <= 0) {
            return null;
        }
        AccessPathFragment taintedAP = taintedPath.getAccessPath();
        String[] oldFields = taintedAP.getFields();
        String[] oldFieldTypes = taintedAP.getFieldTypes();
        String[] fields = new String[fieldCnt];
        String[] fieldTypes = new String[fieldCnt];
        System.arraycopy(oldFields, flowSource.getAccessPathLength(), fields, 0, fieldCnt);
        System.arraycopy(oldFieldTypes, flowSource.getAccessPathLength(), fieldTypes, 0, fieldCnt);
        ContainerContext[][] contexts = new ContainerContext[fieldCnt][];
        System.arraycopy(taintedAP.getContexts(), flowSource.getAccessPathLength(), contexts, 0, fieldCnt);
        return new AccessPathFragment(fields, fieldTypes, (ContainerContext[][])contexts);
    }

    private Value getMethodBase(Stmt stmt) {
        if (!stmt.containsInvokeExpr()) {
            throw new RuntimeException("Statement is not a method call: " + stmt);
        }
        InvokeExpr invExpr = stmt.getInvokeExpr();
        if (invExpr instanceof InstanceInvokeExpr) {
            return ((InstanceInvokeExpr)invExpr).getBase();
        }
        return null;
    }

    public boolean isExclusive(Stmt stmt, Abstraction taintedPath) {
        InvokeExpr invExpr;
        SootClass targetClass;
        if (this.supportsCallee(stmt)) {
            this.wrapperHits.getAndIncrement();
            return true;
        }
        if (this.fallbackWrapper != null && this.fallbackWrapper.isExclusive(stmt, taintedPath)) {
            this.wrapperHits.getAndIncrement();
            return true;
        }
        if (stmt.containsInvokeExpr() && (targetClass = (invExpr = stmt.getInvokeExpr()).getMethod().getDeclaringClass()) != null) {
            String targetClassName = targetClass.getName();
            ClassMethodSummaries cms = this.flows.getClassFlows(targetClassName);
            if (cms != null && cms.isExclusiveForClass()) {
                this.wrapperHits.getAndIncrement();
                return true;
            }
            ClassSummaries summaries = this.flows.getSummaries();
            SummaryMetaData metaData = summaries.getMetaData();
            if (metaData != null && metaData.isClassExclusive(targetClassName)) {
                this.wrapperHits.getAndIncrement();
                return true;
            }
            SummaryResponse resp = this.summaryResolver.resolve(SummaryQuery.fromStmt(stmt));
            if (resp.isClassSupported()) {
                return true;
            }
        }
        this.wrapperMisses.getAndIncrement();
        return false;
    }

    public boolean supportsCallee(SootMethod method) {
        SootClass declClass = method.getDeclaringClass();
        if (declClass == null) {
            return false;
        }
        ClassMethodSummaries cms = this.flows.getClassFlows(declClass.getName());
        if (cms == null) {
            return false;
        }
        if (cms.isExclusiveForClass()) {
            return true;
        }
        MethodSummaries summaries = cms.getMethodSummaries().filterForMethod(method.getSubSignature());
        return summaries != null && !summaries.isEmpty();
    }

    public boolean supportsCallee(Stmt callSite) {
        if (!callSite.containsInvokeExpr()) {
            return false;
        }
        if (this.manager == null) {
            SootMethod method = callSite.getInvokeExpr().getMethod();
            if (this.supportsCallee(method)) {
                return true;
            }
        } else {
            for (SootMethod callee : this.manager.getICFG().getCalleesOfCallAt((Object)callSite)) {
                if (callee.isStaticInitializer() || !this.supportsCallee(callee)) continue;
                return true;
            }
        }
        return false;
    }

    Set<AccessPathPropagator> getUserCodeTaints(Abstraction abs, SootMethod callee) {
        return this.userCodeTaints.get((Object)new Pair((Object)abs, (Object)callee));
    }

    public int getWrapperHits() {
        return this.wrapperHits.get();
    }

    public int getWrapperMisses() {
        return this.wrapperMisses.get();
    }

    public Set<Abstraction> getAliasesForMethod(Stmt stmt, Abstraction d1, Abstraction taintedAbs) {
        if (!stmt.containsInvokeExpr()) {
            return Collections.singleton(taintedAbs);
        }
        SootMethod method = stmt.getInvokeExpr().getMethod();
        ClassSummaries flowsInCallees = this.getFlowSummariesForMethod(stmt, method, taintedAbs, null);
        if (flowsInCallees == null || flowsInCallees.isEmpty()) {
            if (this.fallbackWrapper == null) {
                return null;
            }
            return this.fallbackWrapper.getAliasesForMethod(stmt, d1, taintedAbs);
        }
        Set<Taint> taintsFromAP = this.createTaintFromAccessPathOnCall(taintedAbs.getAccessPath(), stmt, true, null);
        if (taintsFromAP == null || taintsFromAP.isEmpty()) {
            return Collections.emptySet();
        }
        ByReferenceBoolean killIncomingTaint = new ByReferenceBoolean();
        HashSet<AccessPath> res = null;
        for (String className : flowsInCallees.getClasses()) {
            MethodSummaries flowsInCallee;
            boolean reverseFlows;
            boolean bl = reverseFlows = this.manager.getConfig().getDataFlowDirection() == InfoflowConfiguration.DataFlowDirection.Backwards;
            ClassMethodSummaries classFlows = flowsInCallees.getClassSummaries(className);
            if (classFlows == null || (flowsInCallee = classFlows.getMethodSummaries()) == null || flowsInCallee.isEmpty() || (flowsInCallee = flowsInCallee.filterForAliases()) == null || flowsInCallee.isEmpty()) continue;
            boolean killTaint = false;
            ArrayList<AccessPathPropagator> workList = new ArrayList<AccessPathPropagator>();
            for (Taint taint : taintsFromAP) {
                boolean preventPropagation = false;
                if (flowsInCallee.hasClears()) {
                    for (MethodClear clear : flowsInCallee.getAllClears()) {
                        if (!clear.isAlias(taint) || !this.clearMatchesTaint(clear, taint, stmt)) continue;
                        killTaint = true;
                        preventPropagation = clear.preventPropagation();
                        break;
                    }
                }
                if (killTaint) {
                    killIncomingTaint.value = true;
                }
                if (preventPropagation) continue;
                workList.add(new AccessPathPropagator(taint, null, null, stmt, d1, taintedAbs, !reverseFlows));
            }
            Set<AccessPath> resCallee = this.applyFlowsIterative(flowsInCallee, workList, false, stmt, taintedAbs, false);
            if (resCallee == null || resCallee.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<AccessPath>();
            }
            res.addAll(resCallee);
        }
        if (res == null || res.isEmpty()) {
            return killIncomingTaint.value ? null : Collections.singleton(taintedAbs);
        }
        HashSet<Abstraction> resAbs = new HashSet<Abstraction>(res.size() + 1);
        if (!killIncomingTaint.value) {
            resAbs.add(taintedAbs);
        }
        for (AccessPath ap : res) {
            Abstraction newAbs = taintedAbs.deriveNewAbstraction(ap, stmt);
            newAbs.setCorrespondingCallSite(stmt);
            resAbs.add(newAbs);
        }
        return resAbs;
    }

    public void setReportMissingDummaries(boolean report) {
        this.reportMissingSummaries = report;
    }

    public void setFallbackTaintWrapper(ITaintPropagationWrapper fallbackWrapper) {
        this.fallbackWrapper = fallbackWrapper;
    }

    public IMethodSummaryProvider getProvider() {
        return this.flows;
    }

    public Set<Abstraction> getInverseTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedAbs) {
        if (!stmt.containsInvokeExpr()) {
            return Collections.singleton(taintedAbs);
        }
        ByReferenceBoolean classSupported = new ByReferenceBoolean(false);
        SootMethod method = stmt.getInvokeExpr().getMethod();
        ClassSummaries flowsInCallees = this.getFlowSummariesForMethod(stmt, method, taintedAbs, classSupported);
        if (flowsInCallees.isEmpty()) {
            if (classSupported.value) {
                return Collections.singleton(taintedAbs);
            }
            if (this.fallbackWrapper != null && this.fallbackWrapper instanceof IReversibleTaintWrapper) {
                return ((IReversibleTaintWrapper)this.fallbackWrapper).getInverseTaintsForMethod(stmt, d1, taintedAbs);
            }
            return null;
        }
        ByReferenceBoolean killIncomingTaint = new ByReferenceBoolean();
        Set<Taint> taintsFromAP = this.createTaintFromAccessPathOnCall(taintedAbs.getAccessPath(), stmt, true, killIncomingTaint);
        if (taintsFromAP == null || taintsFromAP.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AccessPath> res = null;
        for (String className : flowsInCallees.getClasses()) {
            MethodSummaries flowsInCallee;
            ClassMethodSummaries classFlows = flowsInCallees.getClassSummaries(className);
            if (classFlows == null || (flowsInCallee = classFlows.getMethodSummaries()) == null || flowsInCallee.isEmpty()) continue;
            ArrayList<AccessPathPropagator> workList = new ArrayList<AccessPathPropagator>();
            for (Taint taint : taintsFromAP) {
                if (!killIncomingTaint.value && flowsInCallee.hasClears()) {
                    for (MethodClear clear : flowsInCallee.getAllClears()) {
                        if (!this.clearMatchesTaint(clear, taint, stmt)) continue;
                        killIncomingTaint.value = true;
                        break;
                    }
                }
                workList.add(new AccessPathPropagator(taint, null, null, stmt, d1, taintedAbs, true));
            }
            Set<AccessPath> resCallee = this.applyFlowsIterative(flowsInCallee, workList, true, stmt, taintedAbs, false);
            if (resCallee == null || resCallee.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<AccessPath>();
            }
            res.addAll(resCallee);
        }
        if (res == null || res.isEmpty()) {
            if (killIncomingTaint.value) {
                return null;
            }
            return Collections.singleton(taintedAbs);
        }
        HashSet<Abstraction> resAbs = new HashSet<Abstraction>(res.size() + 1);
        if (!killIncomingTaint.value) {
            resAbs.add(taintedAbs);
        }
        for (AccessPath ap : res) {
            Abstraction newAbs = taintedAbs.deriveNewAbstraction(ap, stmt);
            newAbs.setCorrespondingCallSite(stmt);
            resAbs.add(newAbs);
        }
        return resAbs;
    }

    public Set<Abstraction> getTaintsForMethodApprox(Stmt stmt, Abstraction d1, Abstraction source) {
        ByReferenceBoolean classSupported;
        boolean mustAlias;
        if (this.containerStrategy == null) {
            return null;
        }
        if (source.getAccessPath().getFragmentCount() == 0 || Arrays.stream(source.getAccessPath().getFragments()).noneMatch(f -> f.hasContext())) {
            return null;
        }
        if (!(stmt.getInvokeExpr() instanceof InstanceInvokeExpr)) {
            return null;
        }
        InstanceInvokeExpr iiExpr = (InstanceInvokeExpr)stmt.getInvokeExpr();
        Local base = (Local)iiExpr.getBase();
        Tristate found = Tristate.FALSE();
        boolean bl = mustAlias = !source.getAccessPath().isStaticFieldRef() && this.manager.getAliasing().mustAlias(source.getAccessPath().getPlainValue(), base, stmt);
        if (mustAlias) {
            found = Tristate.TRUE();
        } else {
            PointsToSet incomingPts;
            PointsToSet basePts = Scene.v().getPointsToAnalysis().reachingObjects(base);
            if (basePts.hasNonEmptyIntersection(incomingPts = Scene.v().getPointsToAnalysis().reachingObjects(source.getAccessPath().getPlainValue()))) {
                found = Tristate.MAYBE();
            } else if (source.getAccessPath().getFragmentCount() > 0) {
                for (soot.jimple.infoflow.data.AccessPathFragment f2 : source.getAccessPath().getFragments()) {
                    incomingPts = Scene.v().getPointsToAnalysis().reachingObjects(incomingPts, f2.getField());
                    if (!basePts.hasNonEmptyIntersection(incomingPts)) continue;
                    found = Tristate.MAYBE();
                    break;
                }
            }
        }
        if (found.isFalse()) {
            return null;
        }
        SootMethod method = stmt.getInvokeExpr().getMethod();
        ClassSummaries flowsInCallees = this.getFlowSummariesForMethod(stmt, method, source, classSupported = new ByReferenceBoolean());
        if (flowsInCallees == null || flowsInCallees.isEmpty()) {
            return null;
        }
        NonNullHashSet res = new NonNullHashSet();
        for (String className : flowsInCallees.getClasses()) {
            AccessPath ap;
            ContainerContext c;
            int i;
            ContainerContext[] ctxt;
            soot.jimple.infoflow.data.AccessPathFragment f3;
            soot.jimple.infoflow.data.AccessPathFragment[] fragments;
            MethodSummaries flowsInCallee;
            ClassMethodSummaries classFlows = flowsInCallees.getClassSummaries(className);
            if (classFlows == null || classFlows.isEmpty() || (flowsInCallee = classFlows.getMethodSummaries().getApproximateFlows()) == null || !flowsInCallee.hasFlows()) continue;
            boolean shiftR = false;
            boolean shiftL = false;
            for (MethodFlow flow : flowsInCallee.getAllFlows()) {
                if (flow.sink().getConstraintType() == ConstraintType.SHIFT_RIGHT) {
                    shiftR = true;
                    break;
                }
                if (flow.sink().getConstraintType() != ConstraintType.SHIFT_LEFT) continue;
                shiftL = true;
                break;
            }
            if (!shiftL && !shiftR) {
                res.add(source);
                continue;
            }
            if (shiftR) {
                fragments = new soot.jimple.infoflow.data.AccessPathFragment[source.getAccessPath().getFragmentCount()];
                for (int k = 0; k < fragments.length; ++k) {
                    f3 = source.getAccessPath().getFragments()[k];
                    if (f3.getContext() == null) {
                        fragments[k] = f3;
                        continue;
                    }
                    ctxt = new ContainerContext[f3.getContext().length];
                    for (i = 0; i < ctxt.length; ++i) {
                        c = f3.getContext()[i];
                        if (c == null || !c.containsInformation()) continue;
                        ctxt[i] = this.containerStrategy.shift(c, 1, found.isTrue());
                        fragments[k] = f3.copyWithNewContext(this.containerStrategy.shouldSmash(ctxt) ? null : ctxt);
                    }
                }
                ap = this.manager.getAccessPathFactory().createAccessPath((Value)source.getAccessPath().getPlainValue(), source.getAccessPath().getBaseType(), fragments, source.getAccessPath().getTaintSubFields(), false, true, source.getAccessPath().getArrayTaintType());
                res.add(source.deriveNewAbstraction(ap, stmt));
                continue;
            }
            if (!shiftL) continue;
            fragments = new soot.jimple.infoflow.data.AccessPathFragment[source.getAccessPath().getFragmentCount()];
            for (int k = 0; k < fragments.length; ++k) {
                f3 = source.getAccessPath().getFragments()[k];
                if (f3.getContext() == null) {
                    fragments[k] = f3;
                    continue;
                }
                ctxt = new ContainerContext[f3.getContext().length];
                for (i = 0; i < ctxt.length; ++i) {
                    c = f3.getContext()[i];
                    if (c == null || !c.containsInformation()) continue;
                    ctxt[i] = this.containerStrategy.shift(c, -1, found.isTrue());
                }
                fragments[k] = f3.copyWithNewContext(this.containerStrategy.shouldSmash(ctxt) ? null : ctxt);
            }
            ap = this.manager.getAccessPathFactory().createAccessPath((Value)source.getAccessPath().getPlainValue(), source.getAccessPath().getBaseType(), fragments, source.getAccessPath().getTaintSubFields(), false, true, source.getAccessPath().getArrayTaintType());
            res.add(source.deriveNewAbstraction(ap, stmt));
        }
        return res.isEmpty() ? Collections.singleton(source) : res;
    }

    protected ContainerContext[] concretizeFlowConstraints(FlowConstraint[] constraints, Stmt stmt, ContainerContext[] taintCtxt) {
        if (this.containerStrategy == null) {
            return taintCtxt;
        }
        if (stmt == null) {
            System.out.println("x");
        }
        assert (stmt.containsInvokeExpr());
        InvokeExpr ie = stmt.getInvokeExpr();
        ContainerContext[] ctxt = new ContainerContext[constraints.length];
        if (constraints.length == 0) {
            return taintCtxt;
        }
        block10: for (int i = 0; i < constraints.length; ++i) {
            FlowConstraint c = constraints[i];
            switch (c.getType()) {
                case Parameter: {
                    if (c.isIndexBased()) {
                        ctxt[i] = this.containerStrategy.getIndexContext(ie.getArg(c.getParamIdx()), stmt);
                        continue block10;
                    }
                    ctxt[i] = this.containerStrategy.getKeyContext(ie.getArg(c.getParamIdx()), stmt);
                    continue block10;
                }
                case Implicit: {
                    assert (c.isIndexBased());
                    assert (ie instanceof InstanceInvokeExpr);
                    switch (c.getImplicitLocation()) {
                        case First: {
                            ctxt[i] = this.containerStrategy.getFirstPosition(((InstanceInvokeExpr)ie).getBase(), stmt);
                            continue block10;
                        }
                        case Last: {
                            ctxt[i] = this.containerStrategy.getLastPosition(((InstanceInvokeExpr)ie).getBase(), stmt);
                            continue block10;
                        }
                        case Next: {
                            ctxt[i] = this.containerStrategy.getNextPosition(((InstanceInvokeExpr)ie).getBase(), stmt);
                            continue block10;
                        }
                    }
                    throw new RuntimeException("Missing case!");
                }
                case Any: {
                    ctxt[i] = UnknownContext.v();
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Unknown context!");
                }
            }
        }
        return ctxt;
    }

    protected Tristate matchesConstraints(AbstractFlowSinkSource flowSource, AbstractMethodSummary flow, Taint taint, Stmt stmt) {
        if (!flowSource.isConstrained()) {
            return Tristate.TRUE();
        }
        ContainerContext[] taintContext = taint.getAccessPath().getFirstFieldContext();
        if (taintContext == null) {
            return Tristate.TRUE();
        }
        ContainerContext[] stmtCtxt = this.concretizeFlowConstraints(flow.getConstraints(), stmt, taintContext);
        assert (stmtCtxt.length == taintContext.length);
        Tristate state = Tristate.TRUE();
        for (int i = 0; i < stmtCtxt.length; ++i) {
            state = state.and(this.containerStrategy.intersect(taintContext[i], stmtCtxt[i]));
        }
        return flowSource.getConstraintType() == ConstraintType.NO_MATCH ? Tristate.fromBoolean((boolean)state.isFalse()) : state;
    }

    protected Tristate matchesConstraintsOnClear(AbstractFlowSinkSource flowSource, AbstractMethodSummary flow, Taint taint, Stmt stmt) {
        if (flowSource.isConstrained() && this.containerStrategy == null) {
            return Tristate.FALSE();
        }
        return this.matchesConstraints(flowSource, flow, taint, stmt);
    }

    protected Tristate matchShiftLeft(AbstractFlowSinkSource flowSource, AbstractMethodSummary flow, Taint taint, Stmt stmt) {
        ContainerContext[] taintContext = taint.getAccessPath().getFirstFieldContext();
        if (taintContext == null) {
            return Tristate.FALSE();
        }
        ContainerContext[] stmtCtxt = this.concretizeFlowConstraints(flow.getConstraints(), stmt, taintContext);
        assert (stmtCtxt.length == taintContext.length);
        Tristate state = Tristate.TRUE();
        for (int i = 0; i < stmtCtxt.length; ++i) {
            state = state.and(this.containerStrategy.lessThanEqual(taintContext[i], stmtCtxt[i]).negate());
        }
        return state;
    }

    protected Tristate matchShiftRight(AbstractFlowSinkSource flowSource, AbstractMethodSummary flow, Taint taint, Stmt stmt) {
        ContainerContext[] taintContext = taint.getAccessPath().getFirstFieldContext();
        if (taintContext == null) {
            return Tristate.FALSE();
        }
        ContainerContext[] stmtCtxt = this.concretizeFlowConstraints(flow.getConstraints(), stmt, taintContext);
        assert (stmtCtxt.length == taintContext.length);
        Tristate state = Tristate.TRUE();
        for (int i = 0; i < stmtCtxt.length; ++i) {
            state = state.and(this.containerStrategy.lessThanEqual(stmtCtxt[i], taintContext[i]));
        }
        return state;
    }

    protected boolean flowMatchesTaint(MethodFlow flow, Taint taint, Stmt stmt) {
        return !this.flowMatchesTaintInternal(flow.source(), flow, taint, stmt, this::matchesConstraints).isFalse();
    }

    protected boolean clearMatchesTaint(MethodClear clear, Taint taint, Stmt stmt) {
        return this.flowMatchesTaintInternal(clear.getClearDefinition(), clear, taint, stmt, this::matchesConstraintsOnClear).isTrue();
    }

    protected Tristate flowShiftLeft(AbstractFlowSinkSource flowSource, AbstractMethodSummary flow, Taint taint, Stmt stmt) {
        return this.flowMatchesTaintInternal(flowSource, flow, taint, stmt, this::matchShiftLeft);
    }

    protected Tristate flowShiftRight(AbstractFlowSinkSource flowSource, AbstractMethodSummary flow, Taint taint, Stmt stmt) {
        return this.flowMatchesTaintInternal(flowSource, flow, taint, stmt, this::matchShiftRight);
    }

    protected Tristate flowMatchesTaintInternal(AbstractFlowSinkSource flowSource, AbstractMethodSummary flow, Taint taint, Stmt stmt, MatchFunction f) {
        boolean match = flowSource.isParameter() && taint.isParameter() && taint.getParameterIndex() == flowSource.getParameterIndex();
        match = match || flowSource.isField() && (taint.isGapBaseObject() || taint.isField());
        match = match || flowSource.isThis() && taint.isField();
        match = match || flowSource.isReturn() && taint.isReturn() && flowSource.getGap() != null && taint.getGap() != null;
        boolean bl = match = match || flowSource.isReturn() && flowSource.getGap() == null && taint.getGap() == null && taint.isReturn();
        if (!match || !this.compareFields(taint, flowSource)) {
            return Tristate.FALSE();
        }
        return f.match(flowSource, flow, taint, stmt);
    }

    private class SummaryFRPSHandler
    implements IFollowReturnsPastSeedsHandler {
        private SummaryFRPSHandler() {
        }

        public void handleFollowReturnsPastSeeds(Abstraction d1, Unit u, Abstraction d2) {
            SootMethod sm = (SootMethod)SummaryTaintWrapper.this.manager.getICFG().getMethodOf((Object)u);
            Set<AccessPathPropagator> propagators = SummaryTaintWrapper.this.getUserCodeTaints(d1, sm);
            if (propagators != null && !propagators.isEmpty()) {
                this.handleFlowBackFromGap(u, d2, propagators);
            } else {
                this.handleFlowSourceInGap(u, d2);
            }
        }

        protected void handleFlowSourceInGap(Unit u, Abstraction d2) {
            boolean reverseFlows = SummaryTaintWrapper.this.manager.getConfig().getDataFlowDirection() == InfoflowConfiguration.DataFlowDirection.Backwards;
            boolean taintLeavesMethod = false;
            SootMethod callee = (SootMethod)SummaryTaintWrapper.this.manager.getICFG().getMethodOf((Object)u);
            if (reverseFlows) {
                taintLeavesMethod = callee.getActiveBody().getParameterLocals().contains(d2.getAccessPath().getPlainValue());
            } else if (u instanceof ReturnStmt) {
                ReturnStmt retStmt = (ReturnStmt)u;
                boolean bl = taintLeavesMethod = retStmt.getOp() == d2.getAccessPath().getPlainValue();
            }
            if (!taintLeavesMethod) {
                return;
            }
            for (Unit callSite : SummaryTaintWrapper.this.manager.getICFG().getCallersOf((Object)callee)) {
                Set<AccessPath> newAPs;
                Stmt sCallSite = (Stmt)callSite;
                ClassSummaries summaries = SummaryTaintWrapper.this.getFlowSummariesForMethod(sCallSite, sCallSite.getInvokeExpr().getMethod(), null);
                ArrayList<AccessPathPropagator> worklist = new ArrayList<AccessPathPropagator>();
                for (MethodFlow flow : summaries.getAllFlows()) {
                    FlowSource src = flow.source();
                    FlowSink tgt = flow.sink();
                    boolean flowMatchesTaint = false;
                    if (!reverseFlows && src.isReturn() && src.hasGap() && this.isImplementationOf(callee, src.getGap().getSignature())) {
                        flowMatchesTaint = true;
                    } else if (reverseFlows && tgt.isParameter() && tgt.hasGap() && this.isImplementationOf(callee, tgt.getGap().getSignature())) {
                        flowMatchesTaint = true;
                    }
                    if (!flowMatchesTaint) continue;
                    Set<Taint> returnTaints = SummaryTaintWrapper.this.createTaintFromAccessPathOnReturn(d2.getAccessPath(), (Stmt)u, reverseFlows ? tgt.getGap() : src.getGap());
                    if (returnTaints == null) continue;
                    for (Taint returnTaint : returnTaints) {
                        AccessPathPropagator propagator = new AccessPathPropagator(returnTaint, null, null, sCallSite, (Abstraction)SummaryTaintWrapper.this.manager.getMainSolver().getTabulationProblem().zeroValue(), d2);
                        if (reverseFlows) {
                            propagator = propagator.deriveInversePropagator();
                        }
                        worklist.add(propagator);
                    }
                }
                if (worklist.isEmpty() || (newAPs = SummaryTaintWrapper.this.applyFlowsIterative(summaries.getMergedMethodSummaries(), worklist, reverseFlows, sCallSite, d2, true)) == null || newAPs.isEmpty()) continue;
                Abstraction zeroValue = (Abstraction)SummaryTaintWrapper.this.manager.getMainSolver().getTabulationProblem().zeroValue();
                for (AccessPath ap : newAPs) {
                    Abstraction abs = d2.deriveNewAbstraction(ap, reverseFlows ? sCallSite : (Stmt)u);
                    if (reverseFlows) {
                        abs.setCorrespondingCallSite(sCallSite);
                    }
                    for (Unit succUnit : SummaryTaintWrapper.this.manager.getICFG().getSuccsOf((Object)callSite)) {
                        SummaryTaintWrapper.this.manager.getMainSolver().processEdge(new PathEdge((Object)zeroValue, (Object)succUnit, (Object)abs));
                    }
                }
            }
        }

        protected void handleFlowBackFromGap(Unit u, Abstraction d2, Set<AccessPathPropagator> propagators) {
            boolean reverseFlows = SummaryTaintWrapper.this.manager.getConfig().getDataFlowDirection() == InfoflowConfiguration.DataFlowDirection.Backwards;
            for (AccessPathPropagator propagator : propagators) {
                GapDefinition parentGap;
                AccessPathPropagator parent = SummaryTaintWrapper.this.safePopParent(propagator);
                GapDefinition gapDefinition = parentGap = propagator.getParent() == null ? null : propagator.getParent().getGap();
                Set<Taint> returnTaints = SummaryTaintWrapper.this.createTaintFromAccessPathOnReturn(d2.getAccessPath(), (Stmt)u, propagator.getGap());
                if (returnTaints == null) continue;
                MethodSummaries flowsInTarget = parentGap == null ? this.getFlowsInOriginalCallee(propagator) : SummaryTaintWrapper.this.getFlowSummariesForGap(parentGap);
                HashSet<AccessPathPropagator> workSet = new HashSet<AccessPathPropagator>();
                for (Taint returnTaint : returnTaints) {
                    AccessPathPropagator newPropagator = new AccessPathPropagator(returnTaint, parentGap, parent, propagator.getParent() == null ? null : propagator.getParent().getStmt(), propagator.getParent() == null ? null : propagator.getParent().getD1(), propagator.getParent() == null ? null : propagator.getParent().getD2());
                    workSet.add(newPropagator);
                }
                AccessPathPropagator rootPropagator = this.getOriginalCallSite(propagator);
                Set<AccessPath> resultAPs = SummaryTaintWrapper.this.applyFlowsIterative(flowsInTarget, new ArrayList<AccessPathPropagator>(workSet), reverseFlows, rootPropagator.getStmt(), d2, true);
                if (resultAPs == null || resultAPs.isEmpty()) continue;
                for (AccessPath ap : resultAPs) {
                    Abstraction newAbs = rootPropagator.getD2().deriveNewAbstraction(ap, rootPropagator.getStmt());
                    if (rootPropagator.isInversePropagator()) {
                        newAbs.setCorrespondingCallSite(rootPropagator.getStmt());
                    }
                    for (Unit succUnit : SummaryTaintWrapper.this.manager.getICFG().getSuccsOf((Object)rootPropagator.getStmt())) {
                        SummaryTaintWrapper.this.manager.getMainSolver().processEdge(new PathEdge((Object)rootPropagator.getD1(), (Object)succUnit, (Object)newAbs));
                    }
                }
            }
        }

        private boolean isImplementationOf(SootMethod sm, String signature) {
            SootMethodAndClass smac = SootMethodRepresentationParser.v().parseSootMethodString(signature);
            if (!smac.getMethodName().equals(sm.getName())) {
                return false;
            }
            if (smac.getParameters().size() != sm.getParameterCount()) {
                return false;
            }
            for (int i = 0; i < smac.getParameters().size(); ++i) {
                if (((String)smac.getParameters().get(i)).equals(sm.getParameterType(i).toString())) continue;
                return false;
            }
            SootClass callbackClass = Scene.v().getSootClassUnsafe(smac.getClassName());
            return Scene.v().getOrMakeFastHierarchy().canStoreClass(sm.getDeclaringClass(), callbackClass);
        }

        private MethodSummaries getFlowsInOriginalCallee(AccessPathPropagator propagator) {
            Stmt originalCallSite = this.getOriginalCallSite(propagator).getStmt();
            ClassSummaries flowsInCallee = SummaryTaintWrapper.this.getFlowSummariesForMethod(originalCallSite, originalCallSite.getInvokeExpr().getMethod(), null);
            String methodSig = originalCallSite.getInvokeExpr().getMethod().getSubSignature();
            return flowsInCallee.getAllSummariesForMethod(methodSig);
        }

        private AccessPathPropagator getOriginalCallSite(AccessPathPropagator propagator) {
            for (AccessPathPropagator curProp = propagator; curProp != null; curProp = curProp.getParent()) {
                if (curProp.getParent() != null) continue;
                return curProp;
            }
            return null;
        }
    }

    class HierarchyInjector
    implements PreAnalysisHandler {
        HierarchyInjector() {
        }

        public void onBeforeCallgraphConstruction() {
            for (String className : SummaryTaintWrapper.this.flows.getAllClassesWithSummaries()) {
                ClassMethodSummaries summaries;
                SootClass sc = Scene.v().forceResolve(className, 2);
                if (!sc.isPhantom() || (summaries = SummaryTaintWrapper.this.flows.getClassFlows(className)) == null) continue;
                if (summaries.hasInterfaceInfo()) {
                    if (summaries.isInterface()) {
                        sc.setModifiers(sc.getModifiers() | 0x200);
                    } else {
                        sc.setModifiers(sc.getModifiers() & 0xFFFFFDFF);
                    }
                }
                if (summaries.hasSuperclass()) {
                    String superclassName = summaries.getSuperClass();
                    SootClass scSuperclass = Scene.v().forceResolve(superclassName, 2);
                    sc.setSuperclass(scSuperclass);
                }
                if (!summaries.hasInterfaces()) continue;
                for (String intfName : summaries.getInterfaces()) {
                    SootClass scIntf = Scene.v().forceResolve(intfName, 2);
                    scIntf.setModifiers(sc.getModifiers() | 0x200);
                    if (sc.implementsInterface(intfName)) continue;
                    sc.addInterface(scIntf);
                }
            }
        }

        public void onAfterCallgraphConstruction() {
        }
    }

    @FunctionalInterface
    protected static interface MatchFunction {
        public Tristate match(AbstractFlowSinkSource var1, AbstractMethodSummary var2, Taint var3, Stmt var4);
    }
}

