/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import soot.jimple.infoflow.collections.data.IndexConstraint;
import soot.jimple.infoflow.collections.data.KeyConstraint;
import soot.jimple.infoflow.methodSummary.data.sourceSink.ConstraintType;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowClear;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowConstraint;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSink;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSource;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.ImplicitLocation;
import soot.jimple.infoflow.methodSummary.data.summary.IsAliasType;
import soot.jimple.infoflow.methodSummary.data.summary.MethodClear;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;
import soot.jimple.infoflow.methodSummary.xml.AbstractXMLReader;
import soot.jimple.infoflow.methodSummary.xml.SummaryXMLException;

public class SummaryReader
extends AbstractXMLReader {
    private static final String XSD_FILE_PATH = "schema/ClassSummaryC.xsd";
    private boolean validateSummariesOnRead = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Reader reader, ClassMethodSummaries summaries) throws XMLStreamException, SummaryXMLException, IOException {
        try (XMLStreamReader xmlreader = null;){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            xmlreader = factory.createXMLStreamReader(reader);
            MethodSummaries summary = summaries.getMethodSummaries();
            HashMap<String, String> sourceAttributes = new HashMap<String, String>();
            HashMap<String, String> sinkAttributes = new HashMap<String, String>();
            HashMap<String, String> clearAttributes = new HashMap<String, String>();
            HashMap<String, String> constraintAttributes = new HashMap<String, String>();
            ArrayList<FlowConstraint> constraints = new ArrayList<FlowConstraint>();
            String currentMethod = "";
            int currentID = -1;
            IsAliasType isAlias = IsAliasType.FALSE;
            Boolean typeChecking = null;
            Boolean ignoreTypes = null;
            Boolean cutSubfields = null;
            boolean isFinal = false;
            boolean excludedOnClear = false;
            State state = State.summary;
            while (xmlreader.hasNext()) {
                xmlreader.next();
                if (!xmlreader.hasName()) continue;
                String localName = xmlreader.getLocalName();
                if (localName.equals("summary") && xmlreader.isStartElement()) {
                    String isExclusive;
                    String isInterface = this.getAttributeByName(xmlreader, "isInterface");
                    if (isInterface != null && !isInterface.isEmpty()) {
                        summaries.setInterface(isInterface.equals("true"));
                    }
                    if ((isExclusive = this.getAttributeByName(xmlreader, "isExclusive")) == null || isExclusive.isEmpty()) continue;
                    summaries.setExclusiveForClass(isExclusive.equals("true"));
                    continue;
                }
                if (localName.equals("methods") && xmlreader.isStartElement()) {
                    if (state == State.summary) {
                        state = State.methods;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("method") && xmlreader.isStartElement()) {
                    if (state == State.methods) {
                        String sIsExcluded;
                        currentMethod = this.getAttributeByName(xmlreader, "id");
                        if (currentMethod.contains(":")) {
                            currentMethod = currentMethod.substring(currentMethod.indexOf(":") + 1).trim();
                        }
                        if ((sIsExcluded = this.getAttributeByName(xmlreader, "isExcluded")) != null && sIsExcluded.equals("true")) {
                            summary.addExcludedMethod(currentMethod);
                        }
                        state = State.method;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("method") && xmlreader.isEndElement()) {
                    if (state == State.method) {
                        state = State.methods;
                        constraints.clear();
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("flow") && xmlreader.isStartElement()) {
                    if (state == State.method) {
                        String sExcludedOnClear;
                        String sIsFinal;
                        String sIgnoreTypes;
                        String sCutSubfields;
                        sourceAttributes.clear();
                        sinkAttributes.clear();
                        state = State.flow;
                        String sAlias = this.getAttributeByName(xmlreader, "isAlias");
                        isAlias = this.parseIsAlias(sAlias);
                        String sTypeChecking = this.getAttributeByName(xmlreader, "typeChecking");
                        if (sTypeChecking != null && !sTypeChecking.isEmpty()) {
                            typeChecking = sTypeChecking.equals("true");
                        }
                        if ((sCutSubfields = this.getAttributeByName(xmlreader, "cutSubfields")) != null && !sCutSubfields.isEmpty()) {
                            cutSubfields = sCutSubfields.equals("true");
                        }
                        if ((sIgnoreTypes = this.getAttributeByName(xmlreader, "ignoreTypes")) != null && !sIgnoreTypes.isEmpty()) {
                            ignoreTypes = sIgnoreTypes.equals("true");
                        }
                        if ((sIsFinal = this.getAttributeByName(xmlreader, "final")) != null && !sIsFinal.isEmpty()) {
                            isFinal = sIsFinal.equals("true");
                        }
                        if ((sExcludedOnClear = this.getAttributeByName(xmlreader, "excludedOnClear")) == null || sExcludedOnClear.isEmpty()) continue;
                        excludedOnClear = sExcludedOnClear.equals("true");
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("clear") && xmlreader.isStartElement()) {
                    if (state == State.method) {
                        clearAttributes.clear();
                        for (int i = 0; i < xmlreader.getAttributeCount(); ++i) {
                            clearAttributes.put(xmlreader.getAttributeLocalName(i), xmlreader.getAttributeValue(i));
                        }
                        state = State.clear;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("from") && xmlreader.isStartElement()) {
                    if (state == State.flow) {
                        for (int i = 0; i < xmlreader.getAttributeCount(); ++i) {
                            sourceAttributes.put(xmlreader.getAttributeLocalName(i), xmlreader.getAttributeValue(i));
                        }
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("to") && xmlreader.isStartElement()) {
                    if (state == State.flow) {
                        if (xmlreader.getAttributeCount() == 0) {
                            throw new RuntimeException();
                        }
                        for (int i = 0; i < xmlreader.getAttributeCount(); ++i) {
                            sinkAttributes.put(xmlreader.getAttributeLocalName(i), xmlreader.getAttributeValue(i));
                        }
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("flow") && xmlreader.isEndElement()) {
                    if (state == State.flow) {
                        state = State.method;
                        MethodFlow flow = new MethodFlow(currentMethod, this.createSource(summary, sourceAttributes), this.createSink(summary, sinkAttributes), isAlias, typeChecking, ignoreTypes, cutSubfields, constraints.toArray(new FlowConstraint[0]), isFinal, excludedOnClear);
                        summary.addFlow(flow);
                        isAlias = IsAliasType.FALSE;
                        isFinal = false;
                        excludedOnClear = false;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("clear") && xmlreader.isEndElement()) {
                    if (state == State.clear) {
                        state = State.method;
                        String sAlias = (String)clearAttributes.get("isAlias");
                        IsAliasType alias = this.parseIsAlias(sAlias);
                        String ppString = (String)clearAttributes.get("preventPropagation");
                        boolean preventProp = ppString == null || ppString.isEmpty() || ppString.equals("true");
                        MethodClear clear = new MethodClear(currentMethod, this.createClear(summary, clearAttributes), constraints.toArray(new FlowConstraint[0]), alias, preventProp);
                        summary.addClear(clear);
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("methods") && xmlreader.isEndElement()) {
                    if (state == State.methods) {
                        state = State.summary;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("gaps") && xmlreader.isStartElement()) {
                    if (state == State.summary) {
                        state = State.gaps;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("gaps") && xmlreader.isEndElement()) {
                    if (state == State.gaps) {
                        state = State.summary;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("gap") && xmlreader.isStartElement()) {
                    if (state == State.gaps) {
                        currentMethod = this.getAttributeByName(xmlreader, "id");
                        currentID = Integer.valueOf(this.getAttributeByName(xmlreader, "num"));
                        summary.getOrCreateGap(currentID, currentMethod);
                        state = State.gap;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("gap") && xmlreader.isEndElement()) {
                    if (state == State.gap) {
                        state = State.gaps;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("hierarchy") && xmlreader.isStartElement()) {
                    if (state == State.summary) {
                        summaries.setSuperClass(this.getAttributeByName(xmlreader, "superClass"));
                        state = State.hierarchy;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("hierarchy") && xmlreader.isEndElement()) {
                    if (state == State.hierarchy) {
                        state = State.summary;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("interface") && xmlreader.isStartElement()) {
                    if (state == State.hierarchy) {
                        summaries.addInterface(this.getAttributeByName(xmlreader, "name"));
                        state = State.intf;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("interface") && xmlreader.isEndElement()) {
                    if (state == State.intf) {
                        state = State.hierarchy;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("constraints") && xmlreader.isStartElement()) {
                    if (state != State.method) {
                        throw new SummaryXMLException();
                    }
                    state = State.constraints;
                    continue;
                }
                if (localName.equals("constraints") && xmlreader.isEndElement()) {
                    if (state != State.constraints) {
                        throw new SummaryXMLException();
                    }
                    state = State.method;
                    continue;
                }
                if (localName.equals("key") && xmlreader.isStartElement()) {
                    if (state != State.constraints) {
                        throw new SummaryXMLException();
                    }
                    state = State.key;
                    for (int i = 0; i < xmlreader.getAttributeCount(); ++i) {
                        constraintAttributes.put(xmlreader.getAttributeLocalName(i), xmlreader.getAttributeValue(i));
                    }
                    continue;
                }
                if (localName.equals("key") && xmlreader.isEndElement()) {
                    if (state != State.key) {
                        throw new SummaryXMLException();
                    }
                    state = State.constraints;
                    constraints.add(this.createKeyConstraint(constraintAttributes));
                    constraintAttributes.clear();
                    continue;
                }
                if (localName.equals("index") && xmlreader.isStartElement()) {
                    if (state != State.constraints) {
                        throw new SummaryXMLException();
                    }
                    state = State.index;
                    for (int i = 0; i < xmlreader.getAttributeCount(); ++i) {
                        constraintAttributes.put(xmlreader.getAttributeLocalName(i), xmlreader.getAttributeValue(i));
                    }
                    continue;
                }
                if (!localName.equals("index") || !xmlreader.isEndElement()) continue;
                if (state != State.index) {
                    throw new SummaryXMLException();
                }
                state = State.constraints;
                constraints.add(this.createIndexConstraint(constraintAttributes));
                constraintAttributes.clear();
            }
            if (this.validateSummariesOnRead) {
                summary.validate();
            }
        }
    }

    private IsAliasType parseIsAlias(String sAlias) throws SummaryXMLException {
        if (sAlias == null) {
            return IsAliasType.FALSE;
        }
        switch (sAlias) {
            case "true": {
                return IsAliasType.TRUE;
            }
            case "": 
            case "false": {
                return IsAliasType.FALSE;
            }
            case "withContext": {
                return IsAliasType.WITH_CONTEXT;
            }
        }
        throw new SummaryXMLException("Unknown isAlias value: " + sAlias);
    }

    public void read(File fileName, ClassMethodSummaries summaries) throws XMLStreamException, SummaryXMLException, IOException {
        if (this.validateSummariesOnRead) {
            try (FileReader rdr = new FileReader(fileName);){
                if (!SummaryReader.verifyXML(rdr, XSD_FILE_PATH)) {
                    throw new RuntimeException("The XML-File isn't valid");
                }
            }
        }
        this.read(new FileReader(fileName), summaries);
    }

    private FlowSource createSource(MethodSummaries summary, Map<String, String> attributes) throws SummaryXMLException {
        if (this.isField(attributes)) {
            return new FlowSource(SourceSinkType.Field, this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes), this.isConstrained(attributes));
        }
        if (this.isParameter(attributes)) {
            return new FlowSource(SourceSinkType.Parameter, this.parameterIdx(attributes), this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes), this.isConstrained(attributes));
        }
        if (this.isGapBaseObject(attributes)) {
            return new FlowSource(SourceSinkType.GapBaseObject, this.getBaseType(attributes), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes), this.isConstrained(attributes));
        }
        if (this.isReturn(attributes)) {
            GapDefinition gap = this.getGapDefinition(attributes, summary);
            if (gap == null) {
                throw new SummaryXMLException("Return values can only be sources if they have a gap specification");
            }
            return new FlowSource(SourceSinkType.Return, this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes), this.isConstrained(attributes));
        }
        throw new SummaryXMLException("Invalid flow source definition");
    }

    private FlowSink createSink(MethodSummaries summary, Map<String, String> attributes) throws SummaryXMLException {
        if (this.isField(attributes)) {
            return new FlowSink(SourceSinkType.Field, this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.taintSubFields(attributes), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes), this.isConstrained(attributes));
        }
        if (this.isParameter(attributes)) {
            return new FlowSink(SourceSinkType.Parameter, this.parameterIdx(attributes), this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.taintSubFields(attributes), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes), this.isConstrained(attributes));
        }
        if (this.isReturn(attributes)) {
            return new FlowSink(SourceSinkType.Return, this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.taintSubFields(attributes), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes), this.isConstrained(attributes));
        }
        if (this.isGapBaseObject(attributes)) {
            return new FlowSink(SourceSinkType.GapBaseObject, -1, this.getBaseType(attributes), false, this.getGapDefinition(attributes, summary), (Object)this.isMatchStrict(attributes), this.isConstrained(attributes));
        }
        throw new SummaryXMLException();
    }

    private FlowClear createClear(MethodSummaries summary, Map<String, String> attributes) throws SummaryXMLException {
        if (this.isField(attributes)) {
            return new FlowClear(SourceSinkType.Field, this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.getGapDefinition(attributes, summary), this.isConstrained(attributes));
        }
        if (this.isParameter(attributes)) {
            return new FlowClear(SourceSinkType.Parameter, this.parameterIdx(attributes), this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.getGapDefinition(attributes, summary), this.isConstrained(attributes));
        }
        if (this.isGapBaseObject(attributes)) {
            return new FlowClear(SourceSinkType.GapBaseObject, this.getBaseType(attributes), this.getGapDefinition(attributes, summary), this.isConstrained(attributes));
        }
        throw new SummaryXMLException("Invalid flow clear definition");
    }

    private FlowConstraint createKeyConstraint(Map<String, String> attributes) throws SummaryXMLException {
        if (this.isParameter(attributes)) {
            return new KeyConstraint(SourceSinkType.Parameter, this.parameterIdx(attributes), this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)));
        }
        if (this.isAny(attributes)) {
            return new KeyConstraint(SourceSinkType.Any, -1, this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)));
        }
        throw new SummaryXMLException();
    }

    private FlowConstraint createIndexConstraint(Map<String, String> attributes) throws SummaryXMLException {
        if (this.isParameter(attributes)) {
            return new IndexConstraint(SourceSinkType.Parameter, this.parameterIdx(attributes), this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), null);
        }
        if (this.isImplicit(attributes)) {
            return new IndexConstraint(SourceSinkType.Implicit, -1, this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.getImplicitLocation(attributes));
        }
        throw new SummaryXMLException();
    }

    private ImplicitLocation getImplicitLocation(Map<String, String> attributes) {
        String implLoc = attributes.get("ImplicitLocation");
        switch (implLoc.toLowerCase()) {
            case "first": {
                return ImplicitLocation.First;
            }
            case "last": {
                return ImplicitLocation.Last;
            }
            case "next": {
                return ImplicitLocation.Next;
            }
        }
        throw new RuntimeException("Missing case!");
    }

    private boolean isReturn(Map<String, String> attributes) {
        if (attributes != null) {
            String attr = attributes.get("sourceSinkType");
            return attr != null && attr.equals(SourceSinkType.Return.toString());
        }
        return false;
    }

    private boolean isField(Map<String, String> attributes) {
        if (attributes != null) {
            String attr = attributes.get("sourceSinkType");
            return attr != null && attr.equals(SourceSinkType.Field.toString());
        }
        return false;
    }

    private boolean isImplicit(Map<String, String> attributes) {
        if (attributes != null) {
            String attr = attributes.get("sourceSinkType");
            return attr != null && attr.equals(SourceSinkType.Implicit.toString());
        }
        return false;
    }

    private ConstraintType isConstrained(Map<String, String> attributes) {
        if (attributes != null) {
            String attr = attributes.get("constrained");
            if (attr == null) {
                return ConstraintType.FALSE;
            }
            switch (attr.toLowerCase()) {
                case "true": {
                    return ConstraintType.TRUE;
                }
                case "false": {
                    return ConstraintType.FALSE;
                }
                case "keep": {
                    return ConstraintType.KEEP;
                }
                case "read-only": {
                    return ConstraintType.READONLY;
                }
                case "shiftright": {
                    return ConstraintType.SHIFT_RIGHT;
                }
                case "shiftleft": {
                    return ConstraintType.SHIFT_LEFT;
                }
                case "nomatch": {
                    return ConstraintType.NO_MATCH;
                }
                case "append": {
                    return ConstraintType.APPEND;
                }
            }
            throw new RuntimeException("Unknown constraint type: " + attr);
        }
        return ConstraintType.FALSE;
    }

    private String[] getAccessPath(Map<String, String> attributes) {
        String ap = attributes.get("AccessPath");
        if (ap != null && ap.length() > 3) {
            String[] res = ap.substring(1, ap.length() - 1).split(",");
            for (int i = 0; i < res.length; ++i) {
                Object curElement = res[i].trim();
                if (!((String)curElement).startsWith("<")) {
                    curElement = "<" + (String)curElement;
                }
                if (!((String)curElement).endsWith(">")) {
                    curElement = (String)curElement + ">";
                }
                res[i] = curElement;
            }
            return res;
        }
        return null;
    }

    private String[] getAccessPathTypes(Map<String, String> attributes) {
        String ap = attributes.get("AccessPathTypes");
        if (ap != null && ap.length() > 3) {
            String[] res = ap.substring(1, ap.length() - 1).split(",");
            for (int i = 0; i < res.length; ++i) {
                res[i] = res[i].trim();
            }
            return res;
        }
        return null;
    }

    private boolean isMatchStrict(Map<String, String> attributes) {
        String str = attributes.get("matchStrict");
        if (str != null && !str.isEmpty()) {
            return Boolean.valueOf(str);
        }
        return false;
    }

    private boolean isParameter(Map<String, String> attributes) {
        return attributes.get("sourceSinkType").equals(SourceSinkType.Parameter.toString());
    }

    private boolean isAny(Map<String, String> attributes) {
        return attributes.get("sourceSinkType").equals(SourceSinkType.Any.toString());
    }

    private boolean isGapBaseObject(Map<String, String> attributes) {
        return attributes != null && attributes.get("sourceSinkType").equals(SourceSinkType.GapBaseObject.toString());
    }

    private int parameterIdx(Map<String, String> attributes) {
        String strIdx = attributes.get("ParameterIndex");
        if (strIdx == null || strIdx.isEmpty()) {
            throw new RuntimeException("Parameter index not specified");
        }
        if (strIdx.equals("*")) {
            return -2;
        }
        return Integer.parseInt(strIdx);
    }

    private String getBaseType(Map<String, String> attributes) {
        return attributes.get("BaseType");
    }

    private boolean taintSubFields(Map<String, String> attributes) {
        String val = attributes.get("taintSubFields");
        return val != null && val.equals("true");
    }

    private GapDefinition getGapDefinition(Map<String, String> attributes, MethodSummaries summary) {
        String id = attributes.get("gap");
        if (id == null || id.isEmpty()) {
            return null;
        }
        GapDefinition gap = summary.getGap(Integer.parseInt(id));
        if (gap != null) {
            return gap;
        }
        return summary.createTemporaryGap(Integer.parseInt(id));
    }

    public void setValidateSummariesOnRead(boolean validateSummariesOnRead) {
        this.validateSummariesOnRead = validateSummariesOnRead;
    }

    private static enum State {
        summary,
        hierarchy,
        intf,
        methods,
        method,
        flow,
        clear,
        gaps,
        gap,
        constraints,
        key,
        index;

    }
}

