/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.AbstractInfoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.IAliasingStrategy;
import soot.jimple.infoflow.cfg.BiDirICFGFactory;
import soot.jimple.infoflow.codeOptimization.AddNopStmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.globalTaints.GlobalTaintManager;
import soot.jimple.infoflow.nativeCallHandler.BackwardNativeCallHandler;
import soot.jimple.infoflow.problems.BackwardsInfoflowProblem;
import soot.jimple.infoflow.problems.rules.BackwardPropagationRuleManagerFactory;
import soot.jimple.infoflow.results.BackwardsInfoflowResults;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.solver.cfg.BackwardsInfoflowCFG;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;
import soot.jimple.infoflow.solver.memory.IMemoryManager;
import soot.jimple.infoflow.sourcesSinks.manager.IReversibleSourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;

public class BackwardsInfoflow
extends AbstractInfoflow {
    public BackwardsInfoflow() {
        this.config.setDataFlowDirection(InfoflowConfiguration.DataFlowDirection.Backwards);
        this.setNativeCallHandler(new BackwardNativeCallHandler());
    }

    public BackwardsInfoflow(String androidPath, boolean forceAndroidJar) {
        super(null, androidPath, forceAndroidJar);
        this.config.setDataFlowDirection(InfoflowConfiguration.DataFlowDirection.Backwards);
        this.setNativeCallHandler(new BackwardNativeCallHandler());
    }

    public BackwardsInfoflow(String androidPath, boolean forceAndroidJar, BiDirICFGFactory icfgFactory) {
        super(icfgFactory, androidPath, forceAndroidJar);
        this.config.setDataFlowDirection(InfoflowConfiguration.DataFlowDirection.Backwards);
        this.setNativeCallHandler(new BackwardNativeCallHandler());
    }

    @Override
    protected IAliasingStrategy createAliasAnalysis(ISourceSinkManager sourcesSinks, IInfoflowCFG iCfg, InterruptableExecutor executor, IMemoryManager<Abstraction, Unit> memoryManager) {
        return this.createBackwardAliasAnalysis(this.manager, sourcesSinks, iCfg, executor, memoryManager);
    }

    @Override
    protected InfoflowManager initializeInfoflowManager(ISourceSinkManager sourcesSinks, IInfoflowCFG iCfg, GlobalTaintManager globalTaintManager) {
        return new InfoflowManager(this.config, null, (IInfoflowCFG)new BackwardsInfoflowCFG(iCfg), sourcesSinks, this.taintWrapper, this.hierarchy, globalTaintManager);
    }

    @Override
    protected BackwardsInfoflowProblem createInfoflowProblem(Abstraction zeroValue) {
        return new BackwardsInfoflowProblem(this.manager, zeroValue, this.ruleManagerFactory);
    }

    @Override
    protected AbstractInfoflow.SourceOrSink scanStmtForSourcesSinks(ISourceSinkManager sourcesSinks, Stmt s) {
        IReversibleSourceSinkManager ssm = (IReversibleSourceSinkManager)sourcesSinks;
        SourceInfo sinkInfo = ssm.getInverseSinkInfo(s, this.manager);
        SinkInfo sourceInfo = ssm.getInverseSourceInfo(s, this.manager, null);
        return new AbstractInfoflow.SourceOrSink(sinkInfo, sourceInfo);
    }

    @Override
    protected InfoflowResults createResultsObject() {
        return new BackwardsInfoflowResults();
    }

    @Override
    protected BackwardPropagationRuleManagerFactory initializeRuleManagerFactory() {
        return new BackwardPropagationRuleManagerFactory();
    }

    @Override
    protected void performCodeInstrumentation(InfoflowManager dceManager, Set<SootMethod> excludedMethods) {
        super.performCodeInstrumentation(dceManager, excludedMethods);
        AddNopStmt nopStmt = new AddNopStmt();
        nopStmt.initialize(this.config);
        nopStmt.run(dceManager, excludedMethods, null, null);
    }
}

