/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.AbstractInfoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.FlowSensitiveAliasStrategy;
import soot.jimple.infoflow.aliasing.IAliasingStrategy;
import soot.jimple.infoflow.aliasing.LazyAliasingStrategy;
import soot.jimple.infoflow.aliasing.NullAliasStrategy;
import soot.jimple.infoflow.aliasing.PtsBasedAliasStrategy;
import soot.jimple.infoflow.cfg.BiDirICFGFactory;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.globalTaints.GlobalTaintManager;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.nativeCallHandler.DefaultNativeCallHandler;
import soot.jimple.infoflow.problems.AliasProblem;
import soot.jimple.infoflow.problems.InfoflowProblem;
import soot.jimple.infoflow.problems.rules.DefaultPropagationRuleManagerFactory;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.river.BackwardNoSinkRuleManagerFactory;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.cfg.BackwardsInfoflowCFG;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;
import soot.jimple.infoflow.solver.memory.IMemoryManager;
import soot.jimple.infoflow.sourcesSinks.manager.EmptySourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;

public class Infoflow
extends AbstractInfoflow {
    public Infoflow() {
    }

    public Infoflow(String androidPath, boolean forceAndroidJar) {
        super(null, androidPath, forceAndroidJar);
    }

    public Infoflow(String androidPath, boolean forceAndroidJar, BiDirICFGFactory icfgFactory) {
        super(icfgFactory, androidPath, forceAndroidJar);
        this.setNativeCallHandler(new DefaultNativeCallHandler());
    }

    @Override
    protected InfoflowManager initializeInfoflowManager(ISourceSinkManager sourcesSinks, IInfoflowCFG iCfg, GlobalTaintManager globalTaintManager) {
        return new InfoflowManager(this.config, null, iCfg, sourcesSinks, this.taintWrapper, this.hierarchy, globalTaintManager);
    }

    @Override
    protected IAliasingStrategy createAliasAnalysis(ISourceSinkManager sourcesSinks, IInfoflowCFG iCfg, InterruptableExecutor executor, IMemoryManager<Abstraction, Unit> memoryManager) {
        IAliasingStrategy aliasingStrategy;
        IInfoflowSolver backSolver = null;
        AliasProblem backProblem = null;
        InfoflowManager aliasManager = null;
        switch (this.getConfig().getAliasingAlgorithm()) {
            case FlowSensitive: {
                aliasManager = new InfoflowManager(this.config, null, (IInfoflowCFG)new BackwardsInfoflowCFG(iCfg), sourcesSinks, this.taintWrapper, this.hierarchy, this.manager);
                backProblem = new AliasProblem(aliasManager);
                InfoflowConfiguration.SolverConfiguration solverConfig = this.config.getSolverConfiguration();
                backSolver = this.createDataFlowSolver(executor, backProblem, solverConfig);
                backSolver.setMemoryManager(memoryManager);
                backSolver.setPredecessorShorteningMode(this.pathConfigToShorteningMode(this.manager.getConfig().getPathConfiguration()));
                backSolver.setMaxJoinPointAbstractions(solverConfig.getMaxJoinPointAbstractions());
                backSolver.setMaxCalleesPerCallSite(solverConfig.getMaxCalleesPerCallSite());
                backSolver.setMaxAbstractionPathLength(solverConfig.getMaxAbstractionPathLength());
                backSolver.setSolverId(false);
                backProblem.setTaintPropagationHandler(this.aliasPropagationHandler);
                backProblem.setTaintWrapper(this.taintWrapper);
                if (this.nativeCallHandler != null) {
                    backProblem.setNativeCallHandler(this.nativeCallHandler);
                }
                this.memoryWatcher.addSolver((IMemoryBoundedSolver)((Object)backSolver));
                aliasingStrategy = new FlowSensitiveAliasStrategy(this.manager, backSolver);
                break;
            }
            case PtsBased: {
                backProblem = null;
                backSolver = null;
                aliasingStrategy = new PtsBasedAliasStrategy(this.manager);
                break;
            }
            case None: {
                backProblem = null;
                backSolver = null;
                aliasingStrategy = new NullAliasStrategy();
                break;
            }
            case Lazy: {
                backProblem = null;
                backSolver = null;
                aliasingStrategy = new LazyAliasingStrategy(this.manager);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported aliasing algorithm");
            }
        }
        return aliasingStrategy;
    }

    @Override
    protected InfoflowProblem createInfoflowProblem(Abstraction zeroValue) {
        return new InfoflowProblem(this.manager, zeroValue, this.ruleManagerFactory);
    }

    @Override
    protected AbstractInfoflow.SourceOrSink scanStmtForSourcesSinks(ISourceSinkManager sourcesSinks, Stmt s) {
        SourceInfo sourceInfo = sourcesSinks.getSourceInfo(s, this.manager);
        SinkInfo sinkInfo = sourcesSinks.getSinkInfo(s, this.manager, null);
        return new AbstractInfoflow.SourceOrSink(sourceInfo, sinkInfo);
    }

    @Override
    protected InfoflowResults createResultsObject() {
        return new InfoflowResults(this.config.getPathAgnosticResults());
    }

    @Override
    protected DefaultPropagationRuleManagerFactory initializeRuleManagerFactory() {
        return new DefaultPropagationRuleManagerFactory();
    }

    @Override
    protected BackwardNoSinkRuleManagerFactory initializeReverseRuleManagerFactory() {
        return new BackwardNoSinkRuleManagerFactory();
    }

    @Override
    protected InfoflowManager initializeReverseInfoflowManager(IInfoflowCFG iCfg, GlobalTaintManager globalTaintManager) {
        return new InfoflowManager(this.config, null, (IInfoflowCFG)new BackwardsInfoflowCFG(iCfg), (ISourceSinkManager)new EmptySourceSinkManager(), this.taintWrapper, this.hierarchy, globalTaintManager);
    }
}

