/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.callmappers;

import java.util.ArrayDeque;
import soot.MethodSubSignature;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.callmappers.ICallerCalleeArgumentMapper;
import soot.jimple.toolkits.callgraph.VirtualEdgesSummaries;

public class VirtualEdgeTargetCallerCalleeMapper
implements ICallerCalleeArgumentMapper {
    private VirtualEdgesSummaries.DirectTarget directTarget;
    private VirtualEdgesSummaries.VirtualEdgeTarget virtualEdgeTarget;

    public VirtualEdgeTargetCallerCalleeMapper(VirtualEdgesSummaries.VirtualEdgeTarget t, VirtualEdgesSummaries.DirectTarget dt) {
        this.virtualEdgeTarget = t;
        this.directTarget = dt;
    }

    @Override
    public int getCallerIndexOfCalleeParameter(int calleeParamIndex) {
        if (calleeParamIndex == -1) {
            return this.virtualEdgeTarget.getArgIndex();
        }
        for (VirtualEdgesSummaries.AbstractParameterMapping i : this.directTarget.getParameterMappings()) {
            if (i instanceof VirtualEdgesSummaries.DirectParameterMapping) {
                VirtualEdgesSummaries.DirectParameterMapping dm = (VirtualEdgesSummaries.DirectParameterMapping)i;
                if (calleeParamIndex != dm.getTargetIndex()) continue;
                return dm.getSourceIndex();
            }
            throw new RuntimeException("Unsupported mapping type: " + i.getClass());
        }
        return -3;
    }

    @Override
    public int getCalleeIndexOfCallerParameter(int callerParamIndex) {
        if (callerParamIndex == -1) {
            return -3;
        }
        for (VirtualEdgesSummaries.AbstractParameterMapping i : this.directTarget.getParameterMappings()) {
            if (i instanceof VirtualEdgesSummaries.DirectParameterMapping) {
                VirtualEdgesSummaries.DirectParameterMapping dm = (VirtualEdgesSummaries.DirectParameterMapping)i;
                if (callerParamIndex != dm.getSourceIndex()) continue;
                return dm.getTargetIndex();
            }
            throw new RuntimeException("Unsupported mapping type: " + i.getClass());
        }
        return -3;
    }

    public static VirtualEdgeTargetCallerCalleeMapper determineVirtualEdgeMapping(InfoflowManager manager, InvokeExpr ie, SootMethod callee) {
        if (ie == null) {
            return null;
        }
        VirtualEdgesSummaries summaries = manager.getVirtualEdgeSummaries();
        VirtualEdgesSummaries.VirtualEdge summary = ie instanceof StaticInvokeExpr ? summaries.getVirtualEdgesMatchingFunction(ie.getMethod().getSignature()) : summaries.getVirtualEdgesMatchingSubSig(new MethodSubSignature(ie.getMethod().makeRef()));
        if (summary != null) {
            for (VirtualEdgesSummaries.VirtualEdgeTarget t : summary.getTargets()) {
                VirtualEdgesSummaries.DirectTarget dt = null;
                if (t instanceof VirtualEdgesSummaries.IndirectTarget) {
                    VirtualEdgesSummaries.IndirectTarget c;
                    ArrayDeque<VirtualEdgesSummaries.IndirectTarget> targetQueue = new ArrayDeque<VirtualEdgesSummaries.IndirectTarget>();
                    targetQueue.add((VirtualEdgesSummaries.IndirectTarget)t);
                    boolean matched = false;
                    block1: while ((c = (VirtualEdgesSummaries.IndirectTarget)targetQueue.poll()) != null) {
                        for (VirtualEdgesSummaries.VirtualEdgeTarget d : c.getTargets()) {
                            if (d instanceof VirtualEdgesSummaries.IndirectTarget) {
                                targetQueue.add((VirtualEdgesSummaries.IndirectTarget)d);
                                continue;
                            }
                            if (!(d instanceof VirtualEdgesSummaries.DirectTarget) || !VirtualEdgeTargetCallerCalleeMapper.matchDirectTarget(manager, dt = (VirtualEdgesSummaries.DirectTarget)d, callee)) continue;
                            matched = true;
                            continue block1;
                        }
                    }
                    if (!matched) {
                        continue;
                    }
                } else {
                    dt = (VirtualEdgesSummaries.DirectTarget)t;
                    if (!VirtualEdgeTargetCallerCalleeMapper.matchDirectTarget(manager, dt, callee)) continue;
                }
                return new VirtualEdgeTargetCallerCalleeMapper(t, dt);
            }
        }
        return null;
    }

    private static boolean matchDirectTarget(InfoflowManager manager, VirtualEdgesSummaries.DirectTarget dt, SootMethod callee) {
        RefType tt = dt.getTargetType();
        if (tt != null && tt.hasSootClass() && tt.getSootClass().resolvingLevel() >= 1 && !manager.getTypeUtils().checkCast((Type)callee.getDeclaringClass().getType(), (Type)tt)) {
            return false;
        }
        return manager.getTypeUtils().isOverriden(dt.getTargetMethod(), callee);
    }
}

