/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collect;

import java.util.concurrent.atomic.AtomicIntegerArray;

public class AtomicBitSet {
    private final AtomicIntegerArray array;
    private int largestInt;

    public AtomicBitSet(int length) {
        this.largestInt = length;
        int intLength = (length + 31) / 32;
        this.array = new AtomicIntegerArray(intLength);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int val = 0;
        for (int i = 0; i < this.array.length(); ++i) {
            int c = this.array.get(i);
            for (int bit = 0; bit < 32; ++bit) {
                if ((c & 1 << bit) != 0) {
                    sb.append(val).append(", ");
                }
                ++val;
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    public String toBitString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.array.length(); ++i) {
            int c = this.array.get(i);
            for (int bit = 0; bit < 32; ++bit) {
                if ((c & 1 << bit) != 0) {
                    sb.append("1, ");
                    continue;
                }
                sb.append("0, ");
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    public boolean unset(long n) {
        int num2;
        int num;
        int bit = 1 << (int)n;
        int idx = (int)(n >>> 5);
        do {
            if ((num = this.array.get(idx)) != (num2 = num & ~bit)) continue;
            return false;
        } while (!this.array.compareAndSet(idx, num, num2));
        return true;
    }

    public boolean set(long n) {
        int num2;
        int num;
        int bit = 1 << (int)n;
        int idx = (int)(n >>> 5);
        do {
            if ((num = this.array.get(idx)) != (num2 = num | bit)) continue;
            return false;
        } while (!this.array.compareAndSet(idx, num, num2));
        return true;
    }

    public int getLargestInt() {
        return this.largestInt;
    }

    public int size() {
        return this.array.length();
    }

    public boolean get(long n) {
        int bit = 1 << (int)n;
        int idx = (int)(n >>> 5);
        int num = this.array.get(idx);
        return (num & bit) != 0;
    }
}

