/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collect;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import soot.jimple.infoflow.collect.ConcurrentIdentityHashMap;
import soot.util.AbstractMultiMap;
import soot.util.MultiMap;

public class ConcurrentIdentityHashMultiMap<K, V>
extends AbstractMultiMap<K, V> {
    private static final long serialVersionUID = -6721251660349964507L;
    Map<K, ConcurrentMap<V, V>> m = new ConcurrentIdentityHashMap<K, ConcurrentMap<V, V>>();

    public ConcurrentIdentityHashMultiMap() {
    }

    public ConcurrentIdentityHashMultiMap(MultiMap<K, V> m) {
        this.putAll(m);
    }

    public int numKeys() {
        return this.m.size();
    }

    public boolean containsKey(Object key) {
        return this.m.containsKey(key);
    }

    public boolean containsValue(V value) {
        for (Map map : this.m.values()) {
            if (!map.containsKey(value)) continue;
            return true;
        }
        return false;
    }

    protected ConcurrentMap<V, V> newSet() {
        return new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<V, V> findSet(K key) {
        ConcurrentMap<V, V> s = this.m.get(key);
        if (s == null) {
            ConcurrentIdentityHashMultiMap concurrentIdentityHashMultiMap = this;
            synchronized (concurrentIdentityHashMultiMap) {
                s = this.m.get(key);
                if (s == null) {
                    s = this.newSet();
                    this.m.put(key, s);
                }
            }
        }
        return s;
    }

    public boolean put(K key, V value) {
        return this.findSet(key).put(value, value) == null;
    }

    public V putIfAbsent(K key, V value) {
        return this.findSet(key).putIfAbsent(value, value);
    }

    public boolean putAll(K key, Collection<V> values) {
        if (values.isEmpty()) {
            return false;
        }
        ConcurrentMap<V, V> set = this.findSet(key);
        boolean ok = false;
        for (V v : values) {
            if (set.put(v, v) != null) continue;
            ok = true;
        }
        return ok;
    }

    public boolean remove(K key, V value) {
        boolean ret;
        Map s = this.m.get(key);
        if (s == null) {
            return false;
        }
        boolean bl = ret = s.remove(value) != null;
        if (s.isEmpty()) {
            this.m.remove(key);
        }
        return ret;
    }

    public boolean remove(K key) {
        return null != this.m.remove(key);
    }

    public boolean removeAll(K key, Collection<V> values) {
        Map s = this.m.get(key);
        if (s == null) {
            return false;
        }
        boolean ret = false;
        for (V v : values) {
            if (s.remove(v) == null) continue;
            ret = true;
        }
        if (s.isEmpty()) {
            this.m.remove(key);
        }
        return ret;
    }

    public Set<V> get(K o) {
        Map ret = this.m.get(o);
        if (ret == null) {
            return Collections.emptySet();
        }
        return ret.keySet();
    }

    public Set<K> keySet() {
        return this.m.keySet();
    }

    public Set<V> values() {
        HashSet ret = new HashSet(this.m.size());
        for (Map map : this.m.values()) {
            ret.addAll(map.keySet());
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiMap)) {
            return false;
        }
        MultiMap mm = (MultiMap)o;
        if (!this.keySet().equals(mm.keySet())) {
            return false;
        }
        for (Map.Entry<K, ConcurrentMap<V, V>> e : this.m.entrySet()) {
            Map s = e.getValue();
            Set otherValues = mm.get(e.getKey());
            if (s.keySet().equals(otherValues)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m.hashCode();
    }

    public int size() {
        return this.m.size();
    }

    public void clear() {
        this.m.clear();
    }
}

