/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.collect.AtomicBitSet;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SourceContext;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.fastSolver.FastSolverLinkedNode;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;

public class Abstraction
implements Cloneable,
FastSolverLinkedNode<Abstraction, Unit> {
    protected static boolean flowSensitiveAliasing = true;
    protected AccessPath accessPath;
    protected Abstraction predecessor = null;
    protected volatile Set<Abstraction> neighbors = null;
    protected Stmt currentStmt = null;
    protected Stmt correspondingCallSite = null;
    protected SourceContext sourceContext = null;
    protected Unit activationUnit = null;
    protected Unit turnUnit = null;
    protected boolean exceptionThrown = false;
    protected int hashCode = 0;
    protected int neighborHashCode = 0;
    protected List<IInfoflowCFG.UnitContainer> postdominators = null;
    protected Unit dominator = null;
    protected boolean isImplicit = false;
    protected boolean dependsOnCutAP = false;
    protected AtomicBitSet pathFlags = null;
    protected int propagationPathLength = 0;

    public Abstraction(Collection<ISourceSinkDefinition> definitions, AccessPath sourceVal, Stmt sourceStmt, Object userData, boolean exceptionThrown, boolean isImplicit) {
        this(sourceVal, new SourceContext(definitions, sourceVal, sourceStmt, userData), exceptionThrown, isImplicit);
    }

    Abstraction(AccessPath apToTaint, SourceContext sourceContext, boolean exceptionThrown, boolean isImplicit) {
        this.sourceContext = sourceContext;
        this.accessPath = apToTaint;
        this.activationUnit = null;
        this.turnUnit = null;
        this.exceptionThrown = exceptionThrown;
        this.neighbors = null;
        this.isImplicit = isImplicit;
        this.currentStmt = sourceContext == null ? null : sourceContext.getStmt();
    }

    protected Abstraction(AccessPath p, Abstraction original) {
        if (original == null) {
            this.sourceContext = null;
            this.exceptionThrown = false;
            this.activationUnit = null;
            this.turnUnit = null;
            this.isImplicit = false;
        } else {
            this.sourceContext = original.sourceContext;
            this.exceptionThrown = original.exceptionThrown;
            this.activationUnit = original.activationUnit;
            this.turnUnit = original.turnUnit;
            assert (this.activationUnit == null || flowSensitiveAliasing);
            this.postdominators = original.postdominators == null ? null : new ArrayList<IInfoflowCFG.UnitContainer>(original.postdominators);
            this.dominator = original.dominator;
            this.dependsOnCutAP = original.dependsOnCutAP;
            this.isImplicit = original.isImplicit;
        }
        this.accessPath = p;
        this.neighbors = null;
        this.currentStmt = null;
    }

    public static void initialize(InfoflowConfiguration config) {
        flowSensitiveAliasing = config.getFlowSensitiveAliasing();
    }

    public Abstraction deriveInactiveAbstraction(Stmt activationUnit) {
        if (!flowSensitiveAliasing) {
            assert (this.isAbstractionActive());
            return this;
        }
        if (!this.isAbstractionActive()) {
            return this;
        }
        Abstraction a = this.deriveNewAbstractionMutable(this.accessPath, null);
        if (a == null) {
            return null;
        }
        a.postdominators = null;
        a.dominator = null;
        a.activationUnit = activationUnit;
        a.dependsOnCutAP |= a.getAccessPath().isCutOffApproximation();
        return a;
    }

    public Abstraction deriveNewAbstraction(AccessPath p, Stmt currentStmt) {
        return this.deriveNewAbstraction(p, currentStmt, this.isImplicit);
    }

    public Abstraction deriveDefinitelyNewAbstraction(AccessPath p, Stmt currentStmt) {
        return this.deriveDefinitelyNewAbstraction(p, currentStmt, this.isImplicit);
    }

    public Abstraction deriveDefinitelyNewAbstraction(AccessPath p, Stmt currentStmt, boolean isImplicit) {
        Abstraction abs = this.deriveNewAbstractionMutable(p, currentStmt);
        if (abs == null) {
            return null;
        }
        abs.isImplicit = isImplicit;
        return abs;
    }

    public Abstraction deriveNewAbstraction(AccessPath p, Stmt currentStmt, boolean isImplicit) {
        if (this.accessPath.equals(p) && this.currentStmt == currentStmt && this.isImplicit == isImplicit) {
            return this;
        }
        return this.deriveDefinitelyNewAbstraction(p, currentStmt, isImplicit);
    }

    protected Abstraction deriveNewAbstractionMutable(AccessPath p, Stmt currentStmt) {
        if (p == null) {
            return null;
        }
        if (this.accessPath.equals(p) && this.currentStmt == currentStmt) {
            Abstraction abs = this.clone();
            abs.currentStmt = currentStmt;
            return abs;
        }
        Abstraction abs = new Abstraction(p, this);
        abs.predecessor = this;
        abs.currentStmt = currentStmt;
        abs.propagationPathLength = this.propagationPathLength + 1;
        if (!abs.getAccessPath().isEmpty()) {
            abs.postdominators = null;
        }
        if (!abs.isAbstractionActive()) {
            abs.dependsOnCutAP = abs.dependsOnCutAP || p.isCutOffApproximation();
        }
        abs.sourceContext = null;
        return abs;
    }

    public Abstraction deriveNewAbstractionOnThrow(Stmt throwStmt) {
        Abstraction abs = this.clone();
        abs.currentStmt = throwStmt;
        abs.sourceContext = null;
        abs.exceptionThrown = true;
        return abs;
    }

    public Abstraction deriveNewAbstractionOnCatch(AccessPath ap) {
        assert (this.exceptionThrown);
        Abstraction abs = this.deriveNewAbstractionMutable(ap, null);
        if (abs == null) {
            return null;
        }
        abs.exceptionThrown = false;
        return abs;
    }

    public boolean isAbstractionActive() {
        return this.activationUnit == null;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public String toString() {
        return (this.isAbstractionActive() ? "" : "_") + this.accessPath.toString() + " | " + (this.turnUnit != null || this.activationUnit == null ? "" : this.activationUnit.toString()) + (this.turnUnit == null ? "" : this.turnUnit.toString()) + ">>";
    }

    public AccessPath getAccessPath() {
        return this.accessPath;
    }

    public Unit getActivationUnit() {
        return this.activationUnit;
    }

    public Unit getTurnUnit() {
        return this.turnUnit;
    }

    public Abstraction deriveNewAbstractionWithTurnUnit(Unit turnUnit) {
        if (this.turnUnit == turnUnit) {
            return this;
        }
        Abstraction a = this.clone();
        a.sourceContext = null;
        a.activationUnit = null;
        a.turnUnit = turnUnit;
        return a;
    }

    @Override
    public Abstraction getActiveCopy() {
        if (this.isAbstractionActive()) {
            return this;
        }
        Abstraction a = this.clone();
        a.sourceContext = null;
        a.activationUnit = null;
        return a;
    }

    public boolean getExceptionThrown() {
        return this.exceptionThrown;
    }

    public Abstraction deriveConditionalAbstractionEnter(IInfoflowCFG.UnitContainer postdom, Stmt conditionalUnit) {
        assert (this.isAbstractionActive());
        if (this.postdominators != null && this.postdominators.contains(postdom)) {
            return this;
        }
        Abstraction abs = this.deriveNewAbstractionMutable(AccessPath.getEmptyAccessPath(), conditionalUnit);
        if (abs == null) {
            return null;
        }
        if (abs.postdominators == null) {
            abs.postdominators = Collections.singletonList(postdom);
        } else {
            abs.postdominators.add(0, postdom);
        }
        return abs;
    }

    public Abstraction deriveConditionalAbstractionCall(Unit conditionalCallSite) {
        assert (this.isAbstractionActive());
        assert (conditionalCallSite != null);
        Abstraction abs = this.deriveNewAbstractionMutable(AccessPath.getEmptyAccessPath(), (Stmt)conditionalCallSite);
        if (abs == null) {
            return null;
        }
        abs.postdominators = null;
        return abs;
    }

    public Abstraction dropTopPostdominator() {
        if (this.postdominators == null || this.postdominators.isEmpty()) {
            return this;
        }
        Abstraction abs = this.clone();
        abs.sourceContext = null;
        abs.postdominators.remove(0);
        return abs;
    }

    public IInfoflowCFG.UnitContainer getTopPostdominator() {
        if (this.postdominators == null || this.postdominators.isEmpty()) {
            return null;
        }
        return this.postdominators.get(0);
    }

    public boolean isTopPostdominator(Unit u) {
        IInfoflowCFG.UnitContainer uc = this.getTopPostdominator();
        if (uc == null) {
            return false;
        }
        return uc.getUnit() == u;
    }

    public boolean isTopPostdominator(SootMethod sm) {
        IInfoflowCFG.UnitContainer uc = this.getTopPostdominator();
        if (uc == null) {
            return false;
        }
        return uc.getMethod() == sm;
    }

    public Abstraction deriveNewAbstractionWithDominator(Unit dominator, Stmt stmt) {
        if (this.dominator != null) {
            return this;
        }
        Abstraction abs = this.deriveNewAbstractionMutable(this.accessPath, stmt);
        if (abs == null) {
            return null;
        }
        abs.setDominator(dominator);
        return abs;
    }

    public Abstraction deriveNewAbstractionWithDominator(Unit dominator) {
        return this.deriveNewAbstractionWithDominator(dominator, null);
    }

    public Abstraction deriveConditionalUpdate(Stmt stmt) {
        return this.deriveNewAbstractionMutable(AccessPath.getEmptyAccessPath(), stmt);
    }

    public Abstraction deriveCondition(AccessPath ap, Stmt stmt) {
        Abstraction abs = this.deriveNewAbstractionMutable(ap, stmt);
        if (abs == null) {
            return null;
        }
        abs.turnUnit = stmt;
        abs.dominator = null;
        return abs;
    }

    public Abstraction removeDominator(Stmt stmt) {
        Abstraction abs = this.deriveNewAbstraction(this.accessPath, stmt);
        if (abs == null) {
            return null;
        }
        abs.setDominator(null);
        return abs;
    }

    public void setDominator(Unit dominator) {
        this.dominator = dominator;
    }

    public Unit getDominator() {
        return this.dominator;
    }

    public boolean isDominator(Unit u) {
        if (this.dominator == null) {
            return false;
        }
        return this.dominator == u;
    }

    @Override
    public Abstraction clone() {
        Abstraction abs = new Abstraction(this.accessPath, this);
        abs.predecessor = this;
        abs.neighbors = null;
        abs.currentStmt = null;
        abs.correspondingCallSite = null;
        abs.propagationPathLength = this.propagationPathLength + 1;
        assert (abs.equals(this));
        return abs;
    }

    @Override
    public Abstraction clone(Unit currentUnit, Unit callSite) {
        Abstraction abs = new Abstraction(this.accessPath, this);
        abs.predecessor = this;
        abs.neighbors = null;
        abs.currentStmt = (Stmt)currentUnit;
        abs.correspondingCallSite = (Stmt)callSite;
        abs.propagationPathLength = this.propagationPathLength + 1;
        assert (abs.equals(this));
        return abs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Abstraction other = (Abstraction)obj;
        if (this.hashCode != 0 && other.hashCode != 0 && this.hashCode != other.hashCode) {
            return false;
        }
        if (this.accessPath == null ? other.accessPath != null : !this.accessPath.equals(other.accessPath)) {
            return false;
        }
        return this.localEquals(other);
    }

    public boolean localEquals(Abstraction other) {
        if (this.sourceContext == null ? other.sourceContext != null : !this.sourceContext.equals(other.sourceContext)) {
            return false;
        }
        if (this.activationUnit == null ? other.activationUnit != null : !this.activationUnit.equals((Object)other.activationUnit)) {
            return false;
        }
        if (this.turnUnit == null ? other.turnUnit != null : !this.turnUnit.equals((Object)other.turnUnit)) {
            return false;
        }
        if (this.exceptionThrown != other.exceptionThrown) {
            return false;
        }
        if (this.postdominators == null ? other.postdominators != null : !this.postdominators.equals(other.postdominators)) {
            return false;
        }
        if (this.dominator == null ? other.dominator != null : !this.dominator.equals((Object)other.dominator)) {
            return false;
        }
        if (this.dependsOnCutAP != other.dependsOnCutAP) {
            return false;
        }
        return this.isImplicit == other.isImplicit;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sourceContext == null ? 0 : this.sourceContext.hashCode());
        result = 31 * result + (this.accessPath == null ? 0 : this.accessPath.hashCode());
        result = 31 * result + (this.activationUnit == null ? 0 : this.activationUnit.hashCode());
        result = 31 * result + (this.turnUnit == null ? 0 : this.turnUnit.hashCode());
        result = 31 * result + (this.exceptionThrown ? 1231 : 1237);
        result = 31 * result + (this.postdominators == null ? 0 : this.postdominators.hashCode());
        result = 31 * result + (this.dominator == null ? 0 : this.dominator.hashCode());
        result = 31 * result + (this.dependsOnCutAP ? 1231 : 1237);
        this.hashCode = result = 31 * result + (this.isImplicit ? 1231 : 1237);
        return this.hashCode;
    }

    public boolean entails(Abstraction other) {
        if (this.accessPath == null ? other.accessPath != null : !this.accessPath.entails(other.accessPath)) {
            return false;
        }
        return this.localEquals(other);
    }

    public SourceContext getSourceContext() {
        return this.sourceContext;
    }

    public boolean dependsOnCutAP() {
        return this.dependsOnCutAP;
    }

    @Override
    public Abstraction getPredecessor() {
        return this.predecessor;
    }

    public Set<Abstraction> getNeighbors() {
        return this.neighbors;
    }

    public Stmt getCurrentStmt() {
        return this.currentStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addNeighbor(Abstraction originalAbstraction) {
        if (originalAbstraction == this) {
            return false;
        }
        Abstraction abstraction = this;
        synchronized (abstraction) {
            if (this.neighbors == null) {
                this.neighbors = Sets.newIdentityHashSet();
            }
            return this.neighbors.add(originalAbstraction);
        }
    }

    public void setCorrespondingCallSite(Stmt callSite) {
        this.correspondingCallSite = callSite;
    }

    public Stmt getCorrespondingCallSite() {
        return this.correspondingCallSite;
    }

    public static Abstraction getZeroAbstraction(boolean flowSensitiveAliasing) {
        Abstraction zeroValue = new Abstraction(AccessPath.getZeroAccessPath(), null, false, false);
        Abstraction.flowSensitiveAliasing = flowSensitiveAliasing;
        return zeroValue;
    }

    @Override
    public void setPredecessor(Abstraction predecessor) {
        this.predecessor = predecessor;
        assert (this.predecessor != this);
        this.neighborHashCode = 0;
    }

    public void setSourceContext(SourceContext sourceContext) {
        this.sourceContext = sourceContext;
        this.hashCode = 0;
        this.neighborHashCode = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerPathFlag(int id, int maxSize) {
        if (this.pathFlags == null || this.pathFlags.getLargestInt() < maxSize) {
            Abstraction abstraction = this;
            synchronized (abstraction) {
                if (this.pathFlags == null) {
                    AtomicBitSet pf;
                    this.pathFlags = pf = new AtomicBitSet(maxSize);
                } else if (this.pathFlags.getLargestInt() < maxSize) {
                    AtomicBitSet pf = new AtomicBitSet(maxSize);
                    for (int i = 0; i < this.pathFlags.size(); ++i) {
                        if (!this.pathFlags.get(i)) continue;
                        pf.set(i);
                    }
                    this.pathFlags = pf;
                }
            }
        }
        return this.pathFlags.set(id);
    }

    public Abstraction injectSourceContext(SourceContext sourceContext) {
        if (this.sourceContext != null && this.sourceContext.equals(sourceContext)) {
            return this;
        }
        Abstraction abs = this.clone();
        abs.predecessor = null;
        abs.neighbors = null;
        abs.sourceContext = sourceContext;
        abs.currentStmt = this.currentStmt;
        return abs;
    }

    void setAccessPath(AccessPath accessPath) {
        this.accessPath = accessPath;
        this.hashCode = 0;
        this.neighborHashCode = 0;
    }

    void setCurrentStmt(Stmt currentStmt) {
        this.currentStmt = currentStmt;
    }

    @Override
    public int getNeighborCount() {
        return this.neighbors == null ? 0 : this.neighbors.size();
    }

    @Override
    public int getPathLength() {
        return this.propagationPathLength;
    }
}

