/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.pathBuilders.AbstractAbstractionPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.ConcurrentAbstractionPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.IAbstractionPathBuilder;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.memory.ISolverTerminationReason;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;

public class BatchPathBuilder
extends AbstractAbstractionPathBuilder {
    protected final IAbstractionPathBuilder innerBuilder;
    protected int batchSize = 5;
    protected ISolverTerminationReason terminationReason = null;

    public BatchPathBuilder(InfoflowManager manager, IAbstractionPathBuilder innerBuilder) {
        super(manager);
        this.innerBuilder = innerBuilder;
    }

    @Override
    public void computeTaintPaths(Set<AbstractionAtSink> res) {
        HashSet<AbstractionAtSink> batch = new HashSet<AbstractionAtSink>();
        Iterator<AbstractionAtSink> resIt = res.iterator();
        int batchId = 1;
        while (resIt.hasNext()) {
            while (batch.size() < this.batchSize && resIt.hasNext()) {
                batch.add(resIt.next());
            }
            this.logger.info("Running path reconstruction batch {} with {} elements", (Object)batchId++, (Object)batch.size());
            this.innerBuilder.reset();
            this.innerBuilder.computeTaintPaths(batch);
            this.terminationReason = this.terminationReason == null ? this.innerBuilder.getTerminationReason() : this.terminationReason.combine(this.innerBuilder.getTerminationReason());
            if (this.innerBuilder instanceof ConcurrentAbstractionPathBuilder) {
                ConcurrentAbstractionPathBuilder concurrentBuilder = (ConcurrentAbstractionPathBuilder)this.innerBuilder;
                InterruptableExecutor resultExecutor = concurrentBuilder.getExecutor();
                try {
                    long pathTimeout = this.manager.getConfig().getPathConfiguration().getPathReconstructionTimeout();
                    if (pathTimeout > 0L) {
                        resultExecutor.awaitCompletion(pathTimeout + 20L, TimeUnit.SECONDS);
                    } else {
                        resultExecutor.awaitCompletion();
                    }
                }
                catch (InterruptedException e) {
                    this.logger.error("Could not wait for executor termination", (Throwable)e);
                }
                resultExecutor.reset();
            }
            batch.clear();
        }
    }

    @Override
    public InfoflowResults getResults() {
        return this.innerBuilder.getResults();
    }

    @Override
    public void runIncrementalPathComputation() {
        this.innerBuilder.runIncrementalPathComputation();
    }

    @Override
    public void forceTerminate(ISolverTerminationReason reason) {
        this.innerBuilder.forceTerminate(reason);
    }

    @Override
    public boolean isTerminated() {
        return this.innerBuilder.isTerminated();
    }

    @Override
    public boolean isKilled() {
        return this.innerBuilder.isKilled();
    }

    @Override
    public ISolverTerminationReason getTerminationReason() {
        return this.terminationReason;
    }

    @Override
    public void reset() {
        this.innerBuilder.reset();
    }

    @Override
    public void addStatusListener(IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener) {
        this.innerBuilder.addStatusListener(listener);
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

