/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import java.util.HashSet;
import java.util.Set;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.pathBuilders.AbstractAbstractionPathBuilder;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.memory.ISolverTerminationReason;
import soot.jimple.infoflow.results.BackwardsInfoflowResults;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;

public abstract class ConcurrentAbstractionPathBuilder
extends AbstractAbstractionPathBuilder {
    protected final InfoflowResults results;
    protected final InterruptableExecutor executor;
    private Set<IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification> notificationListeners = new HashSet<IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification>();
    private ISolverTerminationReason killFlag = null;

    public ConcurrentAbstractionPathBuilder(InfoflowManager manager, InterruptableExecutor executor) {
        super(manager);
        this.executor = executor;
        boolean pathAgnostic = manager.getConfig().getPathAgnosticResults();
        InfoflowConfiguration.DataFlowDirection direction = manager.getConfig().getDataFlowDirection();
        this.results = direction == InfoflowConfiguration.DataFlowDirection.Backwards ? new BackwardsInfoflowResults(pathAgnostic) : new InfoflowResults(pathAgnostic);
    }

    protected abstract Runnable getTaintPathTask(AbstractionAtSink var1);

    @Override
    public void computeTaintPaths(Set<AbstractionAtSink> res) {
        if (res == null || res.isEmpty()) {
            return;
        }
        this.logger.info("Obtainted {} connections between sources and sinks", (Object)res.size());
        if (!this.manager.getConfig().getPathAgnosticResults()) {
            this.logger.info("Path-agnostic results are disabled, i.e., there will be one result per path");
        }
        for (IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener : this.notificationListeners) {
            listener.notifySolverStarted(this);
        }
        int curResIdx = 0;
        for (AbstractionAtSink abs : res) {
            this.executor.reset();
            if (this.killFlag != null) {
                res.clear();
                break;
            }
            this.logger.info(String.format("Building path %d...", ++curResIdx));
            Runnable task = this.getTaintPathTask(abs);
            if (task != null) {
                this.executor.execute(task);
            }
            if (this.triggerComputationForNeighbors() && abs.getAbstraction().getNeighbors() != null) {
                for (Abstraction neighbor : abs.getAbstraction().getNeighbors()) {
                    AbstractionAtSink neighborAtSink = new AbstractionAtSink(abs.getSinkDefinitions(), neighbor, abs.getSinkStmt());
                    task = this.getTaintPathTask(neighborAtSink);
                    if (task == null) continue;
                    this.executor.execute(task);
                }
            }
            if (!this.config.getPathConfiguration().getSequentialPathProcessing()) continue;
            try {
                this.executor.awaitCompletion();
                this.executor.reset();
            }
            catch (InterruptedException ex) {
                this.logger.error("Could not wait for path executor completion", (Throwable)ex);
            }
        }
        for (IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener : this.notificationListeners) {
            listener.notifySolverTerminated(this);
        }
    }

    protected abstract boolean triggerComputationForNeighbors();

    @Override
    public void forceTerminate(ISolverTerminationReason reason) {
        this.killFlag = reason;
        this.executor.interrupt();
        this.logger.warn("Path reconstruction terminated due to low memory");
    }

    protected void scheduleDependentTask(Runnable task) {
        if (!this.isKilled()) {
            this.executor.execute(task);
        }
    }

    @Override
    public InfoflowResults getResults() {
        return this.results;
    }

    @Override
    public boolean isTerminated() {
        return this.killFlag != null || this.executor.isFinished();
    }

    @Override
    public boolean isKilled() {
        return this.killFlag != null;
    }

    @Override
    public void reset() {
        this.killFlag = null;
    }

    @Override
    public ISolverTerminationReason getTerminationReason() {
        return this.killFlag;
    }

    @Override
    public void addStatusListener(IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener) {
        this.notificationListeners.add(listener);
    }

    InterruptableExecutor getExecutor() {
        return this.executor;
    }
}

