/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.pathBuilders.ConcurrentAbstractionPathBuilder;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;

public class ContextInsensitiveSourceFinder
extends ConcurrentAbstractionPathBuilder {
    private int lastTaskId = 0;
    private int numTasks = 0;

    public ContextInsensitiveSourceFinder(InfoflowManager manager, InterruptableExecutor executor) {
        this(manager, executor, -1);
    }

    public ContextInsensitiveSourceFinder(InfoflowManager manager, InterruptableExecutor executor, int numTasks) {
        super(manager, executor);
        this.numTasks = numTasks;
    }

    @Override
    protected boolean triggerComputationForNeighbors() {
        return false;
    }

    @Override
    protected Runnable getTaintPathTask(AbstractionAtSink abs) {
        return new SourceFindingTask(this.lastTaskId++, abs, abs.getAbstraction());
    }

    @Override
    public void runIncrementalPathComputation() {
    }

    @Override
    public void computeTaintPaths(Set<AbstractionAtSink> res) {
        this.numTasks = this.numTasks < 0 ? res.size() : (this.numTasks += res.size());
        super.computeTaintPaths(res);
    }

    private class SourceFindingTask
    implements Runnable {
        private final int taskId;
        private final AbstractionAtSink flagAbs;
        private final Deque<Abstraction> abstractionQueue = new ArrayDeque<Abstraction>();

        public SourceFindingTask(int taskId, AbstractionAtSink flagAbs, Abstraction abstraction) {
            this.taskId = taskId;
            this.flagAbs = flagAbs;
            this.abstractionQueue.add(abstraction);
            abstraction.registerPathFlag(taskId, ContextInsensitiveSourceFinder.this.numTasks);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block0: while (true) {
                if (ContextInsensitiveSourceFinder.this.isKilled()) {
                    this.abstractionQueue.clear();
                    return;
                }
                abstraction = this.abstractionQueue.poll();
                if (abstraction == null) break;
                if (abstraction.getSourceContext() != null) {
                    ContextInsensitiveSourceFinder.this.results.addResult(this.flagAbs.getSinkDefinitions(), this.flagAbs.getAbstraction().getAccessPath(), this.flagAbs.getSinkStmt(), abstraction.getSourceContext().getDefinitions(), abstraction.getSourceContext().getAccessPath(), abstraction.getSourceContext().getStmt(), abstraction.getSourceContext().getUserData(), null, ContextInsensitiveSourceFinder.this.manager);
                    if (!SourceFindingTask.$assertionsDisabled && abstraction.getPredecessor() != null) {
                        throw new AssertionError();
                    }
                } else if (abstraction.getPredecessor().registerPathFlag(this.taskId, ContextInsensitiveSourceFinder.access$000(ContextInsensitiveSourceFinder.this))) {
                    this.abstractionQueue.add(abstraction.getPredecessor());
                }
                if (abstraction.getNeighbors() == null) continue;
                var2_2 = abstraction.getNeighbors().iterator();
                while (true) {
                    if (var2_2.hasNext()) ** break;
                    continue block0;
                    nb = var2_2.next();
                    if (!nb.registerPathFlag(this.taskId, ContextInsensitiveSourceFinder.access$000(ContextInsensitiveSourceFinder.this))) continue;
                    this.abstractionQueue.add(nb);
                }
                break;
            }
        }
    }
}

