/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.entryPointCreators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LocalGenerator;
import soot.LongType;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.DoubleConstant;
import soot.jimple.EqExpr;
import soot.jimple.FloatConstant;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LongConstant;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.tagkit.Tag;

public abstract class BaseEntryPointCreator
implements IEntryPointCreator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<SootClass, Local> localVarsForClasses = new HashMap<SootClass, Local>();
    private final Set<SootClass> failedClasses = new HashSet<SootClass>();
    private boolean substituteCallParams = false;
    private List<String> substituteClasses;
    private boolean allowSelfReferences = false;
    private boolean ignoreSystemClassParams = true;
    private boolean allowNonPublicConstructors = false;
    private final Set<SootMethod> failedMethods = new HashSet<SootMethod>();
    protected String dummyClassName = "dummyMainClass";
    protected String dummyMethodName = "dummyMainMethod";
    protected boolean shallowMode = false;
    protected boolean overwriteDummyMainMethod = false;
    protected boolean warnOnConstructorLoop = false;
    protected Value intCounter;
    protected int conditionCounter;
    protected SootMethod mainMethod = null;
    protected Body body = null;
    protected LocalGenerator generator = null;

    public Set<SootClass> getFailedClasses() {
        return new HashSet<SootClass>(this.failedClasses);
    }

    public Set<SootMethod> getFailedMethods() {
        return new HashSet<SootMethod>(this.failedMethods);
    }

    @Override
    public void setSubstituteCallParams(boolean b) {
        this.substituteCallParams = b;
    }

    @Override
    public void setSubstituteClasses(List<String> l) {
        this.substituteClasses = l;
    }

    @Override
    public SootMethod createDummyMain() {
        if (this.substituteCallParams) {
            for (String className : this.substituteClasses) {
                Scene.v().forceResolve(className, 3).setApplicationClass();
            }
        }
        this.createAdditionalFields();
        this.createAdditionalMethods();
        this.createEmptyMainMethod();
        this.body = this.mainMethod.getActiveBody();
        Body body = this.mainMethod.getActiveBody();
        this.generator = Scene.v().createLocalGenerator(body);
        this.conditionCounter = 0;
        this.intCounter = this.generator.generateLocal((Type)IntType.v());
        body.getUnits().add((Unit)Jimple.v().newAssignStmt(this.intCounter, (Value)IntConstant.v((int)this.conditionCounter)));
        SootMethod m = this.createDummyMainInternal();
        m.addTag((Tag)SimulatedCodeElementTag.TAG);
        return m;
    }

    protected abstract SootMethod createDummyMainInternal();

    protected SootClass getOrCreateDummyMainClass() {
        SootClass mainClass = Scene.v().getSootClassUnsafe(this.dummyClassName);
        if (mainClass == null) {
            mainClass = Scene.v().makeSootClass(this.dummyClassName);
            mainClass.setResolvingLevel(3);
            Scene.v().addClass(mainClass);
        }
        return mainClass;
    }

    protected void createEmptyMainMethod() {
        int methodIndex = 0;
        String methodName = this.dummyMethodName;
        SootClass mainClass = this.getOrCreateDummyMainClass();
        if (!this.overwriteDummyMainMethod) {
            while (mainClass.declaresMethodByName(methodName)) {
                methodName = this.dummyMethodName + "_" + methodIndex++;
            }
        }
        ArrayType stringArrayType = ArrayType.v((Type)RefType.v((String)"java.lang.String"), (int)1);
        this.mainMethod = mainClass.getMethodByNameUnsafe(methodName);
        if (this.mainMethod != null) {
            mainClass.removeMethod(this.mainMethod);
            this.mainMethod = null;
        }
        this.mainMethod = Scene.v().makeSootMethod(methodName, Collections.singletonList(stringArrayType), (Type)VoidType.v());
        JimpleBody body = Jimple.v().newBody();
        body.setMethod(this.mainMethod);
        this.mainMethod.setActiveBody((Body)body);
        mainClass.addMethod(this.mainMethod);
        mainClass.setApplicationClass();
        this.mainMethod.setModifiers(9);
        LocalGenerator lg = Scene.v().createLocalGenerator((Body)body);
        Local paramLocal = lg.generateLocal((Type)stringArrayType);
        body.getUnits().addFirst((Unit)Jimple.v().newIdentityStmt((Value)paramLocal, (Value)Jimple.v().newParameterRef((Type)stringArrayType, 0)));
    }

    protected void createAdditionalFields() {
    }

    protected void createAdditionalMethods() {
    }

    protected String getNonCollidingFieldName(String baseName) {
        String fieldName = baseName;
        int fieldIdx = 0;
        SootClass mainClass = this.getOrCreateDummyMainClass();
        while (mainClass.declaresFieldByName(fieldName)) {
            fieldName = baseName + "_" + fieldIdx++;
        }
        return fieldName;
    }

    protected Stmt buildMethodCall(SootMethod methodToCall, Local classLocal) {
        return this.buildMethodCall(methodToCall, classLocal, Collections.emptySet());
    }

    protected Stmt buildMethodCall(SootMethod methodToCall, Local classLocal, Set<SootClass> parentClasses) {
        InvokeStmt stmt;
        Object invokeExpr;
        if (methodToCall == null) {
            return null;
        }
        if (classLocal == null && !methodToCall.isStatic()) {
            this.logger.warn("Cannot call method {}, because there is no local for base object: {}", (Object)methodToCall, (Object)methodToCall.getDeclaringClass());
            this.failedMethods.add(methodToCall);
            return null;
        }
        Jimple jimple = Jimple.v();
        LinkedList<Value> args = new LinkedList<Value>();
        if (methodToCall.getParameterCount() > 0) {
            for (Type tp : methodToCall.getParameterTypes()) {
                HashSet<SootClass> constructionStack = new HashSet<SootClass>();
                if (!this.allowSelfReferences) {
                    constructionStack.add(methodToCall.getDeclaringClass());
                }
                args.add(this.getValueForType(tp, constructionStack, parentClasses));
            }
            if (methodToCall.isStatic()) {
                invokeExpr = jimple.newStaticInvokeExpr(methodToCall.makeRef(), args);
            } else {
                assert (classLocal != null) : "Class local method was null for non-static method call";
                invokeExpr = methodToCall.isConstructor() ? jimple.newSpecialInvokeExpr(classLocal, methodToCall.makeRef(), args) : (methodToCall.getDeclaringClass().isInterface() ? jimple.newInterfaceInvokeExpr(classLocal, methodToCall.makeRef(), args) : jimple.newVirtualInvokeExpr(classLocal, methodToCall.makeRef(), args));
            }
        } else if (methodToCall.isStatic()) {
            invokeExpr = jimple.newStaticInvokeExpr(methodToCall.makeRef());
        } else {
            assert (classLocal != null) : "Class local method was null for non-static method call";
            invokeExpr = methodToCall.isConstructor() ? jimple.newSpecialInvokeExpr(classLocal, methodToCall.makeRef()) : (methodToCall.getDeclaringClass().isInterface() ? jimple.newInterfaceInvokeExpr(classLocal, methodToCall.makeRef(), args) : jimple.newVirtualInvokeExpr(classLocal, methodToCall.makeRef()));
        }
        if (!(methodToCall.getReturnType() instanceof VoidType)) {
            Local returnLocal = this.generator.generateLocal(methodToCall.getReturnType());
            stmt = jimple.newAssignStmt((Value)returnLocal, (Value)invokeExpr);
        } else {
            stmt = jimple.newInvokeStmt((Value)invokeExpr);
        }
        this.body.getUnits().add((Unit)stmt);
        for (Value val : args) {
            if (!(val instanceof Local) || !(val.getType() instanceof RefType) || parentClasses.contains(((RefType)val.getType()).getSootClass())) continue;
            this.body.getUnits().add((Unit)jimple.newAssignStmt(val, (Value)NullConstant.v()));
            this.localVarsForClasses.remove(((RefType)val.getType()).getSootClass());
        }
        return stmt;
    }

    protected Value getValueForType(Type tp, Set<SootClass> constructionStack, Set<SootClass> parentClasses) {
        return this.getValueForType(tp, constructionStack, parentClasses, null, false);
    }

    protected Value getValueForType(Type tp, Set<SootClass> constructionStack, Set<SootClass> parentClasses, Set<Local> generatedLocals, boolean ignoreExcludes) {
        if (BaseEntryPointCreator.isSimpleType(tp)) {
            return this.getSimpleDefaultValue(tp);
        }
        if (tp instanceof RefType) {
            SootClass classToType = ((RefType)tp).getSootClass();
            if (classToType != null) {
                if (parentClasses != null && !parentClasses.isEmpty()) {
                    for (SootClass parent : parentClasses) {
                        Value val;
                        if (!this.isCompatible(parent, classToType) || (val = (Value)this.localVarsForClasses.get(parent)) == null) continue;
                        return val;
                    }
                }
                if (!ignoreExcludes && this.ignoreSystemClassParams && SystemClassHandler.v().isClassInSystemPackage(classToType.getName())) {
                    return NullConstant.v();
                }
                Local val = this.generateClassConstructor(classToType, constructionStack, parentClasses, generatedLocals);
                if (val == null) {
                    return NullConstant.v();
                }
                if (generatedLocals != null && val instanceof Local) {
                    generatedLocals.add(val);
                }
                return val;
            }
        } else {
            if (tp instanceof ArrayType) {
                Value arrVal = this.buildArrayOfType((ArrayType)tp, constructionStack, parentClasses, generatedLocals);
                if (arrVal == null) {
                    this.logger.warn("Array parameter substituted by null");
                    return NullConstant.v();
                }
                return arrVal;
            }
            this.logger.warn("Unsupported parameter type: {}", (Object)tp.toString());
            return null;
        }
        throw new RuntimeException("Should never see me");
    }

    private Value buildArrayOfType(ArrayType tp, Set<SootClass> constructionStack, Set<SootClass> parentClasses, Set<Local> generatedLocals) {
        Value singleElement = this.getValueForType(tp.getElementType(), constructionStack, parentClasses);
        Local local = this.generator.generateLocal((Type)tp);
        NewArrayExpr newArrayExpr = Jimple.v().newNewArrayExpr(tp.getElementType(), (Value)IntConstant.v((int)1));
        AssignStmt assignArray = Jimple.v().newAssignStmt((Value)local, (Value)newArrayExpr);
        this.body.getUnits().add((Unit)assignArray);
        AssignStmt assign = Jimple.v().newAssignStmt((Value)Jimple.v().newArrayRef((Value)local, (Value)IntConstant.v((int)0)), singleElement);
        this.body.getUnits().add((Unit)assign);
        return local;
    }

    protected Local generateClassConstructor(SootClass createdClass) {
        return this.generateClassConstructor(createdClass, new HashSet<SootClass>(), Collections.emptySet(), null);
    }

    protected Local generateClassConstructor(SootClass createdClass, Set<SootClass> parentClasses) {
        return this.generateClassConstructor(createdClass, new HashSet<SootClass>(), parentClasses, null);
    }

    protected boolean acceptClass(SootClass clazz) {
        if (!clazz.getName().equals("android.view.View") && (clazz.isPhantom() || clazz.isPhantomClass())) {
            this.logger.warn("Cannot generate constructor for phantom class {}", (Object)clazz.getName());
            return false;
        }
        return true;
    }

    protected Local generateClassConstructor(SootClass createdClass, Set<SootClass> constructionStack, Set<SootClass> parentClasses, Set<Local> tempLocals) {
        SootClass outerClass;
        if (createdClass == null || this.failedClasses.contains(createdClass)) {
            return null;
        }
        Local existingLocal = this.localVarsForClasses.get(createdClass);
        if (existingLocal != null) {
            return existingLocal;
        }
        if (!this.acceptClass(createdClass)) {
            this.failedClasses.add(createdClass);
            return null;
        }
        Jimple jimple = Jimple.v();
        if (BaseEntryPointCreator.isSimpleType((Type)createdClass.getType())) {
            Local varLocal = this.generator.generateLocal((Type)createdClass.getType());
            AssignStmt aStmt = jimple.newAssignStmt((Value)varLocal, this.getSimpleDefaultValue((Type)createdClass.getType()));
            this.body.getUnits().add((Unit)aStmt);
            return varLocal;
        }
        boolean isInnerClass = createdClass.getName().contains("$");
        SootClass sootClass = outerClass = isInnerClass ? Scene.v().getSootClassUnsafe(createdClass.getName().substring(0, createdClass.getName().lastIndexOf("$"))) : null;
        if (constructionStack != null && !constructionStack.add(createdClass)) {
            if (this.warnOnConstructorLoop) {
                this.logger.warn("Ran into a constructor generation loop for class " + createdClass + ", substituting with null...");
            }
            Local tempLocal = this.generator.generateLocal((Type)RefType.v((SootClass)createdClass));
            AssignStmt assignStmt = jimple.newAssignStmt((Value)tempLocal, (Value)NullConstant.v());
            this.body.getUnits().add((Unit)assignStmt);
            return tempLocal;
        }
        if (createdClass.isInterface() || createdClass.isAbstract()) {
            return this.generateSubstitutedClassConstructor(createdClass, constructionStack, parentClasses);
        }
        ArrayList<SootMethod> constructors = new ArrayList<SootMethod>();
        for (SootMethod currentMethod : createdClass.getMethods()) {
            if (!currentMethod.isConstructor() || !this.allowNonPublicConstructors && (currentMethod.isPrivate() || currentMethod.isProtected())) continue;
            constructors.add(currentMethod);
        }
        Collections.sort(constructors, new Comparator<SootMethod>(){

            @Override
            public int compare(SootMethod o1, SootMethod o2) {
                if ((o1.isPrivate() || o1.isProtected()) != (o2.isPrivate() || o2.isProtected())) {
                    return o1.isPrivate() || o1.isProtected() ? 1 : -1;
                }
                if (o1.getParameterCount() == o2.getParameterCount()) {
                    int i;
                    int o1Prims = 0;
                    int o2Prims = 0;
                    for (i = 0; i < o1.getParameterCount(); ++i) {
                        if (!(o1.getParameterType(i) instanceof PrimType)) continue;
                        ++o1Prims;
                    }
                    for (i = 0; i < o2.getParameterCount(); ++i) {
                        if (!(o2.getParameterType(i) instanceof PrimType)) continue;
                        ++o2Prims;
                    }
                    return o1Prims - o2Prims;
                }
                return o1.getParameterCount() - o2.getParameterCount();
            }
        });
        if (!constructors.isEmpty()) {
            SootMethod currentMethod = (SootMethod)constructors.remove(0);
            LinkedList<Object> params = new LinkedList<Object>();
            for (Type type : currentMethod.getParameterTypes()) {
                SootClass typeClass;
                HashSet<SootClass> newStack = new HashSet<SootClass>(constructionStack == null ? Collections.emptySet() : constructionStack);
                SootClass sootClass2 = typeClass = type instanceof RefType ? ((RefType)type).getSootClass() : null;
                if (typeClass != null && isInnerClass && typeClass == outerClass && this.localVarsForClasses.containsKey(outerClass)) {
                    params.add((Value)this.localVarsForClasses.get(outerClass));
                    continue;
                }
                if (this.shallowMode) {
                    if (BaseEntryPointCreator.isSimpleType(type)) {
                        params.add(this.getSimpleDefaultValue(type));
                        continue;
                    }
                    params.add(NullConstant.v());
                    continue;
                }
                Value val = this.getValueForType(type, newStack, parentClasses, tempLocals, false);
                params.add(val);
            }
            NewExpr newExpr = jimple.newNewExpr(RefType.v((SootClass)createdClass));
            Local tempLocal = this.generator.generateLocal((Type)RefType.v((SootClass)createdClass));
            AssignStmt assignStmt = jimple.newAssignStmt((Value)tempLocal, (Value)newExpr);
            this.body.getUnits().add((Unit)assignStmt);
            SpecialInvokeExpr vInvokeExpr = params.isEmpty() || params.contains(null) ? jimple.newSpecialInvokeExpr(tempLocal, currentMethod.makeRef()) : jimple.newSpecialInvokeExpr(tempLocal, currentMethod.makeRef(), params);
            this.body.getUnits().add((Unit)jimple.newInvokeStmt((Value)vInvokeExpr));
            if (tempLocals != null) {
                tempLocals.add(tempLocal);
            }
            return tempLocal;
        }
        this.failedClasses.add(createdClass);
        return null;
    }

    private Local generateSubstitutedClassConstructor(SootClass createdClass, Set<SootClass> constructionStack, Set<SootClass> parentClasses) {
        if (!this.substituteCallParams) {
            this.logger.warn("Cannot create valid constructor for {}, because it is {} and cannot substitute with subclass", (Object)createdClass, (Object)(createdClass.isInterface() ? "an interface" : (createdClass.isAbstract() ? "abstract" : "")));
            this.failedClasses.add(createdClass);
            return null;
        }
        List classes = createdClass.isInterface() ? Scene.v().getActiveHierarchy().getImplementersOf(createdClass) : Scene.v().getActiveHierarchy().getSubclassesOf(createdClass);
        for (SootClass sClass : classes) {
            Local cons;
            if (!this.substituteClasses.contains(sClass.toString()) || (cons = this.generateClassConstructor(sClass, constructionStack, parentClasses, null)) == null) continue;
            return cons;
        }
        this.logger.warn("Cannot create valid constructor for {}, because it is {} and cannot substitute with subclass", (Object)createdClass, (Object)(createdClass.isInterface() ? "an interface" : (createdClass.isAbstract() ? "abstract" : "")));
        this.failedClasses.add(createdClass);
        return null;
    }

    protected static boolean isSimpleType(Type t) {
        RefType rt;
        if (t instanceof PrimType) {
            return true;
        }
        return t instanceof RefType && (rt = (RefType)t).getSootClass().getName().equals("java.lang.String");
    }

    protected Value getSimpleDefaultValue(Type t) {
        if (t == RefType.v((String)"java.lang.String")) {
            return StringConstant.v((String)"");
        }
        if (t instanceof CharType) {
            return IntConstant.v((int)0);
        }
        if (t instanceof ByteType) {
            return IntConstant.v((int)0);
        }
        if (t instanceof ShortType) {
            return IntConstant.v((int)0);
        }
        if (t instanceof IntType) {
            return IntConstant.v((int)0);
        }
        if (t instanceof FloatType) {
            return FloatConstant.v((float)0.0f);
        }
        if (t instanceof LongType) {
            return LongConstant.v((long)0L);
        }
        if (t instanceof DoubleType) {
            return DoubleConstant.v((double)0.0);
        }
        if (t instanceof BooleanType) {
            return IntConstant.v((int)0);
        }
        return NullConstant.v();
    }

    protected SootMethod findMethod(SootClass currentClass, String subsignature) {
        SootMethod m = currentClass.getMethodUnsafe(subsignature);
        if (m != null) {
            return m;
        }
        if (currentClass.hasSuperclass()) {
            return this.findMethod(currentClass.getSuperclass(), subsignature);
        }
        return null;
    }

    protected boolean isCompatible(SootClass actual, SootClass expected) {
        return Scene.v().getOrMakeFastHierarchy().canStoreType((Type)actual.getType(), (Type)expected.getType());
    }

    protected void eliminateSelfLoops() {
        Iterator unitIt = this.body.getUnits().iterator();
        while (unitIt.hasNext()) {
            IfStmt ifStmt;
            Unit u = (Unit)unitIt.next();
            if (!(u instanceof IfStmt) || (ifStmt = (IfStmt)u).getTarget() != ifStmt) continue;
            unitIt.remove();
        }
    }

    public void setDummyClassName(String dummyClassName) {
        this.dummyClassName = dummyClassName;
    }

    public void setDummyMethodName(String dummyMethodName) {
        this.dummyMethodName = dummyMethodName;
    }

    public void setAllowSelfReferences(boolean value) {
        this.allowSelfReferences = value;
    }

    public void setShallowMode(boolean shallowMode) {
        this.shallowMode = shallowMode;
    }

    public boolean getShallowMode() {
        return this.shallowMode;
    }

    public void setIgnoreSystemClassParams(boolean ignoreSystemClassParams) {
        this.ignoreSystemClassParams = ignoreSystemClassParams;
    }

    public void setAllowNonPublicConstructors(boolean allowNonPublicConstructors) {
        this.allowNonPublicConstructors = allowNonPublicConstructors;
    }

    public void setOverwriteDummyMainMethod(boolean overwriteDummyMainValue) {
        this.overwriteDummyMainMethod = overwriteDummyMainValue;
    }

    public boolean getOverwriteDummyMainMethod() {
        return this.overwriteDummyMainMethod;
    }

    public void setWarnOnConstructorLoop(boolean warnOnConstructorLoop) {
        this.warnOnConstructorLoop = warnOnConstructorLoop;
    }

    public boolean getWarnOnConstructorLoop() {
        return this.warnOnConstructorLoop;
    }

    protected void reset() {
        this.localVarsForClasses.clear();
        this.conditionCounter = 0;
    }

    protected void createIfStmt(Unit target) {
        if (target == null) {
            return;
        }
        Jimple jimple = Jimple.v();
        EqExpr cond = jimple.newEqExpr(this.intCounter, (Value)IntConstant.v((int)this.conditionCounter++));
        IfStmt ifStmt = jimple.newIfStmt((Value)cond, target);
        this.body.getUnits().add((Unit)ifStmt);
    }

    @Override
    public SootMethod getGeneratedMainMethod() {
        return this.mainMethod;
    }
}

