/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.memory;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.util.ThreadUtils;

public class MemoryWarningSystem {
    private static final Logger logger = LoggerFactory.getLogger(MemoryWarningSystem.class);
    private static final MemoryPoolMXBean tenuredGenPool = MemoryWarningSystem.findTenuredGenPool();
    private final Set<OnMemoryThresholdReached> listeners = new HashSet<OnMemoryThresholdReached>();
    private static final NotificationListener memoryListener;
    private boolean isClosed = false;
    private long threshold;
    private static Thread thrLowMemoryWarningThread;
    private static TreeSet<MemoryWarningSystem> warningSystems;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long triggerNotification() {
        long maxMemory = tenuredGenPool.getUsage().getMax();
        long usedMemory = tenuredGenPool.getUsage().getUsed();
        Runtime runtime = Runtime.getRuntime();
        long usedMem = runtime.totalMemory() - runtime.freeMemory();
        TreeSet<MemoryWarningSystem> treeSet = warningSystems;
        synchronized (treeSet) {
            Iterator<MemoryWarningSystem> it = warningSystems.iterator();
            while (it.hasNext()) {
                MemoryWarningSystem ws = it.next();
                if (ws.threshold <= usedMemory) {
                    logger.info("Triggering memory warning at " + usedMem / 1000L / 1000L + " MB (" + maxMemory / 1000L / 1000L + " MB max, " + usedMemory / 1000L / 1000L + " in watched memory pool)...");
                    for (OnMemoryThresholdReached listener : ws.listeners) {
                        listener.onThresholdReached(usedMemory, maxMemory);
                    }
                    it.remove();
                    continue;
                }
                tenuredGenPool.setUsageThreshold(ws.threshold);
                return ws.threshold;
            }
            return -1L;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void addListener(OnMemoryThresholdReached listener) {
        this.listeners.add(listener);
    }

    public static MemoryPoolMXBean findTenuredGenPool() {
        ArrayList<MemoryPoolMXBean> usablePools = new ArrayList<MemoryPoolMXBean>();
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            usablePools.add(pool);
            if (!pool.getName().equals("Tenured Gen")) continue;
            return pool;
        }
        if (!usablePools.isEmpty()) {
            return (MemoryPoolMXBean)usablePools.get(0);
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWarningThreshold(double percentage) {
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Percentage not in range");
        }
        long maxMemory = tenuredGenPool.getUsage().getMax();
        long warningThreshold = (long)((double)maxMemory * percentage);
        TreeSet<MemoryWarningSystem> treeSet = warningSystems;
        synchronized (treeSet) {
            boolean useOwnImplementation;
            warningSystems.remove(this);
            this.threshold = warningThreshold;
            logger.info(MessageFormat.format("Registered a memory warning system for {0} MiB", (double)this.threshold / 1024.0 / 1024.0));
            warningSystems.add(this);
            MemoryUsage usage = tenuredGenPool.getUsage();
            long threshold = MemoryWarningSystem.warningSystems.iterator().next().threshold;
            boolean bl = useOwnImplementation = !tenuredGenPool.isUsageThresholdSupported();
            if (!useOwnImplementation && usage != null && usage.getUsed() > threshold) {
                tenuredGenPool.setUsageThreshold(threshold);
            } else {
                useOwnImplementation = true;
            }
            if (useOwnImplementation && thrLowMemoryWarningThread == null) {
                thrLowMemoryWarningThread = ThreadUtils.createGenericThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            long missing;
                            MemoryWarningSystem l;
                            TreeSet treeSet = warningSystems;
                            synchronized (treeSet) {
                                if (warningSystems.isEmpty()) {
                                    thrLowMemoryWarningThread = null;
                                    return;
                                }
                                l = (MemoryWarningSystem)warningSystems.iterator().next();
                            }
                            long nextThreshold = l.threshold;
                            MemoryUsage usage = tenuredGenPool.getUsage();
                            if (usage == null) {
                                logger.warn(MessageFormat.format("Memory usage of {0} could not be estimated", tenuredGenPool.getName()));
                                return;
                            }
                            long used = usage.getUsed();
                            if (used >= l.threshold && (nextThreshold = MemoryWarningSystem.triggerNotification()) == -1L) {
                                TreeSet treeSet2 = warningSystems;
                                synchronized (treeSet2) {
                                    if (warningSystems.isEmpty()) {
                                        thrLowMemoryWarningThread = null;
                                        return;
                                    }
                                }
                            }
                            if ((missing = nextThreshold - (used = usage.getUsed())) <= 0L) continue;
                            try {
                                long wait = (long)((double)missing / (double)tenuredGenPool.getUsage().getMax() * 500.0);
                                Thread.sleep(wait);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                    }
                }, "Low memory monitor", true);
                thrLowMemoryWarningThread.setPriority(1);
                thrLowMemoryWarningThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed) {
            return;
        }
        logger.info("Shutting down the memory warning system...");
        TreeSet<MemoryWarningSystem> treeSet = warningSystems;
        synchronized (treeSet) {
            warningSystems.remove(this);
        }
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        try {
            ((NotificationEmitter)((Object)memoryBean)).removeNotificationListener(memoryListener);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
        this.isClosed = true;
    }

    static {
        warningSystems = new TreeSet<MemoryWarningSystem>(new Comparator<MemoryWarningSystem>(){

            @Override
            public int compare(MemoryWarningSystem o1, MemoryWarningSystem o2) {
                return Long.compare(o1.threshold, o2.threshold);
            }
        });
        memoryListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                if (notification.getType().equals("java.management.memory.threshold.exceeded")) {
                    MemoryWarningSystem.triggerNotification();
                }
            }
        };
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        ((NotificationEmitter)((Object)memoryBean)).addNotificationListener(memoryListener, new NotificationFilter(){
            private static final long serialVersionUID = -3755179266517545663L;

            @Override
            public boolean isNotificationEnabled(Notification notification) {
                return notification.getType().equals("java.management.memory.threshold.exceeded");
            }
        }, null);
    }

    public static interface OnMemoryThresholdReached {
        public void onThresholdReached(long var1, long var3);
    }
}

