/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.nativeCallHandler;

import java.util.Collections;
import java.util.Set;
import soot.Local;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.nativeCallHandler.AbstractNativeCallHandler;

public class DefaultNativeCallHandler
extends AbstractNativeCallHandler {
    private static final String SIG_ARRAYCOPY = "<java.lang.System: void arraycopy(java.lang.Object,int,java.lang.Object,int,int)>";
    private static final String SIG_NEW_ARRAY = "<java.lang.reflect.Array: java.lang.Object newArray(java.lang.Class,int)>";
    private static final String SIG_COMPARE_AND_SWAP_OBJECT = "<sun.misc.Unsafe: boolean compareAndSwapObject(java.lang.Object,long,java.lang.Object,java.lang.Object)>";

    @Override
    public Set<Abstraction> getTaintedValues(Stmt call, Abstraction source, Value[] params) {
        if (source.isAbstractionActive()) {
            Local taintedValue = source.getAccessPath().getPlainValue();
            switch (call.getInvokeExpr().getMethodRef().getSignature()) {
                case "<java.lang.System: void arraycopy(java.lang.Object,int,java.lang.Object,int,int)>": {
                    if (!params[0].equals((Object)taintedValue) || !this.manager.getTypeUtils().checkCast(source.getAccessPath(), params[2].getType())) break;
                    AccessPath ap = this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), params[2], source.getAccessPath().getBaseType(), false);
                    Abstraction abs = source.deriveNewAbstraction(ap, call);
                    abs.setCorrespondingCallSite(call);
                    return Collections.singleton(abs);
                }
                case "<java.lang.reflect.Array: java.lang.Object newArray(java.lang.Class,int)>": {
                    if (!params[1].equals((Object)taintedValue) || !(call instanceof DefinitionStmt)) break;
                    DefinitionStmt defStmt = (DefinitionStmt)call;
                    if (!this.manager.getTypeUtils().checkCast(source.getAccessPath(), params[1].getType())) break;
                    AccessPath ap = this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), defStmt.getLeftOp(), null, false, true, AccessPath.ArrayTaintType.Length);
                    Abstraction abs = source.deriveNewAbstraction(ap, call);
                    abs.setCorrespondingCallSite(call);
                    return Collections.singleton(abs);
                }
                case "<sun.misc.Unsafe: boolean compareAndSwapObject(java.lang.Object,long,java.lang.Object,java.lang.Object)>": {
                    if (!params[3].equals((Object)taintedValue) || !this.manager.getTypeUtils().checkCast(source.getAccessPath(), params[3].getType())) break;
                    AccessPath ap = this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), params[0], null, false, true, AccessPath.ArrayTaintType.Length);
                    Abstraction abs = source.deriveNewAbstraction(ap, call);
                    abs.setCorrespondingCallSite(call);
                    return Collections.singleton(abs);
                }
            }
        }
        return null;
    }

    @Override
    public boolean supportsCall(Stmt call) {
        String sig;
        if (!call.containsInvokeExpr()) {
            return false;
        }
        switch (sig = call.getInvokeExpr().getMethod().getSignature()) {
            case "<java.lang.System: void arraycopy(java.lang.Object,int,java.lang.Object,int,int)>": 
            case "<sun.misc.Unsafe: boolean compareAndSwapObject(java.lang.Object,long,java.lang.Object,java.lang.Object)>": 
            case "<java.lang.reflect.Array: java.lang.Object newArray(java.lang.Class,int)>": {
                return true;
            }
        }
        return false;
    }
}

