/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.FlowFunction;
import heros.FlowFunctions;
import heros.flowfunc.Identity;
import heros.flowfunc.KillAll;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.ArrayType;
import soot.Local;
import soot.PrimType;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.UnopExpr;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.callmappers.CallerCalleeManager;
import soot.jimple.infoflow.callmappers.ICallerCalleeArgumentMapper;
import soot.jimple.infoflow.collect.MutableTwoElementSet;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.problems.rules.EmptyPropagationRuleManagerFactory;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.infoflow.util.BaseSelector;

public class AliasProblem
extends AbstractInfoflowProblem {
    @Override
    public void setTaintWrapper(ITaintPropagationWrapper wrapper) {
        this.taintWrapper = wrapper;
    }

    public AliasProblem(InfoflowManager manager) {
        super(manager, null, EmptyPropagationRuleManagerFactory.INSTANCE);
    }

    public FlowFunctions<Unit, Abstraction, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, Abstraction, SootMethod>(){

            private Abstraction checkAbstraction(Abstraction abs) {
                if (abs == null) {
                    return null;
                }
                if (!abs.getAccessPath().isStaticFieldRef() ? abs.getAccessPath().getBaseType() instanceof PrimType : abs.getAccessPath().getFirstFieldType() instanceof PrimType) {
                    return null;
                }
                return abs;
            }

            private Set<Abstraction> computeAliases(DefinitionStmt defStmt, Value leftValue, Abstraction d1, Abstraction source) {
                boolean aliasOverwritten;
                assert (!source.getAccessPath().isEmpty());
                if (source == AliasProblem.this.getZeroValue()) {
                    return null;
                }
                MutableTwoElementSet<Abstraction> res = new MutableTwoElementSet<Abstraction>();
                if (defStmt instanceof IdentityStmt) {
                    res.add(source);
                    return res;
                }
                if (!(defStmt instanceof AssignStmt)) {
                    return res;
                }
                boolean leftSideMatches = Aliasing.baseMatches(leftValue, source);
                if (!leftSideMatches) {
                    res.add(source);
                }
                Value rightValue = BaseSelector.selectBase(defStmt.getRightOp(), false);
                if (leftSideMatches && !(rightValue instanceof Local) && !(rightValue instanceof FieldRef) && !(rightValue instanceof ArrayRef)) {
                    return res;
                }
                if (rightValue instanceof Constant) {
                    return res;
                }
                if (defStmt.getRightOp() instanceof NewArrayExpr) {
                    return res;
                }
                if (defStmt.getRightOp() instanceof BinopExpr) {
                    return res;
                }
                if (defStmt.getRightOp() instanceof UnopExpr) {
                    return res;
                }
                boolean bl = aliasOverwritten = Aliasing.baseMatchesStrict(rightValue, source) && rightValue.getType() instanceof RefType && !source.dependsOnCutAP();
                if (!aliasOverwritten && !(rightValue.getType() instanceof PrimType)) {
                    AccessPath ap;
                    InstanceFieldRef ref;
                    Abstraction newLeftAbs = null;
                    if (rightValue instanceof InstanceFieldRef) {
                        ref = (InstanceFieldRef)rightValue;
                        if (source.getAccessPath().isInstanceFieldRef() && ref.getBase() == source.getAccessPath().getPlainValue() && source.getAccessPath().firstFieldMatches(ref.getField())) {
                            ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftValue, source.getAccessPath().getFirstFieldType(), true);
                            newLeftAbs = this.checkAbstraction(source.deriveNewAbstraction(ap, (Stmt)defStmt));
                        }
                    } else if (AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && rightValue instanceof StaticFieldRef) {
                        ref = (StaticFieldRef)rightValue;
                        if (source.getAccessPath().isStaticFieldRef() && source.getAccessPath().firstFieldMatches(ref.getField())) {
                            ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftValue, source.getAccessPath().getBaseType(), true);
                            newLeftAbs = this.checkAbstraction(source.deriveNewAbstraction(ap, (Stmt)defStmt));
                        }
                    } else if (rightValue == source.getAccessPath().getPlainValue()) {
                        Object newType = source.getAccessPath().getBaseType();
                        if (leftValue instanceof ArrayRef) {
                            ArrayRef arrayRef = (ArrayRef)leftValue;
                            newType = TypeUtils.buildArrayOrAddDimension((Type)newType, (Type)arrayRef.getType().getArrayType());
                        } else if (defStmt.getRightOp() instanceof ArrayRef) {
                            newType = ((ArrayType)newType).getElementType();
                        } else if (!AliasProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), leftValue.getType())) {
                            return null;
                        }
                        if (defStmt.getRightOp() instanceof CastExpr) {
                            CastExpr ce = (CastExpr)defStmt.getRightOp();
                            if (!AliasProblem.this.manager.getHierarchy().canStoreType((Type)newType, ce.getCastType())) {
                                newType = ce.getCastType();
                            }
                        } else {
                            if (defStmt.getRightOp() instanceof LengthExpr) {
                                return res;
                            }
                            if (defStmt.getRightOp() instanceof InstanceOfExpr) {
                                return res;
                            }
                        }
                        ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftValue, (Type)newType, false);
                        newLeftAbs = this.checkAbstraction(source.deriveNewAbstraction(ap, (Stmt)defStmt));
                    }
                    if (newLeftAbs != null && !newLeftAbs.getAccessPath().equals(source.getAccessPath())) {
                        for (Unit u : AliasProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                            AliasProblem.this.manager.getMainSolver().processEdge((PathEdge<Unit, Abstraction>)new PathEdge((Object)d1, (Object)u, (Object)newLeftAbs));
                        }
                    }
                }
                if ((rightValue instanceof Local || rightValue instanceof FieldRef) && !(leftValue.getType() instanceof PrimType)) {
                    boolean addRightValue = false;
                    boolean cutFirstField = false;
                    Type targetType = null;
                    if (leftValue instanceof InstanceFieldRef) {
                        InstanceFieldRef leftRef;
                        if (source.getAccessPath().isInstanceFieldRef() && (leftRef = (InstanceFieldRef)leftValue).getBase() == source.getAccessPath().getPlainValue() && source.getAccessPath().firstFieldMatches(leftRef.getField())) {
                            targetType = source.getAccessPath().getFirstFieldType();
                            addRightValue = true;
                            cutFirstField = true;
                        }
                    } else if (leftValue instanceof Local && source.getAccessPath().isInstanceFieldRef()) {
                        Local base = source.getAccessPath().getPlainValue();
                        if (leftValue == base) {
                            targetType = source.getAccessPath().getBaseType();
                            addRightValue = true;
                        }
                    } else if (leftValue instanceof ArrayRef) {
                        ArrayRef ar = (ArrayRef)leftValue;
                        Local leftBase = (Local)ar.getBase();
                        if (leftBase == source.getAccessPath().getPlainValue()) {
                            addRightValue = true;
                            targetType = source.getAccessPath().getBaseType();
                        }
                    } else if (leftValue == source.getAccessPath().getPlainValue()) {
                        if (!AliasProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), defStmt.getRightOp().getType())) {
                            return null;
                        }
                        addRightValue = true;
                        targetType = source.getAccessPath().getBaseType();
                    }
                    if (addRightValue) {
                        AccessPath ap;
                        Abstraction newAbs;
                        if (targetType != null) {
                            if (defStmt.getRightOp() instanceof ArrayRef) {
                                ArrayRef arrayRef = (ArrayRef)defStmt.getRightOp();
                                targetType = TypeUtils.buildArrayOrAddDimension(targetType, (Type)arrayRef.getType().getArrayType());
                            } else if (leftValue instanceof ArrayRef) {
                                assert (source.getAccessPath().getBaseType() instanceof ArrayType);
                                if (TypeUtils.isObjectLikeType(targetType = ((ArrayType)targetType).getElementType())) {
                                    targetType = rightValue.getType();
                                }
                                if (!AliasProblem.this.manager.getTypeUtils().checkCast(rightValue.getType(), targetType)) {
                                    addRightValue = false;
                                }
                            }
                        }
                        if (defStmt.getRightOp() instanceof LengthExpr) {
                            targetType = null;
                        }
                        if ((targetType instanceof PrimType || targetType instanceof ArrayType && ((ArrayType)targetType).getElementType() instanceof PrimType) && !source.getAccessPath().isStaticFieldRef() && !source.getAccessPath().isLocal()) {
                            return null;
                        }
                        if ((rightValue.getType() instanceof PrimType || rightValue.getType() instanceof ArrayType && ((ArrayType)rightValue.getType()).getElementType() instanceof PrimType) && !source.getAccessPath().isStaticFieldRef() && !source.getAccessPath().isLocal()) {
                            return null;
                        }
                        if (addRightValue && !AliasProblem.this.manager.getTypeUtils().checkCast(rightValue.getType(), targetType)) {
                            addRightValue = false;
                        }
                        if (addRightValue && rightValue instanceof StaticFieldRef && AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.None) {
                            addRightValue = false;
                        }
                        if (addRightValue && (newAbs = this.checkAbstraction(source.deriveNewAbstraction(ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), rightValue, targetType, cutFirstField), (Stmt)defStmt))) != null && !newAbs.getAccessPath().equals(source.getAccessPath())) {
                            if (rightValue instanceof StaticFieldRef && AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.ContextFlowInsensitive) {
                                AliasProblem.this.manager.getGlobalTaintManager().addToGlobalTaintState(newAbs);
                            } else {
                                res.add(newAbs);
                                for (Unit u : AliasProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                                    AliasProblem.this.manager.getMainSolver().processEdge((PathEdge<Unit, Abstraction>)new PathEdge((Object)d1, (Object)u, (Object)newAbs));
                                }
                            }
                        }
                    }
                }
                return res;
            }

            public FlowFunction<Abstraction> getNormalFlowFunction(final Unit src, Unit dest) {
                if (src instanceof DefinitionStmt) {
                    final DefinitionStmt defStmt = (DefinitionStmt)src;
                    final Value leftValue = BaseSelector.selectBase(defStmt.getLeftOp(), true);
                    final DefinitionStmt destDefStmt = dest instanceof DefinitionStmt ? (DefinitionStmt)dest : null;
                    final Value destLeftValue = destDefStmt == null ? null : BaseSelector.selectBase(destDefStmt.getLeftOp(), true);
                    return new SolverNormalFlowFunction(){

                        @Override
                        public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                            if (source == AliasProblem.this.getZeroValue()) {
                                return null;
                            }
                            assert (source.isAbstractionActive() || AliasProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                            if (AliasProblem.this.taintPropagationHandler != null) {
                                AliasProblem.this.taintPropagationHandler.notifyFlowIn(src, source, AliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                            }
                            Set res = this.computeAliases(defStmt, leftValue, d1, source);
                            if (destDefStmt != null && res != null && !res.isEmpty() && AliasProblem.this.interproceduralCFG().isExitStmt(destDefStmt)) {
                                for (Abstraction abs : res) {
                                    this.computeAliases(destDefStmt, destLeftValue, d1, abs);
                                }
                            }
                            return AliasProblem.this.notifyOutFlowHandlers(src, d1, source, res, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                        }
                    };
                }
                return Identity.v();
            }

            public FlowFunction<Abstraction> getCallFlowFunction(final Unit src, final SootMethod dest) {
                if (!dest.hasActiveBody()) {
                    return KillAll.v();
                }
                final Stmt stmt = (Stmt)src;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final Value[] paramLocals = new Value[dest.getParameterCount()];
                for (int i = 0; i < dest.getParameterCount(); ++i) {
                    paramLocals[i] = dest.getActiveBody().getParameterLocal(i);
                }
                final boolean isSink = stmt.hasTag("fd_sink");
                final boolean isSource = stmt.hasTag("fd_source");
                final Local thisLocal = dest.isStatic() ? null : dest.getActiveBody().getThisLocal();
                final ICallerCalleeArgumentMapper mapper = CallerCalleeManager.getMapper(AliasProblem.this.manager, stmt, dest);
                final boolean isReflectiveCallSite = mapper != null ? mapper.isReflectiveMapper() : false;
                return new SolverCallFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        Abstraction abs;
                        Value callBase;
                        Abstraction abs2;
                        DefinitionStmt defnStmt;
                        Value leftOp;
                        if (source == AliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        assert (source.isAbstractionActive() || AliasProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                        if (AliasProblem.this.taintPropagationHandler != null) {
                            AliasProblem.this.taintPropagationHandler.notifyFlowIn((Unit)stmt, source, AliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                        }
                        if (!AliasProblem.this.manager.getConfig().getInspectSources() && isSource) {
                            return null;
                        }
                        if (!AliasProblem.this.manager.getConfig().getInspectSinks() && isSink) {
                            return null;
                        }
                        if (AliasProblem.this.isCallSiteActivatingTaint((Unit)stmt, source.getActivationUnit())) {
                            return null;
                        }
                        if (AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.None && dest.isStaticInitializer()) {
                            return null;
                        }
                        if (AliasProblem.this.taintWrapper != null && AliasProblem.this.taintWrapper.isExclusive(stmt, source)) {
                            return null;
                        }
                        if (AliasProblem.this.isExcluded(dest)) {
                            return null;
                        }
                        if (AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && !AliasProblem.this.interproceduralCFG().isStaticFieldRead(dest, source.getAccessPath().getFirstField())) {
                            return null;
                        }
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (src instanceof DefinitionStmt && (leftOp = (defnStmt = (DefinitionStmt)src).getLeftOp()) == source.getAccessPath().getPlainValue()) {
                            for (Unit u : dest.getActiveBody().getUnits()) {
                                AccessPath ap;
                                Abstraction abs3;
                                ReturnStmt rStmt;
                                if (!(u instanceof ReturnStmt) || !((rStmt = (ReturnStmt)u).getOp() instanceof Local) && !(rStmt.getOp() instanceof FieldRef) || !AliasProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), rStmt.getOp().getType()) || (abs3 = this.checkAbstraction(source.deriveNewAbstraction(ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), rStmt.getOp(), null, false), (Stmt)src))) == null) continue;
                                res.add(abs3);
                            }
                        }
                        if (AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && (abs2 = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath(), stmt))) != null) {
                            res.add(abs2);
                        }
                        Local sourceBase = source.getAccessPath().getPlainValue();
                        if (!source.getAccessPath().isStaticFieldRef() && !dest.isStatic() && (callBase = mapper.getCallerValueOfCalleeParameter(ie, -1)) == sourceBase && AliasProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), dest.getDeclaringClass())) {
                            AccessPath ap;
                            boolean param = false;
                            if (!isReflectiveCallSite) {
                                for (int i = 0; i < dest.getParameterCount(); ++i) {
                                    if (stmt.getInvokeExpr().getArg(i) != sourceBase) continue;
                                    param = true;
                                    break;
                                }
                            }
                            if (!param && (abs = this.checkAbstraction(source.deriveNewAbstraction(ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), (Value)thisLocal), (Stmt)src))) != null) {
                                res.add(abs);
                            }
                        }
                        if (ie != null && dest.getParameterCount() > 0) {
                            for (int i = 0; i < ie.getArgCount(); ++i) {
                                AccessPath ap;
                                int mappedIntoCallee;
                                if (ie.getArg(i) != source.getAccessPath().getPlainValue() || (mappedIntoCallee = mapper.getCalleeIndexOfCallerParameter(i)) == -3) continue;
                                if (mappedIntoCallee == -2) {
                                    int j = 0;
                                    while (i < paramLocals.length) {
                                        AccessPath ap2 = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), paramLocals[j], null, false);
                                        Abstraction abs4 = this.checkAbstraction(source.deriveNewAbstraction(ap2, stmt));
                                        if (abs4 != null) {
                                            res.add(abs4);
                                        }
                                        ++i;
                                    }
                                    continue;
                                }
                                if (mappedIntoCallee == -1 || (abs = this.checkAbstraction(source.deriveNewAbstraction(ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), paramLocals[mappedIntoCallee]), stmt))) == null) continue;
                                res.add(abs);
                            }
                        }
                        if (res != null && !res.isEmpty()) {
                            for (Abstraction d3 : res) {
                                AliasProblem.this.manager.getMainSolver().injectContext(AliasProblem.this.solver, dest, d3, src, source, d1);
                            }
                        }
                        return AliasProblem.this.notifyOutFlowHandlers(src, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                    }
                };
            }

            public FlowFunction<Abstraction> getReturnFlowFunction(final Unit callSite, final SootMethod callee, final Unit exitStmt, Unit retSite) {
                final Value[] paramLocals = new Value[callee.getParameterCount()];
                for (int i = 0; i < callee.getParameterCount(); ++i) {
                    paramLocals[i] = callee.getActiveBody().getParameterLocal(i);
                }
                final Stmt stmt = (Stmt)callSite;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final Local thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
                final ICallerCalleeArgumentMapper mapper = CallerCalleeManager.getMapper(AliasProblem.this.manager, stmt, callee);
                final boolean isReflectiveCallSite = mapper != null ? mapper.isReflectiveMapper() : false;
                return new SolverReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction source, Abstraction d1, Collection<Abstraction> callerD1s) {
                        AccessPath ap;
                        Abstraction abs;
                        Value callerBaseLocal;
                        if (source == AliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        assert (source.isAbstractionActive() || AliasProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                        if (callSite == null) {
                            return null;
                        }
                        if (AliasProblem.this.taintPropagationHandler != null) {
                            AliasProblem.this.taintPropagationHandler.notifyFlowIn((Unit)stmt, source, AliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        if (AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef()) {
                            AliasProblem.this.registerActivationCallSite(callSite, callee, source);
                            return AliasProblem.this.notifyOutFlowHandlers(exitStmt, d1, source, Collections.singleton(source), TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        Local sourceBase = source.getAccessPath().getPlainValue();
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        boolean parameterAliases = false;
                        block0: for (int i = 0; i < paramLocals.length; ++i) {
                            AccessPath ap2;
                            Abstraction abs2;
                            Value originalCallArg;
                            if (paramLocals[i] != sourceBase) continue;
                            parameterAliases = true;
                            if (!(callSite instanceof Stmt) || (originalCallArg = mapper.getCallerValueOfCalleeParameter(ie, i)) == null || !AccessPath.canContainValue(originalCallArg) || !isReflectiveCallSite && !AliasProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), originalCallArg.getType()) || source.getAccessPath().getBaseType() instanceof PrimType || TypeUtils.isStringType(source.getAccessPath().getBaseType()) && !source.getAccessPath().getCanHaveImmutableAliases() || AliasProblem.this.interproceduralCFG().methodWritesValue(callee, paramLocals[i]) || (abs2 = this.checkAbstraction(source.deriveNewAbstraction(ap2 = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), originalCallArg, isReflectiveCallSite ? null : source.getAccessPath().getBaseType(), false), (Stmt)exitStmt))) == null) continue;
                            res.add(abs2);
                            AliasProblem.this.registerActivationCallSite(callSite, callee, abs2);
                            for (int argIndex = 0; !isReflectiveCallSite && argIndex < ie.getArgCount(); ++argIndex) {
                                if (i == argIndex || originalCallArg != ie.getArg(argIndex)) continue;
                                AccessPath aliasAp = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(abs2.getAccessPath(), paramLocals[argIndex], abs2.getAccessPath().getBaseType(), false);
                                Abstraction aliasAbs = this.checkAbstraction(source.deriveNewAbstraction(aliasAp, (Stmt)exitStmt));
                                AliasProblem.this.manager.getMainSolver().processEdge((PathEdge<Unit, Abstraction>)new PathEdge((Object)d1, (Object)exitStmt, (Object)aliasAbs));
                            }
                            for (Unit u : AliasProblem.this.manager.getICFG().getStartPointsOf(callee)) {
                                if (!(u instanceof ReturnStmt) || paramLocals[i] != ((ReturnStmt)u).getOp()) continue;
                                AliasProblem.this.manager.getMainSolver().processEdge((PathEdge<Unit, Abstraction>)new PathEdge((Object)d1, (Object)exitStmt, (Object)source));
                                continue block0;
                            }
                        }
                        if (!callee.isStatic() && thisLocal == sourceBase && AliasProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), callee.getDeclaringClass()) && !parameterAliases && callSite instanceof Stmt && (callerBaseLocal = mapper.getCallerValueOfCalleeParameter(ie, -1)) != null && (abs = this.checkAbstraction(source.deriveNewAbstraction(ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), callerBaseLocal, isReflectiveCallSite ? null : source.getAccessPath().getBaseType(), false), (Stmt)exitStmt))) != null) {
                            res.add(abs);
                            AliasProblem.this.registerActivationCallSite(callSite, callee, abs);
                        }
                        for (Abstraction abs3 : res) {
                            if (abs3 == source) continue;
                            abs3.setCorrespondingCallSite((Stmt)callSite);
                        }
                        return AliasProblem.this.notifyOutFlowHandlers(exitStmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                    }
                };
            }

            public FlowFunction<Abstraction> getCallToReturnFlowFunction(final Unit call, Unit returnSite) {
                final Stmt iStmt = (Stmt)call;
                InvokeExpr invExpr = iStmt.getInvokeExpr();
                final Value[] callArgs = new Value[iStmt.getInvokeExpr().getArgCount()];
                for (int i = 0; i < iStmt.getInvokeExpr().getArgCount(); ++i) {
                    callArgs[i] = iStmt.getInvokeExpr().getArg(i);
                }
                final SootMethod callee = invExpr.getMethod();
                final DefinitionStmt defStmt = iStmt instanceof DefinitionStmt ? (DefinitionStmt)iStmt : null;
                return new SolverCallToReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        InstanceInvokeExpr iinv;
                        Set<Abstraction> wrapperAliases;
                        if (source == AliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        assert (source.isAbstractionActive() || AliasProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                        if (AliasProblem.this.taintPropagationHandler != null) {
                            AliasProblem.this.taintPropagationHandler.notifyFlowIn(call, source, AliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        if (AliasProblem.this.taintWrapper != null && (wrapperAliases = AliasProblem.this.taintWrapper.getAliasesForMethod(iStmt, d1, source)) != null && !wrapperAliases.isEmpty()) {
                            HashSet<Abstraction> passOnSet = new HashSet<Abstraction>(wrapperAliases.size());
                            for (Abstraction abs : wrapperAliases) {
                                if (defStmt == null || defStmt.getLeftOp() != abs.getAccessPath().getPlainValue()) {
                                    passOnSet.add(abs);
                                }
                                if (source.equals(abs)) continue;
                                for (Unit u : AliasProblem.this.interproceduralCFG().getPredsOf(call)) {
                                    AliasProblem.this.manager.getMainSolver().processEdge((PathEdge<Unit, Abstraction>)new PathEdge((Object)d1, (Object)u, (Object)abs));
                                }
                            }
                            return AliasProblem.this.notifyOutFlowHandlers(call, d1, source, passOnSet, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        boolean mustPropagate = AliasProblem.this.isExcluded(callee);
                        if (!(mustPropagate |= AliasProblem.this.interproceduralCFG().getCalleesOfCallAt(call).isEmpty()) && AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && AliasProblem.this.interproceduralCFG().isStaticFieldUsed(callee, source.getAccessPath().getFirstField())) {
                            return null;
                        }
                        if (iStmt instanceof DefinitionStmt && ((DefinitionStmt)iStmt).getLeftOp() == source.getAccessPath().getPlainValue()) {
                            return null;
                        }
                        if (!mustPropagate && iStmt.getInvokeExpr() instanceof InstanceInvokeExpr && (iinv = (InstanceInvokeExpr)iStmt.getInvokeExpr()).getBase() == source.getAccessPath().getPlainValue() && !AliasProblem.this.interproceduralCFG().getCalleesOfCallAt(call).isEmpty()) {
                            return null;
                        }
                        if (!mustPropagate) {
                            for (int i = 0; i < callArgs.length; ++i) {
                                if (callArgs[i] != source.getAccessPath().getPlainValue()) continue;
                                return null;
                            }
                        }
                        return AliasProblem.this.notifyOutFlowHandlers(call, d1, source, Collections.singleton(source), TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                    }
                };
            }
        };
    }
}

