/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules.backward;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.sourcesSinks.manager.IReversibleSourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class BackwardsSinkPropagationRule
extends AbstractTaintPropagationRule {
    public BackwardsSinkPropagationRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    private Collection<Abstraction> propagate(Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (source == this.getZeroValue()) {
            if (!(this.manager.getSourceSinkManager() instanceof IReversibleSourceSinkManager)) {
                return null;
            }
            IReversibleSourceSinkManager ssm = (IReversibleSourceSinkManager)this.manager.getSourceSinkManager();
            SourceInfo sinkInfo = ssm.getInverseSinkInfo(stmt, this.getManager());
            killSource.value = true;
            if (sinkInfo != null && !sinkInfo.getAccessPaths().isEmpty()) {
                Stmt callerStmt;
                Optional caller = this.manager.getICFG().getCallersOf((SootMethod)this.manager.getICFG().getMethodOf(stmt)).stream().findAny();
                if (caller.isPresent() && (callerStmt = (Stmt)caller.get()).containsInvokeExpr() && this.manager.getTaintWrapper() != null && this.manager.getTaintWrapper().isExclusive(callerStmt, this.zeroValue)) {
                    return null;
                }
                HashSet<Abstraction> res = new HashSet<Abstraction>();
                for (AccessPath ap : sinkInfo.getAccessPaths()) {
                    if (ap.isEmpty()) continue;
                    Abstraction abs = new Abstraction(sinkInfo.getDefinitionsForAccessPath(ap), ap, stmt, sinkInfo.getUserData(), false, false);
                    abs.setCorrespondingCallSite(stmt);
                    abs = abs.deriveNewAbstractionWithTurnUnit((Unit)stmt);
                    res.add(abs);
                }
                return res;
            }
            if (killAll != null) {
                killAll.value = true;
            }
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return this.propagate(source, stmt, killSource, killAll);
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return this.propagate(source, stmt, killSource, null);
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction calleeD1, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        killAll.value = killAll.value || !this.getManager().getConfig().getInspectSources() && stmt.hasTag("fd_source");
        killAll.value = killAll.value || !this.getManager().getConfig().getInspectSinks() && stmt.hasTag("fd_sink");
        return null;
    }
}

