/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.results.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFragment;
import soot.jimple.infoflow.results.InfoflowPerformanceData;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;

public class InfoflowResultsSerializer {
    public static final int FILE_FORMAT_VERSION = 102;
    protected boolean serializeTaintPath = true;
    protected IInfoflowCFG icfg;
    protected InfoflowConfiguration config;
    protected long startTime = 0L;

    public InfoflowResultsSerializer(InfoflowConfiguration config) {
        this(null, config);
    }

    public InfoflowResultsSerializer(IInfoflowCFG cfg, InfoflowConfiguration config) {
        this.icfg = cfg;
        this.config = config;
    }

    public void serialize(InfoflowResults results, String fileName) throws XMLStreamException, IOException {
        this.startTime = System.currentTimeMillis();
        try (FileOutputStream out = new FileOutputStream(fileName);){
            InfoflowPerformanceData performanceData;
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = factory.createXMLStreamWriter(out, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("DataFlowResults");
            writer.writeAttribute("FileFormatVersion", "102");
            writer.writeAttribute("TerminationState", this.terminationStateToString(results.getTerminationState()));
            if (results != null && !results.isEmpty()) {
                writer.writeStartElement("Results");
                this.writeDataFlows(results, writer);
                writer.writeEndElement();
            }
            if ((performanceData = results.getPerformanceData()) != null && !performanceData.isEmpty()) {
                writer.writeStartElement("PerformanceData");
                this.writePerformanceData(performanceData, writer);
                writer.writeEndElement();
            }
            writer.writeEndDocument();
            writer.close();
        }
    }

    private String terminationStateToString(int terminationState) {
        switch (terminationState) {
            case 0: {
                return "Success";
            }
            case 1: {
                return "DataFlowTimeout";
            }
            case 2: {
                return "DataFlowOutOfMemory";
            }
            case 4: {
                return "PathReconstructionTimeout";
            }
            case 8: {
                return "PathReconstructionOfMemory";
            }
        }
        return "Unknown";
    }

    private void writePerformanceData(InfoflowPerformanceData performanceData, XMLStreamWriter writer) throws XMLStreamException {
        this.writePerformanceEntry("CallgraphConstructionSeconds", performanceData.getCallgraphConstructionSeconds(), writer);
        this.writePerformanceEntry("TaintPropagationSeconds", performanceData.getTaintPropagationSeconds(), writer);
        this.writePerformanceEntry("PathReconstructionSeconds", performanceData.getPathReconstructionSeconds(), writer);
        this.writePerformanceEntry("TotalRuntimeSeconds", performanceData.getTotalRuntimeSeconds(), writer);
        this.writePerformanceEntry("MaxMemoryConsumption", performanceData.getMaxMemoryConsumption(), writer);
        this.writePerformanceEntry("SourceCount", performanceData.getSourceCount(), writer);
        this.writePerformanceEntry("SinkCount", performanceData.getSinkCount(), writer);
    }

    private void writePerformanceEntry(String entryName, int entryValue, XMLStreamWriter writer) throws XMLStreamException {
        if (entryValue > 0) {
            writer.writeStartElement("PerformanceEntry");
            writer.writeAttribute("Name", entryName);
            writer.writeAttribute("Value", entryValue + "");
            writer.writeEndElement();
        }
    }

    protected void writeDataFlows(InfoflowResults results, XMLStreamWriter writer) throws XMLStreamException {
        for (ResultSinkInfo sink : results.getResults().keySet()) {
            writer.writeStartElement("Result");
            this.writeSinkInfo(sink, writer);
            writer.writeStartElement("Sources");
            for (ResultSourceInfo src : results.getResults().get((Object)sink)) {
                this.writeSourceInfo(src, writer);
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeSourceInfo(ResultSourceInfo source, XMLStreamWriter writer) throws XMLStreamException {
        MethodSourceSinkDefinition ms;
        ISourceSinkDefinition def;
        writer.writeStartElement("Source");
        writer.writeAttribute("Statement", source.getStmt().toString());
        if (this.config.getEnableLineNumbers()) {
            writer.writeAttribute("LineNumber", String.valueOf(source.getStmt().getJavaSourceStartLineNumber()));
        }
        if (source.getDefinition().getCategory() != null) {
            writer.writeAttribute("Category", source.getDefinition().getCategory().getHumanReadableDescription());
        }
        if (this.icfg != null) {
            writer.writeAttribute("Method", ((SootMethod)this.icfg.getMethodOf(source.getStmt())).getSignature());
        }
        if ((def = source.getDefinition()) instanceof MethodSourceSinkDefinition && (ms = (MethodSourceSinkDefinition)def).getMethod() != null) {
            writer.writeAttribute("MethodSourceSinkDefinition", ms.getMethod().getSignature());
        }
        this.writeAdditionalSourceInfo(source, writer);
        this.writeAccessPath(source.getAccessPath(), writer);
        if (this.serializeTaintPath && source.getPath() != null) {
            writer.writeStartElement("TaintPath");
            for (int i = 0; i < source.getPath().length; ++i) {
                writer.writeStartElement("PathElement");
                Stmt curStmt = source.getPath()[i];
                writer.writeAttribute("Statement", curStmt.toString());
                if (this.icfg != null) {
                    writer.writeAttribute("Method", ((SootMethod)this.icfg.getMethodOf(curStmt)).getSignature());
                }
                AccessPath curAP = source.getPathAccessPaths()[i];
                this.writeAccessPath(curAP, writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected void writeAdditionalSourceInfo(ResultSourceInfo source, XMLStreamWriter writer) throws XMLStreamException {
    }

    private void writeSinkInfo(ResultSinkInfo sink, XMLStreamWriter writer) throws XMLStreamException {
        MethodSourceSinkDefinition ms;
        ISourceSinkDefinition def;
        writer.writeStartElement("Sink");
        writer.writeAttribute("Statement", sink.getStmt().toString());
        if (this.config.getEnableLineNumbers()) {
            writer.writeAttribute("LineNumber", String.valueOf(sink.getStmt().getJavaSourceStartLineNumber()));
        }
        if (sink.getDefinition().getCategory() != null) {
            writer.writeAttribute("Category", sink.getDefinition().getCategory().getHumanReadableDescription());
        }
        if (this.icfg != null) {
            writer.writeAttribute("Method", ((SootMethod)this.icfg.getMethodOf(sink.getStmt())).getSignature());
        }
        if ((def = sink.getDefinition()) instanceof MethodSourceSinkDefinition && (ms = (MethodSourceSinkDefinition)def).getMethod() != null) {
            writer.writeAttribute("MethodSourceSinkDefinition", ms.getMethod().getSignature());
        }
        this.writeAdditionalSinkInfo(sink, writer);
        this.writeAccessPath(sink.getAccessPath(), writer);
        writer.writeEndElement();
    }

    protected void writeAdditionalSinkInfo(ResultSinkInfo sink, XMLStreamWriter writer) throws XMLStreamException {
    }

    protected void writeAccessPath(AccessPath accessPath, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("AccessPath");
        if (accessPath.getPlainValue() != null) {
            writer.writeAttribute("Value", accessPath.getPlainValue().toString());
        }
        if (accessPath.getBaseType() != null) {
            writer.writeAttribute("Type", accessPath.getBaseType().toString());
        }
        writer.writeAttribute("TaintSubFields", accessPath.getTaintSubFields() ? "true" : "false");
        if (accessPath.getFragmentCount() > 0) {
            writer.writeStartElement("Fields");
            for (int i = 0; i < accessPath.getFragmentCount(); ++i) {
                writer.writeStartElement("Field");
                AccessPathFragment fragment = accessPath.getFragments()[i];
                writer.writeAttribute("Value", fragment.getField().toString());
                writer.writeAttribute("Type", fragment.getFieldType().toString());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void setSerializeTaintPath(boolean serialize) {
        this.serializeTaintPath = serialize;
    }
}

