/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.river;

import heros.solver.PathEdge;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.RefType;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.river.AdditionalFlowInfoSourceContext;
import soot.jimple.infoflow.river.AdditionalFlowInfoSpecification;
import soot.jimple.infoflow.river.ConditionalSecondarySourceDefinition;
import soot.jimple.infoflow.river.IConditionalFlowManager;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;

public class SecondaryFlowGenerator
implements TaintPropagationHandler {
    private IConditionalFlowManager condFlowManager = null;

    private void ensureCondFlowManager(InfoflowManager manager) {
        if (this.condFlowManager != null) {
            return;
        }
        if (!manager.getConfig().getAdditionalFlowsEnabled()) {
            throw new IllegalStateException("Additional flows are not enabled!");
        }
        ISourceSinkManager ssm = manager.getSourceSinkManager();
        if (ssm instanceof IConditionalFlowManager) {
            this.condFlowManager = (IConditionalFlowManager)((Object)ssm);
            return;
        }
        throw new IllegalStateException("Additional Flows enabled but no ConditionalFlowManager in place!");
    }

    @Override
    public void notifyFlowIn(Unit stmt, Abstraction taint, InfoflowManager manager, TaintPropagationHandler.FlowFunctionType type) {
    }

    @Override
    public Set<Abstraction> notifyFlowOut(Unit unit, Abstraction d1, Abstraction incoming, Set<Abstraction> outgoing, InfoflowManager manager, TaintPropagationHandler.FlowFunctionType type) {
        RefType ref;
        Abstraction baseTaint;
        if (type != TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction) {
            return outgoing;
        }
        if (!this.isReadAt(unit, incoming.getAccessPath())) {
            return outgoing;
        }
        this.ensureCondFlowManager(manager);
        Stmt stmt = (Stmt)unit;
        HashSet<Abstraction> additionalAbsSet = new HashSet<Abstraction>();
        if (stmt.containsInvokeExpr() && stmt.getInvokeExpr() instanceof InstanceInvokeExpr && (baseTaint = this.getTaintFromLocal(outgoing, ((InstanceInvokeExpr)stmt.getInvokeExpr()).getBase())) != null && baseTaint.getAccessPath().getBaseType() instanceof RefType && this.condFlowManager.isConditionalSink(stmt, (ref = (RefType)baseTaint.getAccessPath().getBaseType()).getSootClass())) {
            Abstraction newAbs = this.createAdditionalFlowAbstraction(baseTaint, stmt);
            additionalAbsSet.add(newAbs);
        }
        for (AdditionalFlowInfoSpecification spec : manager.getUsageContextProvider().needsAdditionalInformation(stmt, outgoing)) {
            additionalAbsSet.add(this.createAdditionalFlowAbstraction(spec, stmt, manager));
        }
        for (Abstraction addAbs : additionalAbsSet) {
            for (Unit pred : manager.getICFG().getPredsOf(unit)) {
                manager.additionalManager.getMainSolver().processEdge((PathEdge<Unit, Abstraction>)new PathEdge((Object)d1, (Object)pred, (Object)addAbs));
            }
        }
        return outgoing;
    }

    protected Abstraction createAdditionalFlowAbstraction(Abstraction baseTaint, Stmt stmt) {
        Abstraction newAbs = new Abstraction(Collections.singleton(ConditionalSecondarySourceDefinition.INSTANCE), baseTaint.getAccessPath(), stmt, null, false, false);
        newAbs.setCorrespondingCallSite(stmt);
        newAbs.setSourceContext(new AdditionalFlowInfoSourceContext(ConditionalSecondarySourceDefinition.INSTANCE, baseTaint.getAccessPath(), stmt));
        return newAbs.deriveNewAbstractionWithTurnUnit((Unit)stmt);
    }

    protected Abstraction createAdditionalFlowAbstraction(AdditionalFlowInfoSpecification spec, Stmt stmt, InfoflowManager manager) {
        AccessPath ap = spec.toAccessPath(manager);
        ISourceSinkDefinition def = spec.getDefinition();
        Abstraction newAbs = new Abstraction(Collections.singleton(def), ap, stmt, null, false, false);
        newAbs.setCorrespondingCallSite(stmt);
        newAbs.setSourceContext(new AdditionalFlowInfoSourceContext(def, ap, stmt));
        return newAbs.deriveNewAbstractionWithTurnUnit((Unit)stmt);
    }

    protected Abstraction getTaintFromLocal(Set<Abstraction> outgoing, Value baseLocal) {
        for (Abstraction abs : outgoing) {
            if (abs.getAccessPath().getPlainValue() != baseLocal) continue;
            return abs;
        }
        return null;
    }

    protected boolean isReadAt(Unit unit, AccessPath ap) {
        for (ValueBox box : unit.getUseBoxes()) {
            if (box.getValue() != ap.getPlainValue()) continue;
            return true;
        }
        return false;
    }
}

