/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver;

import heros.SynchronizedBy;
import heros.solver.Pair;
import java.util.HashSet;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.ISolverPeerGroup;
import soot.jimple.infoflow.solver.IncomingRecord;
import soot.util.ConcurrentHashMultiMap;

public class DefaultSolverPeerGroup
implements ISolverPeerGroup {
    @SynchronizedBy(value="consistent lock on field")
    protected final ConcurrentHashMultiMap<Pair<SootMethod, Abstraction>, IncomingRecord<Unit, Abstraction>> incoming = new ConcurrentHashMultiMap();
    protected Set<IInfoflowSolver> solvers = new HashSet<IInfoflowSolver>();

    @Override
    public void addSolver(IInfoflowSolver solver) {
        this.solvers.add(solver);
        solver.setPeerGroup(this);
    }

    @Override
    public Set<IncomingRecord<Unit, Abstraction>> incoming(Abstraction d1, SootMethod m) {
        return this.incoming.get((Object)new Pair((Object)m, (Object)d1));
    }

    @Override
    public boolean addIncoming(SootMethod m, Abstraction d3, Unit n, Abstraction d1, Abstraction d2) {
        IncomingRecord<Unit, Abstraction> newRecord = new IncomingRecord<Unit, Abstraction>(n, d1, d2, d3);
        IncomingRecord rec = (IncomingRecord)this.incoming.putIfAbsent((Object)new Pair((Object)m, (Object)d3), newRecord);
        if (rec == null) {
            for (IInfoflowSolver solver : this.solvers) {
                solver.applySummary(m, d3, n, d2, d1);
            }
        }
        return false;
    }
}

